/*
 * Decompiled with CFR 0.152.
 */
package net.bobis.jinput.hidraw;

import java.util.BitSet;
import net.bobis.jinput.hidraw.HidRawController;
import net.bobis.jinput.hidraw.HidRawDevice;
import net.bobis.jinput.hidraw.RDDisplayOutputReport;
import net.bobis.jinput.hidraw.RDInputReport;
import net.java.games.input.Component;
import net.java.games.input.Controller;

public class RailDriverModernDesktop
extends HidRawController {
    private RDDisplayOutputReport display_report;
    private final int maxLen;
    private final long scrollMillis = 500L;
    private final long tempMillis = 1000L;
    static final int inReportSize = 15;
    static final int outReportSize = 9;

    protected void setBufferSizes() {
        this.device.setInBufferSize(15);
        this.device.setOutBufferSize(9);
    }

    public RailDriverModernDesktop(String name, HidRawDevice device, Component[] components) throws Exception {
        super(name, device, components);
        this.current_report = new RDInputReport();
        this.display_report = new RDDisplayOutputReport(device);
        this.maxLen = this.display_report.getNumLed();
        this.displayStrFlash("hid", 3);
        this.displayStrNext("rd");
    }

    public Controller.Type getType() {
        return Controller.Type.GAMEPAD;
    }

    public void displayStrScroll(String str) {
        BitSet bitSet = new BitSet(this.maxLen);
        for (int i = 0; i < str.length() - this.maxLen + 1; ++i) {
            String slice = str.substring(i, i + this.maxLen);
            bitSet.clear();
            for (int j = 0; j < this.maxLen; ++j) {
                if (i + j >= str.length() - this.maxLen) continue;
            }
            this.display_report.displayStrSeq(slice, bitSet, 500L);
        }
        bitSet.clear();
        this.display_report.displayStrNext(str, bitSet);
    }

    public void displayStrNext(String str) {
        this.display_report.displayStrNext(str);
    }

    public void displayStrImm(String str) {
        this.display_report.displayStrImm(str);
    }

    public void displayStrTemp(String str) {
        this.display_report.displayStrTemp(str, 1000L);
    }

    public void displayStrFlash(String str, int times) {
        this.display_report.displayStrFlash(str, times);
    }

    public void displayNumNext(int num) {
        this.display_report.displayNumNext(num);
    }

    public void displayNumImm(int num) {
        this.display_report.displayNumImm(num);
    }

    public void displayNumTemp(int num) {
        this.display_report.displayNumTemp(num, 1000L);
    }

    public void displayNumNext(float num) {
        this.display_report.displayNumNext(num);
    }

    public void displayNumImm(float num) {
        this.display_report.displayNumImm(num);
    }

    public void displayNumTemp(float num) {
        this.display_report.displayNumTemp(num, 1000L);
    }

    public Component getDirection() {
        return this.getComponent((Component.Identifier)Component.Identifier.Axis._0);
    }

    public Component getThrottle() {
        return this.getComponent((Component.Identifier)Component.Identifier.Axis._1);
    }

    public Component getAutoBrake() {
        return this.getComponent((Component.Identifier)Component.Identifier.Axis._2);
    }

    public Component getIndependentBrake() {
        return this.getComponent((Component.Identifier)Component.Identifier.Axis._3);
    }

    public Component getBailOff() {
        return this.getComponent((Component.Identifier)Component.Identifier.Axis._4);
    }

    public Component getWiper() {
        return this.getComponent((Component.Identifier)Component.Identifier.Axis._5);
    }

    public Component getLights() {
        return this.getComponent((Component.Identifier)Component.Identifier.Axis._6);
    }

    public Component getButton0() {
        return this.getComponent((Component.Identifier)Component.Identifier.Button._0);
    }

    public Component getButton1() {
        return this.getComponent((Component.Identifier)Component.Identifier.Button._1);
    }

    public Component getButton2() {
        return this.getComponent((Component.Identifier)Component.Identifier.Button._2);
    }

    public Component getButton3() {
        return this.getComponent((Component.Identifier)Component.Identifier.Button._3);
    }

    public Component getButton4() {
        return this.getComponent((Component.Identifier)Component.Identifier.Button._4);
    }

    public Component getButton5() {
        return this.getComponent((Component.Identifier)Component.Identifier.Button._5);
    }

    public Component getButtonUp() {
        return this.getComponent((Component.Identifier)Component.Identifier.Button._30);
    }

    public Component getButtonRight() {
        return this.getComponent((Component.Identifier)Component.Identifier.Button._31);
    }

    public Component getButtonDown() {
        return this.getComponent((Component.Identifier)Component.Identifier.Button._32);
    }

    public Component getButtonLeft() {
        return this.getComponent((Component.Identifier)Component.Identifier.Button._33);
    }

    public Component getButtonAlert() {
        return this.getComponent((Component.Identifier)Component.Identifier.Button._38);
    }

    public Component getButtonBell() {
        return this.getComponent((Component.Identifier)Component.Identifier.Button._41);
    }
}

