/*
 * Decompiled with CFR 0.152.
 */
package net.bobis.jinput.hidraw;

import java.util.BitSet;
import net.bobis.jinput.hidraw.HidRawDevice;
import net.bobis.jinput.hidraw.HidRawOutputComponent;
import net.bobis.jinput.hidraw.HidRawOutputReport;
import net.bobis.jinput.hidraw.TimedQueue;

public final class RDDisplayOutputReport
extends HidRawOutputReport {
    private final int numLed = 3;
    private final int maxInt = 999;
    private final String intFormat = "%03d";
    private final int numDec = 2;
    private final float maxFloat = 9.99f;
    private final String floatFormat = "%#03.2f";
    private final long flashMillis = 500L;
    private final int maxFlashTimes = 5;
    private final int queueSize = 50;
    private TimedQueue.CallBack cb;
    private TimedQueue<byte[]> tq;

    RDDisplayOutputReport(HidRawDevice dev) throws Exception {
        super(dev);
        this.dataBytes = new byte[9];
        this.dataBytes[1] = -122;
        this.clean();
        this.cb = new TimedQueue.CallBack(this, "sendData");
        this.tq = new TimedQueue("RDDisplayOutputReport", 50, this.cb);
    }

    public int getNumLed() {
        return 3;
    }

    public void sendData(Object obj) {
        try {
            this.device.writeReportSync((byte[])obj);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void stop() {
        this.tq.stop();
    }

    public void clean() {
        for (int i = 2; i < this.dataBytes.length; ++i) {
            this.dataBytes[i] = 0;
        }
    }

    public boolean putValueSevenSegment(Byte value, int ss_id) {
        if (ss_id > 2 || ss_id < 0) {
            return false;
        }
        this.dataBytes[4 - ss_id] = value;
        return true;
    }

    public boolean putStr(String str) {
        return this.putStr(str, new BitSet(3));
    }

    public boolean putStr(String str, BitSet points) {
        int i;
        boolean ret = true;
        for (i = 0; i < Math.min(3, str.length()); ++i) {
            ret &= this.putValueSevenSegment(HidRawOutputComponent.SevenSegment.getByte(str.charAt(i), points.get(i)), i);
        }
        for (i = str.length(); i < 3; ++i) {
            ret &= this.putValueSevenSegment(HidRawOutputComponent.SevenSegment.NONE, i);
        }
        return ret;
    }

    public boolean putStrEmpty() {
        boolean ret = true;
        for (int i = 0; i < 3; ++i) {
            ret &= this.putValueSevenSegment(HidRawOutputComponent.SevenSegment.NONE, i);
        }
        return ret;
    }

    public boolean putNum(int value) {
        int val = Math.abs(value);
        if (val > 999) {
            val %= 1000;
        }
        String str = String.format("%03d", val);
        return this.putStr(str);
    }

    public boolean putNum(float value) {
        float val = Math.abs(value);
        BitSet bitSet = new BitSet(3);
        if (val > 9.99f) {
            return false;
        }
        String str = String.format("%#03.2f", Float.valueOf(val));
        bitSet.set(0);
        assert (str.length() == 4);
        str = str.substring(0, 1) + str.substring(2);
        return this.putStr(str, bitSet);
    }

    public boolean displayStrNext(String str) {
        return this.putStr(str) & this.tq.setValueNext((byte[])this.getOutData().clone());
    }

    public boolean displayStrNext(String str, BitSet points) {
        return this.putStr(str, points) & this.tq.setValueNext((byte[])this.getOutData().clone());
    }

    public boolean displayStrImm(String str) {
        return this.putStr(str) & this.tq.setValueImm((byte[])this.getOutData().clone());
    }

    public boolean displayStrImm(String str, BitSet points) {
        return this.putStr(str, points) & this.tq.setValueImm((byte[])this.getOutData().clone());
    }

    public boolean displayStrTemp(String str, long millis) {
        return this.putStr(str) & this.tq.setValueTemp((byte[])this.getOutData().clone(), millis);
    }

    public boolean displayStrTemp(String str, BitSet points, long millis) {
        return this.putStr(str, points) & this.tq.setValueTemp((byte[])this.getOutData().clone(), millis);
    }

    public boolean displayStrSeq(String str, long millis) {
        return this.putStr(str) & this.tq.setValueSeq((byte[])this.getOutData().clone(), millis);
    }

    public boolean displayStrSeq(String str, BitSet points, long millis) {
        return this.putStr(str, points) & this.tq.setValueSeq((byte[])this.getOutData().clone(), millis);
    }

    public boolean displayStrFlash(String str, int times) {
        boolean ret = true;
        ret &= this.putStr(str) & this.tq.setValueNext((byte[])this.getOutData().clone());
        for (int i = 0; i < Math.min(5, times); ++i) {
            ret &= this.putStr(str) & this.tq.setValueTemp((byte[])this.getOutData().clone(), 500L);
            ret &= this.putStrEmpty() & this.tq.setValueTemp((byte[])this.getOutData().clone(), 500L);
        }
        return ret;
    }

    public boolean displayNumNext(int num) {
        return this.putNum(num) & this.tq.setValueNext((byte[])this.getOutData().clone());
    }

    public boolean displayNumImm(int num) {
        return this.putNum(num) & this.tq.setValueImm((byte[])this.getOutData().clone());
    }

    public boolean displayNumTemp(int num, long millis) {
        return this.putNum(num) & this.tq.setValueTemp((byte[])this.getOutData().clone(), millis);
    }

    public boolean displayNumNext(float num) {
        return this.putNum(num) & this.tq.setValueNext((byte[])this.getOutData().clone());
    }

    public boolean displayNumImm(float num) {
        return this.putNum(num) & this.tq.setValueImm((byte[])this.getOutData().clone());
    }

    public boolean displayNumTemp(float num, long millis) {
        return this.putNum(num) & this.tq.setValueTemp((byte[])this.getOutData().clone(), millis);
    }
}

