/*
 * Decompiled with CFR 0.152.
 */
package net.bobis.jinput.hidraw;

import java.io.IOException;
import java.util.HashMap;
import net.bobis.jinput.hidraw.AbstractOutputComponent;
import net.bobis.jinput.hidraw.HidRawDevice;
import net.bobis.jinput.hidraw.OutputComponent;

public class HidRawOutputComponent {
    public static final OutputComponent.Identifier.SevenSegment getSSIdentifier(int id) {
        switch (id) {
            case 0: {
                return OutputComponent.Identifier.SevenSegment._0;
            }
            case 1: {
                return OutputComponent.Identifier.SevenSegment._1;
            }
            case 2: {
                return OutputComponent.Identifier.SevenSegment._2;
            }
            case 3: {
                return OutputComponent.Identifier.SevenSegment._3;
            }
            case 4: {
                return OutputComponent.Identifier.SevenSegment._4;
            }
            case 5: {
                return OutputComponent.Identifier.SevenSegment._5;
            }
            case 6: {
                return OutputComponent.Identifier.SevenSegment._6;
            }
            case 7: {
                return OutputComponent.Identifier.SevenSegment._7;
            }
            case 8: {
                return OutputComponent.Identifier.SevenSegment._8;
            }
            case 9: {
                return OutputComponent.Identifier.SevenSegment._9;
            }
        }
        return null;
    }

    static final class SevenSegment
    extends AbstractOutputComponent {
        private static HashMap<Character, Byte> map = new HashMap(60);
        private final HidRawDevice device;
        private final int ss_id;
        public static byte NONE;
        public static byte POINT;
        public static byte ALL;

        public SevenSegment(HidRawDevice device, OutputComponent.Identifier id, int ss_id) {
            super(id.getName(), id);
            this.device = device;
            this.ss_id = ss_id;
        }

        protected final boolean output(Object value) throws IOException {
            return false;
        }

        protected final boolean output(char value) throws IOException {
            return false;
        }

        public static byte getByte(char c, boolean withPoint) {
            Byte b = map.get(Character.valueOf(Character.toLowerCase(c)));
            if (b != null) {
                if (withPoint) {
                    return (byte)(b | POINT);
                }
                return b;
            }
            return -1;
        }

        public static byte getByte(char c) {
            return SevenSegment.getByte(c, false);
        }

        private static void init() {
            map.put(Character.valueOf('0'), (byte)63);
            map.put(Character.valueOf('1'), (byte)6);
            map.put(Character.valueOf('2'), (byte)91);
            map.put(Character.valueOf('3'), (byte)79);
            map.put(Character.valueOf('4'), (byte)102);
            map.put(Character.valueOf('5'), (byte)109);
            map.put(Character.valueOf('6'), (byte)125);
            map.put(Character.valueOf('7'), (byte)7);
            map.put(Character.valueOf('8'), (byte)127);
            map.put(Character.valueOf('9'), (byte)111);
            map.put(Character.valueOf(' '), (byte)0);
            map.put(Character.valueOf('a'), (byte)119);
            map.put(Character.valueOf('b'), (byte)124);
            map.put(Character.valueOf('c'), (byte)88);
            map.put(Character.valueOf('d'), (byte)94);
            map.put(Character.valueOf('e'), (byte)121);
            map.put(Character.valueOf('f'), (byte)113);
            map.put(Character.valueOf('g'), (byte)61);
            map.put(Character.valueOf('h'), (byte)116);
            map.put(Character.valueOf('i'), (byte)16);
            map.put(Character.valueOf('j'), (byte)30);
            map.put(Character.valueOf('k'), (byte)117);
            map.put(Character.valueOf('l'), (byte)56);
            map.put(Character.valueOf('m'), (byte)43);
            map.put(Character.valueOf('n'), (byte)84);
            map.put(Character.valueOf('o'), (byte)92);
            map.put(Character.valueOf('p'), (byte)115);
            map.put(Character.valueOf('q'), (byte)103);
            map.put(Character.valueOf('r'), (byte)80);
            map.put(Character.valueOf('s'), (byte)109);
            map.put(Character.valueOf('t'), (byte)120);
            map.put(Character.valueOf('u'), (byte)28);
            map.put(Character.valueOf('v'), (byte)98);
            map.put(Character.valueOf('w'), (byte)106);
            map.put(Character.valueOf('x'), (byte)118);
            map.put(Character.valueOf('y'), (byte)110);
            map.put(Character.valueOf('z'), (byte)91);
            map.put(Character.valueOf('-'), (byte)64);
            map.put(Character.valueOf('.'), (byte)-128);
        }

        static {
            SevenSegment.init();
            NONE = 0;
            POINT = (byte)-128;
            ALL = (byte)-1;
        }
    }

    static final class Switch
    extends AbstractOutputComponent {
        private final HidRawDevice device;
        private final int switch_id;

        public Switch(HidRawDevice device, OutputComponent.Identifier id, int switch_id) {
            super(id.getName(), id);
            this.device = device;
            this.switch_id = switch_id;
        }

        protected final boolean output(Object value) throws IOException {
            return false;
        }

        protected final boolean output(boolean value) throws IOException {
            return false;
        }
    }
}

