/*
 * Decompiled with CFR 0.152.
 */
package net.bobis.jinput.hidraw;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import net.bobis.jinput.hidraw.HidRawComponent;
import net.bobis.jinput.hidraw.HidRawDevice;
import net.bobis.jinput.hidraw.HidRawNativeDevice;
import net.java.games.input.AbstractController;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import net.java.games.util.plugins.Plugin;

public class HidRawEnvironmentPlugin
extends ControllerEnvironment
implements Plugin {
    private static final Logger log = Logger.getLogger(HidRawEnvironmentPlugin.class.getName());
    private static boolean supported = false;
    private static String osFamily = null;
    private static final String WindowsLibName = "jhidrawplugin-win";
    private static final String PostFix64bit = "_64";
    public static final String prefsFolder = "xml" + File.separator + "jinputDevices" + File.separator;
    public static final String VENDOR_ID = "vendor_id";
    public static final String PRODUCT_ID = "product_id";
    public static final String DEVICE_NAME = "device_name";
    public static final String DEVICE_NAME_DEF = "unknown name";
    public static final String UDEV_DEVICE_PATH = "udev_device_path";
    public static final String UDEV_DEVICE_PATH_DEF = "unknown path";
    public static final String NUM_COMPONENTS = "num_components";
    public static final int NUM_COMPONENTS_DEF = 70;
    private final Controller[] controllers;
    private final List active_devices = new ArrayList();
    private Preferences prefsHidRaw = Preferences.userNodeForPackage(((Object)((Object)this)).getClass()).node("HidRawDevices");
    private static final FileFilter XML_FILTER;

    public void resetPrefs() {
        try {
            this.prefsHidRaw.removeNode();
            this.prefsHidRaw.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public HidRawEnvironmentPlugin() {
        if (HidRawEnvironmentPlugin.getPrivilegedProperty("jinput.resetHidRawPreferences", "false").toLowerCase().trim().equals("true")) {
            this.resetPrefs();
        }
        Controller[] controllers = new Controller[]{};
        if (this.isSupported()) {
            try {
                controllers = this.enumControllers();
            }
            catch (IOException e) {
                log.info("Failed to enumerate devices: " + e.getMessage());
            }
            this.controllers = controllers;
            AccessController.doPrivileged(new PrivilegedAction(){

                public final Object run() {
                    Runtime.getRuntime().addShutdownHook(new ShutdownHook());
                    return null;
                }
            });
        } else {
            this.controllers = controllers;
        }
    }

    public final Controller[] getControllers() {
        return this.controllers;
    }

    private final Component[] createComponents(HidRawDevice device) {
        ArrayList<HidRawComponent.Button> controller_components = new ArrayList<HidRawComponent.Button>();
        Preferences prefs = device.getPrefs().node("Components");
        for (int i = 0; i < prefs.getInt(NUM_COMPONENTS, 70); ++i) {
            HidRawComponent component;
            Preferences prefsComp = prefs.node("comp" + i);
            String type = prefsComp.get("type", "button");
            int ident = prefsComp.getInt("ident", i);
            String name = prefsComp.get("name", "unknown");
            Object identifier = type.equals("button") ? HidRawComponent.getButtonIdentifier(ident) : (type.equals("axis") ? HidRawComponent.getAxisIdentifier(ident) : null);
            if (identifier == null) continue;
            if (type.equals("button")) {
                component = new HidRawComponent.Button(device, name, (Component.Identifier)identifier, ident);
                controller_components.add((HidRawComponent.Button)component);
            }
            if (!type.equals("axis")) continue;
            component = new HidRawComponent.Axis(device, name, (Component.Identifier)identifier, ident);
            controller_components.add((HidRawComponent.Button)component);
        }
        Component[] components = new Component[controller_components.size()];
        controller_components.toArray(components);
        return components;
    }

    private final AbstractController createControllerFromDevice(HidRawDevice device) {
        try {
            String pkg_name = ((Object)((Object)this)).getClass().getPackage().getName();
            Class<?> cls = Class.forName(pkg_name + "." + device.getNameClean());
            Class[] partypes = new Class[]{Class.forName("java.lang.String"), Class.forName(pkg_name + ".HidRawDevice"), Class.forName("[Lnet.java.games.input.Component;")};
            Constructor<?> ct = cls.getConstructor(partypes);
            Object[] arglist = new Object[]{device.getName(), device, this.createComponents(device)};
            AbstractController controller = (AbstractController)ct.newInstance(arglist);
            return controller;
        }
        catch (Exception e) {
            log.info("Failed to create HidRawController for device " + device.getName() + ": " + e.getMessage());
            return null;
        }
    }

    private final Controller[] enumControllers() throws IOException {
        ArrayList<AbstractController> controllers = new ArrayList<AbstractController>();
        List devices = this.enumHidRawDevices();
        for (int i = 0; i < devices.size(); ++i) {
            HidRawDevice device = (HidRawDevice)devices.get(i);
            AbstractController controller = this.createControllerFromDevice(device);
            if (controller == null) continue;
            controllers.add(controller);
            this.active_devices.add(device);
        }
        Controller[] controllers_array = new Controller[controllers.size()];
        controllers.toArray(controllers_array);
        return controllers_array;
    }

    public boolean isSupported() {
        return supported;
    }

    private final List enumHidRawDevices() throws IOException {
        ArrayList nativeDevices = new ArrayList();
        ArrayList<HidRawDevice> devices = new ArrayList<HidRawDevice>();
        this.loadPrefsFiles();
        if (osFamily.equals("linux")) {
            this.nLinuxEnumHidRawDevices(nativeDevices);
        }
        if (osFamily.equals("windows")) {
            this.nWindowsEnumHidRawDevices(nativeDevices);
        }
        String str = "";
        for (Object dev : nativeDevices) {
            str = str + dev.toString() + "\n";
        }
        log.info("HidRawEnvironmentPlugin, native devices: " + str);
        try {
            String[] devNodeNames = this.prefsHidRaw.childrenNames();
            for (Object dev : nativeDevices) {
                HidRawNativeDevice natDev = (HidRawNativeDevice)dev;
                boolean found = false;
                for (String devNodeName : devNodeNames) {
                    Preferences devNode = this.prefsHidRaw.node(devNodeName);
                    if (natDev.getVendorID() != devNode.getInt(VENDOR_ID, 0) || natDev.getProductID() != devNode.getInt(PRODUCT_ID, 0)) continue;
                    devices.add(new HidRawDevice(devNode.get(DEVICE_NAME, DEVICE_NAME_DEF), natDev.getPath(), natDev.getVendorID(), natDev.getProductID()));
                    found = true;
                }
                if (found) continue;
                log.info("No preferences found for native device: " + natDev.toString());
            }
        }
        catch (Exception ex) {
            log.severe("Error matching preferences: " + ex.getMessage());
        }
        return devices;
    }

    private final void nLinuxEnumHidRawDevices(List nativeDevices) throws IOException {
        long dummy = 0L;
        try {
            String[] devNodeNames;
            for (String devNodeName : devNodeNames = this.prefsHidRaw.childrenNames()) {
                Preferences devNode = this.prefsHidRaw.node(devNodeName);
                nativeDevices.add(new HidRawNativeDevice(dummy, devNode.get(DEVICE_NAME, DEVICE_NAME_DEF), devNode.get(UDEV_DEVICE_PATH, UDEV_DEVICE_PATH_DEF), devNode.getInt(VENDOR_ID, 0), devNode.getInt(PRODUCT_ID, 0)));
            }
        }
        catch (Exception ex) {
            log.severe("Error creating Linux native devices from preferences: " + ex.getMessage());
        }
    }

    private final native void nWindowsEnumHidRawDevices(List var1) throws IOException;

    private void loadPrefsFiles() {
        File dir = new File(prefsFolder);
        log.info("Scanning xml files for devices on folder: " + dir.getAbsolutePath());
        File[] xmlFiles = dir.listFiles(XML_FILTER);
        if (xmlFiles == null) {
            log.warning("No xml files found");
            return;
        }
        for (int i = 0; i < xmlFiles.length; ++i) {
            String fileName = xmlFiles[i].getName();
            String devNodeName = fileName.substring(0, fileName.length() - 4);
            try {
                if (!this.prefsHidRaw.nodeExists(devNodeName)) {
                    FileInputStream is = new FileInputStream(xmlFiles[i]);
                    log.info("Using file " + xmlFiles[i].getAbsolutePath() + " to get preferences for device " + devNodeName);
                    Preferences.importPreferences(is);
                    is.close();
                    continue;
                }
                log.info("Using already existing preferences for device " + devNodeName + "\n\t To reset preferences for _all_ HidRaw devices use -Djinput.resetHidRawPreferences=true" + "\n\t After that, preferences for this device will be loaded from " + xmlFiles[i].getAbsolutePath());
                continue;
            }
            catch (Exception ex) {
                log.warning("File " + xmlFiles[i].getAbsolutePath() + " not found or wrong format: " + ex.getMessage());
            }
        }
    }

    static void loadLibrary(final String lib_name) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public final Object run() {
                try {
                    String lib_path = System.getProperty("net.java.games.input.librarypath");
                    if (lib_path != null) {
                        System.load(lib_path + File.separator + System.mapLibraryName(lib_name));
                    } else {
                        System.loadLibrary(lib_name);
                    }
                }
                catch (UnsatisfiedLinkError e) {
                    e.printStackTrace();
                    supported = false;
                }
                return null;
            }
        });
    }

    static String getPrivilegedProperty(final String property) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(property);
            }
        });
    }

    static String getPrivilegedProperty(final String property, final String default_value) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(property, default_value);
            }
        });
    }

    private static final boolean isOSVersionOrBetterThan(int major_required, int minor_required) {
        int minor;
        int major;
        String os_version = System.getProperty("os.version");
        StringTokenizer version_tokenizer = new StringTokenizer(os_version, ".");
        try {
            String major_str = version_tokenizer.nextToken();
            String minor_str = version_tokenizer.nextToken();
            major = Integer.parseInt(major_str);
            minor = Integer.parseInt(minor_str);
        }
        catch (Exception ex) {
            log.severe("Exception occurred while trying to determine OS version: " + ex);
            return false;
        }
        return major > major_required || major == major_required && minor >= minor_required;
    }

    static {
        String osName = HidRawEnvironmentPlugin.getPrivilegedProperty("os.name", "").trim();
        if (osName.equals("Linux")) {
            supported = true;
            osFamily = "linux";
        }
        if (osName.equals("Mac OS X")) {
            supported = false;
            osFamily = "osx";
        }
        if (osName.startsWith("Windows")) {
            supported = true;
            osFamily = "windows";
            if ("x86".equals(HidRawEnvironmentPlugin.getPrivilegedProperty("os.arch"))) {
                HidRawEnvironmentPlugin.loadLibrary(WindowsLibName);
            } else {
                HidRawEnvironmentPlugin.loadLibrary("jhidrawplugin-win_64");
            }
        }
        XML_FILTER = new XmlFileFilter();
    }

    private static class XmlFileFilter
    implements FileFilter {
        private XmlFileFilter() {
        }

        public boolean accept(File file) {
            return file.getName().toLowerCase().endsWith(".xml");
        }
    }

    private final class ShutdownHook
    extends Thread {
        private ShutdownHook() {
        }

        public final void run() {
            for (int i = 0; i < HidRawEnvironmentPlugin.this.active_devices.size(); ++i) {
                HidRawDevice device = (HidRawDevice)HidRawEnvironmentPlugin.this.active_devices.get(i);
                boolean dummy = device.closeFiles();
                device.savePrefs();
            }
        }
    }
}

