/*
 * Decompiled with CFR 0.152.
 */
package net.bobis.jinput.hidraw;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import net.bobis.jinput.hidraw.HidRawEnvironmentPlugin;
import net.bobis.jinput.hidraw.HidRawInputReport;
import net.bobis.jinput.hidraw.HidRawOutputReport;

public final class HidRawDevice {
    private static final Logger log = Logger.getLogger(HidRawDevice.class.getName());
    private final Preferences prefs;
    private final String device_name;
    private final String device_path;
    private final int device_vendor_id;
    private final int device_product_id;
    private boolean isInOpened = false;
    private FileChannel inChannel;
    private ByteBuffer inBuffer;
    private boolean isOutOpened = false;
    private FileChannel outChannel;
    private ByteBuffer outBuffer;

    public HidRawDevice(String device_name, String device_path, int device_vendor_id, int device_product_id) {
        this.device_name = device_name;
        this.device_path = device_path;
        this.device_vendor_id = device_vendor_id;
        this.device_product_id = device_product_id;
        Preferences prefsHidRaw = Preferences.userNodeForPackage(this.getClass()).node("HidRawDevices");
        this.prefs = prefsHidRaw.node(this.getNameClean());
    }

    public final String getName() {
        return this.device_name;
    }

    public final String getNameClean() {
        return this.getName().replaceAll("\\W", "");
    }

    public final Preferences getPrefs() {
        return this.prefs;
    }

    public final String getNamePrefsFile() {
        return HidRawEnvironmentPlugin.prefsFolder + this.getNameClean() + ".xml";
    }

    public final void savePrefs() {
        File f = new File(this.getNamePrefsFile());
        try {
            FileOutputStream os = new FileOutputStream(f);
            this.getPrefs().flush();
            this.getPrefs().exportSubtree(os);
        }
        catch (Exception ex) {
            log.info("Impossible to save preferences to file " + f.getAbsolutePath() + ": " + ex.getMessage());
        }
    }

    public final int getVendorID() {
        return this.device_vendor_id;
    }

    public final int getProductID() {
        return this.device_product_id;
    }

    public void setInBufferSize(int size) {
        this.inBuffer = ByteBuffer.allocate(size);
    }

    public void setOutBufferSize(int size) {
        this.outBuffer = ByteBuffer.allocate(size);
    }

    public final synchronized void setBufferSize(int size) {
    }

    public final void poll() {
    }

    public final boolean getNextReport(HidRawInputReport report) {
        try {
            if (!this.readReportSync(report.getData())) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        report.set(System.currentTimeMillis());
        return true;
    }

    public final boolean setOutReport(HidRawOutputReport report) {
        try {
            if (!this.writeReportSync(report.getOutData())) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public final boolean openInFile() throws IOException {
        try {
            this.inChannel = new FileInputStream(this.device_path).getChannel();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        this.isInOpened = true;
        return true;
    }

    public final boolean closeInFile() {
        try {
            if (this.isInOpened) {
                this.inChannel.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        this.isInOpened = false;
        return true;
    }

    public final boolean readReportSync(byte[] data) throws IOException {
        int offset = 0;
        if (!this.isInOpened && !this.openInFile()) {
            return false;
        }
        this.inBuffer.clear();
        int res = this.inChannel.read(this.inBuffer);
        if (res + 1 == data.length) {
            data[0] = 0;
            offset = 1;
        } else if (res < data.length) {
            log.info("HidRawDevice, Read return: " + res);
            return false;
        }
        this.inBuffer.flip();
        this.inBuffer.get(data, offset, res);
        return true;
    }

    public final boolean openOutFile() throws IOException {
        try {
            this.outChannel = new FileOutputStream(this.device_path).getChannel();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        this.isOutOpened = true;
        return true;
    }

    public final boolean closeOutFile() {
        try {
            if (this.isOutOpened) {
                this.outChannel.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        this.isOutOpened = false;
        return true;
    }

    public final boolean writeReportSync(byte[] data) throws IOException {
        if (!this.isOutOpened && !this.openOutFile()) {
            return false;
        }
        this.outBuffer.clear();
        this.outBuffer.put(data);
        this.outBuffer.flip();
        int res = this.outChannel.write(this.outBuffer);
        if (res < data.length) {
            log.info("HidRawDevice, Write return: " + res);
            return false;
        }
        return true;
    }

    public boolean closeFiles() {
        boolean dummy = this.closeInFile();
        return this.closeOutFile() & dummy;
    }
}

