/*
 * Decompiled with CFR 0.152.
 */
package net.bobis.jinput.hidraw;

import java.io.IOException;
import net.bobis.jinput.hidraw.HidRawComponent;
import net.bobis.jinput.hidraw.HidRawDevice;
import net.bobis.jinput.hidraw.HidRawInputReport;
import net.java.games.input.AbstractController;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.Event;
import net.java.games.input.Rumbler;

public abstract class HidRawController
extends AbstractController {
    private static final int EVENT_DONE = 0;
    private static final int EVENT_AXIS_MIN = 10;
    private static final int EVENT_AXIS_MAX = 39;
    private static final int EVENT_BUTTON_MIN = 40;
    private static final int EVENT_BUTTON_MAX = 89;
    private static final int EVENT_LAST = 99;
    private int event_state = 0;
    protected final HidRawDevice device;
    protected HidRawInputReport current_report;

    public Controller.Type getType() {
        return Controller.Type.UNKNOWN;
    }

    protected abstract void setBufferSizes();

    protected HidRawController(String name, HidRawDevice device, Component[] components) throws IOException {
        this(name, device, components, new Controller[0], new Rumbler[0]);
    }

    protected HidRawController(String name, HidRawDevice device, Component[] components, Controller[] children, Rumbler[] rumblers) throws IOException {
        super(name, components, children, rumblers);
        this.device = device;
        this.setBufferSizes();
        for (Component c : this.getComponents()) {
            HidRawComponent comp = (HidRawComponent)c;
            comp.setController(this);
        }
        this.setDeviceEventQueueSize(200);
    }

    public final HidRawInputReport getCurrentReport() {
        return this.current_report;
    }

    public final void pollDevice() throws IOException {
        this.device.poll();
    }

    protected final synchronized boolean getNextDeviceEvent(Event event) throws IOException {
        block7: {
            float value;
            HidRawComponent comp;
            while (true) {
                if (this.event_state == 0) {
                    if (!this.device.getNextReport(this.current_report)) {
                        return false;
                    }
                    this.event_state = 10;
                    continue;
                }
                if (this.event_state <= 39) {
                    int axis = this.event_state - 10;
                    ++this.event_state;
                    if (this.event_state > 39) {
                        this.event_state = 40;
                    }
                    if ((comp = (HidRawComponent)this.getComponent((Component.Identifier)HidRawComponent.getAxisIdentifier(axis))) == null) continue;
                    value = comp.poll();
                    float old_val = comp.getEventValue();
                    if (!(Math.abs(value) > comp.getDeadZone()) || !(Math.abs(value - old_val) > comp.getThreshold())) continue;
                    event.set((Component)comp, value, this.current_report.getNanos());
                    return true;
                }
                if (this.event_state > 89) break block7;
                int button = this.event_state - 40;
                ++this.event_state;
                if (this.event_state > 89) {
                    this.event_state = 99;
                }
                if ((comp = (HidRawComponent)this.getComponent((Component.Identifier)HidRawComponent.getButtonIdentifier(button))) != null) break;
            }
            value = comp.poll();
            event.set((Component)comp, value, this.current_report.getNanos());
            return true;
        }
        if (this.event_state == 99) {
            this.event_state = 0;
            return false;
        }
        throw new RuntimeException("Unknown event state: " + this.event_state);
    }

    protected final void setDeviceEventQueueSize(int size) throws IOException {
        this.device.setBufferSize(size);
    }
}

