/*
 * Decompiled with CFR 0.152.
 */
package net.bobis.jinput.hidraw;

import java.io.IOException;
import java.util.prefs.Preferences;
import net.bobis.jinput.hidraw.HidRawController;
import net.bobis.jinput.hidraw.HidRawDevice;
import net.java.games.input.AbstractComponent;
import net.java.games.input.Component;

public abstract class HidRawComponent
extends AbstractComponent {
    public static final String TYPE = "type";
    public static final String TYPE_DEF = "button";
    public static final String IDENT = "ident";
    public static final Integer IDENT_DEF = 0;
    public static final String NAME = "name";
    public static final String NAME_DEF = "unknown";
    protected HidRawController controller;
    protected HidRawDevice device;

    public void setController(HidRawController cont) {
        this.controller = cont;
    }

    protected HidRawComponent(String name, Component.Identifier id) {
        super(name, id);
    }

    public float getThreshold() {
        return 0.0f;
    }

    public abstract float poll() throws IOException;

    public static final Component.Identifier.Axis getAxisIdentifier(int id) {
        switch (id) {
            case 0: {
                return Component.Identifier.Axis._0;
            }
            case 1: {
                return Component.Identifier.Axis._1;
            }
            case 2: {
                return Component.Identifier.Axis._2;
            }
            case 3: {
                return Component.Identifier.Axis._3;
            }
            case 4: {
                return Component.Identifier.Axis._4;
            }
            case 5: {
                return Component.Identifier.Axis._5;
            }
            case 6: {
                return Component.Identifier.Axis._6;
            }
            case 7: {
                return Component.Identifier.Axis._7;
            }
            case 8: {
                return Component.Identifier.Axis._8;
            }
            case 9: {
                return Component.Identifier.Axis._9;
            }
            case 10: {
                return Component.Identifier.Axis._10;
            }
            case 11: {
                return Component.Identifier.Axis._11;
            }
            case 12: {
                return Component.Identifier.Axis._12;
            }
            case 13: {
                return Component.Identifier.Axis._13;
            }
            case 14: {
                return Component.Identifier.Axis._14;
            }
            case 15: {
                return Component.Identifier.Axis._15;
            }
            case 16: {
                return Component.Identifier.Axis._16;
            }
            case 17: {
                return Component.Identifier.Axis._17;
            }
            case 18: {
                return Component.Identifier.Axis._18;
            }
            case 19: {
                return Component.Identifier.Axis._19;
            }
            case 20: {
                return Component.Identifier.Axis._20;
            }
            case 21: {
                return Component.Identifier.Axis._21;
            }
            case 22: {
                return Component.Identifier.Axis._22;
            }
            case 23: {
                return Component.Identifier.Axis._23;
            }
            case 24: {
                return Component.Identifier.Axis._24;
            }
            case 25: {
                return Component.Identifier.Axis._25;
            }
            case 26: {
                return Component.Identifier.Axis._26;
            }
            case 27: {
                return Component.Identifier.Axis._27;
            }
            case 28: {
                return Component.Identifier.Axis._28;
            }
            case 29: {
                return Component.Identifier.Axis._29;
            }
        }
        return null;
    }

    public static final Component.Identifier.Button getButtonIdentifier(int id) {
        switch (id) {
            case 0: {
                return Component.Identifier.Button._0;
            }
            case 1: {
                return Component.Identifier.Button._1;
            }
            case 2: {
                return Component.Identifier.Button._2;
            }
            case 3: {
                return Component.Identifier.Button._3;
            }
            case 4: {
                return Component.Identifier.Button._4;
            }
            case 5: {
                return Component.Identifier.Button._5;
            }
            case 6: {
                return Component.Identifier.Button._6;
            }
            case 7: {
                return Component.Identifier.Button._7;
            }
            case 8: {
                return Component.Identifier.Button._8;
            }
            case 9: {
                return Component.Identifier.Button._9;
            }
            case 10: {
                return Component.Identifier.Button._10;
            }
            case 11: {
                return Component.Identifier.Button._11;
            }
            case 12: {
                return Component.Identifier.Button._12;
            }
            case 13: {
                return Component.Identifier.Button._13;
            }
            case 14: {
                return Component.Identifier.Button._14;
            }
            case 15: {
                return Component.Identifier.Button._15;
            }
            case 16: {
                return Component.Identifier.Button._16;
            }
            case 17: {
                return Component.Identifier.Button._17;
            }
            case 18: {
                return Component.Identifier.Button._18;
            }
            case 19: {
                return Component.Identifier.Button._19;
            }
            case 20: {
                return Component.Identifier.Button._20;
            }
            case 21: {
                return Component.Identifier.Button._21;
            }
            case 22: {
                return Component.Identifier.Button._22;
            }
            case 23: {
                return Component.Identifier.Button._23;
            }
            case 24: {
                return Component.Identifier.Button._24;
            }
            case 25: {
                return Component.Identifier.Button._25;
            }
            case 26: {
                return Component.Identifier.Button._26;
            }
            case 27: {
                return Component.Identifier.Button._27;
            }
            case 28: {
                return Component.Identifier.Button._28;
            }
            case 29: {
                return Component.Identifier.Button._29;
            }
            case 30: {
                return Component.Identifier.Button._30;
            }
            case 31: {
                return Component.Identifier.Button._31;
            }
            case 32: {
                return Component.Identifier.Button._32;
            }
            case 33: {
                return Component.Identifier.Button._33;
            }
            case 34: {
                return Component.Identifier.Button._34;
            }
            case 35: {
                return Component.Identifier.Button._35;
            }
            case 36: {
                return Component.Identifier.Button._36;
            }
            case 37: {
                return Component.Identifier.Button._37;
            }
            case 38: {
                return Component.Identifier.Button._38;
            }
            case 39: {
                return Component.Identifier.Button._39;
            }
            case 40: {
                return Component.Identifier.Button._40;
            }
            case 41: {
                return Component.Identifier.Button._41;
            }
            case 42: {
                return Component.Identifier.Button._42;
            }
            case 43: {
                return Component.Identifier.Button._43;
            }
            case 44: {
                return Component.Identifier.Button._44;
            }
            case 45: {
                return Component.Identifier.Button._45;
            }
            case 46: {
                return Component.Identifier.Button._46;
            }
            case 47: {
                return Component.Identifier.Button._47;
            }
            case 48: {
                return Component.Identifier.Button._48;
            }
            case 49: {
                return Component.Identifier.Button._49;
            }
        }
        return null;
    }

    public static final class Button
    extends HidRawComponent {
        private final int button_id;

        public Button(HidRawDevice device, String name, Component.Identifier id, int button_id) {
            super(name, id);
            this.device = device;
            this.button_id = button_id;
        }

        public final boolean isRelative() {
            return false;
        }

        public final boolean isAnalog() {
            return false;
        }

        public final float poll() throws IOException {
            return this.controller.getCurrentReport().getValueButton(this.button_id);
        }
    }

    public static final class Axis
    extends HidRawComponent {
        private Preferences prefs;
        public static final String CALIB_OFFSET = "calib_zero_offset";
        public static final String CALIB_NEG = "calib_negative_factor";
        public static final String CALIB_POS = "calib_positive_factor";
        public static final String DEAD_ZONE = "dead_zone";
        public static final String THRESHOLD = "threshold";
        public static final float CALIB_OFFSET_DEF = 0.0f;
        public static final float CALIB_NEG_DEF = 10.0f;
        public static final float CALIB_POS_DEF = 10.0f;
        public static final float DEAD_ZONE_DEF = 0.05f;
        public static final float THRESHOLD_DEF = 0.05f;
        private final int axis_id;
        private float calibOffset = 0.0f;
        private float calibNeg = 10.0f;
        private float calibPos = 10.0f;
        private float deadZone = 0.05f;
        private float threshold = 0.05f;

        public Axis(HidRawDevice device, String name, Component.Identifier id, int axis_id) {
            super(name, id);
            this.device = device;
            this.axis_id = axis_id;
            this.prefs = device.getPrefs().node("Calibration").node(this.getName());
            this.calibOffset = this.prefs.getFloat(CALIB_OFFSET, 0.0f);
            this.calibNeg = this.prefs.getFloat(CALIB_NEG, 10.0f);
            this.calibPos = this.prefs.getFloat(CALIB_POS, 10.0f);
            this.deadZone = this.prefs.getFloat(DEAD_ZONE, 0.05f);
            this.threshold = this.prefs.getFloat(THRESHOLD, 0.05f);
        }

        public final boolean isRelative() {
            return false;
        }

        public final boolean isAnalog() {
            return true;
        }

        public float getDeadZone() {
            return this.deadZone;
        }

        public void setDeadZone(float deadZone) {
            this.deadZone = deadZone;
            this.prefs.putFloat(DEAD_ZONE, deadZone);
        }

        public float getThreshold() {
            return this.threshold;
        }

        public void setThreshold(float threshold) {
            this.threshold = threshold;
            this.prefs.putFloat(THRESHOLD, threshold);
        }

        public float getCalibOffset() {
            return this.calibOffset;
        }

        public void setCalibOffset(float poll) {
            this.calibOffset = poll;
            this.prefs.putFloat(CALIB_OFFSET, this.calibOffset);
        }

        public float getCalibNeg() {
            return this.calibNeg;
        }

        public void setCalibNeg(float poll) {
            this.calibNeg = (float)Math.pow(10.0, 1.0 / (double)Math.abs(poll - this.calibOffset));
            this.prefs.putFloat(CALIB_NEG, this.calibNeg);
        }

        public float getCalibPos() {
            return this.calibPos;
        }

        public void setCalibPos(float poll) {
            this.calibPos = (float)Math.pow(10.0, 1.0 / (double)(poll - this.calibOffset));
            this.prefs.putFloat(CALIB_POS, this.calibPos);
        }

        public final float poll() throws IOException {
            float val = this.controller.getCurrentReport().getValueAxis(this.axis_id);
            if ((val -= this.getCalibOffset()) >= 0.0f) {
                return Math.min(1.0f, (float)Math.pow(this.getCalibPos(), val) / 10.0f);
            }
            return Math.max(-1.0f, (float)Math.pow(this.getCalibNeg(), -val) / -10.0f);
        }

        public final float pollRaw() {
            return this.controller.getCurrentReport().getValueAxis(this.axis_id);
        }
    }
}

