/*
 * Decompiled with CFR 0.152.
 */
package net.bobis.jinput.hidraw;

import java.util.BitSet;
import net.bobis.jinput.hidraw.HidRawDevice;
import net.bobis.jinput.hidraw.ReDACDigitalOutputReport;
import net.bobis.jinput.hidraw.TimedQueue;

public class AAR105LightOutputReport
extends ReDACDigitalOutputReport {
    private final int numLed = 6;
    private final long flashMillis = 500L;
    private final int maxFlashTimes = 5;
    private final int queueSize = 50;
    private TimedQueue.CallBack cb = new TimedQueue.CallBack(this, "sendData");
    private TimedQueue<byte[]> tq = new TimedQueue("AAR105LightOutputReport", 50, this.cb);

    AAR105LightOutputReport(HidRawDevice dev) throws Exception {
        super(dev);
    }

    public int getNumLed() {
        return 6;
    }

    public void stop() {
        this.tq.stop();
    }

    public boolean putValueLight(boolean on, int light_id) {
        int pin;
        if (light_id > 6 || light_id < 1) {
            return false;
        }
        switch (light_id) {
            case 1: {
                pin = 14;
                break;
            }
            case 2: {
                pin = 24;
                break;
            }
            case 3: {
                pin = 10;
                break;
            }
            case 4: {
                pin = 17;
                break;
            }
            case 5: {
                pin = 15;
                break;
            }
            case 6: {
                pin = 3;
                break;
            }
            default: {
                return false;
            }
        }
        return this.putValuePin(on, pin);
    }

    public boolean putValueLights(BitSet lights) {
        boolean ret = true;
        for (int i = 0; i < lights.size(); ++i) {
            ret &= this.putValueLight(lights.get(i), i);
        }
        return ret;
    }

    public boolean putAllLightsOn() {
        BitSet bs = new BitSet(6);
        bs.set(0, 6);
        return this.putValueLights(bs);
    }

    public boolean putAllLightsOff() {
        return this.putValueLights(new BitSet(6));
    }

    public boolean displayLightNext(boolean on, int light_id) {
        return this.putValueLight(on, light_id) & this.tq.setValueNext((byte[])this.getOutData().clone());
    }

    public boolean displayLightsNext(BitSet lights) {
        return this.putValueLights(lights) & this.tq.setValueNext((byte[])this.getOutData().clone());
    }

    public boolean displayLightImm(boolean on, int light_id) {
        return this.putValueLight(on, light_id) & this.tq.setValueImm((byte[])this.getOutData().clone());
    }

    public boolean displayLightsImm(BitSet lights) {
        return this.putValueLights(lights) & this.tq.setValueImm((byte[])this.getOutData().clone());
    }

    public boolean displayLightTemp(boolean on, int light_id, long millis) {
        return this.putValueLight(on, light_id) & this.tq.setValueTemp((byte[])this.getOutData().clone(), millis);
    }

    public boolean displayLightsTemp(BitSet lights, long millis) {
        return this.putValueLights(lights) & this.tq.setValueTemp((byte[])this.getOutData().clone(), millis);
    }

    public boolean displayLightSeq(boolean on, int light_id, long millis) {
        return this.putValueLight(on, light_id) & this.tq.setValueSeq((byte[])this.getOutData().clone(), millis);
    }

    public boolean displayLightsSeq(BitSet lights, long millis) {
        return this.putValueLights(lights) & this.tq.setValueSeq((byte[])this.getOutData().clone(), millis);
    }

    public boolean displayAllLightsFlash(int times) {
        boolean ret = true;
        for (int i = 0; i < Math.min(5, times); ++i) {
            ret &= this.putAllLightsOn() & this.tq.setValueTemp((byte[])this.getOutData().clone(), 500L);
            ret &= this.putAllLightsOff() & this.tq.setValueTemp((byte[])this.getOutData().clone(), 500L);
        }
        return ret;
    }
}

