/*
 *   options.c
 *
 *   (C) Richard Drummond 2001-2007
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 */

#ifndef OPTIONS_H
#define OPTIONS_H

#include "defs.h"


#define OPT_TYPE_BOOLEAN    0
#define OPT_TYPE_STRING     1
#define OPT_TYPE_INT        2


typedef struct
{
  char *name;
  int   type;
  int   offset;
  char *help;
} OptionTemplate;


int Options_parse( const OptionTemplate *tmplt, void *opts, int argc, const char *argv[] );
void Options_printUsage( const OptionTemplate *opt, FILE *stream );

#endif /* OPTIONS_H */
