/*
 * This application is free software and is released under the terms of
 * the BSD license. See LICENSE file for details.
 *
 * Copyright (c) 2010 Volker Poplawski (volker@openbios.org)
 */
#include "recordWidget.h"
#include "global.h"

RecordWidget::RecordWidget(QWidget *parent) :
    QWidget(parent)
{
  QVBoxLayout* vbox = new QVBoxLayout;
  setLayout(vbox);

  m_textEdit = new QTextEdit(this);
  m_textEdit->setReadOnly(true);
  layout()->addWidget(m_textEdit);
}


void RecordWidget::setRecord(const AsterixRecord *record)
{
  m_textEdit->clear();

  if (record == 0)
    return;

  const uchar* const p = record->data();  // points to fspec bytes
  m_textEdit->setHtml(renderFspecHtml(p));
}
