/*
 * This application is free software and is released under the terms of
 * the BSD license. See LICENSE file for details.
 *
 * Copyright (c) 2010 Volker Poplawski (volker@openbios.org)
 */

#include <QtWidgets>
#include <QCommandLineParser>

#include <iostream>
#include <locale.h>
#include "global.h"
#include "mainWindow.h"

#include <map>


int main(int argc, char *argv[])
{
  QApplication app(argc, argv);
  QApplication::setApplicationName("asterixInspector");
  QApplication::setApplicationVersion(g_version);

  QCommandLineParser parser;
  parser.addHelpOption();
  parser.addVersionOption();
  parser.addPositionalArgument("file", "Asterix file to open");
  parser.addOption(QCommandLineOption("specs", "Add specifications from directory", "specs"));

  parser.process(app);

  if (!parser.positionalArguments().isEmpty())
  {
    g_openFileName = parser.positionalArguments()[0];
  }
  g_specsDirectory = parser.value("specs");

  // UAP parser uses sscanf() to parse floats. Force sane locale.
  setlocale(LC_NUMERIC, "C");

  MainWindow w;
  w.show();

  return app.exec();
}
