/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 2.0.0
 * november 2000
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#include "chartcompo.h"
#include <stdlib.h>
#define MAX_COLORS 7
struct { int red,green,blue; } colors[MAX_COLORS] =
{
  {255,255,255},
  {255,0,0},
  {0,255,0},
  {0,0,255},
  {255,255,0},
  {0,255,255},
  {255,0,255}
};
const int MIN = 0;
const int MAX = 200;
const int SIZE = 20;
///////////////////////////////////////////////////   
DEFINE_SIGNAL_MAP(ChartComponent,VDKBox)
  ON_SIGNAL(plot,clicked_signal,Plot),
  ON_SIGNAL(clear,clicked_signal,ClearPlot),
  ON_SIGNAL(combo,selection_changed_signal,OnCombo)
END_SIGNAL_MAP
///////////////////////////////////////////////////
/*
 */
bool ChartComponent::OnCombo(VDKObject*)
{
int sel = combo->Selected;
switch(sel)
  {
  case 0:
    LineChart();
    ClearPlot(chart);
    break;
  case 1:
    ScatteredChart();
    ClearPlot(chart);
    break;
  case 2:
    BarChart();
    ClearPlot(chart);
  }
 return true;
}
/*
 */
bool ChartComponent::ClearPlot(VDKObject*)
{
if(chart)
  {
    chart->Clear();
    z = 0;
  }
return true;
}
/*
 */

bool ChartComponent::Plot(VDKObject*)
{
if(!chart)
  return true;
switch(chart->isA())
  {
  case linechart_class:
    PlotSeries(true,SIZE);
    break;
  case scatteredchart_class:
    PlotSeries(false,SIZE);
    break;
  case barchart_class:
    PlotSeries(false,1); 
    break;
  }
return true;
}
/*
 */

void ChartComponent::PlotSeries(bool sort, int size)
{
  int t;
  char buff[32];
  static int range = MAX-MIN;
  Darray x(size),y(size);
#if defined _WIN32 || defined _WIN64
  srand(time(NULL));
  for (t=0; t < size; t++)
    {
      x[t] = MIN + rand()%range;
      y[t] = MIN + rand()%range; 
    }
#else
  srandom((unsigned int)(time(NULL)));
  for (t=0; t < size; t++)
    {
      x[t] = MIN + random()%range;
      y[t] = MIN + random()%range; 
    }
#endif
  if(sort)
    {
      x.Heapsort();
      y.Heapsort();
    }
  sprintf(buff,"Series %d",++z);
  Series *s = new Series(buff);
  for (t=0; t < x.size(); t++)
    s->Add(x[t],y[t]);
  s->Color = VDKRgb(colors[z%MAX_COLORS].red,
		    colors[z%MAX_COLORS].green,
		    colors[z%MAX_COLORS].blue);
  chart->LabelXDigits = 1;
  chart->LabelYDigits = 1;
  chart->Title = buff;
  chart->LabelX = buff;
  chart->LabelY = buff;
  chart->AddSeries(s);
}
/*
 */

void ChartComponent::Setup()
{
  char buff[64];
  LineChart();
  VDKBox *box1 = new VDKBox(Owner(),h_box);
  combo = new VDKCombo(Owner());
  StringList sl = combo->PopdownStrings;
  sl.add("VDKLineChart");
  sl.add("VDKScatteredChart");
  sl.add("VDKBarChart");
  combo->PopdownStrings = sl;
  sprintf(buff,"Plots %d randomly generated points (sorted)",SIZE);
  plot = new VDKCustomButton(Owner(),"Plot");
  plot->SetTip(buff);
  clear = new VDKCustomButton(Owner(),"Clear");
  box1->Add(combo,l_justify,true,true,5);
  box1->Add(plot,l_justify,true,true,5); 
  box1->Add(clear,l_justify,true,true,5);  
  Add(box1,r_justify,false,false,0);
}
/*
 */
void ChartComponent::LineChart()
{
  if(chart)
    RemoveObject(chart);
  chart = new VDKLineChart(Owner(),400,300);
  chart->NormalBackground = VDKRgb("navyblue");
  chart->Foreground = clYellow;
  chart->Font = new VDKFont(this,"helvetica 8");
  chart->ChartBorder = 60;
  chart->Title = "VDKLineChart";
  Add(chart);
}
/*
 */
void ChartComponent::ScatteredChart()
{
  if(chart)
      RemoveObject(chart);
  chart = new VDKScatteredChart(Owner(),400,300);
  chart->NormalBackground = clBlack;
  chart->Foreground = clGreen;
  chart->Font = new VDKFont(this,"helvetica 8");
  chart->ChartBorder = 60;
  chart->Title = "VDKScatteredChart";
  Add(chart);
}
/*
 */
void ChartComponent::BarChart()
{
  if(chart)
      RemoveObject(chart);
  chart = new VDKBarChart(Owner(),400,300);
  chart->NormalBackground = clBlack;
  chart->Foreground = clGreen;
  chart->Font = new VDKFont(this,"helvetica 8");
  chart->ChartBorder = 60;
  chart->Title = "VDKBarChart";
  Add(chart);
}
