/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * Revision on vdk 0.5.3
 * Feb 1999 by mm
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#include "vdk/vdkobj.h"
#include "vdk/forms.h"
#include "vdk/evhandle.h"
#include "vdk/evobjhandle.h"
#include "vdk/colors.h"
#include "vdk/tooltips.h"
#include "vdk/vdkfont.h"
#include <config.h>
#include <vdk/widcontain.h>
#include <vdk/vdkcustom.h>
#ifdef VDKDEBUG
int objectC = 0;
int objectD = 0;
extern int objRemoved;
#endif

#define color_nihil VDKRgb(-1,-1,-1)

// VDKObjectSignalUnit class
VDKObjectSignalUnit::VDKObjectSignalUnit(void* owner,void *obj, char* signal) :
        owner(owner),obj(obj),signal(signal)
{
}
VDKObjectSignalUnit::~VDKObjectSignalUnit()
{
}

// VDKObjectEventUnit class
VDKObjectEventUnit::VDKObjectEventUnit(void* owner,void *obj, char* signal) :
        owner(owner),obj(obj),signal(signal)
{
}

VDKObjectEventUnit::~VDKObjectEventUnit()
{
}

// SizeObjectProp class
SizeObjectProp::SizeObjectProp()
{
}

SizeObjectProp::SizeObjectProp(char* name, VDKObject* object,
                   void (VDKObject::*write)(VDKPoint),
                   VDKPoint (VDKObject::*read)(void)) :
		SizeOProp(name,object,VDKPoint(0,0),write,read)
{
}

SizeObjectProp::~SizeObjectProp()
{
}

// VDKObject class
void
VDKObject::SetNormalBackground(VDKRgb c)
{
	SetBackground(c,GTK_STATE_NORMAL);
}
void
VDKObject::SetPrelightBackground(VDKRgb c)
{
	SetBackground(c,GTK_STATE_PRELIGHT);
}
void
VDKObject::SetInsensitiveBackground(VDKRgb c)
{
	SetBackground(c,GTK_STATE_INSENSITIVE);
}
void
VDKObject::SetActiveBackground(VDKRgb c)
{
	SetBackground(c,GTK_STATE_ACTIVE);
}
void
VDKObject::SetSelectedBackground(VDKRgb c)
{
	SetBackground(c,GTK_STATE_SELECTED);
}

int
VDKObject::isA()
{
	return object_class;
}

VDKForm*
VDKObject::Owner()
{
	return owner;
}

VDKCursorType
VDKObject::GetCursor() 
{
	return Cursor;
}

void
VDKObject::SetNormalForeground(VDKRgb color) 
{
	SetForeground(color);
}

void
VDKObject::SetSize(int w, int h) 
{
	if(GTK_IS_WIDGET(widget))
	gtk_widget_set_usize(GTK_WIDGET(widget),w,h);
}

void
VDKObject::SetUsize(VDKPoint s) 
{
	SetSize(s.X(),s.Y());
}

bool
VDKObject::GetEnabled() 
{
	return Enabled;
}

bool
VDKObject::GetVisible() 
{
	return GTK_WIDGET_VISIBLE(widget);
}

VDKFont*
VDKObject::GetFont()
{
	return Font;
}

ItemList&
VDKObject::Items() 
{
	return items;
}

ItemList&
VDKObject::Garbages() 
{
	return garbages;
}

RawList&
VDKObject::Raws() 
{
	return raws;
}

void
VDKObject::SignalEmitParent(int signal)
{
	SignalEmit(signal,Parent_level);
}

GtkWidget*
VDKObject::Widget()
{
  return widget ? GTK_WIDGET(widget): (GtkWidget*) NULL;
}
/*
 */
GtkWidget*
VDKObject::ConnectingWidget()
{
  return sigwid ? GTK_WIDGET(sigwid) : widget ? GTK_WIDGET(widget): (GtkWidget*) NULL;
}

GtkWidget*
VDKObject::WrappedWidget()
{
  return ConnectingWidget();
}

/*
 */
VDKObject::VDKObject(VDKForm* owner):
  // sets properties
    NormalBackground("NormalBackGround",this,
		     color_nihil,
		     &VDKObject::SetNormalBackground),
    PrelightBackground("PrelightBackGround",this,
		       color_nihil,
		       &VDKObject::SetPrelightBackground),
    InsensitiveBackground("InsensitiveBackGround",
			  this,
			  color_nihil,
			  &VDKObject::SetInsensitiveBackground),

    ActiveBackground("ActiveBackGround",
		     this,
		     color_nihil,
		     &VDKObject::SetActiveBackground),

    SelectedBackground("SelectedBackGround",
		       this,
		     color_nihil,
		     &VDKObject::SetSelectedBackground),
    Foreground("Foreground",this,
	       color_nihil,
	       &VDKObject::SetNormalForeground),

    Font("Font",this,NULL,&VDKObject::SetFont),
    Usize("Usize",this),
    Enabled("Enabled",this,true,&VDKObject::Enable),
    Cursor("Cursor",this,curDefault,&VDKObject::SetCursor),
    Visible("Visible",this,true,&VDKObject::SetVisible,&VDKObject::GetVisible),
    HasFocus("HasFocus",this,false,&VDKObject::isFocused),
    Tag(0),
    //
    tip(NULL),
    owner(owner),
    widget(NULL),
    sigwid(NULL),
    parent(NULL)
#ifdef USE_SIGCPLUSPLUS
     , OnRawEvent(this)
     , OnButtonEvent(this)
     , OnKeyEvent(this)
     , OnKeyFocusEvent(this)
     , OnPointerFocusEvent(this)
     , OnPointerEvent(this)
     , OnMapEvent(this)
     , OnGeometryEvent(this)
     , OnPaintEvent(this)
#endif     
    {
#ifdef VDKDEBUG
	objectC++;
#endif /* USE_SIGCPLUSPLUS */
    }

/*
 */
VDKObject::VDKObject(VDKForm* owner,GtkWidget* widget):
  // sets properties
    NormalBackground("NormalBackGround",this,
		     color_nihil,
		     &VDKObject::SetNormalBackground),
    PrelightBackground("PrelightBackGround",this,
		       color_nihil,
		       &VDKObject::SetPrelightBackground),
    InsensitiveBackground("InsensitiveBackGround",
			  this,
			  color_nihil,
			  &VDKObject::SetInsensitiveBackground),
    ActiveBackground("ActiveBackGround",
		     this,
		     color_nihil,
		     &VDKObject::SetActiveBackground),
    SelectedBackground("SelectedBackGround",
		       this,
		       color_nihil,
		       &VDKObject::SetSelectedBackground),
    Foreground("Foreground",this,
	       color_nihil,
	       &VDKObject::SetNormalForeground),
    Font("Font",this,NULL,&VDKObject::SetFont),
    Usize("Usize",this),
    Enabled("Enabled",this,true,&VDKObject::Enable),
    Cursor("Cursor",this,curDefault,&VDKObject::SetCursor),
    Visible("Visible",this,true,&VDKObject::SetVisible,&VDKObject::GetVisible),
    HasFocus("HasFocus",this,false,&VDKObject::isFocused),
    Tag(0),
    //
    tip(NULL),
    owner(owner),
    widget(widget),
    sigwid(NULL),
    parent(NULL)
#ifdef USE_SIGCPLUSPLUS
     , OnRawEvent(this)
     , OnButtonEvent(this)
     , OnKeyEvent(this)
     , OnKeyFocusEvent(this)
     , OnPointerFocusEvent(this)
     , OnPointerEvent(this)
     , OnMapEvent(this)
     , OnGeometryEvent(this)
     , OnPaintEvent(this)
#endif /* USE_SIGCPLUSPLUS */
{
#ifdef VDKDEBUG
    objectC++;
#endif
}

/*
 */
void VDKObject::SetCursor(VDKCursorType curType)
{
  GdkCursor *cursor = NULL;
  if((! widget) || (! widget->window)) return;
  // restore default cursor
  if(curType == curDefault) gdk_window_set_cursor(widget->window, NULL);
  else {
      cursor = gdk_cursor_new((GdkCursorType)curType);
      gdk_window_set_cursor (widget->window, cursor);
      // plm - 07/11/2005
      //gdk_cursor_destroy (cursor);
      gdk_cursor_unref(cursor);
  }
  /* X operations are not synchronous.
     Request is queued by the client
     but not delivered to the server.
     So with this call the change occurs
     immediately
  */
  gdk_flush();
}
/*
  Overridden in some subclasses
 */
void VDKObject::ConnectDefaultEvents()
{

}
/*

 */
void VDKObject::ConnectDefaultSignals()
{
  if(! widget )
    return;
  else if(!(dynamic_cast<VDKObjectContainer*>(this)))
     {
       s_realize.obj = this;
       s_realize.signal = realize_signal;
       GtkWidget* gtkwidget = ConnectingWidget();
       gtk_signal_connect(GTK_OBJECT(gtkwidget),"realize",
			  GTK_SIGNAL_FUNC(VDKObject::VDKSignalPipe),
			  (gpointer) &s_realize);
     }
  /*
  gtk_widget_set_events(widget,GDK_ALL_EVENTS_MASK);
  gtk_widget_set_events(WrappedWidget(),GDK_ALL_EVENTS_MASK);
  */
  //  printf("\nvoid VDKObject::ConnectDefaultSignals()");
  // fflush(stdout);

}
/*
 */
VDKObject::~VDKObject()
{
  /*
    delete items, garbage and raws
  */
  ItemListIterator li(items);
  for(;li;li++)
    delete li.current();

  ItemListIterator lg(garbages);
  for(;lg;lg++)
    delete lg.current();

  RawListIterator lr(raws);
  for(;lr;lr++)
    delete lr.current();

  // deletes signal unit list
  SignalUnitListIterator lu(suList);
  for(;lu;lu++)
    delete lu.current();

  // deletes event unit list
  EventUnitListIterator le(euList);
  for(;le;le++)
    delete le.current();
#ifdef VDKDEBUG
    objectD++;
#endif

}

/*
 */
void
VDKObject::SetVisible(bool visible)
{
  /*
     could be wrong iterate on subwidget tree
     since gtk+ makes the job already
     (who knows ?)
     mm. 5.51999
     ItemListIterator li(items);
     for(;li;li++)
     li.current()->SetVisible(visible);
  */
  ShowWidget(visible);
}

VDKObject*
VDKObject::Parent(VDKObject* p)
{
	if (p) parent = p;
	return parent;
}
/*
  ==================================
  SIGNAL HANDLING FOR STATIC TABLES
  AND DYNAMIC SIGNAL LISTS
  ==================================
  "the signal is considered treated if and only if a user response
  returned true".
  Signal flow:
  1. to object level and up to his hierarchy if not treated.
  2. to parent level and up to parent hierarchy if not treated.
  if parent has a parent step 2 will be repeated until found
  a parent without parent.
  3. if yet not treated signal is lost.
*/
/*
=======================
handles signal calling
static tables routines
=======================
*/
void
VDKObject::VDKSignalPipe(GtkWidget* w, void* s)
{
  g_return_if_fail(s != NULL);
  VDKObjectSignal* signal =
    reinterpret_cast<VDKObjectSignal*>(s);
  VDKObject* obj = reinterpret_cast<VDKObject*>(signal->obj);
  // visits class level
  if(obj->VDKObjectSignalResponse(w,signal->signal,obj,false))
    return;
  // visit parent level
  VDKObject* parent;
  for(parent = obj->Parent(); parent; parent = parent->Parent())
    if(parent->VDKSignalResponse(w,signal->signal,obj,obj,false))
      break;
}

int
VDKObject::VDKObjectSignalResponse(GtkWidget* , int , void*, bool) 
{
	return FALSE;
}

int
VDKObject::VDKObjectEventResponse(GtkWidget* , GdkEvent*, void*, bool) 
{
	return FALSE;
}

int
VDKObject::ObjectSignalDetach(int , int ) 
{
	return -1;
}

bool
VDKObject::ObjectSignalAttach(int ) 
{
	return false;
}

int
VDKObject::ObjectEventDetach(VDKEvent ) 
{
	return -1;
}

bool
VDKObject::ObjectEventAttach(int ) 
{
	return false;
}

int
VDKObject::VDKObjectSignalResponseTableSize() 
{
	return 0;
}

int
VDKObject::VDKObjectEventResponseTableSize() 
{
	return 0;
}

int
VDKObject::VDKSignalResponse(GtkWidget* , int , void*, void *, bool) 
{
	return 0;
}

int
VDKObject::VDKEventResponse(GtkWidget* , GdkEvent* , void*, void*, bool )
{
	return 0;
}

int
VDKObject::SignalDetach(VDKObject* , int ) 
{
	return -1;
}

bool
VDKObject::SignalAttach(int ) 
{
	return false;
}

int
VDKObject::EventDetach(VDKObject* ,VDKEvent ) 
{
	return -1;
}

bool
VDKObject::EventAttach(int ) 
{
	return false;
}

int
VDKObject::VDKSignalResponseTableSize() 
{
	return 0;
}

int
VDKObject::VDKEventResponseTableSize() 
{
	return 0;
}

/*
=======================
handles signal calling
dynamic list  routines
=======================
*/
void
VDKObject::VDKSignalUnitPipe(GtkWidget* w, void* s)
{
  g_return_if_fail(s != NULL);
  VDKObjectSignalUnit* signal =
    reinterpret_cast<VDKObjectSignalUnit*>(s);
  VDKObject* obj = reinterpret_cast<VDKObject*>(signal->obj);
  // visits class level if signal->owner == signal->obj
  // it depends if user call SignalEmit(obj,signal,func)
  // or SignalEmitParent(obj,signal,func)
  if(signal->owner == signal->obj) //SignalEmit()
    {
      if(obj->VDKSignalUnitResponse(w,(char*) signal->signal,obj))
	return;
      VDKForm* f;
      /* if obj is a form, see if has an owner,
	 in this case is a child form so try to disseminate
	 also to his parent form
      */
      if((f = dynamic_cast<VDKForm*>(obj)) )
	{
	  // main application does not have an owner
	  VDKForm* owner = f->Owner();
	  if(owner)
	    {
	      bool result = 
		owner->VDKSignalUnitResponse(w,(char*) signal->signal,obj);
	      if(result)
		return;
	    }
	}
    }
    // else visit parent level  user called SignalEmitParent()
  VDKObject* parent;
  for(parent = obj->Parent(); parent; parent = parent->Parent())
    {
      if(parent->VDKSignalUnitResponse(w,(char*) signal->signal,obj))
	break;
      VDKForm* f;
      /* if parent is a form, see if has an owner,
	 in this case is a child form so try to disseminate
	 also to his parent form
      */
      if((f = dynamic_cast<VDKForm*>(parent)) )
	{
	  // main application does not have an owner
	  VDKForm* owner = f->Owner();
	  if(owner)
	    {
	      bool result = 
		owner->VDKSignalUnitResponse(w,(char*) signal->signal,obj);
	      if(result)
		return;
	    }
	}
    }
}
/*
=======================
handles events calling
static tables routines
=======================
 */
int
VDKObject::VDKEventPipe(GtkWidget* w, GdkEvent* event, void* o)
{
  g_return_val_if_fail(o!= NULL, FALSE);
  VDKObject* obj = reinterpret_cast<VDKObject*>(o);
  if(obj->VDKObjectEventResponse(w,event,o,false))
    return TRUE;
  VDKObject* parent;
  for(parent = obj->Parent(); parent; parent = parent->Parent())
    if(parent->VDKEventResponse(w,event,o,o, false))
      return TRUE;
  return FALSE; //TRUE;
}
/*
=======================
handles events calling
dynamic list  routines
=======================
*/
int
VDKObject::VDKEventUnitPipe(GtkWidget* w, GdkEvent* ev, void* s)
{
  g_return_val_if_fail(s != NULL, TRUE);
  VDKObjectEventUnit* event =
    reinterpret_cast<VDKObjectEventUnit*>(s);
  VDKObject* obj = reinterpret_cast<VDKObject*>(event->obj);
  // visits class level if event->owner == event->obj
  if(event->owner == event->obj)
    {
      if(obj->VDKEventUnitResponse(w,(char*) event->signal, ev, obj))
	return TRUE;
      VDKForm* f;
      /* if obj is a form, see if has an owner,
	 in this case is a child form so try to disseminate
	 also to his parent form
      */
      if((f = dynamic_cast<VDKForm*>(obj)) )
	{
	  // main application form does not have an owner
	  VDKForm* owner = f->Owner();
	  if(owner)
	    {
	      bool result = 
		owner->VDKEventUnitResponse(w,(char*) event->signal,ev,obj);
	      if(result)
		return TRUE;
	    }
	}
    }
    // visit parent level
  VDKObject* parent;
  for(parent = obj->Parent(); parent; parent = parent->Parent())
    {
      if(parent->VDKEventUnitResponse(w,(char*) event->signal,ev, obj))
	return TRUE;
      VDKForm* f;
      /* if parent is a form, see if has an owner,
	 in this case is a child form so try to disseminate
	 also to his parent form
      */
      if((f = dynamic_cast<VDKForm*>(parent)) )
	{
	  // main application form does not have an owner
	  VDKForm* owner = f->Owner();
	  if(owner)
	    {
	      bool result = owner->VDKEventUnitResponse(w,(char*) event->signal,ev,obj);
	      if(result)
		return TRUE;
	    }
	}
    }
  return FALSE;
}

int
VDKObject::SignalConnect(VDKObject* obj, 
      char* signal,
      bool (VDKObject::*method)(VDKObject*), 
      bool gtk,
      bool after) 
{
	return -1;
}

int
VDKObject::SignalConnect(char* signal ,
      bool (VDKObject::*method)(VDKObject*), 
      bool gtk,
      bool after) 
{
	return -1;
}

int
VDKObject::VDKSignalUnitResponse(GtkWidget* , char* , void*) 
{
	return 0;
}

bool
VDKObject::SignalDisconnect(int connection) 
{
	return false;
}

bool
VDKObject::FindSignalAtClassLevel(VDKObject* , char* ) 
{
	return false;
}

bool
VDKObject::FindSignalAtParentLevel(VDKObject* , char* ) 
{
	return false;
}

bool
VDKObject::FindEventAtClassLevel(VDKObject* , char* ) 
{
	return false;
}

bool
VDKObject::FindEventAtParentLevel(VDKObject* , char* ) 
{
	return false;
}

int
VDKObject::VDKEventUnitResponse(GtkWidget* , char* , GdkEvent* , void*)
{
	return 0;
}

int
VDKObject::EventConnect(VDKObject* obj, 
       char* event, 
       bool (VDKObject::*method) (VDKObject* , GdkEvent*), 
       bool after) 
{
	return -1;
}

int
VDKObject::EventConnect(char* , bool (VDKObject::*) (VDKObject* , GdkEvent*), 
       bool after) 
{
	return -1;
}

bool
VDKObject::EventDisconnect(int connection) 
{
	return false;
}
int
VDKObject::VDKSignalResponseListSize()
{
	return 0;
}

/*
==================
signal emitting
(static tables)
=================
*/
void VDKObject::SignalEmit(int sig)
{
  VDKObjectSignal signal;
  signal.obj = this;
  signal.signal = sig;
  VDKSignalPipe(widget,&signal);
}
/*
==================
signal emitting
(dyna tables)
=================
 */
void VDKObject::SignalEmit(char* sig)
{
  VDKObjectSignalUnit* signal = new VDKObjectSignalUnit(this,this,sig);
  suList.add(signal);
  VDKSignalUnitPipe(widget,signal);
}
/*
==================
signal emitting
to parent level
(dyna lists)
=================
 */
void VDKObject::SignalEmitParent(char* sig)
{
  VDKObjectSignalUnit* signal = new VDKObjectSignalUnit(Parent(),this,sig);
  suList.add(signal);
  VDKSignalUnitPipe(widget,signal);
}
/*
==================
signal emitting
to class or
parent level
(static tables)
=================
private
 */
void VDKObject::SignalEmit(int signal, int level)
{
  VDKObject* obj_parent;
  switch (level)
    {
      // visit class level
    case Class_level:
      if(VDKObjectSignalResponse(widget, signal, this,false))
	return;
      // visit level passing himself as sender
    case Parent_level:
      for(obj_parent = Parent(); obj_parent; obj_parent = obj_parent->Parent())
	if(obj_parent->VDKSignalResponse(widget, signal,
					 this, this, false))
	  break;
    }
}

/*
======================================================================
*/
/*
 */
void
VDKObject::SetFont(VDKFont* font)
{
  if(!widget) return;
  _setFont_(widget,font);
  ItemListIterator li(items);
  for(;li;li++)
	li.current()->SetFont(font);

}
/*
 */
void
VDKObject::_setFont_(GtkWidget* wid, VDKFont* font)
{
  if(GTK_IS_WIDGET(wid) && font)
    {
	
      //      if(!GTK_WIDGET_REALIZED(wid))
      //	{
      	  PangoFontDescription* font_desc = font->AsPangoFontDescription();
      	  g_return_if_fail (font_desc != NULL);
      	  gtk_widget_modify_font (wid,font_desc);
	  
	  // 	}
      /*
      else
	{
	  GtkRcStyle *rc_style;
	  rc_style = gtk_rc_style_new ();
	  rc_style->font_desc = 
	    pango_font_description_copy (font->AsPangoFontDescription());
	  gtk_widget_modify_style (WrappedWidget(), rc_style);
	  gtk_rc_style_unref (rc_style);
	  gtk_widget_size_request (wid, NULL);
	}
	  */
    }
}

/*
 */
void
VDKObject::SetForeground(VDKRgb color, GtkStateType state)
{
  if(!widget) return;
  _setForeground_(widget,color.red,color.green,color.blue, state);
}

/*
 */
void
VDKObject::SetBackground(VDKRgb color, GtkStateType state)
{
  if(!widget) return;
  _setBackground_(widget,color.red,color.green,color.blue, state);
}

/*
read background color property
 */
VDKRgb
VDKObject::GetBackground(GtkStateType state)
{
VDKRgb rgb;
switch(state)
  {
  case GTK_STATE_ACTIVE:
    rgb = ActiveBackground;
    break;
  case GTK_STATE_PRELIGHT:
    rgb = PrelightBackground;
    break;
  case GTK_STATE_SELECTED:
    rgb = SelectedBackground;
    break;
  case GTK_STATE_INSENSITIVE:
    rgb = InsensitiveBackground;
    break;
  default:
    rgb = NormalBackground;
  }
return rgb;
}
/*
read foreground color property
 */
VDKRgb
VDKObject::GetForeground(GtkStateType state)
{
  VDKRgb rgb = Foreground;
  return rgb;
}


void
VDKObject::_setBackground_(GtkWidget* wid,
			   int red,int green, int blue,
			   GtkStateType state)
{
  VDKColor *color = NULL;

  if(!GTK_IS_WIDGET(wid))
    return;
  else
    color = new VDKColor(Owner() ? Owner() : this ,red,green,blue);
  gtk_widget_modify_bg (wid,state,color->Color());
}
/*
 */
void
VDKObject::_setForeground_(GtkWidget* wid,
			   int red,int green, int blue,
			   GtkStateType state)
{
  VDKColor *color = NULL;
  if(!GTK_IS_WIDGET(wid))
    return;
  else
    color = new VDKColor(Owner() ? Owner() : this ,red,green,blue);
  gtk_widget_modify_fg (wid,state,color->Color());
  
}
/*
 */
void
VDKObject::Enable(bool flag)
{
  if(GTK_IS_WIDGET(widget))
     {
       gtk_widget_set_sensitive (widget, flag);
       Enabled(flag);
     }
}
/*
 */
void
VDKObject::SetTip(const char* t)
{
  if(tip)
    tip->SetTip(t);
  else
    tip = new VDKTooltip(Owner(), this, t);
}

/*
 */
void
VDKObject::GrabFocus()
{
	if (widget) {
		VDKCustom* custom = dynamic_cast<VDKCustom*>(this);
		if (custom) gtk_widget_grab_focus(custom->CustomWidget());
		else gtk_widget_grab_focus(WrappedWidget());
	}
}
/*
 */
bool
VDKObject::isFocused()
{
	if (widget) return gtk_widget_has_focus(widget);
	return false;
}
/*
 */
void VDKObject::ShowWidget(bool visible)
{
if(widget && GTK_IS_WIDGET(widget))
  {
    if(visible)
      gtk_widget_show(widget);
    else
      gtk_widget_hide(widget);
  }
}
/*
 */
void
VDKObject::Add(VDKObject*, int, int ,
	       int , int  )
{
	g_warning("VDKObject::Add() unuseful call");
}
/*
 */
void VDKObject::AddItem(VDKObject* item)
{
	items.add(item);
}
/*
 */
void VDKObject::RemoveItem(VDKObject* item)
{
  if(items.remove(item))
    {
      if(Owner())
	Owner()->Garbages().add(item);
      else
	Garbages().add(item);
    }
}
/*
recursively removes items
 */
void VDKObject::RemoveItems()
{
  if(items.size() > 0)
    {
      ItemListIterator li(items);
      for(;li;li++)
	{
	  li.current()->RemoveItems();
	  if(Owner())
	    Owner()->Garbages().add(li.current());
	  else
	    Garbages().add(li.current());
	}
#ifdef VDKDEBUG
      objRemoved += items.size();
#endif
      items.flush();
    }
if(Owner())
  Owner()->Garbages().add(this);
else
  Garbages().add(this);
#ifdef VDKDEBUG
  objRemoved ++;
#endif
}

/*
explicitely destroy this
*/

bool VDKObject::Destroy()
{
  VDKObject* parent = NULL;

  for(parent = Parent() ; parent; parent = parent->Parent())
    if( Parent()->Items().remove(this) || Parent()->Garbages().remove(this) )
      break;

  if(parent && widget != NULL && GTK_IS_WIDGET(widget))
    {
#ifdef VDKDEBUG
      printf("\ndestroying widget:%p",Widget());
      fflush(stdout);
#endif      
      gtk_widget_destroy(Widget());
      delete this;
      return true;
    }
  else
    return false;
}

/*
 */
void VDKObject::Draw(GdkRectangle* area)
{
  if(widget)
    gtk_widget_draw(widget,area);
}

/*
 */
void SizeObjectProp::operator = (VDKPoint p)
{
  value = p;
  GtkWidget* wid = object->Widget();
  if(wid)
    gtk_widget_set_size_request(wid,p.X(), p.Y());
}

/*
 */
SizeObjectProp::operator VDKPoint()
{
  GtkWidget* wid = object->Widget();
  return wid ? VDKPoint (wid->allocation.width,
			 wid->allocation.height) : VDKPoint(0,0);
}

#ifdef USE_SIGCPLUSPLUS
// Compiled from here in order to avoid complicated conditionals
// in makefile, will change in near future
#include "sigc_events.cc"
#include "sigc_eventsignals.cc"
#endif /* USE_SIGCPLUSPLUS */









