
/*
 * =========================== 
 * VDK Visual Development Kit 
 * Version 2.0.0
 * March 2002
 * =========================== 
 * 
 * Copyright (C) 2002, Mario Motta 
 * Developed by Mario Motta <mmotta@guest.net> 
 * 
 * This library is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU Library General Public 
 * License as published by the Free Software Foundation; either 
 * version 2 of the License, or (at your option) any later version. 
 * 
 * This library is distributed in the hope that it will be useful, 
 * but WITHOUT ANY WARRANTY; without even the implied warranty of 
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
 * Library General Public License for more details. 
 * 
 * You should have received a copy of the GNU Library General Public 
 * License along with this library; if not, write to the Free Software 
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 
 * 02111-1307, USA. 
 */ 
 
#include "vdk/vdkdrawarea.h" 
#include "vdk/forms.h" 
#include "vdk/rawpixmap.h" 
#include <stdlib.h> 
/*
      VDKDRAWTOOL CLASS
*/
VDKDrawTool::VDKDrawTool (VDKDrawingArea* owner): owner (owner),  
  Fill ("Fill", this, GDK_SOLID, &VDKDrawTool::SetFill),
  Function ("Function", this, GDK_COPY, &VDKDrawTool::SetFunction)
{
 tile = NULL; 
}
/*
*/
VDKDrawTool::~VDKDrawTool ()
{
  if (tile)
    gdk_pixmap_unref (tile);
  }

/*
*/
void
VDKDrawTool::SetFill (GdkFill fill)
{
  gdk_gc_set_fill(owner->GC (),fill);
}

/*
*/
void 
VDKDrawTool::SetTile (const char* tfile)
{
  GdkGCValues values;
  gdk_gc_get_values(owner->GC (),&values);
  GdkBitmap *mask;
  GdkPixmap *local = gdk_pixmap_create_from_xpm (owner->Widget()->window,
                                      &mask,
                                      &values.background,
                                      tfile);
  if (local)
    {
    if (tile)
      gdk_pixmap_unref (tile);
    tile = local;
    gdk_gc_set_tile(owner->GC (),tile);
    }
  }
/*
*/
void 
VDKDrawTool::SetTile (char** tdata)
{
  GdkGCValues values;
  gdk_gc_get_values(owner->GC (),&values);
  GdkBitmap *mask;
  GdkPixmap *local = gdk_pixmap_create_from_xpm_d (owner->Widget()->window,
                                      &mask,
                                      &values.background,
                                      tdata);
  if (local)
    {
    if (tile)
      gdk_pixmap_unref (tile);
    tile = local;
    gdk_gc_set_tile(owner->GC (),tile);
    }
}

/*
*/
void 
VDKDrawTool::SetTile (GdkPixmap* tile)
{
  if(tile)
    gdk_gc_set_tile(owner->GC (),tile);
}
/*
 */
GdkPixmap *
VDKDrawTool::Tile(char** tdata)
{
  GdkGCValues values;
  gdk_gc_get_values(owner->GC (),&values);
  GdkBitmap *mask;
  GdkPixmap *local = gdk_pixmap_create_from_xpm_d (owner->Widget()->window,
                                      &mask,
                                      &values.background,
                                      tdata);
  return local;
}

/*
 */
GdkPixmap *
VDKDrawTool::Tile(const char* tfile)
{
  GdkGCValues values;
  gdk_gc_get_values(owner->GC (),&values);
  GdkBitmap *mask;
  GdkPixmap *local = gdk_pixmap_create_from_xpm (owner->Widget()->window,
                                      &mask,
                                      &values.background,
                                      tfile);
  return local;
}

/*
 */
void 
VDKDrawTool::SetFunction(GdkFunction function)
{
  gdk_gc_set_function (owner->GC(), function);
}
/*
  VDKPEN CLASS
*/

VDKPen::VDKPen (VDKDrawingArea* owner): VDKDrawTool (owner),  
  Color ("Color", this, VDKRgb ("black"), &VDKPen::SetColor), 
  Thickness ("Thickness" , this, 1, &VDKPen::SetThickness), 
  Style ("Style", this, GDK_LINE_SOLID, &VDKPen::SetStyle), 
  Cap ("Cap", this,GDK_CAP_NOT_LAST, &VDKPen::SetCap), 
  Join ("Join", this,GDK_JOIN_MITER, &VDKPen::SetJoin) 
{
  
}

/*
*/
void
VDKPen::SetColor (VDKRgb color)
{
  owner->SetForeground (color);
  return;
}
/*
*/
void
VDKPen::SetThickness (int t)
{
 gdk_gc_set_line_attributes(owner->GC (),t,
                           Style,Cap,Join);
}
/*
*/
void
VDKPen::SetStyle (GdkLineStyle style)
{
  gdk_gc_set_line_attributes(owner->GC (),
                           Thickness,style,
                           Cap,Join);
  }
/*
*/
void
VDKPen::SetCap (GdkCapStyle cap)
{
  gdk_gc_set_line_attributes(owner->GC (),
                           Thickness,Style,
                           cap,Join);

  }
/*
*/
void 
VDKPen::SetJoin (GdkJoinStyle join)
{
    gdk_gc_set_line_attributes(owner->GC (),
                           Thickness,Style,
                           Cap,join);

}

/*
  VDKDRAWINGAREA CLASS
*/
void
VDKDrawingArea::RealizeEvent (GtkWidget* wid,  gpointer gp )
{
  VDKDrawingArea* area = reinterpret_cast <VDKDrawingArea*>(gp);
  if(!area->_gc)
    area->_gc = gdk_gc_new(wid->window);
}

/* 
 */ 
VDKDrawingArea::VDKDrawingArea(VDKForm* owner): 
  VDKObject(owner)
{ 
  _gc = NULL;
  Pen = new VDKPen (this);
  Brush = new VDKBrush (this);
  widget = sigwid = gtk_drawing_area_new(); 
  gtk_widget_add_events(widget,
     GDK_EXPOSURE_MASK | 
     GDK_BUTTON_PRESS_MASK |  
     GDK_POINTER_MOTION_MASK | 
     GDK_BUTTON_RELEASE_MASK | 
     GDK_KEY_PRESS_MASK | 
     GDK_KEY_RELEASE_MASK |
     GDK_ENTER_NOTIFY_MASK |
     GDK_LEAVE_NOTIFY_MASK); 
  ConnectDefaultSignals(); 
  g_signal_connect_data (sigwid, "realize", 
      G_CALLBACK (VDKDrawingArea::RealizeEvent), this, 
      NULL,(GConnectFlags) 0);
} 
 
/* 
 */ 
VDKDrawingArea::~VDKDrawingArea() 
{ 
  if(_gc)
    gdk_gc_destroy(_gc);
  if (Pen)
    delete Pen;
  if (Brush)
    delete Brush;
} 

/*
 */
void
VDKDrawingArea::Clear()
{
  if(widget->window)
      gdk_window_clear (widget->window);
}
//=========================================================== 
// extern void PixSize(int* width, int* height, char* filename); 


void 
VDKDrawingArea::DrawPixbuf(int x, int y, const char ** data) 
{ 
  DrawPixbuf(x,y,new VDKPixbuf(this,data)); 
} 

void VDKDrawingArea::DrawPixbuf(int x, int y, const char *pixfile) 
{ 
  DrawPixbuf(x,y,new VDKPixbuf(this,pixfile)); 
} 

/* 
 */ 

void VDKDrawingArea::DrawPixbuf(int x, int y, VDKPixbuf* pix) 
{ 
  if(pix) 
    gdk_pixbuf_render_to_drawable (pix->AsGdkPixbuf (),
		       widget->window,
		       _gc,
		       0,0,
		       x,y,
		       -1,    -1,
		       GDK_RGB_DITHER_NORMAL,
		       x, y);
} 

/* 
 */ 
 void VDKDrawingArea::DrawString(int x, int y, char* text) 
{ 
  GdkFont* font = NULL;
  VDKFont* vdkfont = Font;
  if(!vdkfont)
    {
    GtkStyle *style = gtk_widget_get_style(widget);
    font = style ? gtk_style_get_font(style) :  NULL;
    }
  else
    font = vdkfont->AsGdkFont ();
  
  if(font && text)
    gdk_draw_string(widget->window, font, _gc, x, y, text); 
      
} 

/* 
*/
void VDKDrawingArea::DrawText(int x, int y, char* text, int n) 
{ 

  GdkFont* font = NULL;
  VDKFont* vdkfont = Font;
  if(!vdkfont)
    {
    GtkStyle *style = gtk_widget_get_style(widget);
    font = style ? gtk_style_get_font(style) :  NULL;
    }
  else
    font = vdkfont->AsGdkFont ();
  
  if(font)
      gdk_draw_text(widget->window, font, _gc, x, y, text, n);       
  
} 

/* 
 */ 
void VDKDrawingArea::DrawPoint(int x, int y) 
{ 
  gdk_draw_point(widget->window, _gc, x, y); 
} 
/* 
 */ 
void VDKDrawingArea::DrawLine(int x, int y, int x1, int y1)  
{ 
  gdk_draw_line(widget->window, _gc, x,y,x1,y1); 
} 
/* 
 */ 
void VDKDrawingArea::DrawRect(gint filled,  int x, int y, int w, int h) 
{ 
 gdk_draw_rectangle(widget->window, _gc, filled, x,y,w,h); 
} 

/* 
 */ 
void VDKDrawingArea::DrawArc(gint filled, 
			       gint x, 
			       gint y, 
			       gint width, 
			       gint height, 
			       gint angle1, 
			       gint angle2) 
{ 
  gdk_draw_arc(widget->window,_gc, filled, 
		 x, y, 
		 width, height, 
		 angle1, angle2); 
} 

/* 
 */ 

void VDKDrawingArea::DrawPolygon(gint		filled, 
				   GdkPoint     *points, 
				   gint		npoints) 
{ 

    gdk_draw_polygon(widget->window, _gc, filled,  points, npoints); 
} 

/* 
 */ 
void VDKDrawingArea::DrawPoints(GdkPoint     *points, 
				  gint		npoints) 
{ 
 gdk_draw_points(widget->window, _gc, points, npoints); 
} 
/* 
 */ 
void VDKDrawingArea::DrawSegments(GdkSegment   *segs, 
				    gint	 nsegs) 
{ 
   gdk_draw_segments(widget->window, _gc, segs, nsegs); 
} 
/* 
 */ 
void 
VDKDrawingArea::DrawLines(GdkPoint  *points, gint npoints) 
{ 
  gdk_draw_lines(widget->window, _gc, points, npoints); 
} 
/*
 */ 
void 
VDKDrawingArea::SetForeground(VDKRgb rgb, GtkStateType state)
{
  if(Widget()->window)
    {
     if (!_gc)
       RealizeEvent (widget, this );
      GdkColor *color = (GdkColor*) malloc (sizeof (GdkColor));
      GdkColormap *colormap = gdk_window_get_colormap (Widget()->window);
      color->red    = (guint16)(rgb.red << 8);
      color->green  = (guint16)(rgb.green << 8);
      color->blue   = (guint16)(rgb.blue << 8);
      if (!gdk_color_alloc (colormap, color))
	gdk_color_black (colormap, color);
      gdk_gc_set_foreground(_gc, color);
      free(color);
    }
} 

void 
VDKDrawingArea::SetBackground(VDKRgb rgb, GtkStateType state)
{
 if(GTK_WIDGET_REALIZED (widget))
    {
      if (!_gc)
        RealizeEvent (widget, this );
      GdkColor *color = (GdkColor*) malloc (sizeof (GdkColor));
      GdkColormap *colormap = gdk_window_get_colormap (Widget()->window);
      color->red    = (guint16)(rgb.red << 8);
      color->green  = (guint16)(rgb.green << 8);
      color->blue   = (guint16)(rgb.blue << 8);
      if (!gdk_color_alloc (colormap, color))
	gdk_color_black (colormap, color);
      gdk_window_set_background (widget->window,color);
      Clear();
      free(color);
    }
  else
   VDKObject::SetBackground (rgb);
  }

void 
VDKDrawingArea::SetFont(VDKFont* f)
{
  Font(f);
}
