/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
*/

#include <vdk/progressbar.h>
#include <vdk/forms.h>
#include <assert.h>
/*
 */
VDKProgressBar::VDKProgressBar(VDKForm* owner, 
			       double min , double max):
  VDKObject(owner),min(min),max(max),
  Value("Value",this,min,&VDKProgressBar::Update,&VDKProgressBar::Position),
  BlockCount("Block Count",
	     this,0,&VDKProgressBar::SetBlockCount),
  BarStyle("Bar Style",
	   this,GTK_PROGRESS_CONTINUOUS,&VDKProgressBar::SetBarStyle),
  BarOrientation("Bar Orientation",
	   this,GTK_PROGRESS_LEFT_TO_RIGHT,&VDKProgressBar::SetBarOrientation),
  ActivityMode("Activity Mode",this,false,&VDKProgressBar::SetActivityMode),
  MinValue("MinValue",this,min,&VDKProgressBar::setminvalue),
  MaxValue("MaxValue",this,max,&VDKProgressBar::setmaxvalue)
{
  GtkAdjustment * adj = 
    (GtkAdjustment *) gtk_adjustment_new (min, min, max, 0, 0, 0);
  widget = gtk_progress_bar_new_with_adjustment (adj);
  ConnectDefaultSignals();
} 
/*
 */
VDKProgressBar::~VDKProgressBar()
{
}
/*
 */
void VDKProgressBar::Update(double val)
{
assert(min != max);
double scale = (val-min)/(max-min);
gtk_progress_bar_update(GTK_PROGRESS_BAR(widget),scale);
}
/*
 */
double VDKProgressBar::Position()
{
double p = gtk_progress_get_current_percentage(GTK_PROGRESS(widget));
p = p*(max-min) + min;
return p;
}




