/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
*/


#include "vdk/entry.h"
#include "vdk/forms.h"
#include "vdk/colors.h"
//#include <string>

static void
EntryChanged(GtkWidget* wid, gpointer gp)
{
  g_return_if_fail(wid != NULL);
  GtkEntry* entry = GTK_ENTRY(wid);
  VDKEntry* vdkentry = reinterpret_cast<VDKEntry*>(gp);
  char* p = gtk_editable_get_chars (GTK_EDITABLE(entry), 0,-1);
  if(p)
    {
#ifdef USE_SIGCPLUSPLUS
      vdkentry->Text.OnValueChanged.emit(vdkentry,vdkentry->GetText());
#endif
      vdkentry->SignalEmit(changed_signal);
      g_free(p);
    }
}

int
VDKEntry::FocusOutEvent(GtkWidget *,
			    GdkEventFocus*,
			    gpointer wid)
{
  g_return_val_if_fail(wid != NULL,FALSE);
  VDKEntry* obj = reinterpret_cast<VDKEntry*>(wid);
  obj->SignalEmit(focus_out_signal);
  return FALSE;//TRUE;
}
/*
 */
int
VDKEntry::FocusInEvent(GtkWidget *,
			    GdkEventFocus *,
			    gpointer wid)
{
  g_return_val_if_fail(wid != NULL,FALSE);
  VDKEntry* obj = reinterpret_cast<VDKEntry*>(wid);
  obj->SignalEmit(focus_in_signal);
  return FALSE;//TRUE;
}
/*
 */
VDKEntry::VDKEntry(VDKForm* owner, int maxLen, char* def):
  VDKObject(owner),
  Text("Text", this, NULL, &VDKEntry::SetText, &VDKEntry::GetText),
  Editable("Editable", this, true, &VDKEntry::SetEditable),
  Hidden("Hidden", this, false, &VDKEntry::SetHidden)
{
	if (maxLen) widget = sigwid = gtk_entry_new_with_max_length(maxLen);
	else widget = sigwid = gtk_entry_new();
	if(def) SetText(def);
	s_activated.obj = this;
	s_activated.signal = activate_signal;
	s_changed.obj = this;
	s_changed.signal = changed_signal;
	gtk_signal_connect(GTK_OBJECT(widget),"activate",
		GTK_SIGNAL_FUNC(VDKObject::VDKSignalPipe),
	(gpointer) &s_activated);
	/*
	changeConnect = gtk_signal_connect(GTK_OBJECT(widget),"changed",
		GTK_SIGNAL_FUNC(VDKObject::VDKSignalPipe),
		(gpointer) &s_changed);
	*/
	changeConnect = gtk_signal_connect(GTK_OBJECT(widget),"changed",
		GTK_SIGNAL_FUNC(::EntryChanged),
		(gpointer) this);
	gtk_signal_connect(GTK_OBJECT(widget),
		"focus_out_event",
		GTK_SIGNAL_FUNC(VDKEntry::FocusOutEvent),
		(gpointer) this);
	gtk_signal_connect(GTK_OBJECT(widget),
		"focus_in_event",
		GTK_SIGNAL_FUNC(VDKEntry::FocusInEvent),
		(gpointer) this);
	ConnectDefaultSignals();
}
/*
 */
VDKEntry::~VDKEntry()
{
}

/*
 */
void VDKEntry::SetText(char* s)
{
  int len = strlen(s);
  if(len)
    {
      char* local = new char[len+1];
      strcpy(local,s);
      if(!g_utf8_validate(local,-1,NULL))
	g_locale_to_utf8(local,-1,NULL,NULL,NULL);
      gtk_entry_set_text(GTK_ENTRY(widget),local);
      delete[] local;
    }
  else
    gtk_entry_set_text(GTK_ENTRY(widget),"");
}
/*
 */
char* VDKEntry::GetText()
{
	char* p = gtk_editable_get_chars (GTK_EDITABLE(WrappedWidget()), 0,-1);
	if (p) {
		buffer = p;
		g_free(p);
	}
	return (char*) buffer;
}

/*
 */
void VDKEntry::SetBackground(VDKRgb rgb, 
			     GtkStateType state)
{
  VDKColor *color = new VDKColor(Owner(),rgb.red,rgb.green,rgb.blue);
  gtk_widget_modify_base (widget, state, color->Color());
  /*
  GtkStyle* style = gtk_style_copy(gtk_widget_get_style(widget));
  g_return_if_fail(style != NULL); 
  gtk_style_ref(style); 
  style->base[state] = *(color->Color()); 
  gtk_widget_set_style(widget,style); 
  */
}
/*
 */
void VDKEntry::SetForeground(VDKRgb rgb, 
			     GtkStateType state)
{
  VDKColor *color = new VDKColor(Owner(),rgb.red,rgb.green,rgb.blue);
  gtk_widget_modify_text (widget, state, color->Color());
  /*
  GtkStyle* style = gtk_style_copy(gtk_widget_get_style(widget));
  g_return_if_fail(style != NULL); 
  gtk_style_ref(style); 
  style->base[state] = *(color->Color()); 
  gtk_widget_set_style(widget,style); 
  */
}

/*
 */
void
VDKEntry::SetFont(VDKFont* font)
{
if(!GTK_WIDGET_REALIZED(WrappedWidget()))
  VDKObject::SetFont(font);
else
  {
    GtkRcStyle *rc_style;
    rc_style = gtk_rc_style_new ();
    rc_style->font_desc = 
      pango_font_description_copy (font->AsPangoFontDescription());
    gtk_widget_modify_style (WrappedWidget(), rc_style);
    gtk_rc_style_unref (rc_style);
    gtk_widget_size_request (WrappedWidget(), NULL);
  }
}

// COMPLETION SUPPORT 
static GtkTreeModel *
create_string_completion_model (char* completion_list[]);

static gboolean
match_func (GtkEntryCompletion *completion,
	    const gchar        *key,
	    GtkTreeIter        *iter,
	    gpointer            user_data);
/*
  completion_list must be a NULL terminating string array;
 */

void 
VDKEntry::SetCompletion(char** completion_list)
{
  // uses any previous model if any
  GtkEntryCompletion * completion = gtk_entry_get_completion (GTK_ENTRY (widget));
  GtkTreeModel *completion_model = NULL;
  if(!completion)
    {
      /* Create the completion object */
      completion = gtk_entry_completion_new ();
      /* Assign the completion to the entry */
      gtk_entry_set_completion (GTK_ENTRY (widget), completion);
      g_object_unref (completion);
    }
  /* Create a tree model and use it as the completion model */
  completion_model = create_string_completion_model (completion_list);
  gtk_entry_completion_set_model (completion, completion_model);
  g_object_unref (completion_model);
  /* Use model column 0 as the text column */
  gtk_entry_completion_set_text_column (completion, 0);
  gtk_entry_completion_set_minimum_key_length (completion, 1);
  gtk_entry_completion_set_match_func (completion, match_func, NULL, NULL);
  return;
}
//
void 
VDKEntry::AddCompletionItem(char* completion_item)
{
  GtkEntryCompletion * completion = gtk_entry_get_completion (GTK_ENTRY (widget));
  GtkListStore *store = NULL;
  if(completion)
    {
      GtkTreeIter iter; 
      store = GTK_LIST_STORE (gtk_entry_completion_get_model (completion));
      if(store)
	{
	  gtk_list_store_append (store, &iter);
	  gtk_list_store_set (store, &iter, 0, completion_item, -1);
	}
    }
}
//
void 
VDKEntry::RemoveCompletionItem(char* completion_item)
{
  GtkEntryCompletion * completion = gtk_entry_get_completion (GTK_ENTRY (widget));
  GtkTreeModel *store = NULL;
  if(completion)
    {
      GtkTreeIter iter; 
      store = gtk_entry_completion_get_model (completion);
      if(store)
	{
	  gchar *item = NULL;  
	  for(bool flag = gtk_tree_model_get_iter_first(store,&iter);
	      flag; flag = gtk_tree_model_iter_next(store,&iter))
	    {
	        gtk_tree_model_get (store, &iter, 0, &item, -1);
		if(!strcmp(item,completion_item))
		  {
		    gtk_list_store_remove (GTK_LIST_STORE(store),&iter);
		    break;
		  }		  
	    }
	}
    }
}
/*
---------- SUPPORT ---------
*/
static gboolean
match_func (GtkEntryCompletion *completion,
	    const gchar        *key,
	    GtkTreeIter        *iter,
	    gpointer            user_data)
{
  gchar *item = NULL;
  GtkTreeModel *model;

  gboolean ret = FALSE;

  model = gtk_entry_completion_get_model (completion);

  gtk_tree_model_get (model, iter, 0, &item, -1);

  if (item != NULL)
    {
      if (strncmp (key, item, strlen (key)) == 0)
	ret = TRUE;
      g_free (item);
    }

  return ret;
}

GtkTreeModel *
create_string_completion_model (char* completion_list[])
{
  GtkListStore *store;
  GtkTreeIter iter;
  store = gtk_list_store_new (1, G_TYPE_STRING);
  for(int t = 0; completion_list[t]; t++)
    {
      gtk_list_store_append (store, &iter);
      gtk_list_store_set (store, &iter, 0, completion_list[t], -1);
    }
  return GTK_TREE_MODEL (store);
}

