/* 
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * =========================== 
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include "vdk/FileDialog.h"
#include <cstdio>
#include <cstring>
#include <cstdlib>
#include <unistd.h>
#include <sys/param.h>
#include <string.h>
#define PIPPO ".pippo.~fdlg"

static char *titles[] = {"./sub folders",NULL};
static char buff[513];
// extensions
extern char* folder_xpm[];
extern char* folder_open_xpm[];
extern char* c_xpm[];
extern char* file_xpm[]; 
extern char* xpm_xpm[];
extern char* text_xpm[];
extern char* gif_xpm[];
extern char* h_xpm[]; 
extern char* tgz_xpm[];
extern char* html_xpm[];
extern char* exec_xpm[];
extern char* link_xpm[];
extern char* socket_xpm[];
/*
caution: this table must be
ordered
*/
#define MAX_EXT 5

static struct 
{ char* ext; char** pix; } Ext[MAX_EXT] =
{
  { ".gz",  tgz_xpm },
  { ".htm",  html_xpm },
  { ".html",  html_xpm },
  { ".tar",  tgz_xpm },
  { ".tgz",  tgz_xpm }
};
/*
this not
*/
#define MAX_CATEG 4 
static struct 
{ char cat; char** pix; } Cat[MAX_CATEG] =
{
  { '*',  exec_xpm },
  { '@',  link_xpm },
  { '=',  socket_xpm },
  { '|',  NULL }
};
 
// 
class FileDlgWaitCursor 
{
  GdkCursor *cursor; 
  VDKForm* form;
 public:
  FileDlgWaitCursor(VDKForm *form):form(form)
    {
      cursor = gdk_cursor_new (GDK_WATCH);
      gdk_window_set_cursor (form->Window()->window, cursor);
      gdk_cursor_destroy (cursor);
    }
  ~FileDlgWaitCursor() 
    {
      cursor = gdk_cursor_new (GDK_LEFT_PTR);
      gdk_window_set_cursor (form->Window()->window, cursor);
      gdk_cursor_destroy (cursor);
    }
};
// signal map
DEFINE_SIGNAL_MAP(VDKFileDialog,VDKForm)
  ON_SIGNAL(dirlist,select_row_signal,DirListDoubleClick),
  ON_SIGNAL(open,clicked_signal,OpenClick),
  ON_SIGNAL(filelist,select_row_signal,OpenClick),
  ON_SIGNAL(cancel,clicked_signal,CancelClick),
  ON_SIGNAL(hiddenCb,toggled_signal,ToggleHidden),
  ON_SIGNAL(filetype,activate_signal,SetFileMask)
END_SIGNAL_MAP

/*
 */  
VDKFileDialog::VDKFileDialog(VDKForm* owner,
			     FileStringArray* selections,
			     char* title, 
			     GtkWindowType display):
  VDKForm(owner,title, display),selections(selections),
  Filter("Filter",this,VDKUString(""))
{
  VDKBox* mainbox = new VDKBox(this,v_box);
  VDKBox  *hbox = new VDKBox(this,h_box);
  VDKPixmap* dirpix = new VDKPixmap(this,folder_open_xpm);
  hbox->Add(dirpix);
  dir_label = new VDKLabel(this,"");
  hbox->Add(dir_label);
  mainbox->Add(hbox);
  mainbox->Add(new VDKSeparator(this,h_separator));
  VDKBox* listbox = new VDKBox(this,h_box); 
  dirlist = new VDKCustomList(this,1,
			      &titles[0],GTK_SELECTION_EXTENDED);
  dirlist->AutoResize = false;
  dirlist->SetSize(200,250); 
  dirlist->ColumnSize(0,250); 
  dirlist->ActiveTitles(false);
  dirlist->PrelightBackground = clWhite;
  listbox->Add(dirlist);
  listbox->Add(new VDKSeparator(this,v_separator));
  filelist = new VDKCustomList(this,1,
			       NULL,GTK_SELECTION_EXTENDED);
  dirlist->AutoResize = false;
  filelist->PrelightBackground = clWhite;
  filelist->SetSize(200,250);
  listbox->Add(filelist);
  mainbox->Add(listbox);
  mainbox->Add(new VDKSeparator(this,h_separator));
  VDKTable *table = new VDKTable(this,2,3);
  hiddenCb =  
    new VDKCheckButton(this,
		       "Shows hidden files");
  filetypeLabel = new VDKLabel(this,"File type");
  table->Add(hiddenCb,0,1,0,1);
  table->Add(filetypeLabel,0,1,1,2);
  filetype = new VDKEntry(this);
  table->Add(filetype,1,2,1,2);
  open = new VDKCustomButton(this,"Open");
  cancel = new VDKCustomButton(this,"Cancel");
  table->Add(open,2,3,0,1);
  table->Add(cancel,2,3,1,2);
  mainbox->Add(table);
  Add(mainbox);
  if(init())
    // load current dir
    LoadDir();
  
}

/*
 */
VDKFileDialog::~VDKFileDialog()
{
}

/*
 */
void VDKFileDialog::OnShow(VDKForm*)
{
VDKUString filter = Filter;
if( ! filter.isNull())
  {
    filetype->Text = (char*) filter;
    LoadDir();
  }
return;  
}
/*
 */
bool VDKFileDialog::init()
{
  // get HOME
  char* homedir = getenv("HOME");
  if(!homedir)
    return false;
  home = homedir;
  // gets prg work dir
  char* cwd = getcwd(NULL,MAXPATHLEN);
  if(cwd)
    {
      pcwd = cwd;
      first_pcwd = cwd;
      free(cwd);
    }
  return true;
}
/*
 */
bool VDKFileDialog::CanClose()
{
	int rslt;
	
	// restore original pwd
	sprintf(buff, "%s", (char*)first_pcwd);
	rslt = chdir(buff);
	return true;
}
/*
 */
void VDKFileDialog::LoadDir(char* dir)
{
  FileStringList *filtered;
  //do not apply mask load dirs only
  FileStringList* list = load_dir(dir,false); 
  if(!list)
    return;
  // filter dir
  filtered = filter(list,0);//filter dir
  if(filtered)
    {
      LoadDirList(filtered);
      delete filtered;
    }
  if(list)
    delete list;
  // filter files
  // apply mask load files only
  list = load_dir(dir,true); // apply mask if any
  FileStringListIterator li(*list);
  filtered = filter(list,1);//filter files
  if(filtered)
    {
      LoadFileList(filtered);
      delete filtered;
    }
  if(list)
    delete list;
}
/*
 */
/*
 */
inline bool is_hidden(char* s)
{
  return *s == '.' && std::strcmp(s,"../") && std::strcmp(s,"./");
}

inline bool is_a_dir(char* s)
{
  return s[std::strlen(s)-1]  == '/';
}


static char* get_filename(char* s, char sep)
{
  size_t t = std::strlen(s)-1;
  char* p = &s[t];
  for(; t >= 0 && *p != sep; p--,t--) ;
  return t ? ++p : static_cast<char*>(0);
}

static char* get_extension(char* s)
{
  size_t t = std::strlen(s)-1;
  char* p = &s[t];
  for(; t >= 0 && *p != '.'; p--,t--) ;
  return t ? p : static_cast<char*>(0);
}

/* 
 */

FileStringList* VDKFileDialog::load_dir(char* dir, int mask)
{
  int rslt;
  VDKUString file_mask(filetype->Text);
  FileStringList* list = new FileStringList;

  char* cwd = getcwd(NULL,MAXPATHLEN);
  if(cwd)
  {
      DIR *d;
      struct dirent *e;
#ifndef _USE_FNMATCH
      regex_t exp[1];
      regmatch_t match[2];
      if(!file_mask.isNull())
      {
          regcomp(exp,(char *)file_mask, (REG_EXTENDED|REG_NEWLINE));
      }
#endif
      if (dir) rslt = chdir(dir);
      if((d = opendir(".")))
      {
          while((e = readdir(d)))
          {
              struct stat st;
              if(mask == 0 || file_mask.isNull() ||
#ifndef _USE_FNMATCH
                 0 == regexec(exp, e->d_name, 1, match, 0)
#else
                 0 == fnmatch((char *)file_mask, e->d_name, 
                              (FNM_PATHNAME | FNM_PERIOD| FNM_NOESCAPE) )
		 // STUB
#endif
                 )
              {
                  VDKUString s(e->d_name);
                  if(0 == stat(e->d_name,&st))
                  {
                      if ((!mask && S_ISDIR(st.st_mode)) || 
                         (mask && !S_ISDIR(st.st_mode)))
                      {
                          if(S_ISLNK(st.st_mode))
                          {
                              s += "@";
                          }
                          else if(S_ISDIR(st.st_mode))
                          {
                              s  += "/";
                          }
                          else if(S_ISSOCK(st.st_mode))                      
                          {
                              s += "=";
                          }
                          else if(S_ISFIFO(st.st_mode))                      
                          {
                              s += "|";
                          }
                          else if(st.st_mode & 0111)
                          {
                              s += "*";
                          }
			  list->insert(s);
                      }
                  }
              }
          }
          closedir(d);
      }
      rslt = chdir(cwd);
#ifndef _USE_FNMATCH
      if(!file_mask.isNull())
      {
          regfree(exp);
      }
#endif
      free(cwd);
  }
  return list;
}
/*
 */
FileStringList* VDKFileDialog::filter(FileStringList* list,int mode)
{
  bool filter_files = mode == 1;
  bool filter_dir = mode == 0;
  int size = list->size();
  FileStringList* filtered = new FileStringList;
  if(!size)
      return filtered;
  FileStringListIterator li(*list);
  for(;li;li++)
    {
      char* fn;
      std::strcpy(buff,(char*) li.current());
      bool isadir = is_a_dir(buff);
      fn = filter_files ? get_filename(buff,'/'): get_filename(buff,' ');
      if(!fn)
	break;
      VDKUString s(fn);
      if(!is_hidden(fn) || hiddenCb->Checked)
	{
	  if(filter_dir && isadir)
	    filtered->add(s);
	  if(filter_files && !isadir)
	  filtered->add(s);
	}
    }
  return filtered;
}
/*
strip last char too
*/
static char** is_category(char* p)
{
  int t = 0;
  char *c = &p[std::strlen(p)-1];
  for(; t < MAX_CATEG;t++)
    if(Cat[t].cat == *c)
      {
	*c = '\0';
	return Cat[t].pix;
      }
  return NULL;
}
/*
 */
static char** is_extension(char* ext)
{
  // binary search, assume Ext table
  // already ordered !!
  if(!ext)
    return NULL;
  int low,high,mid;
  low = 0; high = MAX_EXT-1;
  while(low <= high)
    {
      mid = (low+high)/2;
      if(std::strcmp(ext,Ext[mid].ext) < 0)
	high = mid-1;
      else if(std::strcmp(ext,Ext[mid].ext) > 0)
	low = mid+1;
      else return Ext[mid].pix;
    }
  return NULL;
}

void VDKFileDialog::LoadFileList(FileStringList* list)
{
  FileDlgWaitCursor c(this);
  FileStringListIterator li(*list);
  filelist->Clear();
  filelist->Freeze();
  for(;li;li++)
    {
      char *p = (char*) li.current();
      char** s = is_extension(get_extension(p));
      /* strip last char too */
      char** c = is_category(p);
      if(s || c)
	filelist->AddRow(&p,s ? s : c,0);
      else
	filelist->AddRow(&p);
  }
  gtk_clist_moveto(GTK_CLIST(filelist->CustomWidget()),0,0,0,0);
  filelist->Thaw();
  sprintf(buff,"%s ,%d file(s)",
	  (char*) pcwd, list->size());
  dir_label->Caption = buff;
}
 
/*
 */
void VDKFileDialog::LoadDirList(FileStringList* list)
{
  FileStringListIterator li(*list);
  dirlist->Clear();
  dirlist->Freeze();
    for(;li;li++)
    {
      char *p = (char*) li.current();
      dirlist->AddRow(&p,folder_xpm,0);
    }
  dirlist->Thaw();
  gtk_clist_moveto(GTK_CLIST(dirlist->CustomWidget()),0,0,0,0);
  

}
/* 
 */
bool VDKFileDialog::DirListDoubleClick(VDKObject* )
{
char local[512];
int ndx = dirlist->Selected.Row();
if(ndx <0) 
  return true;
sprintf(local,"%s",(char*) dirlist->Tuples[ndx][0]);
if(chdir(local) == 0)
  {
    // gets prg work dir
    char* cwd = getcwd(NULL,MAXPATHLEN);
    if(cwd)
      {
	pcwd = cwd;
	free(cwd);
      }
    LoadDir();
  }
return true;
}
/*
 */
bool VDKFileDialog::OpenClick(VDKObject*)
{

  int v = filelist->Selections().size();
  int j;
  if(v > 0)
    {
      selections->resize(filelist->Selections().size());
      int t;
      for( t=0; t < selections->size();t++)
	{ 
	  int row = filelist->Selections()[t];
	  sprintf(buff,"%s/%s",(char*) pcwd,(char*) filelist->Tuples[row][0]);
	  VDKUString s(buff);
	  (*selections)[t] = s;
	}
    }  
  else
    {
      j = filelist->Selected.Row();
      if(j >= 0)
	{
	  selections->resize(1);
	  sprintf(buff,"%s/%s",(char*) pcwd,(char*) filelist->Tuples[j][0]);
	  VDKUString s(buff);
	  (*selections)[0] = s;
	}
      else
	selections->resize(0);
    }
  if(isModal) 
    Close();
return true;  
} 

/*
 */
bool VDKFileDialog::CancelClick(VDKObject*)
{
selections->resize(0);
Close();
return true;
}
/*
 */
bool VDKFileDialog::ToggleHidden(VDKObject*)
{
  // reload present dir 
LoadDir();
return true;
}
/*
 */
bool VDKFileDialog::SetFileMask(VDKObject*)
{
LoadDir();
return true;
}
