/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */


#ifndef VDK_TYPES_H
#define VDK_TYPES_H
#include <gdk/gdkcursor.h>
#include <gdk/gdkevents.h>
#include <gtk/gtkenums.h>

#ifdef NULL
#undef NULL
#define NULL 0x0000
#endif

// For mouse cursors
enum VDKCursorType
{
curDefault = -255,
curXCursor = GDK_X_CURSOR,
curArrow = GDK_ARROW,
curArrowDown = GDK_BASED_ARROW_DOWN,
curArrowUp = GDK_BASED_ARROW_UP,
curBoat = GDK_BOAT,
curBogosity = GDK_BOGOSITY,
curBottomLeftCorner = GDK_BOTTOM_LEFT_CORNER,
curBottomRightCorner = GDK_BOTTOM_RIGHT_CORNER,
curBottomSide = GDK_BOTTOM_SIDE,
curBottomTee = GDK_BOTTOM_TEE,
curBoxSpiral = GDK_BOX_SPIRAL,
curCenterPtr = GDK_CENTER_PTR,
curCircle = GDK_CIRCLE,
curClock = GDK_CLOCK,
curCoffeeMug = GDK_COFFEE_MUG,
curCross = GDK_CROSS,
curCrossReverse = GDK_CROSS_REVERSE,
curCrossHair = GDK_CROSSHAIR,
curDiamondCross = GDK_DIAMOND_CROSS,
curDot = GDK_DOT,
curDotBox = GDK_DOTBOX,
curDoubleArrow = GDK_DOUBLE_ARROW,
curDraftLarge = GDK_DRAFT_LARGE,
curDraftSmall = GDK_DRAFT_SMALL,
curDrapedBox = GDK_DRAPED_BOX,
curExchange = GDK_EXCHANGE,
curFleur = GDK_FLEUR,
curGobbler = GDK_GOBBLER,
curGumby = GDK_GUMBY,
curHand1 = GDK_HAND1,
curHandPtr = GDK_HAND2,
curHeart = GDK_HEART,
curIcon = GDK_ICON,
curIronCross = GDK_IRON_CROSS,
curLeftPtr = GDK_LEFT_PTR,
curLeftSide = GDK_LEFT_SIDE,
curLeftTee = GDK_LEFT_TEE,
curLeftButton = GDK_LEFTBUTTON,
curLLAngle = GDK_LL_ANGLE,
curLRAngle = GDK_LR_ANGLE,
curMan = GDK_MAN,
curMiddleButton = GDK_MIDDLEBUTTON,
curMouse = GDK_MOUSE,
curPencil = GDK_PENCIL,
curPirate = GDK_PIRATE,
curPlus = GDK_PLUS,
curQuestionArrow = GDK_QUESTION_ARROW,
curRightPtr = GDK_RIGHT_PTR,
curRightSide = GDK_RIGHT_SIDE,
curRightTee = GDK_RIGHT_TEE,
curRightButton = GDK_RIGHTBUTTON,
curRTLLogo = GDK_RTL_LOGO,
curSailBoat = GDK_SAILBOAT,
curSBDownArrow = GDK_SB_DOWN_ARROW,
curSBHDoubleArrow = GDK_SB_H_DOUBLE_ARROW,
curSBLeftArrow = GDK_SB_LEFT_ARROW,
curSBRightArrow = GDK_SB_RIGHT_ARROW,
curSBUpArrow = GDK_SB_UP_ARROW,
curSBVDoubleArrow = GDK_SB_V_DOUBLE_ARROW,
curShuttle = GDK_SHUTTLE,
curSizing = GDK_SIZING,
curSpider = GDK_SPIDER,
curSprayCan = GDK_SPRAYCAN,
curStar = GDK_STAR,
curTarget = GDK_TARGET,
curTCross = GDK_TCROSS,
curTopLeftArrow = GDK_TOP_LEFT_ARROW,
curTopLeftCorner = GDK_TOP_LEFT_CORNER,
curTopRightCorner = GDK_TOP_RIGHT_CORNER,
curTopSide = GDK_TOP_SIDE,
curTopTee = GDK_TOP_TEE,
curTrek = GDK_TREK,
curULAngle = GDK_UL_ANGLE,
curUmbrella = GDK_UMBRELLA,
curURAngle = GDK_UR_ANGLE,
curWatch = GDK_WATCH,
curXTerm = GDK_XTERM,
curLastCursor = GDK_LAST_CURSOR,
curIsPixmap = GDK_CURSOR_IS_PIXMAP
};

enum VDKSignal
{
  no_signal = -1,
  clicked_signal,
  pressed_signal,
  released_signal,
  enter_signal,
  leave_signal,
  activate_signal,
  select_row_signal,
  unselect_row_signal,
  click_column_signal,
  changed_signal,
  focus_out_signal,
  focus_in_signal,
  timer_tick_signal,
  realize_signal,
  switch_page_signal,
  toggled_signal,
  event_browser_signal,
  value_changed_signal,
  child_attached_signal,
  child_detached_signal,
  selection_changed_signal, // used in VDKCombo
  text_changed_signal, // used in VDKtext
  select_node_signal,
  unselect_node_signal,
  databox_zoomed_signal, // used in VDKDataBox
  databox_marked_signal,
  databox_selection_started_signal,
  databox_selection_changed_signal,
  databox_selection_stopped_signal,
  databox_selection_canceled_signal,
#if HAVE_GNOME
  // gnome widget signals
  date_changed_signal = 1024, // VDKGnomeDateEdit
  time_changed_signal,
#endif
  row_activated_signal = 1512, // VDKTreeView
  cell_edited_signal = 1513,
  cell_toggled_signal = 1514,
  user_signal = 4096
};

enum VDKEvent
{
  no_event = GDK_NOTHING,	
  delete_event = GDK_DELETE,
  destroy_event = GDK_DESTROY,
  expose_event = GDK_EXPOSE,
  motion_notify_event = GDK_MOTION_NOTIFY,
  button_press_event = GDK_BUTTON_PRESS,
  double_click_event = GDK_2BUTTON_PRESS,
  triple_click_event = GDK_3BUTTON_PRESS,
  button_release_event = GDK_BUTTON_RELEASE,
  key_press_event = GDK_KEY_PRESS,
  key_release_event = GDK_KEY_RELEASE,
  enter_notify_event = GDK_ENTER_NOTIFY,
  leave_notify_event = GDK_LEAVE_NOTIFY,
  focus_change_event = GDK_FOCUS_CHANGE,
  configure_event = GDK_CONFIGURE,
  map_event = GDK_MAP,
  unmap_event = GDK_UNMAP,
  property_notify_event = GDK_PROPERTY_NOTIFY,
  selection_clear_event = GDK_SELECTION_CLEAR,
  selection_request_event = GDK_SELECTION_REQUEST,
  selection_notify_event = GDK_SELECTION_NOTIFY,
  proximity_in_event = GDK_PROXIMITY_IN,
  proximity_ou_event = GDK_PROXIMITY_OUT,
  client_event = GDK_CLIENT_EVENT,
  visibility_notify_event = GDK_VISIBILITY_NOTIFY,
  no_expose_event = GDK_NO_EXPOSE,
  drag_start_event = GDK_DRAG_ENTER,
  drag_stop_event = GDK_DRAG_LEAVE,
  dragging_event = GDK_DRAG_MOTION
};

enum { v_box, h_box, table_box };
enum { l_justify, c_justify, r_justify , pos_justify = 100};
enum { h_separator, v_separator };
enum { shadow_none, shadow_in, shadow_out,
       shadow_etched_in, shadow_etched_out };
enum { Class_level = 8192, Parent_level };

enum VDKUpdateType
{
 update_continuos = GTK_UPDATE_CONTINUOUS,
 update_discontinuos =  GTK_UPDATE_DISCONTINUOUS,
 update_delayed =  GTK_UPDATE_DELAYED
};

/* custom button toggled or not */
#define VDK_CBUTTON_UNTOGGLED         0x0010
#define VDK_CBUTTON_TOGGLED           0x0020
#define VDK_CBUTTON_TOGGLEMASK        0x00F0
/* custom button type */
#define VDK_CBUTTON_NORMAL            0x0000
#define VDK_CBUTTON_COMBO             0x0004
#define VDK_CBUTTON_TYPEMASK          0x000F
/* MessageBox icon types */
#ifndef VDK_ICONSTOP
#define VDK_ICONSTOP          0x0010
#define VDK_ICONWARNING       VDK_ICONSTOP
#define VDK_ICONQUESTION      0x0020
#define VDK_ICONINFORMATION   0x0040
#define VDK_ICONERROR         0x0080
#define VDK_ICONMASK          0x00F0
#endif
/* MessageBox  type */
#define VDK_OK                0x0000
#define VDK_YESNO             0x0002	//0x0004
#define VDK_OKCANCEL          0x0004	//0x0008
#define VDK_YESNOCANCEL       0x0008
#define VDK_TYPEMASK          0x000F
/* MessageBox answers */
#define VDK_IDYES             0x0001
#define VDK_IDNO              0x0002
#define VDK_IDOK              0x0003
#define VDK_IDCANCEL          0x0004 /* (not yet implemented) */

/* some useful colors */
#define clWhite VDKRgb(255,255,255)
#define clBlack VDKRgb(0,0,0)
#define clYellow VDKRgb(255,255,0)
#define clRed   VDKRgb(255,0,0)
#define clGreen VDKRgb(0,255,0)
#define clBlue  VDKRgb(0,0,255)
#define clNavyBlue  VDKRgb(0,0,130)
#define clMaroon VDKRgb(146,89,28)
#define clSiena  VDKRgb(178,32,32)
#define clIvory  VDKRgb(255,255,223)
#define clAirBlue VDKRgb(89,186,231)
#define clLightBlue clAirBlue
#define clDodgerBlue VDKRgb(101,191,212)

/* some useful fonts */
#define fnFixed14 "fixed Medium 14"
#define fnCourier12 "courier Medium 12"
#define fnCourier14 "courier Medium 14"
#define fnFixed12   "fixed Medium 12"
#define fnLucida12  "lucida Medium 12"
#define fnLucidaBold12 "lucida Bold 12"
#define fnTimesBold12 "times Bold 12"
#define fnTimesBold14 "times Bold 14"
#define fnTimes24 "times Medium 24"
#define fnTimesBold24 "times Bold 24"

#endif





