// -*- c++ -*-
/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-130
 */ 

#ifndef VDKPROPS_H
#define VDKPROPS_H
#include <vdk/vdkustring.h>
#include <vdk/vdkfont.h>
#include <cstdio>

#ifdef USE_SIGCPLUSPLUS
#   include <vdk/sigc_addon.h>
#endif // USE_SIGCPLUSPLUS

#define __rwproperty(ownerClass,propertyType) \
  VDKReadWriteValueProp<ownerClass, propertyType>
#define __rproperty(ownerClass,propertyType) \
  VDKReadOnlyValueProp<ownerClass, propertyType>
#ifdef NULL
#undef NULL
#define NULL 0x0000
#endif
#define PFREAD_NULL  (PFRead) 0x0000
#define PFWRITE_NULL (PFWrite) 0x0000
//==================================================
/*
read/write values property
*/
template <class T, typename S>
class VDKReadWriteValueProp 
#ifdef USE_SIGCPLUSPLUS
     : public SigC::Object
#endif 
{
	// checked out because confuse some compiler
	//friend class T;
	protected:
		typedef S (T::*PFRead)(void);
		typedef void (T::*PFWrite)(S);

		VDKUString name;
		T* object;
		S  (T::*get)(void);
		void (T::*set)(S);
		S value;
		VDKReadWriteValueProp(VDKReadWriteValueProp& p);
		void operator = (VDKReadWriteValueProp& p);
	public:

		VDKReadWriteValueProp();

		VDKReadWriteValueProp(
			const char* name,
			T* object,
			S defValue,
			void (T::*write)(S) = NULL,//PFWRITE_NULL,
			S (T::*read)(void) =  NULL //PFREAD_NULL
		);

		virtual ~VDKReadWriteValueProp();

		// raw setting (functor)
		// caution using it in read only props breaks
		// data hiding and can lead in ugly errors.
		// user: use it at your own risk.
		virtual void operator()(S val);
		// setting prop value operator
		virtual void operator = (S val);
		// getting prop value operator
		virtual operator S() const;
		char* Name();
		S Value()const { return value; } 
#ifdef USE_SIGCPLUSPLUS
		DualSignal1<void, T*,S> OnValueChanged;
#endif
};

/*
read only values property
*/
template <class T, class S>
class VDKReadOnlyValueProp: public VDKReadWriteValueProp<T,S> 
{
	public:
		void operator = (S);
		VDKReadOnlyValueProp();
		VDKReadOnlyValueProp(
			const char* name,
			T* object,
			S defValue,
			S (T::*read)(void) = NULL, //PFREAD_NULL,
			void (T::*write)(S) = NULL //PFWRITE_NULL
		);

	virtual ~VDKReadOnlyValueProp();
};

// VDKReadWriteValueProp class
template <class T, typename S>
VDKReadWriteValueProp<T, S>::VDKReadWriteValueProp(): 
    name(""),
    object(NULL),
    get(NULL /*PFREAD_NULL*/),
    set(NULL /*PFWRITE_NULL*/)
{
}

template <class T, typename S>
VDKReadWriteValueProp<T, S>::VDKReadWriteValueProp(const char* name,
											T* object,
											S defValue,
											void (T::*write)(S),
											S (T::*read)(void)):
	name(name),object(object),
	get(read),set(write),
	value(defValue)
{
}

template <class T, typename S>
VDKReadWriteValueProp<T, S>::VDKReadWriteValueProp(VDKReadWriteValueProp& p)
{
}

template <class T, typename S>
VDKReadWriteValueProp<T, S>::~VDKReadWriteValueProp()
{
}

template <class T, typename S>
void VDKReadWriteValueProp<T, S>::operator = (VDKReadWriteValueProp& p)
{
}

template <class T, typename S>
void VDKReadWriteValueProp<T, S>::operator()(S val) 
{ 
	value = val; 
#ifdef USE_SIGCPLUSPLUS
	OnValueChanged.emit(object, value);
#endif
}

template <class T, typename S>
void VDKReadWriteValueProp<T, S>::operator = (S val) 
{
	if (set && object) ((*object).*set)(val);
	value = val;
#ifdef USE_SIGCPLUSPLUS
	OnValueChanged.emit(object, value);
#endif
}

template <class T, typename S>
VDKReadWriteValueProp<T, S>::operator S() const
{ 
	if (get && object) {
		//return (*((const_cast<VDKReadWriteValueProp<T,S>*>(this))->object).*get)();
		return ((*object).*get)();
	}
	else return value;
}

template <class T, typename S>
char* VDKReadWriteValueProp<T, S>::Name() 
{
	return name;
}

// VDKReadOnlyValueProp class
template <class T, typename S>
VDKReadOnlyValueProp<T, S>::VDKReadOnlyValueProp() : VDKReadWriteValueProp<T,S>()
{
}

template <class T, typename S>
VDKReadOnlyValueProp<T, S>::VDKReadOnlyValueProp(const char* name,
										  T* object,
										  S defValue,
										  S (T::*read)(void),
										  void (T::*write)(S)) :
	VDKReadWriteValueProp<T,S>(name, object, defValue, write, read)
{
}

template <class T, typename S>
VDKReadOnlyValueProp<T, S>::~VDKReadOnlyValueProp()
{
}

template <class T, typename S>
void VDKReadOnlyValueProp<T, S>::operator = (S)
{
}


#endif













