/*
 * ===========================
 * VDK Visual Development Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef  TOOLTIPS_H
#define  TOOLTIPS_H

#include <vdk/vdkobj.h>
class VDKColor;
/*!
  \class VDKTooltip
  \brief Provides a tooltip
 */
class VDKTooltip: public VDKObject
{
  char* tip;
  GtkTooltips* tooltip;
  VDKObject* tipped;
  int delay;
 public:
  /*!
    Constructor.
    \param owner
    \param tipped object 
    \param tip
    \param delay 
   */
  VDKTooltip(VDKForm* owner,VDKObject *tipped,
	     const char* tip, int delay = 0);
  /*!
    Destructor
  */
  ~VDKTooltip();
  /*!
    This does not work at all !
    \par TIP
    Tip background should be customized via an rc file like this:
    \code
    style "tooltip"
    {
      bg[NORMAL] = {1.0, 1.0, 0.0}
      fg[NORMAL] = {0.0, 1.0, 0.0}
    }
    widget "gtk-tooltips*" style "tooltip"
    \endcode
    Recall that almost all gtk themes except default one override
    your tip settings.
   */
  virtual void SetColors(int fred, int fgreen, int fblue,
			 int bred, int bgreen, int bblue);
  /*!
    Change tip
  */
  void SetTip(const char* );
  /*!
    Sets delay time in msecs
  */
  void SetDelay(int delay);
};
#endif
