/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#ifndef  ENTRY_H
#define  ENTRY_H

#include <vdk/vdkobj.h>
#include <vdk/vdkprops.h>
#include <vdk/vdkustring.h>
#include <string.h>

/*!
  \class VDKEntry
  \brief This class provides a gtkentry wrapper
  \par SIGNALS
  \arg \b activate_signal received when the user presses Enter key
  \arg \b changed_signal received when user presses other than an editing key
  \arg \b focus_in_signal received when widget gains focus
  \arg \b focus_out_signal received when widget looses focus
  \par EXAMPLES
  In ./testvdk/entrieswin.cc
 */
class VDKEntry: public VDKObject
{
	static int FocusOutEvent(GtkWidget *w,
			    GdkEventFocus *event,
			    gpointer wid);
	static int FocusInEvent(GtkWidget *w,
			    GdkEventFocus *event,
			    gpointer wid);
	VDKUString buffer;
protected:
	int changeConnect;
	VDKObjectSignal s_activated, s_changed;
public:
  // properties
  /*!
    Read/write entry text.
    \code
    char* p = "a text";
    entry->Text = p;
    printf("\ntext:%s",(char*) entry->Text);
    fflush(stdout);
    \endcode
   */
  VDKReadWriteValueProp<VDKEntry,char*> Text;
  /*!
    Enable/disable editing
   */
  VDKReadWriteValueProp<VDKEntry,bool>  Editable;
  /*!
    Enable/disable text visibility
    \par Tip
    Use this property set to true to make a "secret" entry field
   */
  VDKReadWriteValueProp<VDKEntry,bool>  Hidden;
  //
  VDKEntry(VDKForm* owner,int maxLen = 0, char* def = (char*) NULL);

  virtual ~VDKEntry();
  /*!
    Enables word completion
    \param completion_list a NULL terminating string array
   */
  void SetCompletion(char** completion_list);
  /*!
    Add a completion word to completion list
    \param completion_item
   */
  void AddCompletionItem(char* completion_item);
  /*!
    Remove a completion word from completion list
    \param completion_item
   */
  void RemoveCompletionItem(char* completion_item);
  /*
   */
  void SetText(char* text);
  char* GetText(); 
  void SetEditable(bool flag)
    { gtk_entry_set_editable(GTK_ENTRY(widget),flag); }
  bool GetEditable() { return Editable; }
  virtual void SetBackground(VDKRgb rgb, GtkStateType state);
  virtual void SetForeground(VDKRgb rgb, GtkStateType state);
  virtual void SetFont(VDKFont* font);
  void SetHidden(bool flag)
    { gtk_entry_set_visibility(GTK_ENTRY(widget), ! flag) ; }
  bool GetHidden()
    { return ! Hidden; }
};
#endif
