/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 0.4
 * October 1998
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
  \latexonly
  <image latex vdklogo.eps 
  \endlatexonly
 */
/*!
  \mainpage VDK Reference version 2.0.0 (beta)

  <center>
  \htmlonly
  <img align=center src="vdklogo.gif"><br>
  \endhtmlonly
  </center>
  \section RELEASE NOTES
  This version is a beta release of next VDK 2.0 series, so take in account
  that by no means is guaranteed to be stable or API will be matained unchanged across
  next versions.

  \section  general General considerations
  \arg 1. Almost all VDKObjects must be constructed on the heap with 
  the new operator, any copy-initializing and/or assignement operations 
  between objects are  prohibited and will be flagged as a compilation error.

  \arg 2. No memory freeing and/or deleting is required, all new'ed objects 
  will be automatically destroyed immediately before application 
  termination or with a timed garbage collection that can be 
  installed/uninstalled by programmer.
  However VDKObject(s) can be explicitely freed with the Destroy() method.

  \arg 3. Both GTK+ "signals" mechanism and the "event" dispatch are available 
  for programmer use but are handled in a different way.

  \arg 4. VDK uses the "property" concepts introduced with RAD, 
  therefore using properties is encouraged even if it's also possible 
  to have usual functions to set/get objects attributes.

  \arg 5. The word "window" used in Gtk+ is here replaced with "Form".

  \arg 6. VDK is consists into two separated modules:
  - VDK Core Library that contains kernel and only Gtk+ wrapped widgets.
  - VDK Components that contains totally new widgets and/or those not 
  yet stable enough to be inserted into the core library.

  \section design VDK DESIGN NOTES
  VDK was designed to be more a C++ framework based on Gtk+ widget 
  set library than a thin-layer wrapper. 
  VDK hides on the background as much gtk+ work as possible rather than 
  wrap all gtk+ function calls. Using VDK one will realize that 
  many one-to-one statement with gtk+ are not wrapped. 
  Even if is possible to make use of VDK without knowing gtk+, 
  more experienced user will take advantage of knowing gtk+ calls and 
  conventions. At this end VDK provides method to access and use 
  underlying gtk+ widgets.
  User should also read and know following gtk+/gdk distribution files:
  - gdk/gdktypes.h
  - gtk/gtkenums.h
  - gdk/gdkkeysyms.h
  VDK is used as base library of VDKBuilder RAD tool, using VDK 
  with VDKBuilder is highly encouraged since user can concentrate his 
  attention to the application rather than gui construction. 
  Also in this case a good knowledge of VDK is a good way to take 
  advantage from using VDKBuilder.

  \section net VDK ON THE NET
  VDK and VDKBuilder have their own web site:
  http://vdkbuilder/sourceforge.net (primary site)

  A mailing list is available for users support, users are encouraged to subscribe it from web site.

  \author
  \arg Mario Motta  mmotta@guest.net
  \arg Ionutz Borcoman borco@borco-ei.eng.hokudai.ac.jp (Ion is no longer an active member)
  \arg Tim Lorenz Tim.Lorenz@stud.uni-hannover.de
  \arg Pierre-Louis Malatray pierrelouis.malatray@free.fr
  \arg George Boutwell gboutwell@yahoo.com
  \par Note
  This manual is a living document and changes with the development of VDK.
  I hope that the hints and tips will be useful. More information can be 
  obtained from the examples source files in ./testvdk. Comments and 
  suggestions are welcome.

  \par Copyright (c)  1998,1999,2000,2001,20020000 VDK Team
  Permission is granted to copy, distribute and/or modify this document
  under the terms of the GNU Free Documentation License, Version 1.1
  or any later version published by the Free Software Foundation;
  with the Invariant Sections being "with no Invariants sections", 
  with the Front-Cover Texts being "with no Front-Cover Texts", 
  and with the Back-Cover Texts  being "with no Back-Cover Texts".
 */
#ifndef APPLICATION_H
#define APPLICATION_H

#include <gtk/gtk.h>
#include <vdk/vdktypes.h>
#include <vdk/vdkstring.h>
#include <vdk/vdkustring.h>


class VDKForm;
/*! \class VDKApplication
 *  \brief Application object.
 *
 *  This class initializes GTK+ library and starts event loop.
 *  Normally user overrides this class using his own application object.
 *  Application objects are responsible to manage also terminating and
 *  clean-up procedures.
 */
class VDKApplication
{
  int gcTag,idleTag;
  VDKUString rcfile;
protected:
  /* !
     \internal
     garbage collection callback,
     invoked from a gtk_timeout established by the user with
     SetGarbageCollection()
  */
  static int GcCallback(gpointer app);
public:
  /*!
   * Must be initialized by the user otherwise an useless default
   * main form will be created
   */
  VDKForm* MainForm;
  /*! 
   * Constructor, receives main() arguments and pass them to 
   * GTK* library.
   * \param rc if isn't NULL <rc> resource file will be loaded
   * and parsed.
   * \param have_locale if true let's VDK to invoke gtk_set_locale()
   * and support any languages that GTK supports.
   */
  VDKApplication(int* argc, char** argv, char* rcf = (char*) NULL,
		 bool have_locale = false);
  /*!
   * Destructor
   */
  virtual ~VDKApplication();
  /*!
   * Initiates event loop
   */
  void Run(void);
  /*!
   * Terminates event loop and quits GTK* library.
   * This method is called after a destroy event on MainForm,
   * user normally doesn't care of it.
   */
  void Terminate(void);
  /*!
   * Returns underlying gtk+ window of the application main form
   */
  GtkWidget* MainWindow();
  /*!
   * Initializes Main form, user must override this one in his own
   * application object.
   */
  virtual void Setup() = 0;
  /*!
    Provide a modal dialog window for messages to user.
    \param mode
    - \c VDK_OK provide only one button with a "Ok" default caption
    - \c VDK_YESNO provides two buttons with "Yes" and "No" default captions.
    - \c VDK_OKCANCEL provides two buttons with "Ok" and "Cancel" default captions.
    - \c VDK_YESNOCANCEL provides three buttons with "Yes", "No" and "Cancel" default captions.
    Mode can be ored with:
    - \c VDK_ICONSTOP provides a warning icon
    - \c VDK_ICONINFORMATION provides a information icon
    - \c VDK_ICONQUESTION provides a question mark icon
    - \c VDK_ICONERROR  provides an error icon
    MessageBox returns an integer that depends on modes and user response:
    - \c VDK_IDOK, user pressed OK button in VDK_OK or VDK_OKCANCEL mode
    - \c VDK_IDYES, user pressed YES button in VDK_YESNO and VDK_YESNOCANCEL mode
    - \c VDK_IDNO, user pressed NO button in VDK_YESNO and VDK_YESNOCANCEL mode
    - \c VDK_IDCANCEL, user pressed NO button in VDK_OKCANCEL and VDK_YESNOCANCEL mode
    \param wait  if set other than 0 makes MessageBox automatically 
    closed after <wait> msecs with IDCANCEL or IDNO result.
    \param msgowner pointer on VDKForm which throws the messagebox,
    needed to send back focus to this window on closing messagebox
    \param lbtext Last button text in VDK_YESNOCANCEL mode (needed for translation purpose)
    \param lbans Last button answer in VDK_YESNOCANCEL mode
    Tip: MessageBox accepts CR according to which button has focus and ESC as "no/cancel" default answers.
   */
  gint VDKMessageBox(const char* caption,
	 	  const char* text,
 		  int mode = VDK_OK,
		  unsigned int wait = 0,
		  VDKForm *msgowner = NULL);
  /*!
  VDKString prototype
  */
  gint VDKMessageBox(VDKString caption,
	 	  VDKString text,
 		  int mode = VDK_OK,
		  unsigned int wait = 0,
		  VDKForm *msgowner = NULL);
  /*!
  VDKUString prototype
  */		  
  gint VDKMessageBox(VDKUString caption,
	 	  VDKUString text,
 		  int mode = VDK_OK,
		  unsigned int wait = 0,
		  VDKForm *msgowner = NULL);

  //
  gint VDKFileChooser(char* caption);
  /*!
    Sets idle callback function, if a previous idle callback was 
    installed, uninstall it.
    /param /c idlecb idle callback function must be declared as:
    void idlecb(gpointer data);
    /param /c data will be passed to user defined function and must
    be a non NULL pointer otherwise SetIdleCallback won't work. 
   */
  void SetIdleCallback(GtkFunction idlecb = NULL ,
		       gpointer data = (gpointer) NULL);
  /*!
    Set a timed garbage collection that will be invoked each <timing> msecs.
   */
  void SetGarbageCollection(unsigned int tick = 1000);
  /*!
    Remove timed garbage collection.
   */
  void RemoveGarbageCollection();
  /*!
    Set a resource file.
    Tip: this should be done before Run()ning app.
   */
  void SetResourceFile(char* rcf);
  /*!
    Indicates if the resource file was loaded and parsed
   */
  bool HasResources() { return ! rcfile.isNull(); }
};

#endif







