/* Swfdec
 * Copyright (C) 2007 Pekka Lampila <pekka.lampila@iki.fi>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "swfdec_as_internal.h"
#include "swfdec_debug.h"

SWFDEC_AS_NATIVE (1067, 1, swfdec_text_snapshot_getCount)
void
swfdec_text_snapshot_getCount (SwfdecAsContext *cx, SwfdecAsObject *object,
    guint argc, SwfdecAsValue *argv, SwfdecAsValue *ret)
{
  SWFDEC_STUB ("TextSnapshot.getCount");
}

SWFDEC_AS_NATIVE (1067, 2, swfdec_text_snapshot_setSelected)
void
swfdec_text_snapshot_setSelected (SwfdecAsContext *cx, SwfdecAsObject *object,
    guint argc, SwfdecAsValue *argv, SwfdecAsValue *ret)
{
  SWFDEC_STUB ("TextSnapshot.setSelected");
}

SWFDEC_AS_NATIVE (1067, 3, swfdec_text_snapshot_getSelected)
void
swfdec_text_snapshot_getSelected (SwfdecAsContext *cx, SwfdecAsObject *object,
    guint argc, SwfdecAsValue *argv, SwfdecAsValue *ret)
{
  SWFDEC_STUB ("TextSnapshot.getSelected");
}

SWFDEC_AS_NATIVE (1067, 4, swfdec_text_snapshot_getText)
void
swfdec_text_snapshot_getText (SwfdecAsContext *cx, SwfdecAsObject *object,
    guint argc, SwfdecAsValue *argv, SwfdecAsValue *ret)
{
  SWFDEC_STUB ("TextSnapshot.getText");
}

SWFDEC_AS_NATIVE (1067, 5, swfdec_text_snapshot_getSelectedText)
void
swfdec_text_snapshot_getSelectedText (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("TextSnapshot.getSelectedText");
}

SWFDEC_AS_NATIVE (1067, 6, swfdec_text_snapshot_hitTestTextNearPos)
void
swfdec_text_snapshot_hitTestTextNearPos (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("TextSnapshot.hitTestTextNearPos");
}

SWFDEC_AS_NATIVE (1067, 7, swfdec_text_snapshot_findText)
void
swfdec_text_snapshot_findText (SwfdecAsContext *cx, SwfdecAsObject *object,
    guint argc, SwfdecAsValue *argv, SwfdecAsValue *ret)
{
  SWFDEC_STUB ("TextSnapshot.findText");
}

SWFDEC_AS_NATIVE (1067, 8, swfdec_text_snapshot_setSelectColor)
void
swfdec_text_snapshot_setSelectColor (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("TextSnapshot.setSelectColor");
}

SWFDEC_AS_NATIVE (1067, 9, swfdec_text_snapshot_getTextRunInfo)
void
swfdec_text_snapshot_getTextRunInfo (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("TextSnapshot.getTextRunInfo");
}

SWFDEC_AS_NATIVE (1067, 0, swfdec_text_snapshot_construct)
void
swfdec_text_snapshot_construct (SwfdecAsContext *cx, SwfdecAsObject *object,
    guint argc, SwfdecAsValue *argv, SwfdecAsValue *ret)
{
  SWFDEC_STUB ("TextSnapshot");
}
