// Module:  Log4CPLUS
// File:    cygwin-win32.cxx
// Created: 7/2011
// Author:  Vaclav Zeman
//
//  Copyright (C) 2011-2015, Vaclav Zeman. All rights reserved.
//  
//  Redistribution and use in source and binary forms, with or without modifica-
//  tion, are permitted provided that the following conditions are met:
//  
//  1. Redistributions of  source code must  retain the above copyright  notice,
//     this list of conditions and the following disclaimer.
//  
//  2. Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//  
//  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED WARRANTIES,
//  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
//  FITNESS  FOR A PARTICULAR  PURPOSE ARE  DISCLAIMED.  IN NO  EVENT SHALL  THE
//  APACHE SOFTWARE  FOUNDATION  OR ITS CONTRIBUTORS  BE LIABLE FOR  ANY DIRECT,
//  INDIRECT, INCIDENTAL, SPECIAL,  EXEMPLARY, OR CONSEQUENTIAL  DAMAGES (INCLU-
//  DING, BUT NOT LIMITED TO, PROCUREMENT  OF SUBSTITUTE GOODS OR SERVICES; LOSS
//  OF USE, DATA, OR  PROFITS; OR BUSINESS  INTERRUPTION)  HOWEVER CAUSED AND ON
//  ANY  THEORY OF LIABILITY,  WHETHER  IN CONTRACT,  STRICT LIABILITY,  OR TORT
//  (INCLUDING  NEGLIGENCE OR  OTHERWISE) ARISING IN  ANY WAY OUT OF THE  USE OF
//  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

#if defined (__CYGWIN__)

// Work around missing _X86_ symbol with Clang on Cygwin.
#if ! defined (_X86_) && defined (__i386__)
#  define _X86_ 1
#endif

#include <log4cplus/internal/cygwin-win32.h>

// This is intentionally included directly instead of through
// windowsh-inc.h.
#include <winsock2.h>


namespace log4cplus { namespace cygwin {

unsigned long
get_current_win32_thread_id ()
{
    return GetCurrentThreadId ();
}


void
output_debug_stringW (wchar_t const * str)
{
    OutputDebugStringW (str);
}

} } // namespace log4cplus { namespace cygwin {

#endif // defined (__CYGWIN__)
