/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.inspector.manager;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.inspector.encryption.BasicDataEncryptionManager;
import org.apache.zookeeper.inspector.encryption.DataEncryptionManager;
import org.apache.zookeeper.inspector.logger.LoggerFactory;
import org.apache.zookeeper.inspector.manager.NodeListener;
import org.apache.zookeeper.inspector.manager.Pair;
import org.apache.zookeeper.inspector.manager.ZooInspectorManager;
import org.apache.zookeeper.retry.ZooKeeperRetry;

public class ZooInspectorManagerImpl
implements ZooInspectorManager {
    private static final String A_VERSION = "ACL Version";
    private static final String C_TIME = "Creation Time";
    private static final String C_VERSION = "Children Version";
    private static final String CZXID = "Creation ID";
    private static final String DATA_LENGTH = "Data Length";
    private static final String EPHEMERAL_OWNER = "Ephemeral Owner";
    private static final String M_TIME = "Last Modified Time";
    private static final String MZXID = "Modified ID";
    private static final String NUM_CHILDREN = "Number of Children";
    private static final String PZXID = "Node ID";
    private static final String VERSION = "Data Version";
    private static final String ACL_PERMS = "Permissions";
    private static final String ACL_SCHEME = "Scheme";
    private static final String ACL_ID = "Id";
    private static final String SESSION_STATE = "Session State";
    private static final String SESSION_ID = "Session ID";
    public static final String CONNECT_STRING = "hosts";
    public static final String SESSION_TIMEOUT = "timeout";
    public static final String DATA_ENCRYPTION_MANAGER = "encryptionManager";
    public static final String AUTH_SCHEME_KEY = "authScheme";
    public static final String AUTH_DATA_KEY = "authData";
    private static final File defaultNodeViewersFile = new File("./config/defaultNodeVeiwers.cfg");
    private static final File defaultConnectionFile = new File("./config/defaultConnectionSettings.cfg");
    private DataEncryptionManager encryptionManager;
    private String connectString;
    private int sessionTimeout;
    private ZooKeeper zooKeeper;
    private final Map<String, NodeWatcher> watchers = new HashMap<String, NodeWatcher>();
    protected boolean connected = true;
    private Properties lastConnectionProps;
    private String defaultEncryptionManager;
    private String defaultTimeout;
    private String defaultHosts;
    private String defaultAuthScheme;
    private String defaultAuthValue;

    public ZooInspectorManagerImpl() throws IOException {
        this.loadDefaultConnectionFile();
    }

    @Override
    public boolean connect(Properties connectionProps) {
        try {
            if (this.zooKeeper == null) {
                String connectString = connectionProps.getProperty(CONNECT_STRING);
                String sessionTimeout = connectionProps.getProperty(SESSION_TIMEOUT);
                String encryptionManager = connectionProps.getProperty(DATA_ENCRYPTION_MANAGER);
                String authScheme = connectionProps.getProperty(AUTH_SCHEME_KEY);
                String authData = connectionProps.getProperty(AUTH_DATA_KEY);
                if (connectString == null || sessionTimeout == null) {
                    throw new IllegalArgumentException("Both connect string and session timeout are required.");
                }
                if (encryptionManager == null) {
                    this.encryptionManager = new BasicDataEncryptionManager();
                } else {
                    Class<?> clazz = Class.forName(encryptionManager);
                    if (Arrays.asList(clazz.getInterfaces()).contains(DataEncryptionManager.class)) {
                        this.encryptionManager = (DataEncryptionManager)Class.forName(encryptionManager).newInstance();
                    } else {
                        throw new IllegalArgumentException("Data encryption manager must implement DataEncryptionManager interface");
                    }
                }
                this.connectString = connectString;
                this.sessionTimeout = Integer.valueOf(sessionTimeout);
                this.zooKeeper = new ZooKeeperRetry(connectString, Integer.valueOf(sessionTimeout), new Watcher(){

                    public void process(WatchedEvent event) {
                        if (event.getState() == Watcher.Event.KeeperState.Expired) {
                            ZooInspectorManagerImpl.this.connected = false;
                        }
                    }
                });
                if (authData != null && authData.length() > 0) {
                    this.zooKeeper.addAuthInfo(authScheme, authData.getBytes());
                }
                ((ZooKeeperRetry)this.zooKeeper).setRetryLimit(10);
                this.connected = ((ZooKeeperRetry)this.zooKeeper).testConnection();
            }
        }
        catch (Exception e) {
            this.connected = false;
            e.printStackTrace();
        }
        if (!this.connected) {
            this.disconnect();
        }
        return this.connected;
    }

    @Override
    public boolean disconnect() {
        try {
            if (this.zooKeeper != null) {
                this.zooKeeper.close();
                this.zooKeeper = null;
                this.connected = false;
                this.removeWatchers(this.watchers.keySet());
                return true;
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger().error("Error occurred while disconnecting from ZooKeeper server", (Throwable)e);
        }
        return false;
    }

    @Override
    public List<String> getChildren(String nodePath) {
        if (this.connected) {
            try {
                return this.zooKeeper.getChildren(nodePath, false);
            }
            catch (Exception e) {
                LoggerFactory.getLogger().error("Error occurred retrieving children of node: " + nodePath, (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public String getData(String nodePath) {
        if (this.connected) {
            try {
                Stat s;
                if (nodePath.length() == 0) {
                    nodePath = "/";
                }
                if ((s = this.zooKeeper.exists(nodePath, false)) != null) {
                    return this.encryptionManager.decryptData(this.zooKeeper.getData(nodePath, false, s));
                }
            }
            catch (Exception e) {
                LoggerFactory.getLogger().error("Error occurred getting data for node: " + nodePath, (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public String getNodeChild(String nodePath, int childIndex) {
        if (this.connected) {
            try {
                Stat s = this.zooKeeper.exists(nodePath, false);
                if (s != null) {
                    return (String)this.zooKeeper.getChildren(nodePath, false).get(childIndex);
                }
            }
            catch (Exception e) {
                LoggerFactory.getLogger().error("Error occurred retrieving child " + childIndex + " of node: " + nodePath, (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public int getNodeIndex(String nodePath) {
        if (this.connected) {
            List<String> children;
            int index = nodePath.lastIndexOf("/");
            if (index == -1 || !nodePath.equals("/") && nodePath.charAt(nodePath.length() - 1) == '/') {
                throw new IllegalArgumentException("Invalid node path: " + nodePath);
            }
            String parentPath = nodePath.substring(0, index);
            String child = nodePath.substring(index + 1);
            if (parentPath != null && parentPath.length() > 0 && (children = this.getChildren(parentPath)) != null) {
                return children.indexOf(child);
            }
        }
        return -1;
    }

    @Override
    public List<Map<String, String>> getACLs(String nodePath) {
        ArrayList<Map<String, String>> returnACLs = new ArrayList<Map<String, String>>();
        if (this.connected) {
            try {
                Stat s;
                if (nodePath.length() == 0) {
                    nodePath = "/";
                }
                if ((s = this.zooKeeper.exists(nodePath, false)) != null) {
                    List acls = this.zooKeeper.getACL(nodePath, s);
                    for (ACL acl : acls) {
                        LinkedHashMap<String, String> aclMap = new LinkedHashMap<String, String>();
                        aclMap.put(ACL_SCHEME, acl.getId().getScheme());
                        aclMap.put(ACL_ID, acl.getId().getId());
                        StringBuilder sb = new StringBuilder();
                        int perms = acl.getPerms();
                        boolean addedPerm = false;
                        if ((perms & 1) == 1) {
                            sb.append("Read");
                            addedPerm = true;
                        }
                        if (addedPerm) {
                            sb.append(", ");
                        }
                        if ((perms & 2) == 2) {
                            sb.append("Write");
                            addedPerm = true;
                        }
                        if (addedPerm) {
                            sb.append(", ");
                        }
                        if ((perms & 4) == 4) {
                            sb.append("Create");
                            addedPerm = true;
                        }
                        if (addedPerm) {
                            sb.append(", ");
                        }
                        if ((perms & 8) == 8) {
                            sb.append("Delete");
                            addedPerm = true;
                        }
                        if (addedPerm) {
                            sb.append(", ");
                        }
                        if ((perms & 0x10) == 16) {
                            sb.append("Admin");
                            addedPerm = true;
                        }
                        aclMap.put(ACL_PERMS, sb.toString());
                        returnACLs.add(aclMap);
                    }
                }
            }
            catch (InterruptedException e) {
                LoggerFactory.getLogger().error("Error occurred retrieving ACLs of node: " + nodePath, (Throwable)e);
            }
            catch (KeeperException e) {
                LoggerFactory.getLogger().error("Error occurred retrieving ACLs of node: " + nodePath, (Throwable)e);
            }
        }
        return returnACLs;
    }

    @Override
    public Map<String, String> getNodeMeta(String nodePath) {
        LinkedHashMap<String, String> nodeMeta = new LinkedHashMap<String, String>();
        if (this.connected) {
            try {
                Stat s;
                if (nodePath.length() == 0) {
                    nodePath = "/";
                }
                if ((s = this.zooKeeper.exists(nodePath, false)) != null) {
                    nodeMeta.put(A_VERSION, String.valueOf(s.getAversion()));
                    nodeMeta.put(C_TIME, String.valueOf(s.getCtime()));
                    nodeMeta.put(C_VERSION, String.valueOf(s.getCversion()));
                    nodeMeta.put(CZXID, String.valueOf(s.getCzxid()));
                    nodeMeta.put(DATA_LENGTH, String.valueOf(s.getDataLength()));
                    nodeMeta.put(EPHEMERAL_OWNER, String.valueOf(s.getEphemeralOwner()));
                    nodeMeta.put(M_TIME, String.valueOf(s.getMtime()));
                    nodeMeta.put(MZXID, String.valueOf(s.getMzxid()));
                    nodeMeta.put(NUM_CHILDREN, String.valueOf(s.getNumChildren()));
                    nodeMeta.put(PZXID, String.valueOf(s.getPzxid()));
                    nodeMeta.put(VERSION, String.valueOf(s.getVersion()));
                }
            }
            catch (Exception e) {
                LoggerFactory.getLogger().error("Error occurred retrieving meta data for node: " + nodePath, (Throwable)e);
            }
        }
        return nodeMeta;
    }

    @Override
    public int getNumChildren(String nodePath) {
        if (this.connected) {
            try {
                Stat s = this.zooKeeper.exists(nodePath, false);
                if (s != null) {
                    return s.getNumChildren();
                }
            }
            catch (Exception e) {
                LoggerFactory.getLogger().error("Error occurred getting the number of children of node: " + nodePath, (Throwable)e);
            }
        }
        return -1;
    }

    @Override
    public boolean hasChildren(String nodePath) {
        return this.getNumChildren(nodePath) > 0;
    }

    @Override
    public boolean isAllowsChildren(String nodePath) {
        if (this.connected) {
            try {
                Stat s = this.zooKeeper.exists(nodePath, false);
                if (s != null) {
                    return s.getEphemeralOwner() == 0L;
                }
            }
            catch (Exception e) {
                LoggerFactory.getLogger().error("Error occurred determining whether node is allowed children: " + nodePath, (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public Map<String, String> getSessionMeta() {
        LinkedHashMap<String, String> sessionMeta = new LinkedHashMap<String, String>();
        try {
            if (this.zooKeeper != null) {
                sessionMeta.put(SESSION_ID, String.valueOf(this.zooKeeper.getSessionId()));
                sessionMeta.put(SESSION_STATE, String.valueOf(this.zooKeeper.getState().toString()));
                sessionMeta.put(CONNECT_STRING, this.connectString);
                sessionMeta.put(SESSION_TIMEOUT, String.valueOf(this.sessionTimeout));
            }
        }
        catch (Exception e) {
            LoggerFactory.getLogger().error("Error occurred retrieving session meta data.", (Throwable)e);
        }
        return sessionMeta;
    }

    @Override
    public boolean createNode(String parent, String nodeName) {
        if (this.connected) {
            try {
                String[] nodeElements;
                for (String nodeElement : nodeElements = nodeName.split("/")) {
                    String node = parent + "/" + nodeElement;
                    Stat s = this.zooKeeper.exists(node, false);
                    if (s != null) continue;
                    this.zooKeeper.create(node, this.encryptionManager.encryptData(null), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                    parent = node;
                }
                return true;
            }
            catch (Exception e) {
                LoggerFactory.getLogger().error("Error occurred creating node: " + parent + "/" + nodeName, (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public boolean deleteNode(String nodePath) {
        if (this.connected) {
            try {
                Stat s = this.zooKeeper.exists(nodePath, false);
                if (s != null) {
                    List children = this.zooKeeper.getChildren(nodePath, false);
                    for (String child : children) {
                        String node = nodePath + "/" + child;
                        this.deleteNode(node);
                    }
                    this.zooKeeper.delete(nodePath, -1);
                }
                return true;
            }
            catch (Exception e) {
                LoggerFactory.getLogger().error("Error occurred deleting node: " + nodePath, (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public boolean setData(String nodePath, String data) {
        if (this.connected) {
            try {
                this.zooKeeper.setData(nodePath, this.encryptionManager.encryptData(data), -1);
                return true;
            }
            catch (Exception e) {
                LoggerFactory.getLogger().error("Error occurred setting data for node: " + nodePath, (Throwable)e);
            }
        }
        return false;
    }

    @Override
    public Pair<Map<String, List<String>>, Map<String, String>> getConnectionPropertiesTemplate() {
        LinkedHashMap<String, List<String>> template = new LinkedHashMap<String, List<String>>();
        template.put(CONNECT_STRING, Arrays.asList(this.defaultHosts));
        template.put(SESSION_TIMEOUT, Arrays.asList(this.defaultTimeout));
        template.put(DATA_ENCRYPTION_MANAGER, Arrays.asList(this.defaultEncryptionManager));
        template.put(AUTH_SCHEME_KEY, Arrays.asList(this.defaultAuthScheme));
        template.put(AUTH_DATA_KEY, Arrays.asList(this.defaultAuthValue));
        LinkedHashMap<String, String> labels = new LinkedHashMap<String, String>();
        labels.put(CONNECT_STRING, "Connect String");
        labels.put(SESSION_TIMEOUT, "Session Timeout");
        labels.put(DATA_ENCRYPTION_MANAGER, "Data Encryption Manager");
        labels.put(AUTH_SCHEME_KEY, "Authentication Scheme");
        labels.put(AUTH_DATA_KEY, "Authentication Data");
        return new Pair<Map<String, List<String>>, Map<String, String>>(template, labels);
    }

    @Override
    public void addWatchers(Collection<String> selectedNodes, NodeListener nodeListener) {
        if (this.connected) {
            for (String node : selectedNodes) {
                if (this.watchers.containsKey(node)) continue;
                try {
                    this.watchers.put(node, new NodeWatcher(node, nodeListener, this.zooKeeper));
                }
                catch (Exception e) {
                    LoggerFactory.getLogger().error("Error occured adding node watcher for node: " + node, (Throwable)e);
                }
            }
        }
    }

    @Override
    public void removeWatchers(Collection<String> selectedNodes) {
        if (this.connected) {
            for (String node : selectedNodes) {
                NodeWatcher watcher;
                if (!this.watchers.containsKey(node) || (watcher = this.watchers.remove(node)) == null) continue;
                watcher.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> loadNodeViewersFile(File selectedFile) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        if (defaultNodeViewersFile.exists()) {
            try (FileReader reader = new FileReader(selectedFile);
                 BufferedReader buff = new BufferedReader(reader);){
                while (buff.ready()) {
                    String line = buff.readLine();
                    if (line == null || line.length() <= 0 || line.startsWith("#")) continue;
                    result.add(line);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDefaultConnectionFile() throws IOException {
        if (defaultConnectionFile.exists()) {
            Properties props = new Properties();
            try (FileReader reader = new FileReader(defaultConnectionFile);){
                props.load(reader);
            }
            this.defaultEncryptionManager = props.getProperty(DATA_ENCRYPTION_MANAGER) == null ? "org.apache.zookeeper.inspector.encryption.BasicDataEncryptionManager" : props.getProperty(DATA_ENCRYPTION_MANAGER);
            this.defaultTimeout = props.getProperty(SESSION_TIMEOUT) == null ? "5000" : props.getProperty(SESSION_TIMEOUT);
            this.defaultHosts = props.getProperty(CONNECT_STRING) == null ? "localhost:2181" : props.getProperty(CONNECT_STRING);
            this.defaultAuthScheme = props.getProperty(AUTH_SCHEME_KEY) == null ? "" : props.getProperty(AUTH_SCHEME_KEY);
            this.defaultAuthValue = props.getProperty(AUTH_DATA_KEY) == null ? "" : props.getProperty(AUTH_DATA_KEY);
        } else {
            this.defaultEncryptionManager = "org.apache.zookeeper.inspector.encryption.BasicDataEncryptionManager";
            this.defaultTimeout = "5000";
            this.defaultHosts = "localhost:2181";
            this.defaultAuthScheme = "";
            this.defaultAuthValue = "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveDefaultConnectionFile(Properties props) throws IOException {
        File defaultDir = defaultConnectionFile.getParentFile();
        if (!defaultDir.exists() && !defaultDir.mkdirs()) {
            throw new IOException("Failed to create configuration directory: " + defaultDir.getAbsolutePath());
        }
        if (!defaultConnectionFile.exists() && !defaultConnectionFile.createNewFile()) {
            throw new IOException("Failed to create default connection file: " + defaultConnectionFile.getAbsolutePath());
        }
        try (FileWriter writer = new FileWriter(defaultConnectionFile);){
            props.store(writer, "Default connection for ZooInspector");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveNodeViewersFile(File selectedFile, List<String> nodeViewersClassNames) throws IOException {
        if (!selectedFile.exists() && !selectedFile.createNewFile()) {
            throw new IOException("Failed to create node viewers configuration file: " + selectedFile.getAbsolutePath());
        }
        try (FileWriter writer = new FileWriter(selectedFile);){
            BufferedWriter buff = new BufferedWriter(writer);
            try {
                for (String nodeViewersClassName : nodeViewersClassNames) {
                    buff.append(nodeViewersClassName);
                    buff.append("\n");
                }
            }
            finally {
                buff.flush();
                buff.close();
            }
        }
    }

    @Override
    public void setDefaultNodeViewerConfiguration(List<String> nodeViewersClassNames) throws IOException {
        File defaultDir = defaultNodeViewersFile.getParentFile();
        if (!defaultDir.exists() && !defaultDir.mkdirs()) {
            throw new IOException("Failed to create configuration directory: " + defaultDir.getAbsolutePath());
        }
        this.saveNodeViewersFile(defaultNodeViewersFile, nodeViewersClassNames);
    }

    @Override
    public List<String> getDefaultNodeViewerConfiguration() throws IOException {
        return this.loadNodeViewersFile(defaultNodeViewersFile);
    }

    @Override
    public Properties getLastConnectionProps() {
        return this.lastConnectionProps;
    }

    @Override
    public void setLastConnectionProps(Properties connectionProps) {
        this.lastConnectionProps = connectionProps;
    }

    public class NodeWatcher
    implements Watcher {
        private final String nodePath;
        private final NodeListener nodeListener;
        private final ZooKeeper zookeeper;
        private boolean closed = false;

        public NodeWatcher(String nodePath, NodeListener nodeListener, ZooKeeper zookeeper) throws KeeperException, InterruptedException {
            this.nodePath = nodePath;
            this.nodeListener = nodeListener;
            this.zookeeper = zookeeper;
            Stat s = ZooInspectorManagerImpl.this.zooKeeper.exists(nodePath, (Watcher)this);
            if (s != null) {
                zookeeper.getChildren(nodePath, (Watcher)this);
            }
        }

        public void process(WatchedEvent event) {
            if (!this.closed) {
                try {
                    Stat s;
                    if (event.getType() != Watcher.Event.EventType.NodeDeleted && (s = ZooInspectorManagerImpl.this.zooKeeper.exists(this.nodePath, (Watcher)this)) != null) {
                        this.zookeeper.getChildren(this.nodePath, (Watcher)this);
                    }
                }
                catch (Exception e) {
                    LoggerFactory.getLogger().error("Error occured re-adding node watcherfor node " + this.nodePath, (Throwable)e);
                }
                this.nodeListener.processEvent(event.getPath(), event.getType().name(), null);
            }
        }

        public void stop() {
            this.closed = true;
        }
    }
}

