#ifdef COPYRIGHT_INFORMATION
#include "gplv3.h"
#endif
/*
 * Copyright (C) 2002-2012 Edscott Wilson Garcia
 * EMail: edscott@users.sf.net
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; 
 */

static
void
set_application_icon (widgets_t * widgets_p, const gchar * icon_id) {
    GdkPixbuf *icon_pixbuf = rfm_get_pixbuf (icon_id, SIZE_ICON);
    rfm_global_t *rfm_global_p = rfm_global();
    if(icon_pixbuf) {
        gtk_window_set_icon (GTK_WINDOW (rfm_global_p->window), icon_pixbuf);
        if (G_IS_OBJECT(icon_pixbuf)) g_object_unref(icon_pixbuf);
    }
}

static
void
set_icon_name (GtkWidget * widget, const gchar * path) {
    gchar *iconname;
    NOOP ("set_icon_name\n");
    if(!path) {
        iconname = rfm_utf_string (g_get_host_name());
    } else if(rfm_g_file_test (path, G_FILE_TEST_EXISTS)) {


        gchar *basename = g_path_get_basename (path);
        gchar *pathname = g_strdup (path);
        gchar *b = rfm_utf_string (basename);   // non chopped
        rfm_chop_excess (pathname);
        gchar *q = rfm_utf_string (pathname);   // non chopped

        g_free (basename);
        g_free (pathname);
	//iconname = g_strconcat (display_host, ":  ", b, " (", q, ")", NULL);
	iconname = g_strconcat (b, " (", q, ")", NULL);
        g_free (q);
        g_free (b);
    } else {
        iconname = rfm_utf_string (path);
        rfm_chop_excess (iconname);
    }

#ifdef DEBUG
    gchar *gg = g_strdup_printf("%s-%d-D", iconname, getpid());
    g_free(iconname);
    iconname = gg;
#else
#ifdef CORE
    gchar *gg = g_strdup_printf("%s-%d-C", iconname, getpid());
    g_free(iconname);
    iconname = gg;
#endif
#endif
   
    gtk_window_set_title (GTK_WINDOW (gtk_widget_get_toplevel (widget)), iconname);
    g_free (iconname);
}

static void
print_loading_msg(widgets_t *widgets_p, record_entry_t *target_en){
    if (!target_en || !widgets_p) return;
    if (target_en->module == NULL){
	rfm_threaded_status (widgets_p, "xffm/stock_dialog-info", g_strdup(_("Loading folder...")));
	return;
    }
    gchar *name = rfm_void(PLUGIN_DIR, target_en->module,  
		    "module_label"); 
    gchar *text = g_strdup_printf(_("Loading %s..."), 
		(name)? name:target_en->module);
    g_free(name);
    rfm_threaded_status (widgets_p, "xffm/stock_dialog-info", text);
    return;
}

 
