//
//
//
#ifdef COPYRIGHT_INFORMATION
#include "gplv3.h"
#endif
static void
entry_activate (GtkWidget * entry, GdkEventKey * event, gpointer data) {
    GtkWidget *dialog = g_object_get_data(G_OBJECT(entry), "dialog");
    gtk_dialog_response  (GTK_DIALOG(dialog), GTK_RESPONSE_YES);
    return;
}
#if 0

This is replaced by rfm_get_response function .

static GtkWidget *
passwd_dialog (widgets_t * widgets_p, 
               const gchar * ptext, 
               gint option, 
               const gchar * qtext, 
               const gchar *default_value) ;

#endif

static
GtkWidget *
confirm_dialog (widgets_t * widgets_p, 
	gint type,
//	GtkMessageType type,
	const gchar * text, 
	const gchar * action_false,
	const gchar * action_true 
	) {
    GtkWidget *dialog;
    GtkWidget *button;
	// type: GTK_MESSAGE_INFO, GTK_MESSAGE_WARNING, GTK_MESSAGE_QUESTION, GTK_MESSAGE_ERROR

    NOOP ("DIAGNOSTICS: rfm_confirm_dialog\n");
    gchar *q = rfm_utf_string (text);
    rfm_global_t *rfm_global_p = rfm_global();

    dialog = gtk_dialog_new_with_buttons ("rfm", 
            (rfm_global_p)?GTK_WINDOW(rfm_global_p->window):NULL,
            GTK_DIALOG_DESTROY_WITH_PARENT, NULL, NULL);
    gtk_window_set_type_hint(GTK_WINDOW(dialog), GDK_WINDOW_TYPE_HINT_DIALOG);


    GtkWidget *cbox = gtk_dialog_get_content_area(GTK_DIALOG(dialog));
    GtkWidget *box = rfm_hbox_new(FALSE, 2);
    gtk_box_pack_start(GTK_BOX(cbox),box, FALSE, FALSE,0);
    gtk_widget_show(box);

    GdkPixbuf *pixbuf=NULL;
    switch (type){
        case GTK_MESSAGE_INFO:
            pixbuf=rfm_get_pixbuf("xffm/stock_dialog-info", 96);
            break;
        case GTK_MESSAGE_WARNING:
            pixbuf=rfm_get_pixbuf("xffm/stock_dialog-warning", 96);
            break;
        case GTK_MESSAGE_QUESTION:
            pixbuf=rfm_get_pixbuf("xffm/stock_dialog-question", 96);
            break;
        case GTK_MESSAGE_ERROR:
            pixbuf=rfm_get_pixbuf("xffm/emblem_cancel", 96);
            break;
        case GTK_MESSAGE_OTHER:
            pixbuf=rfm_get_pixbuf("xffm/emblem_bookmark", 96);
            break;
        case -1:
            pixbuf = rfm_get_pixbuf("xffm/stock_directory/compositeNW/emblem_star", 250);
    }
    if (pixbuf) {
        GtkWidget *image=gtk_image_new_from_pixbuf(pixbuf);
        gtk_widget_show(image);
        g_object_unref(pixbuf);
	gtk_box_pack_start(GTK_BOX(box),image, FALSE, FALSE,0);
    }
    GtkWidget *label = gtk_label_new("");
    gtk_label_set_markup(GTK_LABEL(label), q);
    gtk_widget_show(label);
    gtk_box_pack_start(GTK_BOX(box),label, FALSE, FALSE,0);

    if(widgets_p && widgets_p->view_p) {
	view_t *view_p=widgets_p->view_p;
        if(view_p->flags.type == DESKVIEW_TYPE) {
	    gtk_window_set_keep_above (GTK_WINDOW(dialog), TRUE);
	    gtk_window_stick (GTK_WINDOW(dialog));
	} else {   
            gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
            if(rfm_global_p) gtk_window_set_transient_for (GTK_WINDOW (dialog), GTK_WINDOW (rfm_global_p->window));
        } 
    } else {
	gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
    }

    if(action_false) {
        button = rfm_dialog_button ("xffm/stock_no", action_false);
        gtk_widget_show (button);
        gtk_dialog_add_action_widget (GTK_DIALOG (dialog), button, GTK_RESPONSE_NO);
        g_object_set_data (G_OBJECT (dialog), "action_false_button", button);
    }
    button = rfm_dialog_button ("xffm/stock_yes", (action_true) ? action_true : _("Ok"));
    gtk_widget_show (button);
    g_object_set_data (G_OBJECT (dialog), "action_true_button", button);
    gtk_dialog_add_action_widget (GTK_DIALOG (dialog), button, GTK_RESPONSE_YES);


    gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_CENTER);
    gtk_widget_show (dialog);
    return dialog;
}

static void *
confirm_f (void *data) {
    void **arg = data;
    if (!arg) g_error("malloc: %s\n", strerror(errno));
    widgets_t * widgets_p = arg[0];
    gint type = GPOINTER_TO_INT(arg[1]);
    const gchar *text = arg[2];
    const gchar *action_false = arg[3];
    const gchar *action_true = arg[4];
    gint response = GTK_RESPONSE_NONE;
    NOOP ("DIAGNOSTICS: confirm_f\n");
    GtkWidget *dialog = confirm_dialog (widgets_p, type, text, action_false, action_true);
    if(!dialog){
        return GINT_TO_POINTER(FALSE);
    }
    response = rfm_dialog_run_response(dialog);

    gtk_widget_hide (dialog);
    gtk_widget_destroy (dialog);

    if(response == GTK_RESPONSE_YES)
        return GINT_TO_POINTER(TRUE);
        
    return GINT_TO_POINTER(FALSE);
}

/////////////////////////////77  simplified response dialog...


static GtkWidget *
response_dialog (widgets_t * widgets_p, const gchar * ptext, const gchar *default_value, gboolean hidden) {

    GtkWidget *dialog = gtk_dialog_new ();
    gtk_window_set_type_hint(GTK_WINDOW(dialog), GDK_WINDOW_TYPE_HINT_DIALOG);

    gtk_window_set_resizable (GTK_WINDOW (dialog), FALSE);
    gtk_container_set_border_width (GTK_CONTAINER (dialog), 5);
    gtk_window_set_modal (GTK_WINDOW (dialog), TRUE);
    gtk_window_set_title(GTK_WINDOW (dialog), _("User Input"));
    gtk_window_set_keep_above(GTK_WINDOW (dialog), TRUE);

    gtk_widget_realize (dialog);

    GtkWidget *hbox = rfm_hbox_new (FALSE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
    gtk_box_pack_start (
	    GTK_BOX (gtk_dialog_get_content_area(GTK_DIALOG(dialog))),
	    hbox, TRUE, TRUE, 0);
    gtk_widget_show (hbox);

    GtkWidget *label = gtk_label_new("");
    if(ptext){
	gtk_label_set_markup  (GTK_LABEL(label), ptext);
    } else {
	gtk_label_set_markup  (GTK_LABEL(label), _("response:"));
    }

    gtk_box_pack_start (GTK_BOX (hbox), label, EXPAND, FILL, 0);
    gtk_widget_show (label);

    GtkWidget *bhbox=rfm_hbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (gtk_dialog_get_content_area(GTK_DIALOG(dialog))), 
	    bhbox, TRUE, TRUE, 0);
    gtk_widget_show (bhbox);

    GtkWidget *vbox=rfm_vbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (bhbox), vbox, TRUE, TRUE, 0);
    // put image here
    GdkPixbuf *pixbuf=rfm_get_pixbuf("xffm/stock_dialog-authentication",BIG_ICON_SIZE);
    GtkWidget *image=gtk_image_new_from_pixbuf(pixbuf);
    g_object_unref(pixbuf);
    gtk_box_pack_start (GTK_BOX (vbox), image, TRUE, TRUE, 0);

    gtk_widget_show (image);
    gtk_widget_show (vbox);
    vbox=rfm_vbox_new (FALSE, 0);
    gtk_box_pack_start (GTK_BOX (bhbox), vbox, TRUE, TRUE, 0);
    gtk_widget_show (vbox);

    hbox = rfm_hbox_new (FALSE, 0);
    gtk_container_set_border_width (GTK_CONTAINER (hbox), 5);
    gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
    gtk_widget_show (hbox);


    GtkWidget *response_text = gtk_entry_new ();
    g_object_set_data(G_OBJECT(response_text), "dialog", dialog);
    gtk_box_pack_start (GTK_BOX (hbox), response_text, EXPAND, NOFILL, 0);
    gtk_entry_set_visibility ((GtkEntry *) response_text, (hidden)?FALSE:TRUE);
    g_signal_connect (G_OBJECT (response_text), "activate", G_CALLBACK (entry_activate), NULL);
    gtk_widget_show (response_text);
    g_object_set_data(G_OBJECT(dialog), "response_text", response_text);
    if (default_value) gtk_entry_set_text(GTK_ENTRY(response_text), default_value);

    GtkWidget *button = rfm_dialog_button ("xffm/stock_ok", _("Ok"));
    gtk_widget_show (button);
    gtk_dialog_add_action_widget (GTK_DIALOG (dialog), button, GTK_RESPONSE_YES);

    
    button = rfm_dialog_button ("xffm/stock_cancel", _("Cancel"));
    gtk_widget_show (button);
    gtk_dialog_add_action_widget (GTK_DIALOG (dialog), button, GTK_RESPONSE_NO);

    if(widgets_p){
	// This borks things bigtime.
        // rfm_global_t *rfm_global_p = rfm_global();
       //gtk_window_set_transient_for (GTK_WINDOW (dialog), GTK_WINDOW (rfm_global_p->window));
    }
    gtk_window_set_position(GTK_WINDOW(dialog), GTK_WIN_POS_CENTER);
    gtk_widget_show (dialog);

    return dialog;
}



static void *
get_response_f (void *data) {
    void **arg = data;
    widgets_t * widgets_p = arg[0];
    const gchar * ptext=arg[1];
    const gchar *default_text = arg[2];
    gboolean hidden = GPOINTER_TO_INT(arg[3]);

    GtkWidget *dialog = response_dialog (widgets_p, ptext, default_text, hidden);
    gint response = GTK_RESPONSE_NONE;
    response = rfm_dialog_run_response(dialog);
    gtk_widget_hide (dialog);

    gchar *response_text = NULL;

    if(response == GTK_RESPONSE_YES){
	GtkWidget *entry = g_object_get_data(G_OBJECT(dialog), "response_text");
	const gchar *c = gtk_entry_get_text(GTK_ENTRY(entry));
	if (c) response_text = g_strdup(c);
	gtk_entry_set_text(GTK_ENTRY(entry), "XXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
    } 
    gtk_widget_destroy (dialog);
    return response_text;
}

