#ifndef RODENT_POPUP_THREADS_H
# define RODENT_POPUP_THREADS_H

# define MENU_PIXMAP 	0
# define BIGGER_MENU_PIXMAP 	10
# define BUTTON_PIXMAP	1
# define BIGGER_BUTTON_PIXMAP	11
void
rodent_popup_control(void);

void
rodent_create_popup_bythread(void);

GtkWidget *
rodent_thread_mk_pixmap_menu (const gchar * icon_id, GtkWidget * parent, int caso);

GtkWidget *
rodent_thread_add_submenu (GtkWidget * parent, const gchar * label, const gchar * name, const gchar * iconfile);

GtkWidget *
rodent_thread_add_menu_separator (GtkWidget * parent, gchar *text);

void
rodent_thread_multimenu_make(GtkAccelGroup * accel_group, RodentMenuDefinition *in_p);

#ifdef RODENT_POPUP_THREADS_C


#define FILE_MENU_STUFF \
	{MENUITEM_TYPE,"file_menu_menu","newfile_menuitem", NEW_FILE_CALLBACK},\
	{MENUITEM_TYPE,"file_menu_menu","newdirectory_menuitem", NEWDIR_CALLBACK},\
	{MENUITEM_TYPE,"file_menu_menu","differences2", DIFFERENCES_CALLBACK},\
	{MENUITEM_TYPE,"file_menu_menu","bcrypt_menuitem", BCRYPT_CALLBACK},\
	{MENUITEM_TYPE,"file_menu_menu","rename_menuitem", RENAME_CALLBACK},\
	{MENUITEM_TYPE,"file_menu_menu","duplicate_menuitem", DUPLICATE_CALLBACK},\
	{MENUITEM_TYPE,"file_menu_menu","symlink_menuitem", SYMLINK_CALLBACK},\
	{MENUITEM_TYPE,"file_menu_menu","touch_menuitem", TOUCH_CALLBACK},\
	{MENUITEM_TYPE,"file_menu_menu","ls_menuitem", LS_CALLBACK},\
	{MENUITEM_TYPE,"file_menu_menu","properties_menuitem", PROPERTIES_CALLBACK},\
	{NULL_TYPE} 


#define GO_STUFF \
	{MENUITEM_TYPE,"goto_menu_menu","goup_menuitem", GO_UP_CALLBACK},\
	{MENUITEM_TYPE,"goto_menu_menu","go_back_menuitem", GO_BACK_CALLBACK},\
	{MENUITEM_TYPE,"goto_menu_menu","go_forward_menuitem", GO_FORWARD_CALLBACK},\
	{MENUITEM_TYPE,"goto_menu_menu","refresh3", RELOAD_CALLBACK}

#define GOTO_MENU_STUFF \
	{MENUITEM_TYPE,"goto_menu_menu","goto2", JUMP_TO_CALLBACK},\
	GO_STUFF, \
	{NULL_TYPE} 

#define GOTO_MENU_STUFF2 \
    {SEPARATOR_TYPE,"goto_menu_menu","navigation_separator",{-1, NULL,NULL,}}, \
	{MENUITEM_TYPE,"goto_menu_menu","host2", GOTO_HOST_CALLBACK},\
	{MENUITEM_TYPE,"goto_menu_menu","home2", GOTO_HOME_CALLBACK},\
	{NULL_TYPE} 


#define SELECT_MENU_STUFF \
	{MENUITEM_TYPE,"select_menu_menu","select_all_menuitem", SELECT_ALL_CALLBACK},\
	{MENUITEM_TYPE,"select_menu_menu","select_invert_menuitem", SELECT_INVERT_CALLBACK},\
	{MENUITEM_TYPE,"select_menu_menu","select_byfilter_menuitem", SELECT_BYFILTER_CALLBACK},\
	{MENUITEM_TYPE,"select_menu_menu","unselect_byfilter_menuitem", UNSELECT_BYFILTER_CALLBACK},\
	{MENUITEM_TYPE,"select_menu_menu","unselect_all_menuitem", UNSELECT_ALL_CALLBACK},\
	{NULL_TYPE} 

#define SORT_MENU_STUFF \
	{CHECKITEM_TYPE,"sort_menu_menu","casesort_menuitem", CASE_SORT_CALLBACK},\
        {MENUITEM_TYPE,"sort_menu_menu","ascending1", SORT_ASCENDING_CALLBACK},\
	{MENUITEM_TYPE,"sort_menu_menu","descending1", SORT_DESCENDING_CALLBACK},\
    {SEPARATOR_TYPE,"sort_menu_menu","sort_separator",{-1, N_("Sort options"),NULL,}}, \
	{RADIOITEM_TYPE,"sort_menu_menu","unsorted6", TYPE_SORT_CALLBACK},\
	{RADIOITEM_TYPE,"sort_menu_menu","namesort", NAME_SORT_CALLBACK},\
	{RADIOITEM_TYPE,"sort_menu_menu","size6", SIZE_SORT_CALLBACK},\
	{RADIOITEM_TYPE,"sort_menu_menu","date6", DATE_SORT_CALLBACK},\
	{RADIOITEM_TYPE,"sort_menu_menu","owner6", OWNER_SORT_CALLBACK},\
	{RADIOITEM_TYPE,"sort_menu_menu","group6", GROUP_SORT_CALLBACK},\
	{RADIOITEM_TYPE,"sort_menu_menu","mode6", MODE_SORT_CALLBACK},\
	{NULL_TYPE} 
#if 0
#endif

#define VIEW_MENU_STUFF \
	{MENUITEM_TYPE,"view_menu_menu","newtab", NEW_TAB_CALLBACK},\
	{MENUITEM_TYPE,"view_menu_menu","newwindow", NEW_WINDOW_CALLBACK},\
	{CHECKITEM_TYPE,"view_menu_menu","show_hidden_menuitem", SHOW_HIDDEN_CALLBACK},\
	{CHECKITEM_TYPE,"view_menu_menu","show_backup_menuitem", SHOW_BACKUP_CALLBACK},\
	{CHECKITEM_TYPE,"view_menu_menu","preview_images_menuitem", PREVIEW_IMAGES_CALLBACK},\
    {SEPARATOR_TYPE,"view_menu_menu","iconsize_separator2", NULL_CALLBACK}, \
    {SEPARATOR_TYPE,"view_menu_menu","iconsize_separator",{-1, N_("Icon size:"),}}, \
	{RADIOITEM_TYPE,"view_menu_menu","compact_iconsize", COMPACT_ICONSIZE_CALLBACK},\
	{RADIOITEM_TYPE,"view_menu_menu","tiny_iconsize", TINY_ICONSIZE_CALLBACK},\
	{RADIOITEM_TYPE,"view_menu_menu","normal_iconsize", NORMAL_ICONSIZE_CALLBACK},\
	{RADIOITEM_TYPE,"view_menu_menu","big_iconsize", BIG_ICONSIZE_CALLBACK},\
	{RADIOITEM_TYPE,"view_menu_menu","huge_iconsize", HUGE_ICONSIZE_CALLBACK},\
    {SEPARATOR_TYPE,"view_menu_menu","iconsize_separator3",NULL_CALLBACK}, \
	{MENUITEM_TYPE,"view_menu_menu","default_iconsize", DEFAULT_ICONSIZE_CALLBACK},\
	{MENUITEM_TYPE,"view_menu_menu","default_iconsize_all", DEFAULT_ICONSIZE_ALL_CALLBACK},\
	{NULL_TYPE} 

#define HELP_MENU_STUFF \
	  {MENUITEM_TYPE,"help_menu_menu","keybindings_menuitem", KEYBINDINGS_CALLBACK},\
	  {MENUITEM_TYPE,"help_menu_menu","about2", ABOUT_CALLBACK},\
	  {MENUITEM_TYPE,"help_menu_menu","help_pdf", HELP_CALLBACK},\
	{NULL_TYPE} 



#define EDIT_STUFF \
	{MENUITEM_TYPE,"main_popup_menu","cut_menuitem", CUT_CALLBACK},\
	{MENUITEM_TYPE,"main_popup_menu","copy_menuitem", COPY_CALLBACK},\
	{MENUITEM_TYPE,"main_popup_menu","paste_menuitem", PASTE_CALLBACK},\
	{MENUITEM_TYPE,"main_popup_menu","remove_menuitem", REMOVE_CALLBACK},\
	{SEPARATOR_TYPE,"main_popup_menu","edit_separator",{-1, NULL,NULL,}}, 

#define AUTOTYPE_STUFF \
	{MENUITEM_TYPE,"main_popup_menu",auto_C_name[0], AUTOTYPE_CALLBACK},\
	{MENUITEM_TYPE,"main_popup_menu",auto_C_name[1], AUTOTYPE_CALLBACK},\
	{MENUITEM_TYPE,"main_popup_menu",auto_C_name[2], AUTOTYPE_CALLBACK},\
	{MENUITEM_TYPE,"main_popup_menu",auto_C_name[3], AUTOTYPE_CALLBACK},\
	{MENUITEM_TYPE,"main_popup_menu",auto_C_name[4], AUTOTYPE_CALLBACK},\
	{MENUITEM_TYPE,"main_popup_menu",auto_C_name[5], AUTOTYPE_CALLBACK},\
	{MENUITEM_TYPE,"main_popup_menu",auto_C_name[6], AUTOTYPE_CALLBACK},\
	{MENUITEM_TYPE,"main_popup_menu",auto_C_name[7], AUTOTYPE_CALLBACK},\
	{MENUITEM_TYPE,"main_popup_menu",auto_C_name[8], AUTOTYPE_CALLBACK},\
	{MENUITEM_TYPE,"main_popup_menu",auto_C_name[9], AUTOTYPE_CALLBACK},\
\
	{MENUITEM_TYPE,"main_popup_menu","autotype_Prun", AUTOTYPE_R_CALLBACK},

#define ACTION_STUFF \
	{MENUITEM_TYPE,"main_popup_menu", "open_with_menuitem", OPEN_WITH_CALLBACK},\
	{SEPARATOR_TYPE,"main_popup_menu","open_with_separator", NULL_CALLBACK },

#define EXEC_STUFF \
	{MENUITEM_TYPE,"main_popup_menu","terminal2", TERMINAL_CALLBACK},\
	{MENUITEM_TYPE,"main_popup_menu","run2", RUN_CALLBACK},\
	{MENUITEM_TYPE,"main_popup_menu","find2", SEARCH_CALLBACK},\
	{MENUITEM_TYPE,"main_popup_menu","addbookmark_menuitem", ADD_BOOKMARK_CALLBACK},\
	{MENUITEM_TYPE,"main_popup_menu","removebookmark_menuitem", REMOVE_BOOKMARK_CALLBACK},\
	{MENUITEM_TYPE,"main_popup_menu","mountP", MOUNT_CALLBACK},\
	{MENUITEM_TYPE,"main_popup_menu","unmountP", UNMOUNT_CALLBACK},\
	{MENUITEM_TYPE,"main_popup_menu","mount_broken", {-1, N_("There was a network error."),"xffm/emblem_unreadable",}},


//	{SUBMENU_TYPE,"main_popup_menu","module1","Module1",NULL,}, 

#define MAIN_MENU_SUBMENUS \
	{SUBMENU_TYPE,"main_popup_menu","goto_menu",{-1, N_("Go"),"xffm/emblem_computer/compositeSW/emblem_menu"}}, \
	{SEPARATOR_TYPE,"main_popup_menu","exec_separator", NULL_CALLBACK}, \
	AUTOTYPE_STUFF \
	ACTION_STUFF \
	EXEC_STUFF \
	{SEPARATOR_TYPE,"main_popup_menu","file_separator", NULL_CALLBACK}, \
	{SUBMENU_TYPE,"main_popup_menu","file_menu",{-1, N_("File"),"xffm/emblem_documents/compositeSW/emblem_menu",}}, \
	{SUBMENU_TYPE,"main_popup_menu","applications_menu",{-1, N_("Applications"),"xffm/stock_execute/compositeSW/emblem_menu", }}, \
	{SUBMENU_TYPE,"main_popup_menu","sort_menu",{-1, N_("Sort"),}}, \
	{SUBMENU_TYPE,"main_popup_menu","view_menu",{-1, N_("View"),"xffm/stock_zoom-in/compositeSW/emblem_menu",}}, \
	{SUBMENU_TYPE,"main_popup_menu","select_menu",{-1, N_("Select"),"xffm/stock_select-all/compositeSW/emblem_menu",}}, \
	{SUBMENU_TYPE,"main_popup_menu","help_menu",{-1, N_("Help"),"xffm/stock_help/compositeSW/emblem_menu",}}, \
	EDIT_STUFF \
	{MENUITEM_TYPE,"main_popup_menu","settings2", SETTINGS_CALLBACK},\
	{MENUITEM_TYPE,"main_popup_menu","exit2", CLOSE_CALLBACK},\
	{SEPARATOR_TYPE,"main_popup_menu","main_menu_separator", NULL_CALLBACK}, \
	{NULL_TYPE} 

#endif
#endif
