#ifndef RODENT_H
#define RODENT_H
#include <rfm.h>
/**
 * RodentCallback:
 * @function_id:
 * @string:
 * @icon:
 * @function:
 * @data:
 * @key:
 * @mask:
 * @type:
 *
 */
typedef struct RodentCallback {
    gint function_id;
    const gchar *string;
    const gchar *icon;
    gpointer function;
    gpointer data;
    guint key; 
    guint mask; 
    gint type;
}RodentCallback;

/** 
 * RodentMenuType:
 * @NULL_TYPE: inactive item with text (may be empty text "")
 * @SUBMENU_TYPE: submenu item
 * @MENUITEM_TYPE: common menu action (single click)
 * @CHECKITEM_TYPE: toggle menu item
 * @RADIOITEM_TYPE: radio-button menu item 
 * @SEPARATOR_TYPE: inactive separator item
 *
 * This type indicates the type of menu item which will
 * be created.
 */
typedef enum {
    NULL_TYPE,
    SUBMENU_TYPE,
    MENUITEM_TYPE,
    CHECKITEM_TYPE,
    RADIOITEM_TYPE,
    SEPARATOR_TYPE
}RodentMenuType;

/** 
 * RodentMenuDefinition:
 * @type: a #RodentMenuType
 * @parent_id: Object's parent name.
 * @id: Object's name.
 * @callback: pointer to #RodentCallback.
 */
typedef struct RodentMenuDefinition{
    gint type;
    const gchar *parent_id;
    const gchar *id;
    RodentCallback callback;
} RodentMenuDefinition;

/**
 * RodentButtonDefinition:
 * @id: Object identifier (used for user cconfiguration).
 * @button_name: Object identifier string.
 * @text: text to appear in button
 * @callback: #RodentCallback.
 *
 */
typedef struct RodentButtonDefinition {
    gint id;
    const gchar *button_name;
    RodentCallback callback;
    const gchar *text;
} RodentButtonDefinition;

# include "rodent_actions.h"
# include "xfdir.h"
# include "rodent_threadqueue.h"
# include "rodent_popup_callbacks.h"
# include "rodent_bookmarks.h"
# include "rodent_expose.h"
# include "rodent_gridview.h"
# include "rodent_tip.h"
# include "rodent_mouse.h"
# include "rodent_population.h"
# include "rodent_popup.h"
# include "rodent_popup_threads.h"

#endif
