#ifndef RFM_RUN_H
# define RFM_RUN_H


const gchar **rfm_get_terminals(void);
const gchar **rfm_get_editors(void);
void rfm_remove_child(pid_t child);
void rfm_killall_children(void);
void rfm_add_child(pid_t child);

gchar * 
rfm_get_text_editor_envar(const gchar *value);

/* The following two programs are the same thing, the only difference is that the
 * command line version will first create the argument array from the command
 * line and will run in a shell (allowing for redireccion, pipes and what not)
 * and the shell command will be saved in the lpterm history file.
 * */
/* run programs with command line: */
// pid_t rfm_thread_run (widgets_t * widgets_p, const gchar * command, gboolean interm);
#define RFM_THREAD_RUN(X,Y,Z) \
    rfm_complex(RFM_MODULE_DIR, "run", X, Y, GINT_TO_POINTER(Z), "rfm_thread_run")


// Use rfm_thread_run2argv or rfm_thread_run?
// rfm_thread_run_argv will execute directly, not via a shell, and will
// not be saved in the lpterm history
//pid_t rfm_thread_run2argv (widgets_t * widgets_p, const gchar * command, gboolean interm);
#define RFM_THREAD_RUN2ARGV(X,Y,Z) \
    rfm_complex(RFM_MODULE_DIR, "run", X, Y, GINT_TO_POINTER(Z), "rfm_thread_run2argv")


//pid_t rfm_try_sudo (widgets_t * widgets_p, gchar ** argv, gboolean interm);
#define RFM_TRY_SUDO(X,Y,Z) \
    rfm_complex(RFM_MODULE_DIR, "run", X, Y, GINT_TO_POINTER(Z), "rfm_try_sudo")



// rfm_thread_run_argv will execute directly, not via a shell, and will
// not be saved in the lpterm history
// 
// run programs with argv array: 
pid_t rfm_thread_run_argv (widgets_t * widgets_p, gchar ** argv, gboolean interm);

pid_t
  rfm_thread_run_argv_full (
	  widgets_t * widgets_p, 
	  gchar ** argv, 
	  gboolean interm, 
	  gint *stdin_fd,
	  void (*stdout_f) (void *stdout_data, 
			    void *stream, 
			    int childFD),
	  void (*stderr_f) (void *stdout_data, 
			    void *stream, 
			    int childFD),
	  void (*tubo_done_f) (void *data)
	  );


gpointer 
rfm_load_sh_command_history (gpointer data);

void
rfm_save_sh_command_history (view_t * view_p, const gchar * command);

void
rfm_recover_flags (gchar * in_cmd, gboolean * interm, gboolean * hold);

const gchar *
rfm_what_term (void);

const gchar * 
rfm_term_exec_option(const gchar *terminal);

//////////////////   module wraparounds ////////////////////////////


/* run programs with argv array and specify stdout_function: */
/* rfm_thread_run_argv_with_stdin */
pid_t
  rfm_thread_run_argv_with_stdin (
	  widgets_t * widgets_p, 
	  gchar ** argv, 
	  gboolean interm, 
	  gint *stdin_fd
	  );

/* rfm_thread_run_argv_with_stdout */
pid_t
  rfm_thread_run_argv_with_stdout (
	  widgets_t * widgets_p, 
	  gchar ** argv, 
	  gboolean interm, 
	  void (*stdout_f) (void *stdout_data, 
			    void *stream, 
			    int childFD)
	  );

pid_t
  rfm_thread_run_argv_with_stderr (
	  widgets_t * widgets_p, 
	  gchar ** argv, 
	  gboolean interm, 
	  void (*stdout_f) (void *stdout_data, 
			    void *stream, 
			    int childFD)
	  );

////////////////////////////////////////////////////////////
#endif
