VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Begin VB.Form fPlcConn 
   Caption         =   "PLC Connection Configuration"
   ClientHeight    =   3945
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   6930
   BeginProperty Font 
      Name            =   "MS Sans Serif"
      Size            =   9.75
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   Icon            =   "fPlcEther.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   3945
   ScaleWidth      =   6930
   StartUpPosition =   3  'Windows Default
   Begin VB.Frame Frame1 
      Caption         =   "Ethernet Configuration"
      Height          =   2640
      Left            =   225
      TabIndex        =   4
      Top             =   225
      Width           =   6465
      Begin VB.TextBox tbPort 
         Height          =   360
         Left            =   1200
         TabIndex        =   8
         Text            =   "102"
         Top             =   375
         Width           =   855
      End
      Begin VB.TextBox tbIPAddr 
         Height          =   360
         Left            =   1200
         TabIndex        =   7
         Text            =   "192.168.250.134"
         Top             =   855
         Width           =   1575
      End
      Begin VB.TextBox tbRack 
         Height          =   360
         Left            =   1200
         TabIndex        =   6
         Text            =   "tbRack"
         Top             =   1425
         Width           =   900
      End
      Begin VB.TextBox tbSlot 
         Height          =   360
         Left            =   1200
         TabIndex        =   5
         Text            =   "tbSlot"
         Top             =   1950
         Width           =   900
      End
      Begin VB.Label Label1 
         AutoSize        =   -1  'True
         Caption         =   "Port:"
         Height          =   240
         Index           =   0
         Left            =   675
         TabIndex        =   14
         Top             =   450
         Width           =   405
      End
      Begin VB.Label Label2 
         Alignment       =   1  'Right Justify
         Caption         =   "IP Address:"
         Height          =   240
         Index           =   0
         Left            =   75
         TabIndex        =   13
         Top             =   900
         Width           =   1080
      End
      Begin VB.Label Label3 
         Caption         =   "Port is the port number for the protocol, usually 102 for ISO over TCP or 1099 for the IBH/MHJ NetLink protocol."
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   390
         Index           =   0
         Left            =   2175
         TabIndex        =   12
         Top             =   375
         Width           =   4140
      End
      Begin VB.Label Label3 
         Caption         =   "IP Address is the address assigned to the PLC/CP."
         BeginProperty Font 
            Name            =   "MS Sans Serif"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         Height          =   390
         Index           =   1
         Left            =   2850
         TabIndex        =   11
         Top             =   900
         Width           =   3465
      End
      Begin VB.Label Label2 
         Alignment       =   1  'Right Justify
         Caption         =   "Rack:"
         Height          =   240
         Index           =   1
         Left            =   75
         TabIndex        =   10
         Top             =   1470
         Width           =   1050
      End
      Begin VB.Label Label2 
         Alignment       =   1  'Right Justify
         Caption         =   "Slot:"
         Height          =   240
         Index           =   2
         Left            =   75
         TabIndex        =   9
         Top             =   2025
         Width           =   1050
      End
   End
   Begin VB.CommandButton cmdTestRead 
      Caption         =   "&Test Rd"
      Height          =   390
      Left            =   3000
      TabIndex        =   3
      Top             =   3075
      Width           =   1215
   End
   Begin VB.CommandButton cmdCancel 
      Cancel          =   -1  'True
      Caption         =   "&Cancel"
      Height          =   390
      Left            =   5475
      TabIndex        =   2
      Top             =   3075
      Width           =   1215
   End
   Begin VB.CommandButton cmdOK 
      Caption         =   "&OK"
      Default         =   -1  'True
      Height          =   390
      Left            =   225
      TabIndex        =   1
      Top             =   3075
      Width           =   1215
   End
   Begin MSComctlLib.StatusBar sBar 
      Align           =   2  'Align Bottom
      Height          =   315
      Left            =   0
      TabIndex        =   0
      Top             =   3630
      Width           =   6930
      _ExtentX        =   12224
      _ExtentY        =   556
      Style           =   1
      SimpleText      =   "Status Bar"
      _Version        =   393216
      BeginProperty Panels {8E3867A5-8586-11D1-B16A-00C0F0283628} 
         NumPanels       =   1
         BeginProperty Panel1 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
         EndProperty
      EndProperty
   End
End
Attribute VB_Name = "fPlcConn"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' Uses libnodave version 0.8.2.  This module is set up to connect to an S7-300
'using an ethernet connection.

'USAGE:
    ' After loading this form, open your .ini file and either:
        'a) rc& = ReadIni(ff%) and check that return value = 0 (success) OR
        'b) Set the variables Port, Rack, and Slot.  Set IP Address by calling
        'PutIP().  Then call SetUI().
'After that rc& = fPlcConnect().  If rc& = 0 then connection made.  If
'connection not made successfully, check settings and cables.  This was
'tested with an S7-300.

' NOTE: This form does NOT save the settings.
'Do the saving externally using functions SaveIni%(ff%) and ReadIni%(ff%).

' To read from PLC:
    ' res = fPlcRead&( Area, AreaNum, Start, numBytes, Buffer )
    
' To write to PLC:
    ' res = fPlcWrite&( Area, AreaNum, Start, NumBytes, Buffer )

' Variables for ethernet connection - needed to make all functions the same
'between fPlcSerial and fPlcEther.
Dim IPAddr As String * 15
Public TCPPort%, Rack%, Slot%

' Variables for serial connection.
'Public ComPort%, Baud%, Parity%, MpiAddr%

Private Const INI_SECTION_ID = "[fPlcConn]"

Dim hPort As Long
Dim di As Long  ' Pointer to daveInterface structure.
Public dc As Long  ' Pointer to a daveConnection structure.
Dim ErrMsg$
'

Public Function fPlcErrMsg$(rc&)
    If rc& = -1 Then
        fPlcErrMsg$ = ErrMsg$
    Else
        fPlcErrMsg$ = daveStrError(rc&)
    End If
End Function

Public Function GetIP$()
    GetIP$ = IPAddr
End Function
Public Sub PutIP(NewIPAddr$)
    IPAddr$ = NewIPAddr$
End Sub

Public Function WriteIni%(FileNum%)

    Write #FileNum%, INI_SECTION_ID
    Write #FileNum%, TCPPort%
    Write #FileNum%, IPAddr$
    Write #FileNum%, Rack%
    Write #FileNum%, Slot%
    
    WriteIni% = 0
End Function

Public Function ReadIni%(FileNum%)
Dim buffer$

    While buffer$ <> INI_SECTION_ID And Not EOF(FileNum%)
        Input #FileNum%, buffer$
    Wend
    If buffer$ <> INI_SECTION_ID Then
        ReadIni% = -1
        Exit Function
    End If
    
    Input #FileNum%, TCPPort%
    Input #FileNum%, IPAddr$
    Input #FileNum%, Rack%
    Input #FileNum%, Slot%
    
    ReadIni% = 0
    SetUI
    
End Function

Private Sub cmdCancel_Click()
    Hide
End Sub

Private Sub cmdOK_Click()
Dim rc&

    GetUI
    rc = fPlcClose()
    If rc <> 0 Then
        MsgBox ("Error " & rc & " from fPlcClose().  Unable to close port, so will not attempt to re-open it.")
        Exit Sub
    End If
    rc = fPlcConnect()
    If rc = 0 Then
        Hide
    Else
        'Msgbox already displayed in fPlcConnect().
        'MsgBox ("Error " & rc & " from fPlcConnect().  Unable to connect " & _
        '    "to PLC.  Check cables and settings and try again.")
    End If

End Sub

Private Function GetUI()

    TCPPort% = Val(tbPort.Text)
    IPAddr$ = tbIPAddr.Text
    Rack% = Val(tbRack.Text)
    Slot% = Val(tbSlot.Text)

End Function

Private Function SetUI()
    tbPort.Text = TCPPort%
    tbIPAddr.Text = IPAddr$
    tbRack.Text = Rack%
    tbSlot.Text = Slot%
End Function

Public Function fPlcConnect() As Long
Dim MpiPpi&, rc&

    hPort = openSocket(TCPPort, IPAddr)    ' for ISO over TCP

    If (hPort > 0) Then
        di = daveNewInterface(hPort, hPort, "IF1", 0, daveProtoISOTCP, daveSpeed187k)
        '
        ' with ISO over TCP, set correct values for rack and slot of the CPU
        '
        Rack = CInt(tbRack.Text)
        Slot = CInt(tbSlot.Text)
        MpiPpi = 0  ' This is unused for ethernet.
        dc = daveNewConnection(di, MpiPpi, Rack, Slot)
        rc& = daveConnectPLC(dc)
        fPlcConnect = rc&
        If rc Then
            ErrMsg = "Error " & rc & ":" & daveStrError(rc) & " from daveConnectPLC.  " & _
                "Connection failed.  Check cables & try again."
        Else
            ErrMsg = "fPlcConnect succeeded."
        End If
    Else
        ErrMsg = "Unable to open " & IPAddr$ & " for PLC connection.  Close other programs using the port or select a different port."
        hPort = 0
        fPlcConnect = -1
    End If

End Function

'
' Disconnect from PLC, disconnect from Adapter, close the interface
'
Public Function fPlcClose() As Long
Dim res&

    fPlcClose = 0   ' Default to no error.
    If dc <> 0 Then
        res = daveDisconnectPLC(dc)
        If res Then
            fPlcClose = res
            MsgBox "Error " & res & ":" & daveStrError(res) & " from daveDisconnectPLC."
        End If
        Call daveFree(dc)
        dc = 0
    End If
    If di <> 0 Then
        res = daveDisconnectAdapter(di)
        If res Then
            fPlcClose = res
            MsgBox "Error " & res & ":" & daveStrError(res) & " from daveDisconnectAdapter."
        End If
        Call daveFree(di)
        di = 0
    End If
    If hPort <> 0 Then
        res = closePort(hPort)
        If res = 0 Then
            'closePort() is an oddball - it returns 0 to indicate error!
            fPlcClose = res
            MsgBox "Error " & res & ":" & daveStrError(res) & " from closePort."
        End If
        hPort = 0
    End If
    
End Function

'
'Read data from PLC.  After calling this function, call daveGet...() functions
    ' to get the data read into variables.
'Inputs: Area - Area in the plc to read.  Must be one of the constants defined
            'in libNoDave.bas.  Normally will be "daveDB" for data block.
        ' AreaNum - Data block or function block to read.
        ' Start - Starting BYTE to read.
        ' NumBytes - Number of BYTES to read.
        ' Buffer - Pointer to place to store data read.  For single thread
            'programs, this will normally be 0 (NULL).  Then the functions
            'daveGetS32(fPlcConn.dc), daveGetFloat(fPlcConn.dc)... can be
            'used to actually get the values received from the plc.
'Outputs: Result - 0 or error.
Public Function fPlcRead&(ByVal area As Long, ByVal AreaNum As Long, _
    ByVal Start As Long, ByVal numBytes As Long, ByVal buffer As Long)

    fPlcRead = daveReadBytes(dc, daveDB, AreaNum, Start, numBytes, buffer)
    ' If result = 0 Then
        ' v1 = daveGetS32(dc)
        ' v2 = daveGetFloat(dc)
        ' ... Finish getting all variables read from PLC.
    ' else
        ' Error handler.
    ' endif

End Function

'
' Write data to PLC
    ' Dim buffer(1024) As Byte, a as Long, result as Long
    ' a = davePut32(buffer(0), v1)
    ' a = davePutFloat(buffer(4), v2)
    ' ... Finish putting all variables to write to plc.
    ' result = daveWriteBytes(fPlcConn.dc, daveDB, AreaNum, Start, NumBytes, buffer(0))
'Inputs:
        ' Area - Area in the plc to read.  Must be one of the constants defined
            'in libNoDave.bas.  Normally will be "daveDB" for data block.
        ' AreaNum - Data block or function block to read.
        ' Start - Starting BYTE to read.
        ' NumBytes - Number of BYTES to read.
        ' Buffer - Pointer to data to write.  Must contain at least NumBytes.
'Outputs: Result - 0 or error.
Public Function fPlcWrite&(ByVal area As Long, ByVal AreaNum As Long, _
    ByVal Start As Long, ByVal numBytes As Long, ByRef buffer As Byte)

    fPlcWrite = daveWriteBytes(dc, area, AreaNum, Start, numBytes, buffer)
    
End Function

Private Sub cmdTestRead_Click()
Dim rc&
Dim rBuffer(PLC_rBYTES) As Byte
Dim PlcInfo As PLC_DATA

    ' Read bytes from DB in PLC.
    rc = fPlcRead&(daveDB, PLC_DB, PLC_START, PLC_rBYTES, 0)
    If rc = 0 Then
        rc = PlcBytesToPLC_DATA(dc, PlcInfo)
        sBar.SimpleText = "Read SUCCESS. PC:" & PlcInfo.PC_Count & _
            " PLC:" & PlcInfo.PLC_Count & _
            " Mdl:" & PlcInfo.Model
    Else
        sBar.SimpleText = "Read FAILED: " & rc
    End If

End Sub

Private Sub Form_Load()
Dim Buff(5) As Byte

    ' Set default values.
    tbPort.Text = "102"
    IPAddr = "192.168.101.1"
    tbRack.Text = "0"
    tbSlot.Text = "2"
    SetUI
    
    ' Output all debug messages.
    'daveSetDebug daveDebugAll
    sBar.SimpleText = "Form loaded."
    
End Sub

Private Sub Form_Unload(Cancel As Integer)

    fPlcClose
    
End Sub
