VERSION 5.00
Object = "{CDE57A40-8B86-11D0-B3C6-00A0C90AEA82}#1.0#0"; "MSDATGRD.OCX"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Begin VB.Form fMySql 
   Caption         =   "Database Searches"
   ClientHeight    =   8295
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   11625
   BeginProperty Font 
      Name            =   "MS Sans Serif"
      Size            =   9.75
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   Icon            =   "fMySql.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   8295
   ScaleWidth      =   11625
   StartUpPosition =   3  'Windows Default
   Begin VB.CheckBox cbRLot 
      Caption         =   "Search by REAR Lot Number"
      Height          =   315
      Left            =   225
      TabIndex        =   27
      Top             =   3750
      Width           =   4215
   End
   Begin VB.TextBox tbRLot 
      Height          =   360
      Left            =   2250
      TabIndex        =   26
      Text            =   "Rear Lot Number"
      Top             =   4125
      Width           =   2190
   End
   Begin MSComDlg.CommonDialog CommonDialog1 
      Left            =   7500
      Top             =   4050
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
      CancelError     =   -1  'True
   End
   Begin VB.CommandButton cmdSave 
      Caption         =   "&Save"
      Enabled         =   0   'False
      Height          =   390
      Left            =   4725
      TabIndex        =   25
      Top             =   4650
      Width           =   1290
   End
   Begin MSDataGridLib.DataGrid DataGrid1 
      Height          =   2790
      Left            =   225
      TabIndex        =   24
      TabStop         =   0   'False
      Top             =   5325
      Width           =   11265
      _ExtentX        =   19870
      _ExtentY        =   4921
      _Version        =   393216
      AllowUpdate     =   0   'False
      HeadLines       =   1
      RowHeight       =   15
      RowDividerStyle =   1
      BeginProperty HeadFont {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "MS Sans Serif"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ColumnCount     =   2
      BeginProperty Column00 
         DataField       =   ""
         Caption         =   ""
         BeginProperty DataFormat {6D835690-900B-11D0-9484-00A0C91110ED} 
            Type            =   0
            Format          =   ""
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1033
            SubFormatType   =   0
         EndProperty
      EndProperty
      BeginProperty Column01 
         DataField       =   ""
         Caption         =   ""
         BeginProperty DataFormat {6D835690-900B-11D0-9484-00A0C91110ED} 
            Type            =   0
            Format          =   ""
            HaveTrueFalseNull=   0
            FirstDayOfWeek  =   0
            FirstWeekOfYear =   0
            LCID            =   1033
            SubFormatType   =   0
         EndProperty
      EndProperty
      SplitCount      =   1
      BeginProperty Split0 
         BeginProperty Column00 
         EndProperty
         BeginProperty Column01 
         EndProperty
      EndProperty
   End
   Begin VB.CommandButton cmdTestAdd 
      Caption         =   "&Test Add"
      Height          =   390
      Left            =   6075
      TabIndex        =   22
      Top             =   3825
      Visible         =   0   'False
      Width           =   990
   End
   Begin VB.CommandButton cmdClose 
      Cancel          =   -1  'True
      Caption         =   "&Close"
      Height          =   390
      Left            =   8700
      TabIndex        =   19
      Top             =   4650
      Width           =   1290
   End
   Begin VB.CommandButton cmdSearch 
      Caption         =   "&Do Search"
      Height          =   390
      Left            =   225
      TabIndex        =   18
      Top             =   4650
      Width           =   1290
   End
   Begin VB.TextBox tbFLot 
      Height          =   360
      Left            =   2250
      TabIndex        =   14
      Text            =   "Front Lot Number"
      Top             =   3150
      Width           =   2190
   End
   Begin VB.TextBox tbModel 
      Height          =   360
      Left            =   2250
      TabIndex        =   13
      Text            =   "Model Number"
      Top             =   2175
      Width           =   2190
   End
   Begin VB.CheckBox cbFLot 
      Caption         =   "Search by FRONT Lot Number"
      Height          =   315
      Left            =   225
      TabIndex        =   10
      Top             =   2775
      Width           =   4215
   End
   Begin VB.CheckBox cbModel 
      Caption         =   "Search by Model Number"
      Height          =   315
      Left            =   225
      TabIndex        =   9
      Top             =   1725
      Width           =   3015
   End
   Begin VB.CheckBox cbDate 
      Caption         =   "Search by Date and Time"
      Height          =   315
      Left            =   225
      TabIndex        =   8
      Top             =   150
      Width           =   3015
   End
   Begin VB.TextBox tbTime 
      Height          =   285
      Index           =   1
      Left            =   3450
      MaxLength       =   8
      TabIndex        =   7
      Text            =   "23:59:59"
      Top             =   1200
      Width           =   915
   End
   Begin VB.TextBox tbDate 
      Height          =   285
      Index           =   1
      Left            =   2250
      MaxLength       =   10
      TabIndex        =   6
      Text            =   "12/31/9999"
      Top             =   1200
      Width           =   1065
   End
   Begin VB.TextBox tbTime 
      Height          =   285
      Index           =   0
      Left            =   3450
      MaxLength       =   8
      TabIndex        =   3
      Text            =   "23:59:59"
      Top             =   825
      Width           =   915
   End
   Begin VB.TextBox tbDate 
      Height          =   285
      Index           =   0
      Left            =   2250
      MaxLength       =   10
      TabIndex        =   2
      Text            =   "12/31/9999"
      Top             =   825
      Width           =   1065
   End
   Begin VB.Label Label1 
      Alignment       =   1  'Right Justify
      Caption         =   "Rear Lot Number:"
      Height          =   240
      Index           =   4
      Left            =   525
      TabIndex        =   28
      Top             =   4125
      Width           =   1635
   End
   Begin VB.Label Label3 
      Caption         =   "Use _ as a wildcard for any 1 character or use % as a wildcard for any number of characters."
      Height          =   765
      Index           =   3
      Left            =   4725
      TabIndex        =   23
      Top             =   2625
      Width           =   5265
      WordWrap        =   -1  'True
   End
   Begin VB.Label lblResults 
      AutoSize        =   -1  'True
      Caption         =   "99999"
      Height          =   240
      Left            =   3225
      TabIndex        =   21
      Top             =   4725
      Width           =   525
   End
   Begin VB.Label Label4 
      Caption         =   "Results Found:"
      Height          =   240
      Left            =   1650
      TabIndex        =   20
      Top             =   4725
      Width           =   1440
   End
   Begin VB.Label Label3 
      Caption         =   $"fMySql.frx":038A
      Height          =   990
      Index           =   2
      Left            =   4725
      TabIndex        =   17
      Top             =   1575
      Width           =   5265
      WordWrap        =   -1  'True
   End
   Begin VB.Label Label3 
      Caption         =   "e.g. checking only ""date and time"" will show all parts produced in a given date/time range."
      Height          =   765
      Index           =   1
      Left            =   4725
      TabIndex        =   16
      Top             =   750
      Width           =   5265
      WordWrap        =   -1  'True
   End
   Begin VB.Label Label3 
      Caption         =   "Checking more boxes will limit the search further."
      Height          =   465
      Index           =   0
      Left            =   4725
      TabIndex        =   15
      Top             =   225
      Width           =   5265
      WordWrap        =   -1  'True
   End
   Begin VB.Label Label1 
      Alignment       =   1  'Right Justify
      Caption         =   "Front Lot Number:"
      Height          =   240
      Index           =   3
      Left            =   525
      TabIndex        =   12
      Top             =   3150
      Width           =   1635
   End
   Begin VB.Label Label1 
      Alignment       =   1  'Right Justify
      Caption         =   "Model Number:"
      Height          =   240
      Index           =   2
      Left            =   525
      TabIndex        =   11
      Top             =   2175
      Width           =   1410
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "Time"
      Height          =   240
      Index           =   1
      Left            =   3675
      TabIndex        =   5
      Top             =   450
      Width           =   465
   End
   Begin VB.Label Label2 
      AutoSize        =   -1  'True
      Caption         =   "Date"
      Height          =   240
      Index           =   0
      Left            =   2550
      TabIndex        =   4
      Top             =   450
      Width           =   435
   End
   Begin VB.Label Label1 
      Alignment       =   1  'Right Justify
      Caption         =   "End Date/Time"
      Height          =   240
      Index           =   1
      Left            =   555
      TabIndex        =   1
      Top             =   1200
      Width           =   1410
   End
   Begin VB.Label Label1 
      Alignment       =   1  'Right Justify
      Caption         =   "Start Date/Time"
      Height          =   240
      Index           =   0
      Left            =   555
      TabIndex        =   0
      Top             =   825
      Width           =   1410
   End
End
Attribute VB_Name = "fMySql"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' Installing MySQL:
'0. Install MySQL as normal.  This program was used with 4.1.12.
'1. Install MySQL ODBC.  Version 3.51 was used.

'Configuring MySQL:
'0. After installing MySQL, open MySQL Command Line Client by:
    'Click: Start, All Programs, MySQL, MySQL Server 4.1, MySQL Command Line Client.
'1.  Create database StuffLot.  Dont need to create any tables in it.
    'Type: Create database StuffLot;
'2.  Create user Stuffer with no password.
    'Type: connect mysql;
    'Type: Grant create, index, update, insert, lock tables, select on StuffLot.* to Stuffer;
'3. Type "Exit" to close MySQL command line client.

Dim conn As ADODB.Connection
Dim rs1 As ADODB.Recordset
'
Dim db_name$, db_server$, db_port$
Dim db_user$, db_pass$
'


Private Sub cmdClose_Click()
    Hide
End Sub

Private Sub cmdSave_Click()
Dim ff%, i&, f%

    On Local Error GoTo SErr
    CommonDialog1.ShowSave
    'Call rs1.Save(CommonDialog1.FileName, adPersistXML)
    On Local Error GoTo SOpenErr
    ff% = FreeFile
    Open CommonDialog1.FileName For Output As #ff%
    On Local Error GoTo SWriteErr
    rs1.MoveFirst
    For i& = 1 To rs1.RecordCount
        Print #ff%, rs1.Fields.item(0);
        For f% = 1 To rs1.Fields.Count - 1
            Print #ff%, ","; rs1.Fields.item(f);
        Next f%
        Print #ff%,
        rs1.MoveNext
    Next i&

SClose:
    Close #ff%
    
SEnd:
    Exit Sub
    
SErr:
    If Err.number = 32755 Then Resume SEnd
    MsgBox ("Error " & Err.number & ".  Filename: " & CommonDialog1.FileName)
    Resume SEnd
    
SOpenErr:
    MsgBox ("Error opening file: " & CommonDialog1.FileName & ".  Data has not been saved.")
    Resume SEnd
    
SWriteErr:
    MsgBox ("Error writing to file: " & CommonDialog1.FileName & ".  All data may not have been saved.")
    Resume SClose

End Sub

Private Sub cmdSearch_Click()
Dim constr$
Dim cb As Boolean

    Set rs1 = Nothing
    Set rs1 = New ADODB.Recordset
    constr = "SELECT * FROM " & db_name & " WHERE"
    If cbDate.value = 1 Then
        constr$ = constr$ + " TestDateTime >= '" & Format(tbDate(0).Text, "yyyy-mm-dd") & " " & tbTime(0).Text & "'"
        constr$ = constr$ + " AND TestDateTime <= '" & Format(tbDate(1).Text, "yyyy-mm-dd") & " " & tbTime(1).Text & "'"
        cb = True
    End If
    If cbModel.value = 1 Then
        If cb Then constr$ = constr$ + " AND"
        constr$ = constr$ + " Model like '" & tbModel.Text & "'"
        cb = True
    End If
    If cbFLot.value = 1 Then
        If cb Then constr$ = constr$ + " AND"
        constr$ = constr$ + " FLot like '" & tbFLot.Text & "'"
        cb = True
    End If
    If cbRLot.value = 1 Then
        If cb Then constr$ = constr$ + " AND"
        constr$ = constr$ + " RLot like '" & tbRLot.Text & "'"
        cb = True
    End If

    If Not cb Then
        MsgBox ("Either date/time, model, or lot must be selected as search criteria.")
        Exit Sub
    End If
    constr$ = constr$ + " order by TestDateTime"
    
    rs1.CursorLocation = adUseClient
    rs1.CursorType = adOpenStatic
    rs1.LockType = adLockReadOnly
    rs1.Open constr$, conn
    Set DataGrid1.DataSource = rs1
    lblResults.Caption = rs1.RecordCount
    If rs1.RecordCount > 0 Then cmdSave.Enabled = True
    
End Sub

Private Sub cmdTestAdd_Click()
    Call SqlAdd(0, tbModel.Text, tbFLot.Text, tbRLot.Text)
End Sub

Private Sub Form_Load()
Dim t!, e As Boolean, M$, rc&

    On Error GoTo DBerror
    
    tbDate(0).Text = Format(Date$, "mm/dd/yyyy")
    tbDate(1).Text = Format(Date$, "mm/dd/yyyy")
    tbTime(0).Text = "00:00:00"
    tbTime(1).Text = Time$
    tbModel.Text = ""
    tbFLot.Text = ""
    tbRLot.Text = ""
    
    db_name = "StuffLot"
    db_server = "localhost"
    db_port = ""    'default port is 3306
    db_user = "Stuffer"
    db_pass = ""
FLOpen:
    OpenServer ' Open without ODBC in Control Panel
    CreateTable
    
    Set rs1 = New ADODB.Recordset
    
EndFL:
Exit Sub

DBerror:
    t = Timer
    'Found that sometimes, this program starts before MySQL does, so wait and try again.
    'Err.number for that is: -2147467259.
    rc = Err.number
    If rc <> -2147467259 Then
        M$ = "DB Error " & rc& & ": " & Err.Description & _
            " in fMySql.Form_Load()."
        M$ = M$ + " Second MySQL connection attempt failed.  Close the program and try again."
        MsgBox (M$)
    Else
        While Timer - t < 10 And Timer > t: Wend
    End If

    If e Then
        Resume EndFL
    Else
        ' Try again to open a connection.
        e = True
        Resume FLOpen
    End If

End Sub

Private Sub OpenServer() 'Connect MySQL Server Without ODBC setup
Dim constr$

    constr = "Provider=MSDASQL.1;Password=;Persist Security Info=True;" & _
        "User ID=;Extended Properties=" & Chr$(34) & _
        "DRIVER={MySQL ODBC 3.51 Driver};DESC=;DATABASE=" & db_name & _
        ";SERVER=" & db_server & ";UID=" & db_user & _
        ";PASSWORD=" & db_pass & ";PORT=" & db_port & _
        ";OPTION=16387;STMT=;" & Chr$(34)
    Set conn = New ADODB.Connection
    conn.Open constr
End Sub

Public Function SqlAdd(PLCCount&, Model$, FLot$, RLot$)
Dim constr$

    On Local Error GoTo SAErr
    
    constr$ = "INSERT INTO " & db_name & "(TestDateTime,PLCCount,Model,FLot,RLot) " & _
        "values(Now()," & PLCCount& & ",'" & Model$ & "','" & FLot$ & "','" & RLot$ & "')"
    conn.Execute constr$
    SqlAdd = 0
    
SAEnd:
    Exit Function
    
SAErr:
    SqlAdd = -1
    
End Function

Private Sub CreateTable()
Dim constr$

    On Local Error GoTo CTErr
    
    constr = "CREATE TABLE IF NOT EXISTS " & db_name & " " _
    & "(TestDateTime DATETIME NOT NULL PRIMARY KEY," _
    & "PLCCount int," _
    & "Model varchar(" & Len_Model & ")," _
    & "FLot varchar(" & Len_FLot & ")," _
    & "RLot varchar(" & Len_RLot & "))"
    conn.Execute constr, , adExecuteNoRecords

CTEnd:
    Exit Sub
    
CTErr:
    MsgBox "Can't connect to MySQL server or create new database please call program again !"
    Resume CTEnd
    
End Sub

