Attribute VB_Name = "Defines"
Option Explicit

Public Const PLC_DB = 1       ' DB block to read from.  Use 1 for S7-200.
'Public Const PLC_DB = 70       ' DB block to read from.  Use 1 for S7-200.
Public Const PLC_START = 0     ' Starting byte in DB to read.
Public Const PLC_wBYTES = 2    ' only write the first 2 bytes back to plc.

Public Const Len_Model = 26
Public Const Len_FLot = 26
Public Const Len_RLot = 26
Public Const PLC_rBYTES = 4 + Len_Model + Len_FLot + Len_RLot ' Total
' number of bytes to read.  This MUST be less than or equal to size
' of PLC_DATA structure below.

Public Type PLC_DATA
    PC_Count As Integer   ' 2 bytes
    PLC_Count As Integer  ' 2 bytes
    Model As String * Len_Model
    FLot As String * Len_FLot
    RLot As String * Len_RLot
End Type
'

' Extract a string from the data read from the PLC.
Public Function daveGetStr$(ByVal dc As Long, ByVal NumBytes)
Dim i%, t$, ch%, FoundNull As Boolean

    t$ = ""
    FoundNull = False
    For i% = 1 To NumBytes
        ch% = daveGetU8(dc)
        If ch% < 32 Then
            If ch% = 0 Then
                'Exit For
            End If
        Else
            t$ = t$ + Chr$(ch)
        End If
    Next i%
    daveGetStr$ = t$
End Function

Public Function PlcBytesToPLC_DATA(ByVal dc As Long, ByRef PlcInfo As PLC_DATA)
Dim BPos%

    PlcInfo.PC_Count = daveGetS16(dc)
    PlcInfo.PLC_Count = daveGetS16(dc)
    PlcInfo.Model = daveGetStr(dc, Len_Model)
    PlcInfo.FLot = daveGetStr(dc, Len_FLot)
    PlcInfo.RLot = daveGetStr(dc, Len_RLot)

End Function

Public Function ErasePLC_DATA(ByRef PlcInfo As PLC_DATA)
    PlcInfo.PC_Count = 0
    PlcInfo.PLC_Count = 0
    PlcInfo.Model = ""
    PlcInfo.FLot = ""
    PlcInfo.RLot = ""
End Function

