VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Begin VB.Form fMain 
   Caption         =   "Stuffer Lot Tracking"
   ClientHeight    =   2280
   ClientLeft      =   165
   ClientTop       =   855
   ClientWidth     =   11400
   BeginProperty Font 
      Name            =   "MS Sans Serif"
      Size            =   9.75
      Charset         =   0
      Weight          =   400
      Underline       =   0   'False
      Italic          =   0   'False
      Strikethrough   =   0   'False
   EndProperty
   Icon            =   "LotTrack.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   2280
   ScaleWidth      =   11400
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton cmdTest 
      Caption         =   "&Test"
      Enabled         =   0   'False
      Height          =   390
      Left            =   5325
      TabIndex        =   9
      Top             =   225
      Visible         =   0   'False
      Width           =   1290
   End
   Begin VB.CheckBox cbPlcRead 
      Caption         =   "Enable automatically reading PLC."
      Height          =   240
      Left            =   75
      TabIndex        =   2
      Top             =   75
      Width           =   3390
   End
   Begin MSComctlLib.StatusBar sBar 
      Align           =   2  'Align Bottom
      Height          =   315
      Left            =   0
      TabIndex        =   1
      Top             =   1965
      Width           =   11400
      _ExtentX        =   20108
      _ExtentY        =   556
      Style           =   1
      SimpleText      =   "Status Bar"
      _Version        =   393216
      BeginProperty Panels {8E3867A5-8586-11D1-B16A-00C0F0283628} 
         NumPanels       =   1
         BeginProperty Panel1 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
         EndProperty
      EndProperty
   End
   Begin VB.Timer tmrReadPlc 
      Enabled         =   0   'False
      Interval        =   1500
      Left            =   4575
      Top             =   0
   End
   Begin VB.Label lblStatus 
      Caption         =   "Status - Incomplete."
      Height          =   240
      Index           =   2
      Left            =   8625
      TabIndex        =   8
      Top             =   1500
      Width           =   2565
   End
   Begin VB.Label lblStatus 
      Caption         =   "Status - Incomplete."
      Height          =   240
      Index           =   1
      Left            =   8625
      TabIndex        =   7
      Top             =   1200
      Width           =   2565
   End
   Begin VB.Label lblStatus 
      Caption         =   "Status - Incomplete."
      Height          =   240
      Index           =   0
      Left            =   8625
      TabIndex        =   6
      Top             =   900
      Width           =   2565
   End
   Begin VB.Label lblData 
      Caption         =   "mm/dd/yyyy hh:mm:ss, Model#, Front Lot #, Rear Lot#"
      Height          =   240
      Index           =   2
      Left            =   300
      TabIndex        =   5
      Top             =   1500
      Width           =   8115
   End
   Begin VB.Label lblData 
      Caption         =   "mm/dd/yyyy hh:mm:ss, Model#, Front Lot #, Rear Lot#"
      Height          =   240
      Index           =   1
      Left            =   300
      TabIndex        =   4
      Top             =   1200
      Width           =   8115
   End
   Begin VB.Label lblData 
      Caption         =   "mm/dd/yyyy hh:mm:ss, Model#, Front Lot #, Rear Lot#"
      Height          =   240
      Index           =   0
      Left            =   300
      TabIndex        =   3
      Top             =   900
      Width           =   8115
   End
   Begin VB.Label Label1 
      Caption         =   "Last parts added:"
      Height          =   240
      Left            =   150
      TabIndex        =   0
      Top             =   600
      Width           =   2040
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnufExit 
         Caption         =   "E&xit"
         Shortcut        =   ^X
      End
   End
   Begin VB.Menu mnuEdit 
      Caption         =   "&Edit"
      Begin VB.Menu mnueSearch 
         Caption         =   "&Search"
         Shortcut        =   ^S
      End
      Begin VB.Menu mnuPlcConn 
         Caption         =   "P&LC Connection"
         Shortcut        =   ^L
      End
   End
   Begin VB.Menu mnuAbout 
      Caption         =   "&About"
   End
End
Attribute VB_Name = "fMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' When the PLC has new data, it will increment PLC_Count.
' When the PC has read the data & saved it, the PC will set PC_Count = PLC_Count
'and write it back to PLC.

Const NUM_PARTS = 3     ' Number of parts to keep displayed on screen.
'Note: NUM_PARTS must match number of labels created on screen.  I did not
'dynamically create those since that would also mean adjusting the form size...
'
Const INI_FILENAME = "LotTrack.INI"
'
Dim PLCOpen As Boolean
'
'

Private Sub cbPlcRead_Click()
    If cbPlcRead.value = 1 Then
        tmrReadPlc.Enabled = True
        sBar.SimpleText = "Reading every " & tmrReadPlc.Interval & " mSec."
    Else
        tmrReadPlc.Enabled = False
        sBar.SimpleText = "Automatic reading disabled."
    End If
End Sub

Private Sub cmdTest_Click()
Static PlcInfo As PLC_DATA
Dim rc&

    'Don't change PlcInfo.PC_Count.  That will be changed below
    PlcInfo.PLC_Count = PlcInfo.PC_Count + 1
    PlcInfo.Model = "Test Model " & PlcInfo.PC_Count
    PlcInfo.FLot = "Front Lot #" & PlcInfo.PLC_Count
    PlcInfo.RLot = "Rear Lot #"
    rc = SavePlcInfo(PlcInfo)
    PlcInfo.PC_Count = PlcInfo.PLC_Count
    
End Sub

Private Function ReadIni()
Dim FName$, ff%, Temp%

    FName = GetCommonAppDataPath() & "\" & INI_FILENAME
    ff% = FreeFile
    On Local Error GoTo RIOpenErr
    Open FName For Input As ff%
    On Local Error GoTo RIReadErr
    Input #ff%, Temp%
    cbPlcRead.value = Temp%
    ReadIni = fPlcConn.ReadIni(ff%)
RIClose:
    Close #ff%
RIExit:
    Exit Function

RIOpenErr:
    'Failure attempting to open file.
    MsgBox "Unable to open ini file: " & FName & " to read settings."
    ReadIni = -1
    Resume RIExit
    
RIReadErr:
    'Failure reading file.
    MsgBox "Error reading ini file: " & FName & " to read settings."
    ReadIni = -2
    Resume RIClose
    
End Function

Private Function WriteIni()
Dim FName$, ff%

    FName = GetCommonAppDataPath() & "\" & INI_FILENAME
    ff% = FreeFile
    On Local Error GoTo WIOpenErr
    Open FName For Output As ff%
    On Local Error GoTo WIWriteErr
    Write #ff%, cbPlcRead.value
    WriteIni = fPlcConn.WriteIni(ff%)
WIClose:
    Close #ff%
WIExit:
    Exit Function
    
WIOpenErr:
    'Failure attempting to open file for output.
    MsgBox "Unable to open ini file: " & FName & " to save settings."
    Resume WIExit
    
WIWriteErr:
    'Failure attempting to write to file.
    MsgBox "Unable to write to ini file: " & FName & " to save settings."
    Resume WIClose
    
End Function

Private Sub Form_Load()
Dim rc&

    Load fMySql
    Load fPlcConn
    
    rc = ReadIni()
    If rc = 0 Then
        rc = fPlcConn.fPlcConnect
        If rc <> 0 Then
            'MsgBox "Error " & rc & " attempting to connect to PLC.  Check PLC settings and click " & _
            '    "OK on PLC Connection window to re-attempt connecting."
            cbPlcRead.value = 0
            sBar.SimpleText = "PLC Connection error."
        Else
            PLCOpen = True
        End If
    Else
        MsgBox "Unable to read .ini file.  Setting to default configuration." & Chr$(13) & _
            "Connection will NOT be made to PLC until OK is clicked on PLC Setup window."
        cbPlcRead.value = 0
        sBar.SimpleText = ".INI file error.  Check configuration."
    End If
    
    If cbPlcRead.value = 1 Then
        tmrReadPlc.Enabled = True
        sBar.SimpleText = "Timer running."
    Else
        sBar.SimpleText = "Timer not started."
    End If
End Sub

Private Sub Form_Unload(Cancel As Integer)
    
    WriteIni
    fPlcConn.fPlcClose
    
    Unload fPlcConn
    Unload fMySql
    Cancel = 0
    
End Sub

Private Sub mnuAbout_Click()
    About.Show
End Sub

Private Sub mnueSearch_Click()
    fMySql.Show
End Sub

Private Sub mnufExit_Click()
    End
End Sub

Private Sub mnuPlcConn_Click()
    fPlcConn.Show
End Sub

Private Function ReOpenPLC()
Dim rc&

    If PLCOpen Then
        rc = fPlcConn.fPlcClose()
        If rc <> 0 Then
            sBar.SimpleText = "Error " & rc & " from fPlcClose().  Unable to close port."
        End If
    End If
    PLCOpen = False
    
    rc = fPlcConn.fPlcConnect()
    If rc = 0 Then
        sBar.SimpleText = "PLC connection re-opened."
        PLCOpen = True
    Else
        sBar.SimpleText = "ReOpenPLC Err:" & rc & ":" & fPlcConn.fPlcErrMsg$(rc)
    End If

End Function
' Get current counter value from PLC.
Private Sub tmrReadPlc_Timer()
Dim PlcInfo As PLC_DATA

    tmrReadPlc.Enabled = False
    
    If Not PLCOpen Then
        ReOpenPLC
        If Not PLCOpen Then
            tmrReadPlc.Enabled = True
            Exit Sub
        End If
    End If
    
    ' Read both PLC counter and PC counter from PLC.
    sBar.SimpleText = "Reading PLC @ " & Time$ & " on " & Date$
    
    If ReadPlc(PlcInfo) = 0 Then
        'No error reading, so save if necessary.
        If PlcInfo.PC_Count <> PlcInfo.PLC_Count Then
            If SavePlcInfo(PlcInfo) = 0 Then
                Call WritePlc(PlcInfo)
            End If
        End If
    Else
        ReOpenPLC
    End If

    tmrReadPlc.Enabled = True
    
End Sub

Private Function ReadPlc&(ByRef PlcInfo As PLC_DATA)
Dim rc&, BPos%

    ReadPlc = 0
    rc = fPlcConn.fPlcRead(daveDB, PLC_DB, PLC_START, PLC_rBYTES, 0)
    If rc Then
        sBar.SimpleText = "Error " & rc & " reading data from PLC."
        ErasePLC_DATA PlcInfo
    Else
        rc = PlcBytesToPLC_DATA(fPlcConn.dc, PlcInfo)
    End If
    ReadPlc = rc
    
End Function

Private Function SavePlcInfo&(ByRef PlcInfo As PLC_DATA)
Dim rc&

    ' Data read successfully.
    'Check to see if data has changed & needs to be saved.
    If PlcInfo.PLC_Count <> PlcInfo.PC_Count Then
        Call UpdateLastParts(PlcInfo, "Saving Data")
        rc = fMySql.SqlAdd(CLng(PlcInfo.PLC_Count), PlcInfo.Model, PlcInfo.FLot, PlcInfo.RLot)
        SavePlcInfo = rc
        If rc Then
            ' Saving data failed.
            sBar.SimpleText = "Error " & rc & " saving data."
            lblStatus(0).Caption = "SqlAdd FAILED " & rc
        End If
    End If

End Function

Private Function WritePlc(ByRef PlcInfo As PLC_DATA) As Long
Dim rc&, buffer(100) As Byte, t$

    PlcInfo.PC_Count = PlcInfo.PLC_Count
    rc = davePut16(buffer(0), PlcInfo.PC_Count)
    ' 14Apr06 BRR-NO!  davePut...() functions do NOT return an error code.
    'The davePut...() functions return a pointer to the next position in
    'the buffer, which is meaningless and not needed for Visual Basic.
'    If rc Then
'        sBar.SimpleText = "Error " & rc & " from davePut16(Ptr, " & PlcInfo.PC_Count & "). " & fPlcErrMsg$(rc)
'        WritePlc = rc
'        MsgBox (sBar.SimpleText)
'        lblStatus(0).Caption = "davePut16 Err:" & rc & " " & fPlcErrMsg$(rc)
'        Exit Function
'    End If
    lblStatus(0).Caption = "Updating PLC."
    rc = fPlcConn.fPlcWrite(daveDB, PLC_DB, PLC_START, PLC_wBYTES, buffer(0))
    If rc Then
        ' Write to PLC failed.
        sBar.SimpleText = "Error " & rc & " writing to plc."
        lblStatus(0).Caption = "PLC Write Err:" & rc
    Else
        ' Everything was successful.
        lblStatus(0).Caption = "Track Complete."
    End If
    WritePlc = rc
    
End Function

Private Sub UpdateLastParts(PlcInfo As PLC_DATA, Status$)
Dim i%

    For i = NUM_PARTS - 1 To 1 Step -1
        lblData(i).Caption = lblData(i - 1).Caption
        lblStatus(i).Caption = lblStatus(i - 1).Caption
    Next i

    lblData(i).Caption = Date$ & ", " & Time$ & "," & PlcInfo.PC_Count & ", " & PlcInfo.PLC_Count & ", " & PlcInfo.Model & ", " & _
            PlcInfo.FLot & ", " & PlcInfo.RLot
    lblStatus(i).Caption = Status$

End Sub
