#!/bin/bash
# Copyright 2016 Google Inc. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS-IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# This is a quick-and-dirty script to analyze the ELF symbol sizes in a binary generated by generate_benchmark.py.
# It can be used to decide which functions should no longer be inlined, to save space.

if [ "$#" != "1" ]
then
    echo "Usage: $0 <executable_file>"
    exit 1
fi

FILE1=$(mktemp)
nm --print-size --size-sort --radix=d "$1" | sort -k 2 | c++filt \
| sed 's/[^ ]* //;s/fruit::impl:://g;s/InvokeConstructorWithInjectedArgVector<.*>::operator()/InvokeConstructorWithInjectedArgVector<...>::operator()/' \
| sed 's/getComponent[0-9]\+/getComponent$N/' \
| sed 's/X[0-9]\+/X$N/g' \
| sed 's/Interface[0-9]\+/Interface$N/g' \
| sed 's/GetBindingDepsHelper<.*>::operator()()/GetBindingDepsHelper<...>::operator()()/' \
| sed 's/\(std::shared_ptr<Interface$N>, \)\+std::shared_ptr<Interface$N>/.../' \
>"$FILE1"

FILE2=$(mktemp)
python3 -c "
lines = open('$FILE1', 'r').readlines()
total_size = {}
for line in lines:
  splits = line.split(' ', maxsplit=1)
  total_size[splits[1]] = total_size.get(splits[1], 0) + int(splits[0])
for key, value in total_size.items():
  print('%s %s' % (value, key))
" >"$FILE2"

sort -n "$FILE2"
