/*
 * Copyright 2014 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "fake_key_value_storage.h"

#include <map>

class FakeKeyValueStorage : public KeyValueStorage {
private:
  std::map<std::string, std::string> storage;

public:
  INJECT(FakeKeyValueStorage()) = default;

  void put(std::string key, std::string value) override {
    storage[key] = value;
  }

  std::string get(std::string key) override {
    return storage[key];
  }
};

fruit::Component<KeyValueStorage> getFakeKeyValueStorageComponent() {
  return fruit::createComponent()
      .bind<KeyValueStorage, FakeKeyValueStorage>();
}
