/********************************************************************************
*                                                                               *
*                                 Test MDI Widgets                              *
*                                                                               *
*********************************************************************************
* Copyright (C) 1998,2021 by Jeroen van der Zijp.   All Rights Reserved.        *
********************************************************************************/
#include "fx.h"
#include <stdio.h>
#include <stdlib.h>

#include "FXThread.h"

/*******************************************************************************/


// Mini application object
class MDITestWindow : public FXMainWindow {
  FXDECLARE(MDITestWindow)

protected:
  FXMenuBar         *menubar;
  FXMDIClient       *mdiclient;               // MDI Client area
  FXMDIMenu         *mdimenu;                 // MDI Window Menu
  FXMenuPane        *filemenu;
  FXMenuPane        *windowmenu;
  FXMenuPane        *helpmenu;
  FXFont            *font;
  FXIcon            *mdiicon;
protected:
  MDITestWindow(){}

public:

  // We define additional ID's, starting from the last one used by the base class+1.
  // This way, we know the ID's are all unique for this particular target.
  enum {
    ID_ABOUT=FXMainWindow::ID_LAST,
    ID_NEW
    };

  // Message handlers
  long onCmdAbout(FXObject*,FXSelector,void*);
  long onCmdNew(FXObject*,FXSelector,void*);

public:
  MDITestWindow(FXApp* a);
  virtual void create();
  virtual ~MDITestWindow();
  };



/*******************************************************************************/


const unsigned char penguin[]={
  0x47,0x49,0x46,0x38,0x37,0x61,0x10,0x00,0x12,0x00,0xf2,0x00,0x00,0xb2,0xc0,0xdc,
  0x80,0x80,0x80,0x00,0x00,0x00,0xc0,0xc0,0xc0,0x10,0x10,0x10,0xff,0xff,0xff,0xe0,
  0xa0,0x08,0x00,0x00,0x00,0x2c,0x00,0x00,0x00,0x00,0x10,0x00,0x12,0x00,0x00,0x03,
  0x53,0x08,0xba,0x21,0x12,0x2b,0xc6,0xe6,0x9e,0x94,0x62,0x64,0x77,0xa3,0x20,0x4e,
  0x21,0x74,0x8b,0x60,0x9c,0x1a,0xa9,0x98,0xa8,0x45,0xb2,0x85,0x38,0x76,0x4f,0x6c,
  0xbb,0x93,0x60,0xdb,0x0d,0xe4,0xd9,0x83,0x1d,0xe7,0x57,0x18,0x04,0x6f,0xb8,0x4c,
  0xec,0x88,0x9c,0x01,0x0c,0x47,0x66,0xac,0xa2,0x38,0x19,0x76,0x36,0x83,0xc3,0xf0,
  0xb4,0x5e,0x77,0x03,0xaf,0xf8,0x7b,0x13,0x77,0xad,0xd3,0xad,0x75,0x61,0xa5,0x54,
  0x02,0x27,0x45,0x02,0x00,0x3b
  };


static const FXchar tyger[]=
  "The Tyger\n\n"
  "Tyger! Tyger! burning bright\n"
  "In the forests of the night\n"
  "What immortal hand or eye\n"
  "Could frame thy fearful symmetry?\n\n"
  "In what distant deeps or skies\n"
  "Burnt the fire of thine eyes?\n"
  "On what wings dare he aspire?\n"
  "What the hand dare seize the fire?\n\n"
  "And what shoulder, and what art,\n"
  "Could twist the sinews of thy heart,\n"
  "And when thy heart began to beat,\n"
  "What dread hand? and what dread feet?\n\n"
  "What the hammer? what the chain?\n"
  "In what furnace was thy brain?\n"
  "What the anvil? what dread grasp\n"
  "Dare its deadly terrors clasp?\n\n"
  "When the stars threw down their spears,\n"
  "And water'd heaven with their tears,\n"
  "Did he smile his work to see?\n"
  "Did he who made the Lamb make thee?\n\n"
  "Tyger! Tyger! burning bright\n"
  "In the forests of the night,\n"
  "What immortal hand or eye,\n"
  "Dare frame thy fearful symmetry?\n\n\n\n"
  "               - William Blake\n\n";


static const FXchar unicode[]=
  "\n"
  "UTF-8 encoded sample plain-text file\n"
  "\xe2\x80\xbe\xe2\x80\xbe\xe2\x80\xbe\xe2\x80\xbe\xe2\x80\xbe\xe2\x80\xbe\xe2\x80"
  "\xbe\xe2\x80\xbe\xe2\x80\xbe\xe2\x80\xbe\xe2\x80\xbe\xe2\x80\xbe\xe2\x80\xbe\xe2"
  "\x80\xbe\xe2\x80\xbe\xe2\x80\xbe\xe2\x80\xbe\xe2\x80\xbe\xe2\x80\xbe\xe2\x80\xbe"
  "\xe2\x80\xbe\xe2\x80\xbe\xe2\x80\xbe\xe2\x80\xbe\xe2\x80\xbe\xe2\x80\xbe\xe2\x80"
  "\xbe\xe2\x80\xbe\xe2\x80\xbe\xe2\x80\xbe\xe2\x80\xbe\xe2\x80\xbe\xe2\x80\xbe\xe2"
  "\x80\xbe\xe2\x80\xbe\xe2\x80\xbe\n"
  "\n"
  "Markus Kuhn [\xcb\x88ma\xca\xb3k\xca\x8as ku\xcb\x90n] <http://www.cl.cam.ac.uk/"
  "~mgk25/> \xe2\x80\x94 2002-07-25\n"
  "\n"
  "\n"
  "The ASCII compatible UTF-8 encoding used in this plain-text file\n"
  "is defined in Unicode, ISO 10646-1, and RFC 2279.\n"
  "\n"
  "\n"
  "Using Unicode/UTF-8, you can write in emails and source code things such as\n"
  "\n"
  "Mathematics and sciences:\n"
  "\n"
  "  \xe2\x88\xae E\xe2\x8b\x85\x64\x61 = Q,  n \xe2\x86\x92 \xe2\x88\x9e, \xe2\x88"
  "\x91 f(i) = \xe2\x88\x8f g(i),      \xe2\x8e\xa7\xe2\x8e\xa1\xe2\x8e\x9b\xe2\x94"
  "\x8c\xe2\x94\x80\xe2\x94\x80\xe2\x94\x80\xe2\x94\x80\xe2\x94\x80\xe2\x94\x90\xe2"
  "\x8e\x9e\xe2\x8e\xa4\xe2\x8e\xab\n"
  "                                            \xe2\x8e\xaa\xe2\x8e\xa2\xe2\x8e\x9c"
  "\xe2\x94\x82\x61\xc2\xb2+b\xc2\xb3 \xe2\x8e\x9f\xe2\x8e\xa5\xe2\x8e\xaa\n"
  "  \xe2\x88\x80x\xe2\x88\x88\xe2\x84\x9d: \xe2\x8c\x88x\xe2\x8c\x89 = \xe2\x88\x92"
  "\xe2\x8c\x8a\xe2\x88\x92x\xe2\x8c\x8b, \xce\xb1 \xe2\x88\xa7 \xc2\xac\xce\xb2 = "
  "\xc2\xac(\xc2\xac\xce\xb1 \xe2\x88\xa8 \xce\xb2),    \xe2\x8e\xaa\xe2\x8e\xa2\xe2"
  "\x8e\x9c\xe2\x94\x82\xe2\x94\x80\xe2\x94\x80\xe2\x94\x80\xe2\x94\x80\xe2\x94\x80"
  " \xe2\x8e\x9f\xe2\x8e\xa5\xe2\x8e\xaa\n"
  "                                            \xe2\x8e\xaa\xe2\x8e\xa2\xe2\x8e\x9c"
  "\xe2\x8e\xb7 c\xe2\x82\x88   \xe2\x8e\x9f\xe2\x8e\xa5\xe2\x8e\xaa\n"
  "  \xe2\x84\x95 \xe2\x8a\x86 \xe2\x84\x95\xe2\x82\x80 \xe2\x8a\x82 \xe2\x84\xa4 \xe2"
  "\x8a\x82 \xe2\x84\x9a \xe2\x8a\x82 \xe2\x84\x9d \xe2\x8a\x82 \xe2\x84\x82,      "
  "             \xe2\x8e\xa8\xe2\x8e\xa2\xe2\x8e\x9c       \xe2\x8e\x9f\xe2\x8e\xa5"
  "\xe2\x8e\xac\n"
  "                                            \xe2\x8e\xaa\xe2\x8e\xa2\xe2\x8e\x9c"
  " \xe2\x88\x9e     \xe2\x8e\x9f\xe2\x8e\xa5\xe2\x8e\xaa\n"
  "  \xe2\x8a\xa5 < a \xe2\x89\xa0 b \xe2\x89\xa1 c \xe2\x89\xa4 d \xe2\x89\xaa \xe2"
  "\x8a\xa4 \xe2\x87\x92 (\xe2\x9f\xa6\x41\xe2\x9f\xa7 \xe2\x87\x94 \xe2\x9f\xaa\x42"
  "\xe2\x9f\xab),      \xe2\x8e\xaa\xe2\x8e\xa2\xe2\x8e\x9c \xe2\x8e\xb2     \xe2\x8e"
  "\x9f\xe2\x8e\xa5\xe2\x8e\xaa\n"
  "                                            \xe2\x8e\xaa\xe2\x8e\xa2\xe2\x8e\x9c"
  " \xe2\x8e\xb3\x61\xe2\x81\xb1-b\xe2\x81\xb1\xe2\x8e\x9f\xe2\x8e\xa5\xe2\x8e\xaa\n"
  "  2H\xe2\x82\x82 + O\xe2\x82\x82 \xe2\x87\x8c 2H\xe2\x82\x82O, R = 4.7 k\xce\xa9"
  ", \xe2\x8c\x80 200 mm     \xe2\x8e\xa9\xe2\x8e\xa3\xe2\x8e\x9di=1    \xe2\x8e\xa0"
  "\xe2\x8e\xa6\xe2\x8e\xad\n"
  "\n"
  "Linguistics and dictionaries:\n"
  "\n"
  "  \xc3\xb0i \xc4\xb1nt\xc9\x99\xcb\x88n\xc3\xa6\xca\x83\xc9\x99n\xc9\x99l f\xc9\x99"
  "\xcb\x88n\xc9\x9bt\xc4\xb1k \xc9\x99so\xca\x8asi\xcb\x88\x65\xc4\xb1\xca\x83n\n"
  "  Y [\xcb\x88\xca\x8fpsil\xc9\x94n], Yen [j\xc9\x9bn], Yoga [\xcb\x88jo\xcb\x90g"
  "\xc9\x91]\n"
  "\n"
  "APL:\n"
  "\n"
  "  ((V\xe2\x8d\xb3V)=\xe2\x8d\xb3\xe2\x8d\xb4V)/V\xe2\x86\x90,V    \xe2\x8c\xb7\xe2"
  "\x86\x90\xe2\x8d\xb3\xe2\x86\x92\xe2\x8d\xb4\xe2\x88\x86\xe2\x88\x87\xe2\x8a\x83"
  "\xe2\x80\xbe\xe2\x8d\x8e\xe2\x8d\x95\xe2\x8c\x88\n"
  "\n"
  "Nicer typography in plain text files:\n"
  "\n"
  "  \xe2\x95\x94\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95"
  "\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2"
  "\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90"
  "\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95"
  "\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2"
  "\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90"
  "\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x97\n"
  "  \xe2\x95\x91                                          \xe2\x95\x91\n"
  "  \xe2\x95\x91   \xe2\x80\xa2 \xe2\x80\x98single\xe2\x80\x99 and \xe2\x80\x9c\x64"
  "ouble\xe2\x80\x9d quotes         \xe2\x95\x91\n"
  "  \xe2\x95\x91                                          \xe2\x95\x91\n"
  "  \xe2\x95\x91   \xe2\x80\xa2 Curly apostrophes: \xe2\x80\x9cWe\xe2\x80\x99ve be"
  "en here\xe2\x80\x9d \xe2\x95\x91\n"
  "  \xe2\x95\x91                                          \xe2\x95\x91\n"
  "  \xe2\x95\x91   \xe2\x80\xa2 Latin-1 apostrophe and accents: '\xc2\xb4`  \xe2\x95"
  "\x91\n"
  "  \xe2\x95\x91                                          \xe2\x95\x91\n"
  "  \xe2\x95\x91   \xe2\x80\xa2 \xe2\x80\x9a\x64\x65utsche\xe2\x80\x98 \xe2\x80\x9e"
  "\x41nf\xc3\xbchrungszeichen\xe2\x80\x9c       \xe2\x95\x91\n"
  "  \xe2\x95\x91                                          \xe2\x95\x91\n"
  "  \xe2\x95\x91   \xe2\x80\xa2 \xe2\x80\xa0, \xe2\x80\xa1, \xe2\x80\xb0, \xe2\x80"
  "\xa2, 3\xe2\x80\x93\x34, \xe2\x80\x94, \xe2\x88\x92\x35/+5, \xe2\x84\xa2, \xe2\x80"
  "\xa6      \xe2\x95\x91\n"
  "  \xe2\x95\x91                                          \xe2\x95\x91\n"
  "  \xe2\x95\x91   \xe2\x80\xa2 ASCII safety test: 1lI|, 0OD, 8B     \xe2\x95\x91\n"
  "  \xe2\x95\x91                      \xe2\x95\xad\xe2\x94\x80\xe2\x94\x80\xe2\x94"
  "\x80\xe2\x94\x80\xe2\x94\x80\xe2\x94\x80\xe2\x94\x80\xe2\x94\x80\xe2\x94\x80\xe2"
  "\x95\xae         \xe2\x95\x91\n"
  "  \xe2\x95\x91   \xe2\x80\xa2 the euro symbol: \xe2\x94\x82 14.95 \xe2\x82\xac \xe2"
  "\x94\x82         \xe2\x95\x91\n"
  "  \xe2\x95\x91                      \xe2\x95\xb0\xe2\x94\x80\xe2\x94\x80\xe2\x94"
  "\x80\xe2\x94\x80\xe2\x94\x80\xe2\x94\x80\xe2\x94\x80\xe2\x94\x80\xe2\x94\x80\xe2"
  "\x95\xaf         \xe2\x95\x91\n"
  "  \xe2\x95\x9a\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95"
  "\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2"
  "\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90"
  "\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95"
  "\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2"
  "\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90"
  "\xe2\x95\x90\xe2\x95\x90\xe2\x95\x90\xe2\x95\x9d\n"
  "\n"
  "Combining characters:\n"
  "\n"
  "  STARG\xce\x9b\xcc\x8aTE SG-1, a = v\xcc\x87 = r\xcc\x88, a\xe2\x83\x91 \xe2\x8a"
  "\xa5 b\xe2\x83\x91\n"
  "\n"
  "Greek (in Polytonic):\n"
  "\n"
  "  The Greek anthem:\n"
  "\n"
  "  \xce\xa3\xe1\xbd\xb2 \xce\xb3\xce\xbd\xcf\x89\xcf\x81\xe1\xbd\xb7\xce\xb6\xcf\x89"
  " \xe1\xbc\x80\xcf\x80\xe1\xbd\xb8 \xcf\x84\xe1\xbd\xb4\xce\xbd \xce\xba\xe1\xbd\xb9"
  "\xcf\x88\xce\xb7\n"
  "  \xcf\x84\xce\xbf\xe1\xbf\xa6 \xcf\x83\xcf\x80\xce\xb1\xce\xb8\xce\xb9\xce\xbf\xe1"
  "\xbf\xa6 \xcf\x84\xe1\xbd\xb4\xce\xbd \xcf\x84\xcf\x81\xce\xbf\xce\xbc\xce\xb5\xcf"
  "\x81\xe1\xbd\xb5,\n"
  "  \xcf\x83\xe1\xbd\xb2 \xce\xb3\xce\xbd\xcf\x89\xcf\x81\xe1\xbd\xb7\xce\xb6\xcf\x89"
  " \xe1\xbc\x80\xcf\x80\xe1\xbd\xb8 \xcf\x84\xe1\xbd\xb4\xce\xbd \xe1\xbd\x84\xcf\x88"
  "\xce\xb7\n"
  "  \xcf\x80\xce\xbf\xe1\xbd\xba \xce\xbc\xe1\xbd\xb2 \xce\xb2\xe1\xbd\xb7\xce\xb1"
  " \xce\xbc\xce\xb5\xcf\x84\xcf\x81\xe1\xbd\xb1\xce\xb5\xce\xb9 \xcf\x84\xe1\xbd\xb4"
  " \xce\xb3\xe1\xbf\x86.\n"
  "\n"
  "  \xe1\xbe\xbf\xce\x91\xcf\x80\xe1\xbe\xbf \xcf\x84\xe1\xbd\xb0 \xce\xba\xe1\xbd"
  "\xb9\xce\xba\xce\xba\xce\xb1\xce\xbb\xce\xb1 \xce\xb2\xce\xb3\xce\xb1\xce\xbb\xce"
  "\xbc\xe1\xbd\xb3\xce\xbd\xce\xb7\n"
  "  \xcf\x84\xe1\xbf\xb6\xce\xbd \xe1\xbf\xbe\xce\x95\xce\xbb\xce\xbb\xe1\xbd\xb5\xce"
  "\xbd\xcf\x89\xce\xbd \xcf\x84\xe1\xbd\xb0 \xe1\xbc\xb1\xce\xb5\xcf\x81\xe1\xbd\xb1"
  "\n"
  "  \xce\xba\xce\xb1\xe1\xbd\xb6 \xcf\x83\xe1\xbd\xb0\xce\xbd \xcf\x80\xcf\x81\xe1"
  "\xbf\xb6\xcf\x84\xce\xb1 \xe1\xbc\x80\xce\xbd\xce\xb4\xcf\x81\xce\xb5\xce\xb9\xcf"
  "\x89\xce\xbc\xe1\xbd\xb3\xce\xbd\xce\xb7\n"
  "  \xcf\x87\xce\xb1\xe1\xbf\x96\xcf\x81\xce\xb5, \xe1\xbd\xa6 \xcf\x87\xce\xb1\xe1"
  "\xbf\x96\xcf\x81\xce\xb5, \xe1\xbe\xbf\xce\x95\xce\xbb\xce\xb5\xcf\x85\xce\xb8\xce"
  "\xb5\xcf\x81\xce\xb9\xe1\xbd\xb1!\n"
  "\n"
  "  From a speech of Demosthenes in the 4th century BC:\n"
  "\n"
  "  \xce\x9f\xe1\xbd\x90\xcf\x87\xe1\xbd\xb6 \xcf\x84\xce\xb1\xe1\xbd\x90\xcf\x84\xe1"
  "\xbd\xb0 \xcf\x80\xce\xb1\xcf\x81\xe1\xbd\xb7\xcf\x83\xcf\x84\xce\xb1\xcf\x84\xce"
  "\xb1\xe1\xbd\xb7 \xce\xbc\xce\xbf\xce\xb9 \xce\xb3\xce\xb9\xce\xb3\xce\xbd\xe1\xbd"
  "\xbd\xcf\x83\xce\xba\xce\xb5\xce\xb9\xce\xbd, \xe1\xbd\xa6 \xe1\xbc\x84\xce\xbd\xce"
  "\xb4\xcf\x81\xce\xb5\xcf\x82 \xe1\xbe\xbf\xce\x91\xce\xb8\xce\xb7\xce\xbd\xce\xb1"
  "\xe1\xbf\x96\xce\xbf\xce\xb9,\n"
  "  \xe1\xbd\x85\xcf\x84\xce\xb1\xce\xbd \xcf\x84\xe1\xbe\xbf \xce\xb5\xe1\xbc\xb0"
  "\xcf\x82 \xcf\x84\xe1\xbd\xb0 \xcf\x80\xcf\x81\xe1\xbd\xb1\xce\xb3\xce\xbc\xce\xb1"
  "\xcf\x84\xce\xb1 \xe1\xbc\x80\xcf\x80\xce\xbf\xce\xb2\xce\xbb\xe1\xbd\xb3\xcf\x88"
  "\xcf\x89 \xce\xba\xce\xb1\xe1\xbd\xb6 \xe1\xbd\x85\xcf\x84\xce\xb1\xce\xbd \xcf\x80"
  "\xcf\x81\xe1\xbd\xb8\xcf\x82 \xcf\x84\xce\xbf\xe1\xbd\xba\xcf\x82\n"
  "  \xce\xbb\xe1\xbd\xb9\xce\xb3\xce\xbf\xcf\x85\xcf\x82 \xce\xbf\xe1\xbd\x93\xcf\x82"
  " \xe1\xbc\x80\xce\xba\xce\xbf\xe1\xbd\xbb\xcf\x89\xce\x87 \xcf\x84\xce\xbf\xe1\xbd"
  "\xba\xcf\x82 \xce\xbc\xe1\xbd\xb2\xce\xbd \xce\xb3\xe1\xbd\xb0\xcf\x81 \xce\xbb\xe1"
  "\xbd\xb9\xce\xb3\xce\xbf\xcf\x85\xcf\x82 \xcf\x80\xce\xb5\xcf\x81\xe1\xbd\xb6 \xcf"
  "\x84\xce\xbf\xe1\xbf\xa6\n"
  "  \xcf\x84\xce\xb9\xce\xbc\xcf\x89\xcf\x81\xe1\xbd\xb5\xcf\x83\xce\xb1\xcf\x83\xce"
  "\xb8\xce\xb1\xce\xb9 \xce\xa6\xe1\xbd\xb7\xce\xbb\xce\xb9\xcf\x80\xcf\x80\xce\xbf"
  "\xce\xbd \xe1\xbd\x81\xcf\x81\xe1\xbf\xb6 \xce\xb3\xce\xb9\xce\xb3\xce\xbd\xce\xbf"
  "\xce\xbc\xe1\xbd\xb3\xce\xbd\xce\xbf\xcf\x85\xcf\x82, \xcf\x84\xe1\xbd\xb0 \xce\xb4"
  "\xe1\xbd\xb2 \xcf\x80\xcf\x81\xe1\xbd\xb1\xce\xb3\xce\xbc\xce\xb1\xcf\x84\xe1\xbe"
  "\xbf \n"
  "  \xce\xb5\xe1\xbc\xb0\xcf\x82 \xcf\x84\xce\xbf\xe1\xbf\xa6\xcf\x84\xce\xbf \xcf"
  "\x80\xcf\x81\xce\xbf\xe1\xbd\xb5\xce\xba\xce\xbf\xce\xbd\xcf\x84\xce\xb1,  \xe1\xbd"
  "\xa5\xcf\x83\xce\xb8\xe1\xbe\xbf \xe1\xbd\x85\xcf\x80\xcf\x89\xcf\x82 \xce\xbc\xe1"
  "\xbd\xb4 \xcf\x80\xce\xb5\xce\xb9\xcf\x83\xe1\xbd\xb9\xce\xbc\xce\xb5\xce\xb8\xe1"
  "\xbe\xbf \xce\xb1\xe1\xbd\x90\xcf\x84\xce\xbf\xe1\xbd\xb6\n"
  "  \xcf\x80\xcf\x81\xe1\xbd\xb9\xcf\x84\xce\xb5\xcf\x81\xce\xbf\xce\xbd \xce\xba\xce"
  "\xb1\xce\xba\xe1\xbf\xb6\xcf\x82 \xcf\x83\xce\xba\xe1\xbd\xb3\xcf\x88\xce\xb1\xcf"
  "\x83\xce\xb8\xce\xb1\xce\xb9 \xce\xb4\xe1\xbd\xb3\xce\xbf\xce\xbd. \xce\xbf\xe1\xbd"
  "\x90\xce\xb4\xe1\xbd\xb3\xce\xbd \xce\xbf\xe1\xbd\x96\xce\xbd \xe1\xbc\x84\xce\xbb"
  "\xce\xbb\xce\xbf \xce\xbc\xce\xbf\xce\xb9 \xce\xb4\xce\xbf\xce\xba\xce\xbf\xe1\xbf"
  "\xa6\xcf\x83\xce\xb9\xce\xbd\n"
  "  \xce\xbf\xe1\xbc\xb1 \xcf\x84\xe1\xbd\xb0 \xcf\x84\xce\xbf\xce\xb9\xce\xb1\xe1"
  "\xbf\xa6\xcf\x84\xce\xb1 \xce\xbb\xe1\xbd\xb3\xce\xb3\xce\xbf\xce\xbd\xcf\x84\xce"
  "\xb5\xcf\x82 \xe1\xbc\xa2 \xcf\x84\xe1\xbd\xb4\xce\xbd \xe1\xbd\x91\xcf\x80\xe1\xbd"
  "\xb9\xce\xb8\xce\xb5\xcf\x83\xce\xb9\xce\xbd, \xcf\x80\xce\xb5\xcf\x81\xe1\xbd\xb6"
  " \xe1\xbc\xa7\xcf\x82 \xce\xb2\xce\xbf\xcf\x85\xce\xbb\xce\xb5\xe1\xbd\xbb\xce\xb5"
  "\xcf\x83\xce\xb8\xce\xb1\xce\xb9,\n"
  "  \xce\xbf\xe1\xbd\x90\xcf\x87\xe1\xbd\xb6 \xcf\x84\xe1\xbd\xb4\xce\xbd \xce\xbf"
  "\xe1\xbd\x96\xcf\x83\xce\xb1\xce\xbd \xcf\x80\xce\xb1\xcf\x81\xce\xb9\xcf\x83\xcf"
  "\x84\xe1\xbd\xb1\xce\xbd\xcf\x84\xce\xb5\xcf\x82 \xe1\xbd\x91\xce\xbc\xe1\xbf\x96"
  "\xce\xbd \xe1\xbc\x81\xce\xbc\xce\xb1\xcf\x81\xcf\x84\xe1\xbd\xb1\xce\xbd\xce\xb5"
  "\xce\xb9\xce\xbd. \xe1\xbc\x90\xce\xb3\xe1\xbd\xbc \xce\xb4\xe1\xbd\xb3, \xe1\xbd"
  "\x85\xcf\x84\xce\xb9 \xce\xbc\xe1\xbd\xb3\xce\xbd\n"
  "  \xcf\x80\xce\xbf\xcf\x84\xe1\xbe\xbf \xe1\xbc\x90\xce\xbe\xe1\xbf\x86\xce\xbd "
  "\xcf\x84\xe1\xbf\x87 \xcf\x80\xe1\xbd\xb9\xce\xbb\xce\xb5\xce\xb9 \xce\xba\xce\xb1"
  "\xe1\xbd\xb6 \xcf\x84\xe1\xbd\xb0 \xce\xb1\xe1\xbd\x91\xcf\x84\xe1\xbf\x86\xcf\x82"
  " \xe1\xbc\x94\xcf\x87\xce\xb5\xce\xb9\xce\xbd \xe1\xbc\x80\xcf\x83\xcf\x86\xce\xb1"
  "\xce\xbb\xe1\xbf\xb6\xcf\x82 \xce\xba\xce\xb1\xe1\xbd\xb6 \xce\xa6\xe1\xbd\xb7\xce"
  "\xbb\xce\xb9\xcf\x80\xcf\x80\xce\xbf\xce\xbd\n"
  "  \xcf\x84\xce\xb9\xce\xbc\xcf\x89\xcf\x81\xe1\xbd\xb5\xcf\x83\xce\xb1\xcf\x83\xce"
  "\xb8\xce\xb1\xce\xb9, \xce\xba\xce\xb1\xe1\xbd\xb6 \xce\xbc\xe1\xbd\xb1\xce\xbb\xe1"
  "\xbe\xbf \xe1\xbc\x80\xce\xba\xcf\x81\xce\xb9\xce\xb2\xe1\xbf\xb6\xcf\x82 \xce\xbf"
  "\xe1\xbc\xb6\xce\xb4\xce\xb1\xce\x87 \xe1\xbc\x90\xcf\x80\xe1\xbe\xbf \xe1\xbc\x90"
  "\xce\xbc\xce\xbf\xe1\xbf\xa6 \xce\xb3\xe1\xbd\xb1\xcf\x81, \xce\xbf\xe1\xbd\x90 "
  "\xcf\x80\xe1\xbd\xb1\xce\xbb\xce\xb1\xce\xb9\n"
  "  \xce\xb3\xe1\xbd\xb3\xce\xb3\xce\xbf\xce\xbd\xce\xb5\xce\xbd \xcf\x84\xce\xb1\xe1"
  "\xbf\xa6\xcf\x84\xe1\xbe\xbf \xe1\xbc\x80\xce\xbc\xcf\x86\xe1\xbd\xb9\xcf\x84\xce"
  "\xb5\xcf\x81\xce\xb1\xce\x87 \xce\xbd\xe1\xbf\xa6\xce\xbd \xce\xbc\xe1\xbd\xb3\xce"
  "\xbd\xcf\x84\xce\xbf\xce\xb9 \xcf\x80\xe1\xbd\xb3\xcf\x80\xce\xb5\xce\xb9\xcf\x83"
  "\xce\xbc\xce\xb1\xce\xb9 \xcf\x84\xce\xbf\xe1\xbf\xa6\xce\xb8\xe1\xbe\xbf \xe1\xbc"
  "\xb1\xce\xba\xce\xb1\xce\xbd\xe1\xbd\xb8\xce\xbd\n"
  "  \xcf\x80\xcf\x81\xce\xbf\xce\xbb\xce\xb1\xce\xb2\xce\xb5\xe1\xbf\x96\xce\xbd \xe1"
  "\xbc\xa1\xce\xbc\xe1\xbf\x96\xce\xbd \xce\xb5\xe1\xbc\xb6\xce\xbd\xce\xb1\xce\xb9"
  " \xcf\x84\xe1\xbd\xb4\xce\xbd \xcf\x80\xcf\x81\xe1\xbd\xbd\xcf\x84\xce\xb7\xce\xbd"
  ", \xe1\xbd\x85\xcf\x80\xcf\x89\xcf\x82 \xcf\x84\xce\xbf\xe1\xbd\xba\xcf\x82 \xcf"
  "\x83\xcf\x85\xce\xbc\xce\xbc\xe1\xbd\xb1\xcf\x87\xce\xbf\xcf\x85\xcf\x82\n"
  "  \xcf\x83\xe1\xbd\xbd\xcf\x83\xce\xbf\xce\xbc\xce\xb5\xce\xbd. \xe1\xbc\x90\xe1"
  "\xbd\xb0\xce\xbd \xce\xb3\xe1\xbd\xb0\xcf\x81 \xcf\x84\xce\xbf\xe1\xbf\xa6\xcf\x84"
  "\xce\xbf \xce\xb2\xce\xb5\xce\xb2\xce\xb1\xe1\xbd\xb7\xcf\x89\xcf\x82 \xe1\xbd\x91"
  "\xcf\x80\xe1\xbd\xb1\xcf\x81\xce\xbe\xe1\xbf\x83, \xcf\x84\xe1\xbd\xb9\xcf\x84\xce"
  "\xb5 \xce\xba\xce\xb1\xe1\xbd\xb6 \xcf\x80\xce\xb5\xcf\x81\xe1\xbd\xb6 \xcf\x84\xce"
  "\xbf\xe1\xbf\xa6\n"
  "  \xcf\x84\xe1\xbd\xb7\xce\xbd\xce\xb1 \xcf\x84\xce\xb9\xce\xbc\xcf\x89\xcf\x81\xe1"
  "\xbd\xb5\xcf\x83\xce\xb5\xcf\x84\xce\xb1\xe1\xbd\xb7 \xcf\x84\xce\xb9\xcf\x82 \xce"
  "\xba\xce\xb1\xe1\xbd\xb6 \xe1\xbd\x83\xce\xbd \xcf\x84\xcf\x81\xe1\xbd\xb9\xcf\x80"
  "\xce\xbf\xce\xbd \xe1\xbc\x90\xce\xbe\xe1\xbd\xb3\xcf\x83\xcf\x84\xce\xb1\xce\xb9"
  " \xcf\x83\xce\xba\xce\xbf\xcf\x80\xce\xb5\xe1\xbf\x96\xce\xbd\xce\x87 \xcf\x80\xcf"
  "\x81\xe1\xbd\xb6\xce\xbd \xce\xb4\xe1\xbd\xb2\n"
  "  \xcf\x84\xe1\xbd\xb4\xce\xbd \xe1\xbc\x80\xcf\x81\xcf\x87\xe1\xbd\xb4\xce\xbd "
  "\xe1\xbd\x80\xcf\x81\xce\xb8\xe1\xbf\xb6\xcf\x82 \xe1\xbd\x91\xcf\x80\xce\xbf\xce"
  "\xb8\xe1\xbd\xb3\xcf\x83\xce\xb8\xce\xb1\xce\xb9, \xce\xbc\xe1\xbd\xb1\xcf\x84\xce"
  "\xb1\xce\xb9\xce\xbf\xce\xbd \xe1\xbc\xa1\xce\xb3\xce\xbf\xe1\xbf\xa6\xce\xbc\xce"
  "\xb1\xce\xb9 \xcf\x80\xce\xb5\xcf\x81\xe1\xbd\xb6 \xcf\x84\xe1\xbf\x86\xcf\x82\n"
  "  \xcf\x84\xce\xb5\xce\xbb\xce\xb5\xcf\x85\xcf\x84\xe1\xbf\x86\xcf\x82 \xe1\xbd\x81"
  "\xce\xbd\xcf\x84\xce\xb9\xce\xbd\xce\xbf\xe1\xbf\xa6\xce\xbd \xcf\x80\xce\xbf\xce"
  "\xb9\xce\xb5\xe1\xbf\x96\xcf\x83\xce\xb8\xce\xb1\xce\xb9 \xce\xbb\xe1\xbd\xb9\xce"
  "\xb3\xce\xbf\xce\xbd.\n"
  "\n"
  "  \xce\x94\xce\xb7\xce\xbc\xce\xbf\xcf\x83\xce\xb8\xe1\xbd\xb3\xce\xbd\xce\xbf\xcf"
  "\x85\xcf\x82, \xce\x93\xe1\xbf\xbd \xe1\xbe\xbf\xce\x9f\xce\xbb\xcf\x85\xce\xbd\xce"
  "\xb8\xce\xb9\xce\xb1\xce\xba\xe1\xbd\xb8\xcf\x82\n"
  "\n"
  "Georgian:\n"
  "\n"
  "  From a Unicode conference invitation:\n"
  "\n"
  "  \xe1\x83\x92\xe1\x83\x97\xe1\x83\xae\xe1\x83\x9d\xe1\x83\x95\xe1\x83\x97 \xe1\x83"
  "\x90\xe1\x83\xae\xe1\x83\x9a\xe1\x83\x90\xe1\x83\x95\xe1\x83\x94 \xe1\x83\x92\xe1"
  "\x83\x90\xe1\x83\x98\xe1\x83\x90\xe1\x83\xa0\xe1\x83\x9d\xe1\x83\x97 \xe1\x83\xa0"
  "\xe1\x83\x94\xe1\x83\x92\xe1\x83\x98\xe1\x83\xa1\xe1\x83\xa2\xe1\x83\xa0\xe1\x83"
  "\x90\xe1\x83\xaa\xe1\x83\x98\xe1\x83\x90 Unicode-\xe1\x83\x98\xe1\x83\xa1 \xe1\x83"
  "\x9b\xe1\x83\x94\xe1\x83\x90\xe1\x83\x97\xe1\x83\x94 \xe1\x83\xa1\xe1\x83\x90\xe1"
  "\x83\x94\xe1\x83\xa0\xe1\x83\x97\xe1\x83\x90\xe1\x83\xa8\xe1\x83\x9d\xe1\x83\xa0"
  "\xe1\x83\x98\xe1\x83\xa1\xe1\x83\x9d\n"
  "  \xe1\x83\x99\xe1\x83\x9d\xe1\x83\x9c\xe1\x83\xa4\xe1\x83\x94\xe1\x83\xa0\xe1\x83"
  "\x94\xe1\x83\x9c\xe1\x83\xaa\xe1\x83\x98\xe1\x83\x90\xe1\x83\x96\xe1\x83\x94 \xe1"
  "\x83\x93\xe1\x83\x90\xe1\x83\xa1\xe1\x83\x90\xe1\x83\xa1\xe1\x83\xac\xe1\x83\xa0"
  "\xe1\x83\x94\xe1\x83\x91\xe1\x83\x90\xe1\x83\x93, \xe1\x83\xa0\xe1\x83\x9d\xe1\x83"
  "\x9b\xe1\x83\x94\xe1\x83\x9a\xe1\x83\x98\xe1\x83\xaa \xe1\x83\x92\xe1\x83\x90\xe1"
  "\x83\x98\xe1\x83\x9b\xe1\x83\x90\xe1\x83\xa0\xe1\x83\x97\xe1\x83\x94\xe1\x83\x91"
  "\xe1\x83\x90 10-12 \xe1\x83\x9b\xe1\x83\x90\xe1\x83\xa0\xe1\x83\xa2\xe1\x83\xa1,"
  "\n"
  "  \xe1\x83\xa5. \xe1\x83\x9b\xe1\x83\x90\xe1\x83\x98\xe1\x83\x9c\xe1\x83\xaa\xe1"
  "\x83\xa8\xe1\x83\x98, \xe1\x83\x92\xe1\x83\x94\xe1\x83\xa0\xe1\x83\x9b\xe1\x83\x90"
  "\xe1\x83\x9c\xe1\x83\x98\xe1\x83\x90\xe1\x83\xa8\xe1\x83\x98. \xe1\x83\x99\xe1\x83"
  "\x9d\xe1\x83\x9c\xe1\x83\xa4\xe1\x83\x94\xe1\x83\xa0\xe1\x83\x94\xe1\x83\x9c\xe1"
  "\x83\xaa\xe1\x83\x98\xe1\x83\x90 \xe1\x83\xa8\xe1\x83\x94\xe1\x83\xb0\xe1\x83\x99"
  "\xe1\x83\xa0\xe1\x83\x94\xe1\x83\x91\xe1\x83\xa1 \xe1\x83\x94\xe1\x83\xa0\xe1\x83"
  "\x97\xe1\x83\x90\xe1\x83\x93 \xe1\x83\x9b\xe1\x83\xa1\xe1\x83\x9d\xe1\x83\xa4\xe1"
  "\x83\x9a\xe1\x83\x98\xe1\x83\x9d\xe1\x83\xa1\n"
  "  \xe1\x83\x94\xe1\x83\xa5\xe1\x83\xa1\xe1\x83\x9e\xe1\x83\x94\xe1\x83\xa0\xe1\x83"
  "\xa2\xe1\x83\x94\xe1\x83\x91\xe1\x83\xa1 \xe1\x83\x98\xe1\x83\xa1\xe1\x83\x94\xe1"
  "\x83\x97 \xe1\x83\x93\xe1\x83\x90\xe1\x83\xa0\xe1\x83\x92\xe1\x83\x94\xe1\x83\x91"
  "\xe1\x83\xa8\xe1\x83\x98 \xe1\x83\xa0\xe1\x83\x9d\xe1\x83\x92\xe1\x83\x9d\xe1\x83"
  "\xa0\xe1\x83\x98\xe1\x83\xaa\xe1\x83\x90\xe1\x83\x90 \xe1\x83\x98\xe1\x83\x9c\xe1"
  "\x83\xa2\xe1\x83\x94\xe1\x83\xa0\xe1\x83\x9c\xe1\x83\x94\xe1\x83\xa2\xe1\x83\x98"
  " \xe1\x83\x93\xe1\x83\x90 Unicode-\xe1\x83\x98,\n"
  "  \xe1\x83\x98\xe1\x83\x9c\xe1\x83\xa2\xe1\x83\x94\xe1\x83\xa0\xe1\x83\x9c\xe1\x83"
  "\x90\xe1\x83\xaa\xe1\x83\x98\xe1\x83\x9d\xe1\x83\x9c\xe1\x83\x90\xe1\x83\x9a\xe1"
  "\x83\x98\xe1\x83\x96\xe1\x83\x90\xe1\x83\xaa\xe1\x83\x98\xe1\x83\x90 \xe1\x83\x93"
  "\xe1\x83\x90 \xe1\x83\x9a\xe1\x83\x9d\xe1\x83\x99\xe1\x83\x90\xe1\x83\x9a\xe1\x83"
  "\x98\xe1\x83\x96\xe1\x83\x90\xe1\x83\xaa\xe1\x83\x98\xe1\x83\x90, Unicode-\xe1\x83"
  "\x98\xe1\x83\xa1 \xe1\x83\x92\xe1\x83\x90\xe1\x83\x9b\xe1\x83\x9d\xe1\x83\xa7\xe1"
  "\x83\x94\xe1\x83\x9c\xe1\x83\x94\xe1\x83\x91\xe1\x83\x90\n"
  "  \xe1\x83\x9d\xe1\x83\x9e\xe1\x83\x94\xe1\x83\xa0\xe1\x83\x90\xe1\x83\xaa\xe1\x83"
  "\x98\xe1\x83\xa3\xe1\x83\x9a \xe1\x83\xa1\xe1\x83\x98\xe1\x83\xa1\xe1\x83\xa2\xe1"
  "\x83\x94\xe1\x83\x9b\xe1\x83\x94\xe1\x83\x91\xe1\x83\xa1\xe1\x83\x90, \xe1\x83\x93"
  "\xe1\x83\x90 \xe1\x83\x92\xe1\x83\x90\xe1\x83\x9b\xe1\x83\x9d\xe1\x83\xa7\xe1\x83"
  "\x94\xe1\x83\x9c\xe1\x83\x94\xe1\x83\x91\xe1\x83\x98\xe1\x83\x97 \xe1\x83\x9e\xe1"
  "\x83\xa0\xe1\x83\x9d\xe1\x83\x92\xe1\x83\xa0\xe1\x83\x90\xe1\x83\x9b\xe1\x83\x94"
  "\xe1\x83\x91\xe1\x83\xa8\xe1\x83\x98, \xe1\x83\xa8\xe1\x83\xa0\xe1\x83\x98\xe1\x83"
  "\xa4\xe1\x83\xa2\xe1\x83\x94\xe1\x83\x91\xe1\x83\xa8\xe1\x83\x98,\n"
  "  \xe1\x83\xa2\xe1\x83\x94\xe1\x83\xa5\xe1\x83\xa1\xe1\x83\xa2\xe1\x83\x94\xe1\x83"
  "\x91\xe1\x83\x98\xe1\x83\xa1 \xe1\x83\x93\xe1\x83\x90\xe1\x83\x9b\xe1\x83\xa3\xe1"
  "\x83\xa8\xe1\x83\x90\xe1\x83\x95\xe1\x83\x94\xe1\x83\x91\xe1\x83\x90\xe1\x83\xa1"
  "\xe1\x83\x90 \xe1\x83\x93\xe1\x83\x90 \xe1\x83\x9b\xe1\x83\xa0\xe1\x83\x90\xe1\x83"
  "\x95\xe1\x83\x90\xe1\x83\x9a\xe1\x83\x94\xe1\x83\x9c\xe1\x83\x9d\xe1\x83\x95\xe1"
  "\x83\x90\xe1\x83\x9c \xe1\x83\x99\xe1\x83\x9d\xe1\x83\x9b\xe1\x83\x9e\xe1\x83\x98"
  "\xe1\x83\xa3\xe1\x83\xa2\xe1\x83\x94\xe1\x83\xa0\xe1\x83\xa3\xe1\x83\x9a \xe1\x83"
  "\xa1\xe1\x83\x98\xe1\x83\xa1\xe1\x83\xa2\xe1\x83\x94\xe1\x83\x9b\xe1\x83\x94\xe1"
  "\x83\x91\xe1\x83\xa8\xe1\x83\x98.\n"
  "\n"
  "Russian:\n"
  "\n"
  "  From a Unicode conference invitation:\n"
  "\n"
  "  \xd0\x97\xd0\xb0\xd1\x80\xd0\xb5\xd0\xb3\xd0\xb8\xd1\x81\xd1\x82\xd1\x80\xd0\xb8"
  "\xd1\x80\xd1\x83\xd0\xb9\xd1\x82\xd0\xb5\xd1\x81\xd1\x8c \xd1\x81\xd0\xb5\xd0\xb9"
  "\xd1\x87\xd0\xb0\xd1\x81 \xd0\xbd\xd0\xb0 \xd0\x94\xd0\xb5\xd1\x81\xd1\x8f\xd1\x82"
  "\xd1\x83\xd1\x8e \xd0\x9c\xd0\xb5\xd0\xb6\xd0\xb4\xd1\x83\xd0\xbd\xd0\xb0\xd1\x80"
  "\xd0\xbe\xd0\xb4\xd0\xbd\xd1\x83\xd1\x8e \xd0\x9a\xd0\xbe\xd0\xbd\xd1\x84\xd0\xb5"
  "\xd1\x80\xd0\xb5\xd0\xbd\xd1\x86\xd0\xb8\xd1\x8e \xd0\xbf\xd0\xbe\n"
  "  Unicode, \xd0\xba\xd0\xbe\xd1\x82\xd0\xbe\xd1\x80\xd0\xb0\xd1\x8f \xd1\x81\xd0"
  "\xbe\xd1\x81\xd1\x82\xd0\xbe\xd0\xb8\xd1\x82\xd1\x81\xd1\x8f 10-12 \xd0\xbc\xd0\xb0"
  "\xd1\x80\xd1\x82\xd0\xb0 1997 \xd0\xb3\xd0\xbe\xd0\xb4\xd0\xb0 \xd0\xb2 \xd0\x9c"
  "\xd0\xb0\xd0\xb9\xd0\xbd\xd1\x86\xd0\xb5 \xd0\xb2 \xd0\x93\xd0\xb5\xd1\x80\xd0\xbc"
  "\xd0\xb0\xd0\xbd\xd0\xb8\xd0\xb8.\n"
  "  \xd0\x9a\xd0\xbe\xd0\xbd\xd1\x84\xd0\xb5\xd1\x80\xd0\xb5\xd0\xbd\xd1\x86\xd0\xb8"
  "\xd1\x8f \xd1\x81\xd0\xbe\xd0\xb1\xd0\xb5\xd1\x80\xd0\xb5\xd1\x82 \xd1\x88\xd0\xb8"
  "\xd1\x80\xd0\xbe\xd0\xba\xd0\xb8\xd0\xb9 \xd0\xba\xd1\x80\xd1\x83\xd0\xb3 \xd1\x8d"
  "\xd0\xba\xd1\x81\xd0\xbf\xd0\xb5\xd1\x80\xd1\x82\xd0\xbe\xd0\xb2 \xd0\xbf\xd0\xbe"
  "  \xd0\xb2\xd0\xbe\xd0\xbf\xd1\x80\xd0\xbe\xd1\x81\xd0\xb0\xd0\xbc \xd0\xb3\xd0\xbb"
  "\xd0\xbe\xd0\xb1\xd0\xb0\xd0\xbb\xd1\x8c\xd0\xbd\xd0\xbe\xd0\xb3\xd0\xbe\n"
  "  \xd0\x98\xd0\xbd\xd1\x82\xd0\xb5\xd1\x80\xd0\xbd\xd0\xb5\xd1\x82\xd0\xb0 \xd0\xb8"
  " Unicode, \xd0\xbb\xd0\xbe\xd0\xba\xd0\xb0\xd0\xbb\xd0\xb8\xd0\xb7\xd0\xb0\xd1\x86"
  "\xd0\xb8\xd0\xb8 \xd0\xb8 \xd0\xb8\xd0\xbd\xd1\x82\xd0\xb5\xd1\x80\xd0\xbd\xd0\xb0"
  "\xd1\x86\xd0\xb8\xd0\xbe\xd0\xbd\xd0\xb0\xd0\xbb\xd0\xb8\xd0\xb7\xd0\xb0\xd1\x86"
  "\xd0\xb8\xd0\xb8, \xd0\xb2\xd0\xbe\xd0\xbf\xd0\xbb\xd0\xbe\xd1\x89\xd0\xb5\xd0\xbd"
  "\xd0\xb8\xd1\x8e \xd0\xb8\n"
  "  \xd0\xbf\xd1\x80\xd0\xb8\xd0\xbc\xd0\xb5\xd0\xbd\xd0\xb5\xd0\xbd\xd0\xb8\xd1\x8e"
  " Unicode \xd0\xb2 \xd1\x80\xd0\xb0\xd0\xb7\xd0\xbb\xd0\xb8\xd1\x87\xd0\xbd\xd1\x8b"
  "\xd1\x85 \xd0\xbe\xd0\xbf\xd0\xb5\xd1\x80\xd0\xb0\xd1\x86\xd0\xb8\xd0\xbe\xd0\xbd"
  "\xd0\xbd\xd1\x8b\xd1\x85 \xd1\x81\xd0\xb8\xd1\x81\xd1\x82\xd0\xb5\xd0\xbc\xd0\xb0"
  "\xd1\x85 \xd0\xb8 \xd0\xbf\xd1\x80\xd0\xbe\xd0\xb3\xd1\x80\xd0\xb0\xd0\xbc\xd0\xbc"
  "\xd0\xbd\xd1\x8b\xd1\x85\n"
  "  \xd0\xbf\xd1\x80\xd0\xb8\xd0\xbb\xd0\xbe\xd0\xb6\xd0\xb5\xd0\xbd\xd0\xb8\xd1\x8f"
  "\xd1\x85, \xd1\x88\xd1\x80\xd0\xb8\xd1\x84\xd1\x82\xd0\xb0\xd1\x85, \xd0\xb2\xd0"
  "\xb5\xd1\x80\xd1\x81\xd1\x82\xd0\xba\xd0\xb5 \xd0\xb8 \xd0\xbc\xd0\xbd\xd0\xbe\xd0"
  "\xb3\xd0\xbe\xd1\x8f\xd0\xb7\xd1\x8b\xd1\x87\xd0\xbd\xd1\x8b\xd1\x85 \xd0\xba\xd0"
  "\xbe\xd0\xbc\xd0\xbf\xd1\x8c\xd1\x8e\xd1\x82\xd0\xb5\xd1\x80\xd0\xbd\xd1\x8b\xd1"
  "\x85 \xd1\x81\xd0\xb8\xd1\x81\xd1\x82\xd0\xb5\xd0\xbc\xd0\xb0\xd1\x85.\n"
  "\n"
  "Thai (UCS Level 2):\n"
  "\n"
  "  Excerpt from a poetry on The Romance of The Three Kingdoms (a Chinese\n"
  "  classic 'San Gua'):\n"
  "\n"
  "  [----------------------------|------------------------]\n"
  "    \xe0\xb9\x8f \xe0\xb9\x81\xe0\xb8\x9c\xe0\xb9\x88\xe0\xb8\x99\xe0\xb8\x94\xe0"
  "\xb8\xb4\xe0\xb8\x99\xe0\xb8\xae\xe0\xb8\xb1\xe0\xb9\x88\xe0\xb8\x99\xe0\xb9\x80"
  "\xe0\xb8\xaa\xe0\xb8\xb7\xe0\xb9\x88\xe0\xb8\xad\xe0\xb8\xa1\xe0\xb9\x82\xe0\xb8"
  "\x97\xe0\xb8\xa3\xe0\xb8\xa1\xe0\xb9\x81\xe0\xb8\xaa\xe0\xb8\x99\xe0\xb8\xaa\xe0"
  "\xb8\xb1\xe0\xb8\x87\xe0\xb9\x80\xe0\xb8\xa7\xe0\xb8\x8a  \xe0\xb8\x9e\xe0\xb8\xa3"
  "\xe0\xb8\xb0\xe0\xb8\x9b\xe0\xb8\x81\xe0\xb9\x80\xe0\xb8\x81\xe0\xb8\xa8\xe0\xb8"
  "\x81\xe0\xb8\xad\xe0\xb8\x87\xe0\xb8\x9a\xe0\xb8\xb9\xe0\xb9\x8a\xe0\xb8\x81\xe0"
  "\xb8\xb9\xe0\xb9\x89\xe0\xb8\x82\xe0\xb8\xb6\xe0\xb9\x89\xe0\xb8\x99\xe0\xb9\x83"
  "\xe0\xb8\xab\xe0\xb8\xa1\xe0\xb9\x88\n"
  "  \xe0\xb8\xaa\xe0\xb8\xb4\xe0\xb8\x9a\xe0\xb8\xaa\xe0\xb8\xad\xe0\xb8\x87\xe0\xb8"
  "\x81\xe0\xb8\xa9\xe0\xb8\xb1\xe0\xb8\x95\xe0\xb8\xa3\xe0\xb8\xb4\xe0\xb8\xa2\xe0"
  "\xb9\x8c\xe0\xb8\x81\xe0\xb9\x88\xe0\xb8\xad\xe0\xb8\x99\xe0\xb8\xab\xe0\xb8\x99"
  "\xe0\xb9\x89\xe0\xb8\xb2\xe0\xb9\x81\xe0\xb8\xa5\xe0\xb8\x96\xe0\xb8\xb1\xe0\xb8"
  "\x94\xe0\xb9\x84\xe0\xb8\x9b       \xe0\xb8\xaa\xe0\xb8\xad\xe0\xb8\x87\xe0\xb8\xad"
  "\xe0\xb8\x87\xe0\xb8\x84\xe0\xb9\x8c\xe0\xb9\x84\xe0\xb8\x8b\xe0\xb8\xa3\xe0\xb9"
  "\x89\xe0\xb9\x82\xe0\xb8\x87\xe0\xb9\x88\xe0\xb9\x80\xe0\xb8\x82\xe0\xb8\xa5\xe0"
  "\xb8\xb2\xe0\xb9\x80\xe0\xb8\x9a\xe0\xb8\xb2\xe0\xb8\x9b\xe0\xb8\xb1\xe0\xb8\x8d"
  "\xe0\xb8\x8d\xe0\xb8\xb2\n"
  "    \xe0\xb8\x97\xe0\xb8\xa3\xe0\xb8\x87\xe0\xb8\x99\xe0\xb8\xb1\xe0\xb8\x9a\xe0"
  "\xb8\x96\xe0\xb8\xb7\xe0\xb8\xad\xe0\xb8\x82\xe0\xb8\xb1\xe0\xb8\x99\xe0\xb8\x97"
  "\xe0\xb8\xb5\xe0\xb9\x80\xe0\xb8\x9b\xe0\xb9\x87\xe0\xb8\x99\xe0\xb8\x97\xe0\xb8"
  "\xb5\xe0\xb9\x88\xe0\xb8\x9e\xe0\xb8\xb6\xe0\xb9\x88\xe0\xb8\x87           \xe0\xb8"
  "\x9a\xe0\xb9\x89\xe0\xb8\xb2\xe0\xb8\x99\xe0\xb9\x80\xe0\xb8\xa1\xe0\xb8\xb7\xe0"
  "\xb8\xad\xe0\xb8\x87\xe0\xb8\x88\xe0\xb8\xb6\xe0\xb8\x87\xe0\xb8\xa7\xe0\xb8\xb4"
  "\xe0\xb8\x9b\xe0\xb8\xa3\xe0\xb8\xb4\xe0\xb8\x95\xe0\xb9\x80\xe0\xb8\x9b\xe0\xb9"
  "\x87\xe0\xb8\x99\xe0\xb8\x99\xe0\xb8\xb1\xe0\xb8\x81\xe0\xb8\xab\xe0\xb8\x99\xe0"
  "\xb8\xb2\n"
  "  \xe0\xb9\x82\xe0\xb8\xae\xe0\xb8\x88\xe0\xb8\xb4\xe0\xb9\x8b\xe0\xb8\x99\xe0\xb9"
  "\x80\xe0\xb8\xa3\xe0\xb8\xb5\xe0\xb8\xa2\xe0\xb8\x81\xe0\xb8\x97\xe0\xb8\xb1\xe0"
  "\xb8\x9e\xe0\xb8\x97\xe0\xb8\xb1\xe0\xb9\x88\xe0\xb8\xa7\xe0\xb8\xab\xe0\xb8\xb1"
  "\xe0\xb8\xa7\xe0\xb9\x80\xe0\xb8\xa1\xe0\xb8\xb7\xe0\xb8\xad\xe0\xb8\x87\xe0\xb8"
  "\xa1\xe0\xb8\xb2         \xe0\xb8\xab\xe0\xb8\xa1\xe0\xb8\xb2\xe0\xb8\xa2\xe0\xb8"
  "\x88\xe0\xb8\xb0\xe0\xb8\x86\xe0\xb9\x88\xe0\xb8\xb2\xe0\xb8\xa1\xe0\xb8\x94\xe0"
  "\xb8\x8a\xe0\xb8\xb1\xe0\xb9\x88\xe0\xb8\xa7\xe0\xb8\x95\xe0\xb8\xb1\xe0\xb8\xa7"
  "\xe0\xb8\xaa\xe0\xb8\xb3\xe0\xb8\x84\xe0\xb8\xb1\xe0\xb8\x8d\n"
  "    \xe0\xb9\x80\xe0\xb8\xab\xe0\xb8\xa1\xe0\xb8\xb7\xe0\xb8\xad\xe0\xb8\x99\xe0"
  "\xb8\x82\xe0\xb8\xb1\xe0\xb8\x9a\xe0\xb9\x84\xe0\xb8\xaa\xe0\xb9\x84\xe0\xb8\xa5"
  "\xe0\xb9\x88\xe0\xb9\x80\xe0\xb8\xaa\xe0\xb8\xb7\xe0\xb8\xad\xe0\xb8\x88\xe0\xb8"
  "\xb2\xe0\xb8\x81\xe0\xb9\x80\xe0\xb8\x84\xe0\xb8\xab\xe0\xb8\xb2      \xe0\xb8\xa3"
  "\xe0\xb8\xb1\xe0\xb8\x9a\xe0\xb8\xab\xe0\xb8\xa1\xe0\xb8\xb2\xe0\xb8\x9b\xe0\xb9"
  "\x88\xe0\xb8\xb2\xe0\xb9\x80\xe0\xb8\x82\xe0\xb9\x89\xe0\xb8\xb2\xe0\xb8\xa1\xe0"
  "\xb8\xb2\xe0\xb9\x80\xe0\xb8\xa5\xe0\xb8\xa2\xe0\xb8\xad\xe0\xb8\xb2\xe0\xb8\xaa"
  "\xe0\xb8\xb1\xe0\xb8\x8d\n"
  "  \xe0\xb8\x9d\xe0\xb9\x88\xe0\xb8\xb2\xe0\xb8\xa2\xe0\xb8\xad\xe0\xb9\x89\xe0\xb8"
  "\xad\xe0\xb8\x87\xe0\xb8\xad\xe0\xb8\xb8\xe0\xb9\x89\xe0\xb8\x99\xe0\xb8\xa2\xe0"
  "\xb8\xb8\xe0\xb9\x81\xe0\xb8\xa2\xe0\xb8\x81\xe0\xb9\x83\xe0\xb8\xab\xe0\xb9\x89"
  "\xe0\xb9\x81\xe0\xb8\x95\xe0\xb8\x81\xe0\xb8\x81\xe0\xb8\xb1\xe0\xb8\x99        "
  "  \xe0\xb9\x83\xe0\xb8\x8a\xe0\xb9\x89\xe0\xb8\xaa\xe0\xb8\xb2\xe0\xb8\xa7\xe0\xb8"
  "\x99\xe0\xb8\xb1\xe0\xb9\x89\xe0\xb8\x99\xe0\xb9\x80\xe0\xb8\x9b\xe0\xb9\x87\xe0"
  "\xb8\x99\xe0\xb8\x8a\xe0\xb8\x99\xe0\xb8\xa7\xe0\xb8\x99\xe0\xb8\x8a\xe0\xb8\xb7"
  "\xe0\xb9\x88\xe0\xb8\x99\xe0\xb8\x8a\xe0\xb8\xa7\xe0\xb8\x99\xe0\xb9\x83\xe0\xb8"
  "\x88\n"
  "    \xe0\xb8\x9e\xe0\xb8\xa5\xe0\xb8\xb1\xe0\xb8\x99\xe0\xb8\xa5\xe0\xb8\xb4\xe0"
  "\xb8\x89\xe0\xb8\xb8\xe0\xb8\xa2\xe0\xb8\x81\xe0\xb8\xb8\xe0\xb8\xa2\xe0\xb8\x81"
  "\xe0\xb8\xb5\xe0\xb8\x81\xe0\xb8\xa5\xe0\xb8\xb1\xe0\xb8\x9a\xe0\xb8\x81\xe0\xb9"
  "\x88\xe0\xb8\xad\xe0\xb9\x80\xe0\xb8\xab\xe0\xb8\x95\xe0\xb8\xb8          \xe0\xb8"
  "\x8a\xe0\xb9\x88\xe0\xb8\xb2\xe0\xb8\x87\xe0\xb8\xad\xe0\xb8\xb2\xe0\xb9\x80\xe0"
  "\xb8\x9e\xe0\xb8\xa8\xe0\xb8\x88\xe0\xb8\xa3\xe0\xb8\xb4\xe0\xb8\x87\xe0\xb8\xab"
  "\xe0\xb8\x99\xe0\xb8\xb2\xe0\xb8\x9f\xe0\xb9\x89\xe0\xb8\xb2\xe0\xb8\xa3\xe0\xb9"
  "\x89\xe0\xb8\xad\xe0\xb8\x87\xe0\xb9\x84\xe0\xb8\xab\xe0\xb9\x89\n"
  "  \xe0\xb8\x95\xe0\xb9\x89\xe0\xb8\xad\xe0\xb8\x87\xe0\xb8\xa3\xe0\xb8\x9a\xe0\xb8"
  "\xa3\xe0\xb8\xb2\xe0\xb8\x86\xe0\xb9\x88\xe0\xb8\xb2\xe0\xb8\x9f\xe0\xb8\xb1\xe0"
  "\xb8\x99\xe0\xb8\x88\xe0\xb8\x99\xe0\xb8\x9a\xe0\xb8\xa3\xe0\xb8\xa3\xe0\xb8\xa5"
  "\xe0\xb8\xb1\xe0\xb8\xa2           \xe0\xb8\xa4\xe0\xb9\x85\xe0\xb8\xab\xe0\xb8\xb2"
  "\xe0\xb9\x83\xe0\xb8\x84\xe0\xb8\xa3\xe0\xb8\x84\xe0\xb9\x89\xe0\xb8\xb3\xe0\xb8"
  "\x8a\xe0\xb8\xb9\xe0\xb8\x81\xe0\xb8\xb9\xe0\xb9\x89\xe0\xb8\x9a\xe0\xb8\xa3\xe0"
  "\xb8\xa3\xe0\xb8\xa5\xe0\xb8\xb1\xe0\xb8\x87\xe0\xb8\x81\xe0\xb9\x8c \xe0\xb8\xaf"
  "\n"
  "\n"
  "  (The above is a two-column text. If combining characters are handled\n"
  "  correctly, the lines of the second column should be aligned with the\n"
  "  | character above.)\n"
  "\n"
  "Ethiopian:\n"
  "\n"
  "  Proverbs in the Amharic language:\n"
  "\n"
  "  \xe1\x88\xb0\xe1\x88\x9b\xe1\x8b\xad \xe1\x8a\xa0\xe1\x8b\xad\xe1\x89\xb3\xe1\x88"
  "\xa8\xe1\x88\xb5 \xe1\x8a\x95\xe1\x8c\x89\xe1\x88\xa5 \xe1\x8a\xa0\xe1\x8b\xad\xe1"
  "\x8a\xa8\xe1\x88\xb0\xe1\x88\xb5\xe1\x8d\xa2\n"
  "  \xe1\x89\xa5\xe1\x88\x8b \xe1\x8a\xab\xe1\x88\x88\xe1\x8a\x9d \xe1\x8a\xa5\xe1"
  "\x8a\x95\xe1\x8b\xb0\xe1\x8a\xa0\xe1\x89\xa3\xe1\x89\xb4 \xe1\x89\xa0\xe1\x89\x86"
  "\xe1\x88\x98\xe1\x8c\xa0\xe1\x8a\x9d\xe1\x8d\xa2\n"
  "  \xe1\x8c\x8c\xe1\x8c\xa5 \xe1\x8b\xab\xe1\x88\x88\xe1\x89\xa4\xe1\x89\xb1 \xe1"
  "\x89\x81\xe1\x88\x9d\xe1\x8c\xa5\xe1\x8a\x93 \xe1\x8a\x90\xe1\x8b\x8d\xe1\x8d\xa2"
  "\n"
  "  \xe1\x8b\xb0\xe1\x88\x80 \xe1\x89\xa0\xe1\x88\x95\xe1\x88\x8d\xe1\x88\x99 \xe1"
  "\x89\x85\xe1\x89\xa4 \xe1\x89\xa3\xe1\x8b\xad\xe1\x8c\xa0\xe1\x8c\xa3 \xe1\x8a\x95"
  "\xe1\x8c\xa3\xe1\x89\xb5 \xe1\x89\xa0\xe1\x8c\x88\xe1\x8b\xb0\xe1\x88\x88\xe1\x8b"
  "\x8d\xe1\x8d\xa2\n"
  "  \xe1\x8b\xa8\xe1\x8a\xa0\xe1\x8d\x8d \xe1\x8b\x88\xe1\x88\x88\xe1\x88\x9d\xe1\x89"
  "\xb3 \xe1\x89\xa0\xe1\x89\x85\xe1\x89\xa4 \xe1\x8a\xa0\xe1\x8b\xad\xe1\x89\xb3\xe1"
  "\x88\xbd\xe1\x88\x9d\xe1\x8d\xa2\n"
  "  \xe1\x8a\xa0\xe1\x8b\xad\xe1\x8c\xa5 \xe1\x89\xa0\xe1\x89\xa0\xe1\x88\x8b \xe1"
  "\x8b\xb3\xe1\x8b\x8b \xe1\x89\xb0\xe1\x88\x98\xe1\x89\xb3\xe1\x8d\xa2\n"
  "  \xe1\x88\xb2\xe1\x89\xb0\xe1\x88\xa8\xe1\x8c\x89\xe1\x88\x99 \xe1\x8b\xad\xe1\x8b"
  "\xb0\xe1\x88\xa8\xe1\x8c\x8d\xe1\x88\x99\xe1\x8d\xa2\n"
  "  \xe1\x89\x80\xe1\x88\xb5 \xe1\x89\xa0\xe1\x89\x80\xe1\x88\xb5\xe1\x8d\xa5 \xe1"
  "\x8b\x95\xe1\x8a\x95\xe1\x89\x81\xe1\x88\x8b\xe1\x88\x8d \xe1\x89\xa0\xe1\x8a\xa5"
  "\xe1\x8c\x8d\xe1\x88\xa9 \xe1\x8b\xad\xe1\x88\x84\xe1\x8b\xb3\xe1\x88\x8d\xe1\x8d"
  "\xa2\n"
  "  \xe1\x8b\xb5\xe1\x88\xad \xe1\x89\xa2\xe1\x8b\xab\xe1\x89\xa5\xe1\x88\xad \xe1"
  "\x8a\xa0\xe1\x8a\x95\xe1\x89\xa0\xe1\x88\xb3 \xe1\x8b\xab\xe1\x88\xb5\xe1\x88\xad"
  "\xe1\x8d\xa2\n"
  "  \xe1\x88\xb0\xe1\x8b\x8d \xe1\x8a\xa5\xe1\x8a\x95\xe1\x8b\xb0\xe1\x89\xa4\xe1\x89"
  "\xb1 \xe1\x8a\xa5\xe1\x8a\x95\xe1\x8c\x85 \xe1\x8a\xa5\xe1\x8a\x95\xe1\x8b\xb0 \xe1"
  "\x8c\x89\xe1\x88\xa8\xe1\x89\xa4\xe1\x89\xb1 \xe1\x8a\xa0\xe1\x8b\xad\xe1\x89\xb0"
  "\xe1\x8b\xb3\xe1\x8b\xb0\xe1\x88\xad\xe1\x88\x9d\xe1\x8d\xa2\n"
  "  \xe1\x8a\xa5\xe1\x8c\x8d\xe1\x8b\x9c\xe1\x88\xad \xe1\x8b\xa8\xe1\x8a\xa8\xe1\x8d"
  "\x88\xe1\x89\xb0\xe1\x8b\x8d\xe1\x8a\x95 \xe1\x8c\x89\xe1\x88\xae\xe1\x88\xae \xe1"
  "\x88\xb3\xe1\x8b\xad\xe1\x8b\x98\xe1\x8c\x8b\xe1\x8b\x8d \xe1\x8a\xa0\xe1\x8b\xad"
  "\xe1\x8b\xb5\xe1\x88\xad\xe1\x88\x9d\xe1\x8d\xa2\n"
  "  \xe1\x8b\xa8\xe1\x8c\x8e\xe1\x88\xa8\xe1\x89\xa4\xe1\x89\xb5 \xe1\x88\x8c\xe1\x89"
  "\xa3\xe1\x8d\xa5 \xe1\x89\xa2\xe1\x8b\xab\xe1\x8b\xa9\xe1\x89\xb5 \xe1\x8b\xad\xe1"
  "\x88\xb5\xe1\x89\x85 \xe1\x89\xa3\xe1\x8b\xab\xe1\x8b\xa9\xe1\x89\xb5 \xe1\x8b\xab"
  "\xe1\x8c\xa0\xe1\x88\x8d\xe1\x89\x85\xe1\x8d\xa2\n"
  "  \xe1\x88\xa5\xe1\x88\xab \xe1\x8a\xa8\xe1\x88\x98\xe1\x8d\x8d\xe1\x89\xb3\xe1\x89"
  "\xb5 \xe1\x88\x8d\xe1\x8c\x84\xe1\x8a\x95 \xe1\x88\x8b\xe1\x8d\x8b\xe1\x89\xb3\xe1"
  "\x89\xb5\xe1\x8d\xa2\n"
  "  \xe1\x8b\x93\xe1\x89\xa3\xe1\x8b\xad \xe1\x88\x9b\xe1\x8b\xb0\xe1\x88\xaa\xe1\x8b"
  "\xab \xe1\x8b\xa8\xe1\x88\x88\xe1\x8b\x8d\xe1\x8d\xa5 \xe1\x8c\x8d\xe1\x8a\x95\xe1"
  "\x8b\xb5 \xe1\x8b\xad\xe1\x8b\x9e \xe1\x8b\xad\xe1\x8b\x9e\xe1\x88\xab\xe1\x88\x8d"
  "\xe1\x8d\xa2\n"
  "  \xe1\x8b\xa8\xe1\x8a\xa5\xe1\x88\xb5\xe1\x88\x8b\xe1\x88\x9d \xe1\x8a\xa0\xe1\x8c"
  "\x88\xe1\x88\xa9 \xe1\x88\x98\xe1\x8a\xab \xe1\x8b\xa8\xe1\x8a\xa0\xe1\x88\x9e\xe1"
  "\x88\xab \xe1\x8a\xa0\xe1\x8c\x88\xe1\x88\xa9 \xe1\x8b\x8b\xe1\x88\xad\xe1\x8a\xab"
  "\xe1\x8d\xa2\n"
  "  \xe1\x89\xb0\xe1\x8a\x95\xe1\x8c\x8b\xe1\x88\x8e \xe1\x89\xa2\xe1\x89\xb0\xe1\x8d"
  "\x89 \xe1\x89\xb0\xe1\x88\x98\xe1\x88\x8d\xe1\x88\xb6 \xe1\x89\xa3\xe1\x8d\x89\xe1"
  "\x8d\xa2\n"
  "  \xe1\x8b\x88\xe1\x8b\xb3\xe1\x8c\x85\xe1\x88\x85 \xe1\x88\x9b\xe1\x88\xad \xe1"
  "\x89\xa2\xe1\x88\x86\xe1\x8a\x95 \xe1\x8c\xa8\xe1\x88\xad\xe1\x88\xb5\xe1\x88\x85"
  " \xe1\x8a\xa0\xe1\x89\xb5\xe1\x88\x8b\xe1\x88\xb0\xe1\x8b\x8d\xe1\x8d\xa2\n"
  "  \xe1\x8a\xa5\xe1\x8c\x8d\xe1\x88\xad\xe1\x88\x85\xe1\x8a\x95 \xe1\x89\xa0\xe1\x8d"
  "\x8d\xe1\x88\xab\xe1\x88\xbd\xe1\x88\x85 \xe1\x88\x8d\xe1\x8a\xad \xe1\x8b\x98\xe1"
  "\x88\xad\xe1\x8c\x8b\xe1\x8d\xa2\n"
  "\n"
  "Runes:\n"
  "\n"
  "  \xe1\x9a\xbb\xe1\x9b\x96 \xe1\x9a\xb3\xe1\x9a\xb9\xe1\x9a\xab\xe1\x9a\xa6 \xe1"
  "\x9a\xa6\xe1\x9a\xab\xe1\x9b\x8f \xe1\x9a\xbb\xe1\x9b\x96 \xe1\x9b\x92\xe1\x9a\xa2"
  "\xe1\x9b\x9e\xe1\x9b\x96 \xe1\x9a\xa9\xe1\x9a\xbe \xe1\x9a\xa6\xe1\x9a\xab\xe1\x9b"
  "\x97 \xe1\x9b\x9a\xe1\x9a\xaa\xe1\x9a\xbe\xe1\x9b\x9e\xe1\x9b\x96 \xe1\x9a\xbe\xe1"
  "\x9a\xa9\xe1\x9a\xb1\xe1\x9a\xa6\xe1\x9a\xb9\xe1\x9b\x96\xe1\x9a\xaa\xe1\x9a\xb1"
  "\xe1\x9b\x9e\xe1\x9a\xa2\xe1\x9b\x97 \xe1\x9a\xb9\xe1\x9b\x81\xe1\x9a\xa6 \xe1\x9a"
  "\xa6\xe1\x9a\xaa \xe1\x9a\xb9\xe1\x9b\x96\xe1\x9b\xa5\xe1\x9a\xab\n"
  "\n"
  "  (Old English, which transcribed into Latin reads 'He cwaeth that he\n"
  "  bude thaem lande northweardum with tha Westsae.' and means 'He said\n"
  "  that he lived in the northern land near the Western Sea.')\n"
  "\n"
  "Braille:\n"
  "\n"
  "  \xe2\xa1\x8c\xe2\xa0\x81\xe2\xa0\xa7\xe2\xa0\x91 \xe2\xa0\xbc\xe2\xa0\x81\xe2\xa0"
  "\x92  \xe2\xa1\x8d\xe2\xa0\x9c\xe2\xa0\x87\xe2\xa0\x91\xe2\xa0\xb9\xe2\xa0\xb0\xe2"
  "\xa0\x8e \xe2\xa1\xa3\xe2\xa0\x95\xe2\xa0\x8c\n"
  "\n"
  "  \xe2\xa1\x8d\xe2\xa0\x9c\xe2\xa0\x87\xe2\xa0\x91\xe2\xa0\xb9 \xe2\xa0\xba\xe2\xa0"
  "\x81\xe2\xa0\x8e \xe2\xa0\x99\xe2\xa0\x91\xe2\xa0\x81\xe2\xa0\x99\xe2\xa0\x92 \xe2"
  "\xa0\x9e\xe2\xa0\x95 \xe2\xa0\x83\xe2\xa0\x91\xe2\xa0\x9b\xe2\xa0\x94 \xe2\xa0\xba"
  "\xe2\xa0\x8a\xe2\xa0\xb9\xe2\xa0\xb2 \xe2\xa1\xb9\xe2\xa0\xbb\xe2\xa0\x91 \xe2\xa0"
  "\x8a\xe2\xa0\x8e \xe2\xa0\x9d\xe2\xa0\x95 \xe2\xa0\x99\xe2\xa0\xb3\xe2\xa0\x83\xe2"
  "\xa0\x9e\n"
  "  \xe2\xa0\xb1\xe2\xa0\x81\xe2\xa0\x9e\xe2\xa0\x91\xe2\xa0\xa7\xe2\xa0\xbb \xe2\xa0"
  "\x81\xe2\xa0\x83\xe2\xa0\xb3\xe2\xa0\x9e \xe2\xa0\xb9\xe2\xa0\x81\xe2\xa0\x9e\xe2"
  "\xa0\xb2 \xe2\xa1\xb9\xe2\xa0\x91 \xe2\xa0\x97\xe2\xa0\x91\xe2\xa0\x9b\xe2\xa0\x8a"
  "\xe2\xa0\x8c\xe2\xa0\xbb \xe2\xa0\x95\xe2\xa0\x8b \xe2\xa0\x99\xe2\xa0\x8a\xe2\xa0"
  "\x8e \xe2\xa0\x83\xe2\xa0\xa5\xe2\xa0\x97\xe2\xa0\x8a\xe2\xa0\x81\xe2\xa0\x87 \xe2"
  "\xa0\xba\xe2\xa0\x81\xe2\xa0\x8e\n"
  "  \xe2\xa0\x8e\xe2\xa0\x8a\xe2\xa0\x9b\xe2\xa0\x9d\xe2\xa0\xab \xe2\xa0\x83\xe2\xa0"
  "\xb9 \xe2\xa0\xb9\xe2\xa0\x91 \xe2\xa0\x8a\xe2\xa0\x87\xe2\xa0\xbb\xe2\xa0\x9b\xe2"
  "\xa0\xb9\xe2\xa0\x8d\xe2\xa0\x81\xe2\xa0\x9d\xe2\xa0\x82 \xe2\xa0\xb9\xe2\xa0\x91"
  " \xe2\xa0\x8a\xe2\xa0\x87\xe2\xa0\xbb\xe2\xa0\x85\xe2\xa0\x82 \xe2\xa0\xb9\xe2\xa0"
  "\x91 \xe2\xa0\xa5\xe2\xa0\x9d\xe2\xa0\x99\xe2\xa0\xbb\xe2\xa0\x9e\xe2\xa0\x81\xe2"
  "\xa0\x85\xe2\xa0\xbb\xe2\xa0\x82\n"
  "  \xe2\xa0\x81\xe2\xa0\x9d\xe2\xa0\x99 \xe2\xa0\xb9\xe2\xa0\x91 \xe2\xa0\xa1\xe2"
  "\xa0\x8a\xe2\xa0\x91\xe2\xa0\x8b \xe2\xa0\x8d\xe2\xa0\xb3\xe2\xa0\x97\xe2\xa0\x9d"
  "\xe2\xa0\xbb\xe2\xa0\xb2 \xe2\xa1\x8e\xe2\xa0\x8a\xe2\xa0\x97\xe2\xa0\x95\xe2\xa0"
  "\x95\xe2\xa0\x9b\xe2\xa0\x91 \xe2\xa0\x8e\xe2\xa0\x8a\xe2\xa0\x9b\xe2\xa0\x9d\xe2"
  "\xa0\xab \xe2\xa0\x8a\xe2\xa0\x9e\xe2\xa0\xb2 \xe2\xa1\x81\xe2\xa0\x9d\xe2\xa0\x99"
  "\n"
  "  \xe2\xa1\x8e\xe2\xa0\x8a\xe2\xa0\x97\xe2\xa0\x95\xe2\xa0\x95\xe2\xa0\x9b\xe2\xa0"
  "\x91\xe2\xa0\xb0\xe2\xa0\x8e \xe2\xa0\x9d\xe2\xa0\x81\xe2\xa0\x8d\xe2\xa0\x91 \xe2"
  "\xa0\xba\xe2\xa0\x81\xe2\xa0\x8e \xe2\xa0\x9b\xe2\xa0\x95\xe2\xa0\x95\xe2\xa0\x99"
  " \xe2\xa0\xa5\xe2\xa0\x8f\xe2\xa0\x95\xe2\xa0\x9d \xe2\xa0\xb0\xe2\xa1\xa1\xe2\xa0"
  "\x81\xe2\xa0\x9d\xe2\xa0\x9b\xe2\xa0\x91\xe2\xa0\x82 \xe2\xa0\x8b\xe2\xa0\x95\xe2"
  "\xa0\x97 \xe2\xa0\x81\xe2\xa0\x9d\xe2\xa0\xb9\xe2\xa0\xb9\xe2\xa0\x94\xe2\xa0\x9b"
  " \xe2\xa0\x99\xe2\xa0\x91 \n"
  "  \xe2\xa0\xa1\xe2\xa0\x95\xe2\xa0\x8e\xe2\xa0\x91 \xe2\xa0\x9e\xe2\xa0\x95 \xe2"
  "\xa0\x8f\xe2\xa0\xa5\xe2\xa0\x9e \xe2\xa0\x99\xe2\xa0\x8a\xe2\xa0\x8e \xe2\xa0\x99"
  "\xe2\xa0\x81\xe2\xa0\x9d\xe2\xa0\x99 \xe2\xa0\x9e\xe2\xa0\x95\xe2\xa0\xb2\n"
  "\n"
  "  \xe2\xa1\x95\xe2\xa0\x87\xe2\xa0\x99 \xe2\xa1\x8d\xe2\xa0\x9c\xe2\xa0\x87\xe2\xa0"
  "\x91\xe2\xa0\xb9 \xe2\xa0\xba\xe2\xa0\x81\xe2\xa0\x8e \xe2\xa0\x81\xe2\xa0\x8e \xe2"
  "\xa0\x99\xe2\xa0\x91\xe2\xa0\x81\xe2\xa0\x99 \xe2\xa0\x81\xe2\xa0\x8e \xe2\xa0\x81"
  " \xe2\xa0\x99\xe2\xa0\x95\xe2\xa0\x95\xe2\xa0\x97\xe2\xa0\xa4\xe2\xa0\x9d\xe2\xa0"
  "\x81\xe2\xa0\x8a\xe2\xa0\x87\xe2\xa0\xb2\n"
  "\n"
  "  \xe2\xa1\x8d\xe2\xa0\x94\xe2\xa0\x99\xe2\xa0\x96 \xe2\xa1\x8a \xe2\xa0\x99\xe2"
  "\xa0\x95\xe2\xa0\x9d\xe2\xa0\xb0\xe2\xa0\x9e \xe2\xa0\x8d\xe2\xa0\x91\xe2\xa0\x81"
  "\xe2\xa0\x9d \xe2\xa0\x9e\xe2\xa0\x95 \xe2\xa0\x8e\xe2\xa0\x81\xe2\xa0\xb9 \xe2\xa0"
  "\xb9\xe2\xa0\x81\xe2\xa0\x9e \xe2\xa1\x8a \xe2\xa0\x85\xe2\xa0\x9d\xe2\xa0\xaa\xe2"
  "\xa0\x82 \xe2\xa0\x95\xe2\xa0\x8b \xe2\xa0\x8d\xe2\xa0\xb9\n"
  "  \xe2\xa0\xaa\xe2\xa0\x9d \xe2\xa0\x85\xe2\xa0\x9d\xe2\xa0\xaa\xe2\xa0\x87\xe2\xa0"
  "\xab\xe2\xa0\x9b\xe2\xa0\x91\xe2\xa0\x82 \xe2\xa0\xb1\xe2\xa0\x81\xe2\xa0\x9e \xe2"
  "\xa0\xb9\xe2\xa0\xbb\xe2\xa0\x91 \xe2\xa0\x8a\xe2\xa0\x8e \xe2\xa0\x8f\xe2\xa0\x9c"
  "\xe2\xa0\x9e\xe2\xa0\x8a\xe2\xa0\x8a\xe2\xa0\xa5\xe2\xa0\x87\xe2\xa0\x9c\xe2\xa0"
  "\x87\xe2\xa0\xb9 \xe2\xa0\x99\xe2\xa0\x91\xe2\xa0\x81\xe2\xa0\x99 \xe2\xa0\x81\xe2"
  "\xa0\x83\xe2\xa0\xb3\xe2\xa0\x9e\n"
  "  \xe2\xa0\x81 \xe2\xa0\x99\xe2\xa0\x95\xe2\xa0\x95\xe2\xa0\x97\xe2\xa0\xa4\xe2\xa0"
  "\x9d\xe2\xa0\x81\xe2\xa0\x8a\xe2\xa0\x87\xe2\xa0\xb2 \xe2\xa1\x8a \xe2\xa0\x8d\xe2"
  "\xa0\x8a\xe2\xa0\xa3\xe2\xa0\x9e \xe2\xa0\x99\xe2\xa0\x81\xe2\xa0\xa7\xe2\xa0\x91"
  " \xe2\xa0\x83\xe2\xa0\x91\xe2\xa0\xb2 \xe2\xa0\x94\xe2\xa0\x8a\xe2\xa0\x87\xe2\xa0"
  "\x94\xe2\xa0\xab\xe2\xa0\x82 \xe2\xa0\x8d\xe2\xa0\xb9\xe2\xa0\x8e\xe2\xa0\x91\xe2"
  "\xa0\x87\xe2\xa0\x8b\xe2\xa0\x82 \xe2\xa0\x9e\xe2\xa0\x95\n"
  "  \xe2\xa0\x97\xe2\xa0\x91\xe2\xa0\x9b\xe2\xa0\x9c\xe2\xa0\x99 \xe2\xa0\x81 \xe2"
  "\xa0\x8a\xe2\xa0\x95\xe2\xa0\x8b\xe2\xa0\x8b\xe2\xa0\x94\xe2\xa0\xa4\xe2\xa0\x9d"
  "\xe2\xa0\x81\xe2\xa0\x8a\xe2\xa0\x87 \xe2\xa0\x81\xe2\xa0\x8e \xe2\xa0\xb9\xe2\xa0"
  "\x91 \xe2\xa0\x99\xe2\xa0\x91\xe2\xa0\x81\xe2\xa0\x99\xe2\xa0\x91\xe2\xa0\x8c \xe2"
  "\xa0\x8f\xe2\xa0\x8a\xe2\xa0\x91\xe2\xa0\x8a\xe2\xa0\x91 \xe2\xa0\x95\xe2\xa0\x8b"
  " \xe2\xa0\x8a\xe2\xa0\x97\xe2\xa0\x95\xe2\xa0\x9d\xe2\xa0\x8d\xe2\xa0\x95\xe2\xa0"
  "\x9d\xe2\xa0\x9b\xe2\xa0\xbb\xe2\xa0\xb9 \n"
  "  \xe2\xa0\x94 \xe2\xa0\xb9\xe2\xa0\x91 \xe2\xa0\x9e\xe2\xa0\x97\xe2\xa0\x81\xe2"
  "\xa0\x99\xe2\xa0\x91\xe2\xa0\xb2 \xe2\xa1\x83\xe2\xa0\xa5\xe2\xa0\x9e \xe2\xa0\xb9"
  "\xe2\xa0\x91 \xe2\xa0\xba\xe2\xa0\x8a\xe2\xa0\x8e\xe2\xa0\x99\xe2\xa0\x95\xe2\xa0"
  "\x8d \xe2\xa0\x95\xe2\xa0\x8b \xe2\xa0\xb3\xe2\xa0\x97 \xe2\xa0\x81\xe2\xa0\x9d\xe2"
  "\xa0\x8a\xe2\xa0\x91\xe2\xa0\x8c\xe2\xa0\x95\xe2\xa0\x97\xe2\xa0\x8e \n"
  "  \xe2\xa0\x8a\xe2\xa0\x8e \xe2\xa0\x94 \xe2\xa0\xb9\xe2\xa0\x91 \xe2\xa0\x8e\xe2"
  "\xa0\x8a\xe2\xa0\x8d\xe2\xa0\x8a\xe2\xa0\x87\xe2\xa0\x91\xe2\xa0\x86 \xe2\xa0\x81"
  "\xe2\xa0\x9d\xe2\xa0\x99 \xe2\xa0\x8d\xe2\xa0\xb9 \xe2\xa0\xa5\xe2\xa0\x9d\xe2\xa0"
  "\x99\xe2\xa0\x81\xe2\xa0\x87\xe2\xa0\x87\xe2\xa0\xaa\xe2\xa0\xab \xe2\xa0\x99\xe2"
  "\xa0\x81\xe2\xa0\x9d\xe2\xa0\x99\xe2\xa0\x8e\n"
  "  \xe2\xa0\xa9\xe2\xa0\x81\xe2\xa0\x87\xe2\xa0\x87 \xe2\xa0\x9d\xe2\xa0\x95\xe2\xa0"
  "\x9e \xe2\xa0\x99\xe2\xa0\x8a\xe2\xa0\x8c\xe2\xa0\xa5\xe2\xa0\x97\xe2\xa0\x83 \xe2"
  "\xa0\x8a\xe2\xa0\x9e\xe2\xa0\x82 \xe2\xa0\x95\xe2\xa0\x97 \xe2\xa0\xb9\xe2\xa0\x91"
  " \xe2\xa1\x8a\xe2\xa0\xb3\xe2\xa0\x9d\xe2\xa0\x9e\xe2\xa0\x97\xe2\xa0\xb9\xe2\xa0"
  "\xb0\xe2\xa0\x8e \xe2\xa0\x99\xe2\xa0\x95\xe2\xa0\x9d\xe2\xa0\x91 \xe2\xa0\x8b\xe2"
  "\xa0\x95\xe2\xa0\x97\xe2\xa0\xb2 \xe2\xa1\xb9\xe2\xa0\xb3\n"
  "  \xe2\xa0\xba\xe2\xa0\x8a\xe2\xa0\x87\xe2\xa0\x87 \xe2\xa0\xb9\xe2\xa0\xbb\xe2\xa0"
  "\x91\xe2\xa0\x8b\xe2\xa0\x95\xe2\xa0\x97\xe2\xa0\x91 \xe2\xa0\x8f\xe2\xa0\xbb\xe2"
  "\xa0\x8d\xe2\xa0\x8a\xe2\xa0\x9e \xe2\xa0\x8d\xe2\xa0\x91 \xe2\xa0\x9e\xe2\xa0\x95"
  " \xe2\xa0\x97\xe2\xa0\x91\xe2\xa0\x8f\xe2\xa0\x91\xe2\xa0\x81\xe2\xa0\x9e\xe2\xa0"
  "\x82 \xe2\xa0\x91\xe2\xa0\x8d\xe2\xa0\x8f\xe2\xa0\x99\xe2\xa0\x81\xe2\xa0\x9e\xe2"
  "\xa0\x8a\xe2\xa0\x8a\xe2\xa0\x81\xe2\xa0\x87\xe2\xa0\x87\xe2\xa0\xb9\xe2\xa0\x82"
  " \xe2\xa0\xb9\xe2\xa0\x81\xe2\xa0\x9e\n"
  "  \xe2\xa1\x8d\xe2\xa0\x9c\xe2\xa0\x87\xe2\xa0\x91\xe2\xa0\xb9 \xe2\xa0\xba\xe2\xa0"
  "\x81\xe2\xa0\x8e \xe2\xa0\x81\xe2\xa0\x8e \xe2\xa0\x99\xe2\xa0\x91\xe2\xa0\x81\xe2"
  "\xa0\x99 \xe2\xa0\x81\xe2\xa0\x8e \xe2\xa0\x81 \xe2\xa0\x99\xe2\xa0\x95\xe2\xa0\x95"
  "\xe2\xa0\x97\xe2\xa0\xa4\xe2\xa0\x9d\xe2\xa0\x81\xe2\xa0\x8a\xe2\xa0\x87\xe2\xa0"
  "\xb2\n"
  "\n"
  "  (The first couple of paragraphs of \"A Christmas Carol\" by Dickens)\n"
  "\n"
  "Compact font selection example text:\n"
  "\n"
  "  ABCDEFGHIJKLMNOPQRSTUVWXYZ /0123456789\n"
  "  abcdefghijklmnopqrstuvwxyz \xc2\xa3\xc2\xa9\xc2\xb5\xc3\x80\xc3\x86\xc3\x96\xc3"
  "\x9e\xc3\x9f\xc3\xa9\xc3\xb6\xc3\xbf\n"
  "  \xe2\x80\x93\xe2\x80\x94\xe2\x80\x98\xe2\x80\x9c\xe2\x80\x9d\xe2\x80\x9e\xe2\x80"
  "\xa0\xe2\x80\xa2\xe2\x80\xa6\xe2\x80\xb0\xe2\x84\xa2\xc5\x93\xc5\xa0\xc5\xb8\xc5"
  "\xbe\xe2\x82\xac \xce\x91\xce\x92\xce\x93\xce\x94\xce\xa9\xce\xb1\xce\xb2\xce\xb3"
  "\xce\xb4\xcf\x89 \xd0\x90\xd0\x91\xd0\x92\xd0\x93\xd0\x94\xd0\xb0\xd0\xb1\xd0\xb2"
  "\xd0\xb3\xd0\xb4\n"
  "  \xe2\x88\x80\xe2\x88\x82\xe2\x88\x88\xe2\x84\x9d\xe2\x88\xa7\xe2\x88\xaa\xe2\x89"
  "\xa1\xe2\x88\x9e \xe2\x86\x91\xe2\x86\x97\xe2\x86\xa8\xe2\x86\xbb\xe2\x87\xa3 \xe2"
  "\x94\x90\xe2\x94\xbc\xe2\x95\x94\xe2\x95\x98\xe2\x96\x91\xe2\x96\xba\xe2\x98\xba"
  "\xe2\x99\x80 \xef\xac\x81\xef\xbf\xbd\xe2\x91\x80\xe2\x82\x82\xe1\xbc\xa0\xe1\xb8"
  "\x82\xd3\xa5\xe1\xba\x84\xc9\x90\xcb\x90\xe2\x8d\x8e\xd7\x90\xd4\xb1\xe1\x83\x90"
  "\n"
  "\n"
  "Greetings in various languages:\n"
  "\n"
  "  Hello world, \xce\x9a\xce\xb1\xce\xbb\xce\xb7\xce\xbc\xe1\xbd\xb3\xcf\x81\xce\xb1"
  " \xce\xba\xe1\xbd\xb9\xcf\x83\xce\xbc\xce\xb5, \xe3\x82\xb3\xe3\x83\xb3\xe3\x83\x8b"
  "\xe3\x83\x81\xe3\x83\x8f\n"
  "\n"
  "Box drawing alignment tests:                                          \xe2\x96\x88"
  "\n"
  "                                                                      \xe2\x96\x89"
  "\n"
  "  \xe2\x95\x94\xe2\x95\x90\xe2\x95\x90\xe2\x95\xa6\xe2\x95\x90\xe2\x95\x90\xe2\x95"
  "\x97  \xe2\x94\x8c\xe2\x94\x80\xe2\x94\x80\xe2\x94\xac\xe2\x94\x80\xe2\x94\x80\xe2"
  "\x94\x90  \xe2\x95\xad\xe2\x94\x80\xe2\x94\x80\xe2\x94\xac\xe2\x94\x80\xe2\x94\x80"
  "\xe2\x95\xae  \xe2\x95\xad\xe2\x94\x80\xe2\x94\x80\xe2\x94\xac\xe2\x94\x80\xe2\x94"
  "\x80\xe2\x95\xae  \xe2\x94\x8f\xe2\x94\x81\xe2\x94\x81\xe2\x94\xb3\xe2\x94\x81\xe2"
  "\x94\x81\xe2\x94\x93  \xe2\x94\x8e\xe2\x94\x92\xe2\x94\x8f\xe2\x94\x91   \xe2\x95"
  "\xb7  \xe2\x95\xbb \xe2\x94\x8f\xe2\x94\xaf\xe2\x94\x93 \xe2\x94\x8c\xe2\x94\xb0"
  "\xe2\x94\x90    \xe2\x96\x8a \xe2\x95\xb1\xe2\x95\xb2\xe2\x95\xb1\xe2\x95\xb2\xe2"
  "\x95\xb3\xe2\x95\xb3\xe2\x95\xb3\n"
  "  \xe2\x95\x91\xe2\x94\x8c\xe2\x94\x80\xe2\x95\xa8\xe2\x94\x80\xe2\x94\x90\xe2\x95"
  "\x91  \xe2\x94\x82\xe2\x95\x94\xe2\x95\x90\xe2\x95\xa7\xe2\x95\x90\xe2\x95\x97\xe2"
  "\x94\x82  \xe2\x94\x82\xe2\x95\x92\xe2\x95\x90\xe2\x95\xaa\xe2\x95\x90\xe2\x95\x95"
  "\xe2\x94\x82  \xe2\x94\x82\xe2\x95\x93\xe2\x94\x80\xe2\x95\x81\xe2\x94\x80\xe2\x95"
  "\x96\xe2\x94\x82  \xe2\x94\x83\xe2\x94\x8c\xe2\x94\x80\xe2\x95\x82\xe2\x94\x80\xe2"
  "\x94\x90\xe2\x94\x83  \xe2\x94\x97\xe2\x95\x83\xe2\x95\x84\xe2\x94\x99  \xe2\x95"
  "\xb6\xe2\x94\xbc\xe2\x95\xb4\xe2\x95\xba\xe2\x95\x8b\xe2\x95\xb8\xe2\x94\xa0\xe2"
  "\x94\xbc\xe2\x94\xa8 \xe2\x94\x9d\xe2\x95\x8b\xe2\x94\xa5    \xe2\x96\x8b \xe2\x95"
  "\xb2\xe2\x95\xb1\xe2\x95\xb2\xe2\x95\xb1\xe2\x95\xb3\xe2\x95\xb3\xe2\x95\xb3\n"
  "  \xe2\x95\x91\xe2\x94\x82\xe2\x95\xb2 \xe2\x95\xb1\xe2\x94\x82\xe2\x95\x91  \xe2"
  "\x94\x82\xe2\x95\x91   \xe2\x95\x91\xe2\x94\x82  \xe2\x94\x82\xe2\x94\x82 \xe2\x94"
  "\x82 \xe2\x94\x82\xe2\x94\x82  \xe2\x94\x82\xe2\x95\x91 \xe2\x94\x83 \xe2\x95\x91"
  "\xe2\x94\x82  \xe2\x94\x83\xe2\x94\x82 \xe2\x95\xbf \xe2\x94\x82\xe2\x94\x83  \xe2"
  "\x94\x8d\xe2\x95\x85\xe2\x95\x86\xe2\x94\x93   \xe2\x95\xb5  \xe2\x95\xb9 \xe2\x94"
  "\x97\xe2\x94\xb7\xe2\x94\x9b \xe2\x94\x94\xe2\x94\xb8\xe2\x94\x98    \xe2\x96\x8c"
  " \xe2\x95\xb1\xe2\x95\xb2\xe2\x95\xb1\xe2\x95\xb2\xe2\x95\xb3\xe2\x95\xb3\xe2\x95"
  "\xb3\n"
  "  \xe2\x95\xa0\xe2\x95\xa1 \xe2\x95\xb3 \xe2\x95\x9e\xe2\x95\xa3  \xe2\x94\x9c\xe2"
  "\x95\xa2   \xe2\x95\x9f\xe2\x94\xa4  \xe2\x94\x9c\xe2\x94\xbc\xe2\x94\x80\xe2\x94"
  "\xbc\xe2\x94\x80\xe2\x94\xbc\xe2\x94\xa4  \xe2\x94\x9c\xe2\x95\xab\xe2\x94\x80\xe2"
  "\x95\x82\xe2\x94\x80\xe2\x95\xab\xe2\x94\xa4  \xe2\x94\xa3\xe2\x94\xbf\xe2\x95\xbe"
  "\xe2\x94\xbc\xe2\x95\xbc\xe2\x94\xbf\xe2\x94\xab  \xe2\x94\x95\xe2\x94\x9b\xe2\x94"
  "\x96\xe2\x94\x9a     \xe2\x94\x8c\xe2\x94\x84\xe2\x94\x84\xe2\x94\x90 \xe2\x95\x8e"
  " \xe2\x94\x8f\xe2\x94\x85\xe2\x94\x85\xe2\x94\x93 \xe2\x94\x8b \xe2\x96\x8d \xe2"
  "\x95\xb2\xe2\x95\xb1\xe2\x95\xb2\xe2\x95\xb1\xe2\x95\xb3\xe2\x95\xb3\xe2\x95\xb3"
  "\n"
  "  \xe2\x95\x91\xe2\x94\x82\xe2\x95\xb1 \xe2\x95\xb2\xe2\x94\x82\xe2\x95\x91  \xe2"
  "\x94\x82\xe2\x95\x91   \xe2\x95\x91\xe2\x94\x82  \xe2\x94\x82\xe2\x94\x82 \xe2\x94"
  "\x82 \xe2\x94\x82\xe2\x94\x82  \xe2\x94\x82\xe2\x95\x91 \xe2\x94\x83 \xe2\x95\x91"
  "\xe2\x94\x82  \xe2\x94\x83\xe2\x94\x82 \xe2\x95\xbd \xe2\x94\x82\xe2\x94\x83  \xe2"
  "\x96\x91\xe2\x96\x91\xe2\x96\x92\xe2\x96\x92\xe2\x96\x93\xe2\x96\x93\xe2\x96\x88"
  "\xe2\x96\x88 \xe2\x94\x8a  \xe2\x94\x86 \xe2\x95\x8e \xe2\x95\x8f  \xe2\x94\x87 "
  "\xe2\x94\x8b \xe2\x96\x8e\n"
  "  \xe2\x95\x91\xe2\x94\x94\xe2\x94\x80\xe2\x95\xa5\xe2\x94\x80\xe2\x94\x98\xe2\x95"
  "\x91  \xe2\x94\x82\xe2\x95\x9a\xe2\x95\x90\xe2\x95\xa4\xe2\x95\x90\xe2\x95\x9d\xe2"
  "\x94\x82  \xe2\x94\x82\xe2\x95\x98\xe2\x95\x90\xe2\x95\xaa\xe2\x95\x90\xe2\x95\x9b"
  "\xe2\x94\x82  \xe2\x94\x82\xe2\x95\x99\xe2\x94\x80\xe2\x95\x80\xe2\x94\x80\xe2\x95"
  "\x9c\xe2\x94\x82  \xe2\x94\x83\xe2\x94\x94\xe2\x94\x80\xe2\x95\x82\xe2\x94\x80\xe2"
  "\x94\x98\xe2\x94\x83  \xe2\x96\x91\xe2\x96\x91\xe2\x96\x92\xe2\x96\x92\xe2\x96\x93"
  "\xe2\x96\x93\xe2\x96\x88\xe2\x96\x88 \xe2\x94\x8a  \xe2\x94\x86 \xe2\x95\x8e \xe2"
  "\x95\x8f  \xe2\x94\x87 \xe2\x94\x8b \xe2\x96\x8f\n"
  "  \xe2\x95\x9a\xe2\x95\x90\xe2\x95\x90\xe2\x95\xa9\xe2\x95\x90\xe2\x95\x90\xe2\x95"
  "\x9d  \xe2\x94\x94\xe2\x94\x80\xe2\x94\x80\xe2\x94\xb4\xe2\x94\x80\xe2\x94\x80\xe2"
  "\x94\x98  \xe2\x95\xb0\xe2\x94\x80\xe2\x94\x80\xe2\x94\xb4\xe2\x94\x80\xe2\x94\x80"
  "\xe2\x95\xaf  \xe2\x95\xb0\xe2\x94\x80\xe2\x94\x80\xe2\x94\xb4\xe2\x94\x80\xe2\x94"
  "\x80\xe2\x95\xaf  \xe2\x94\x97\xe2\x94\x81\xe2\x94\x81\xe2\x94\xbb\xe2\x94\x81\xe2"
  "\x94\x81\xe2\x94\x9b  \xe2\x96\x97\xe2\x96\x84\xe2\x96\x96\xe2\x96\x9b\xe2\x96\x80"
  "\xe2\x96\x9c   \xe2\x94\x94\xe2\x95\x8c\xe2\x95\x8c\xe2\x94\x98 \xe2\x95\x8e \xe2"
  "\x94\x97\xe2\x95\x8d\xe2\x95\x8d\xe2\x94\x9b \xe2\x94\x8b  \xe2\x96\x81\xe2\x96\x82"
  "\xe2\x96\x83\xe2\x96\x84\xe2\x96\x85\xe2\x96\x86\xe2\x96\x87\xe2\x96\x88\n"
  "                                               \xe2\x96\x9d\xe2\x96\x80\xe2\x96\x98"
  "\xe2\x96\x99\xe2\x96\x84\xe2\x96\x9f\n"
  ""
  ;


// Map
FXDEFMAP(MDITestWindow) MDITestWindowMap[]={
  //________Message_Type____________ID___________________Message_Handler________
  FXMAPFUNC(SEL_COMMAND,  MDITestWindow::ID_ABOUT,    MDITestWindow::onCmdAbout),
  FXMAPFUNC(SEL_COMMAND,  MDITestWindow::ID_NEW,      MDITestWindow::onCmdNew),
  };


// Object implementation
FXIMPLEMENT(MDITestWindow,FXMainWindow,MDITestWindowMap,ARRAYNUMBER(MDITestWindowMap))


// Make some windows
MDITestWindow::MDITestWindow(FXApp* a):FXMainWindow(a,"MDI Widget Test",NULL,NULL,DECOR_ALL,0,0,800,600){
  FXMDIChild *mdichild;
  FXScrollWindow *scrollwindow;
  FXButton *btn;

#ifdef WIN32
  font=new FXFont(getApp(),"Arial Unicode MS,105,,,,iso10646-1");
#else
  font=new FXFont(getApp(),"fixed,105,,,,iso10646-1");
//  font=new FXFont(getApp(),"fixed [misc]",12,0,0,FONTENCODING_UNICODE,0,0);
#endif

  // Menubar
  menubar=new FXMenuBar(this,LAYOUT_SIDE_TOP|LAYOUT_FILL_X);

  // Status bar
  new FXStatusBar(this,LAYOUT_SIDE_BOTTOM|LAYOUT_FILL_X|STATUSBAR_WITH_DRAGCORNER);

  // MDI Client
  mdiclient=new FXMDIClient(this,LAYOUT_FILL_X|LAYOUT_FILL_Y);

  // Icon for MDI Child
  mdiicon=new FXGIFIcon(getApp(),penguin);

  // Make MDI Menu
  mdimenu=new FXMDIMenu(this,mdiclient);

  // MDI buttons in menu:- note the message ID's!!!!!
  // Normally, MDI commands are simply sensitized or desensitized;
  // Under the menubar, however, they're hidden if the MDI Client is
  // not maximized.  To do this, they must have different ID's.
  new FXMDIWindowButton(menubar,mdimenu,mdiclient,FXMDIClient::ID_MDI_MENUWINDOW,LAYOUT_LEFT);
  new FXMDIDeleteButton(menubar,mdiclient,FXMDIClient::ID_MDI_MENUCLOSE,FRAME_RAISED|LAYOUT_RIGHT);
  new FXMDIRestoreButton(menubar,mdiclient,FXMDIClient::ID_MDI_MENURESTORE,FRAME_RAISED|LAYOUT_RIGHT);
  new FXMDIMinimizeButton(menubar,mdiclient,FXMDIClient::ID_MDI_MENUMINIMIZE,FRAME_RAISED|LAYOUT_RIGHT);

  // Test window #1
  mdichild=new FXMDIChild(mdiclient,"Child",mdiicon,mdimenu,MDI_NORMAL|MDI_TRACKING,10,10,400,300);
  scrollwindow=new FXScrollWindow(mdichild,0);
  btn=new FXButton(scrollwindow,tyger,NULL,NULL,0,LAYOUT_BOTTOM|LAYOUT_RIGHT);
  btn->setBackColor(FXRGB(255,255,255));
  btn->setFont(font);
  mdiclient->setActiveChild(mdichild);

  // Test window #2
  mdichild=new FXMDIChild(mdiclient,"Child",mdiicon,mdimenu,MDI_NORMAL|MDI_TRACKING,20,20,400,300);
  scrollwindow=new FXScrollWindow(mdichild,0);
  btn=new FXButton(scrollwindow,unicode,NULL,NULL,0,JUSTIFY_LEFT|LAYOUT_CENTER_Y|LAYOUT_CENTER_X);
  btn->setFont(font);
  btn->setBackColor(FXRGB(255,255,255));

  // Test window #3
  mdichild=new FXMDIChild(mdiclient,"Child",mdiicon,mdimenu,MDI_NORMAL|MDI_TRACKING,30,30,400,300);
  scrollwindow=new FXScrollWindow(mdichild,0);
  btn=new FXButton(scrollwindow,tyger,NULL,NULL,0,LAYOUT_FIX_WIDTH|LAYOUT_FIX_HEIGHT,0,0,600,1000);
  btn->setFont(font);
  btn->setBackColor(FXRGB(255,255,255));

  // File menu
  filemenu=new FXMenuPane(this);
  new FXMenuCommand(filemenu,"&New\tCtl-N\tCreate new document.",NULL,this,ID_NEW);
  new FXMenuCommand(filemenu,"&Open\tCtl-O\tOpen document.");
  new FXMenuCommand(filemenu,"&Quit\tCtl-Q\tQuit application.",NULL,getApp(),FXApp::ID_QUIT,0);
  new FXMenuTitle(menubar,"&File",NULL,filemenu);

  // Window menu
  windowmenu=new FXMenuPane(this);
  new FXMenuCommand(windowmenu,"Tile &Horizontally",NULL,mdiclient,FXMDIClient::ID_MDI_TILEHORIZONTAL);
  new FXMenuCommand(windowmenu,"Tile &Vertically",NULL,mdiclient,FXMDIClient::ID_MDI_TILEVERTICAL);
  new FXMenuCommand(windowmenu,"C&ascade",NULL,mdiclient,FXMDIClient::ID_MDI_CASCADE);
  new FXMenuCommand(windowmenu,"&Close",NULL,mdiclient,FXMDIClient::ID_MDI_CLOSE);
  new FXMenuSeparator(windowmenu,mdiclient,FXMDIClient::ID_MDI_ANY);
  new FXMenuCommand(windowmenu,FXString::null,NULL,mdiclient,FXMDIClient::ID_MDI_1);
  new FXMenuCommand(windowmenu,FXString::null,NULL,mdiclient,FXMDIClient::ID_MDI_2);
  new FXMenuCommand(windowmenu,FXString::null,NULL,mdiclient,FXMDIClient::ID_MDI_3);
  new FXMenuCommand(windowmenu,FXString::null,NULL,mdiclient,FXMDIClient::ID_MDI_4);
  new FXMenuCommand(windowmenu,"&Others...",NULL,mdiclient,FXMDIClient::ID_MDI_OVER_5);
  new FXMenuTitle(menubar,"&Window",NULL,windowmenu);

  // Help menu
  helpmenu=new FXMenuPane(this);
  new FXMenuCommand(helpmenu,"&About FOX...",NULL,this,ID_ABOUT,0);
  new FXMenuTitle(menubar,"&Help",NULL,helpmenu,LAYOUT_RIGHT);

  }


// Clean up
MDITestWindow::~MDITestWindow(){
  delete filemenu;
  delete windowmenu;
  delete helpmenu;
  delete font;
  delete mdiicon;
  }


// About
long MDITestWindow::onCmdAbout(FXObject*,FXSelector,void*){
  FXMessageBox::information(this,MBOX_OK,"About MDI Test","Test of the FOX MDI Widgets\nWritten by Jeroen van der Zijp");
  return 1;
  }


// New
long MDITestWindow::onCmdNew(FXObject*,FXSelector,void*){
  FXMDIChild *mdichild=new FXMDIChild(mdiclient,"Child",mdiicon,mdimenu,MDI_NORMAL|MDI_TRACKING,20,20,300,200);
  FXScrollWindow *scrollwindow=new FXScrollWindow(mdichild,0);
  FXButton* btn=new FXButton(scrollwindow,tyger,NULL,NULL,0,LAYOUT_CENTER_X|LAYOUT_FILL_Y);
  btn->setBackColor(FXRGB(255,255,255));
  mdichild->create();
  return 1;
  }


// Start
void MDITestWindow::create(){
  FXMainWindow::create();
  show(PLACEMENT_SCREEN);
  }


/*******************************************************************************/

// Start the whole thing
int main(int argc,char *argv[]){

  // Make application
  FXApp application("MDIApp","FoxTest");

  // Open display
  application.init(argc,argv);

  // Make window
  new MDITestWindow(&application);

  // Create app
  application.create();

  // Run
  return application.run();
  }


