#!/usr/bin/env python

# import os
# import sys
# import glob

from setuptools import setup


def get_data_files():
    data_files = [
        ('share/doc/batinfo', ['AUTHORS', 'README.md', 'LICENSE'])
    ]

    return data_files

setup(
    name='batinfo',
    version='0.4.2',
    description="A simple Python module to retrieve battery information",
    author='Nicolas Hennion',
    author_email='nicolas@nicolargo.com',
    url='https://github.com/nicolargo/batinfo',
    license="LGPLv3",
    keywords="lib battery",
    packages=['batinfo'],
    include_package_data=True,
    data_files=get_data_files(),
    classifiers=[
        'Development Status :: 5 - Production/Stable',
        'Environment :: Console',
        'License :: OSI Approved :: GNU Lesser General Public License v3 (LGPLv3)',
        'Operating System :: OS Independent',
        'Natural Language :: English',
        'Operating System :: OS Independent',
        'Programming Language :: Python :: 2',
        'Programming Language :: Python :: 3',
        'Topic :: System :: Monitoring',
        'Topic :: System :: Systems Administration',
        'Topic :: Utilities',
        'Topic :: Software Development :: Libraries :: Python Modules',
        'Intended Audience :: Developers',
        'Intended Audience :: System Administrators'
    ]
)
