/*
 *  xwxapt: An application to decode APT signals from weather
 *  satellites and produce an image of the weather.
 *
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef SHARED_H
#define SHARED_H		1

#include "common.h"
#include "image.h"


/* Runtime config data */
extern rc_data_t rc_data;

/* Global widgets */
extern GtkWidget
  *gbl_scope,
  *gbl_waterfall;

/* Scope signal display */
extern gint
  gbl_scope_width,
  gbl_scope_height;

/* Waterfall window pixbuf */
extern GdkPixbuf *gbl_wfall_pixbuf;
extern guchar *gbl_wfall_pixels;
extern gint
  gbl_wfall_rowstride,
  gbl_wfall_n_channels,
  gbl_wfall_width,
  gbl_wfall_height;

/* Pixel buffer */
extern guchar *gbl_pixel_buf;

extern int
  gbl_sat_type, /* Weather satellite type number   */
  gbl_sync_ref, /* Required position of sync train */
  gbl_sync_err, /* Deviation from sync reference   */
  gbl_duration,	/* Processing duration */
  gbl_line_idx; /* Index to signal samples buffer   */

/* List of required sync position references */
extern int gbl_sync_refs[];

/* Signal/DSP samples buffer */
extern short gbl_line_buffer[];

/* Pixel buffer for display */
extern GdkPixbuf *gbl_pixbuf;

/* Pixbuf rowstride and num of channels */
extern gint
  gbl_rowstride,
  gbl_n_channels;

extern GtkWidget
  *xwxapt_main_window, /* xwxapt's top window   */
  *gbl_text_scroller,  /* Text view scroller    */
  *gbl_level_pbar,     /* Signal level prog. bar */
  *gbl_sync_pbar,      /* Sync level prog. bar  */
  *gbl_status_table,   /* Status widgets' table */
  *gbl_sync_icon,      /* Sync status indicator */
  *gbl_apt_image;      /* Image to be displayed */

/* Text buffer for text view */
extern GtkTextBuffer *gbl_text_buffer;

/* Pixel buffer for display */
extern GdkPixbuf *gbl_pixbuf;

/* Satellite type names */
extern char *gbl_sat_names[];

extern char
  gbl_samples_file[MAX_FILE_NAME], /* Samples file name */
  gbl_image_file[MAX_FILE_NAME];   /* Image files name  */

/* Pointer to samples file */
extern FILE *gbl_samples_fp;

/* Buffer for reading in Sound Card DSP data */
extern short *gbl_snd_buffer;
extern guint snd_buf_idx; /* Index for this buffer  */

extern int dsp_rate_err;  /* dsp sampling rate error*/

/* Common between callbacks.c and callback_func.c */
extern GtkWidget
  *quit_dialog,
  *error_dialog,
  *popup_menu,
  *fileselection,
  *start_stop_timer,
  *timeout_dialog;

/* Tag to wake-up timeout function */
extern guint cancel_timer_tag;

/* dft in/out buffers */
extern int
  *dft_in_i,
  *dft_in_q;

/* Chebyshev filter data I/Q */
extern filter_data_t filter_data_i;
extern filter_data_t filter_data_q;

/* Playback control semaphore */ 
extern sem_t pback_semaphore;

#endif

