/*  shared.c
 *
 *  Shared global variables
 */

/*
 *  xwxapt: An application to decode APT signals from
 *  weather satellites and produce image(s) of the weather.
 *
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#include "shared.h"

/* Runtime config data */
rc_data_t rc_data;

/* Global widgets */
GtkWidget
  *gbl_scope,
  *gbl_waterfall;

/* Scope signal display */
gint
  gbl_scope_width,
  gbl_scope_height;

/* Waterfall window pixbuf */
GdkPixbuf *gbl_wfall_pixbuf = NULL;
guchar *gbl_wfall_pixels;
gint
  gbl_wfall_rowstride,
  gbl_wfall_n_channels,
  gbl_wfall_width,
  gbl_wfall_height;

/* Pixel buffer */
guchar *gbl_pixel_buf;

int
  gbl_sat_type, /* Weather satellite type number   */
  gbl_sync_ref, /* Required position of sync train */
  gbl_sync_err, /* Deviation from sync reference   */
  gbl_duration,	/* Processing duration */
  gbl_line_idx; /* Index to signal samples buffer   */

/* List of required sync position references */
int gbl_sync_refs[] = { SYNC_REFS };

/* Signal/DSP samples buffer */
short gbl_line_buffer[BLOCK_BUFFER_SIZE];

GtkWidget
  *xwxapt_main_window, /* xwxapt's top window   */
  *gbl_text_scroller,  /* Text view scroller    */
  *gbl_level_pbar,     /* Signal level prog. bar */
  *gbl_sync_pbar,      /* Sync level prog. bar  */
  *gbl_status_table,   /* Status widgets' table */
  *gbl_sync_icon,      /* Sync status indicator */
  *gbl_apt_image;      /* Image to be displayed */

/* Text buffer for text view */
GtkTextBuffer *gbl_text_buffer;

/* Pixel buffer for display */
GdkPixbuf *gbl_pixbuf;

/* Pixbuf rowstride and num of channels */
gint
  gbl_rowstride,
  gbl_n_channels;

/* Satellite type names */
char *gbl_sat_names[] = { SAT_NAMES };

char
  gbl_samples_file[MAX_FILE_NAME], /* Samples file name */
  gbl_image_file  [MAX_FILE_NAME]; /* Image files name  */

/* Pointer to samples file */
FILE *gbl_samples_fp = NULL;

/* Buffer for reading in DSP data */
short *gbl_snd_buffer = NULL;

/* Index for this buffer  */
guint snd_buf_idx;

/* dsp sampling rate error*/
int dsp_rate_err;

/* Common between callbacks.c and callback_func.c */
GtkWidget
  *quit_dialog   = NULL,
  *error_dialog  = NULL,
  *popup_menu    = NULL,
  *fileselection = NULL,
  *start_stop_timer = NULL,
  *timeout_dialog   = NULL;

/* Tag to wake-up timeout function */
guint cancel_timer_tag;

/* dft input buffers */
int
  *dft_in_i = NULL,
  *dft_in_q = NULL;

/* Chebyshev filter data I/Q */
filter_data_t filter_data_i;
filter_data_t filter_data_q;

/* Playback control semaphore */ 
sem_t pback_semaphore;

/*------------------------------------------------------------------------*/

