/*
 *  xwxapt: An application to decode APT signals from weather
 *  satellites and produce an image of the weather.
 *
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef MONITORS_H
#define MONITORS_H		1

#include "common.h"

/* These are calculated by Size = DSPRate * BinSize / MaxFreq */
/* Size of dft input array for detector spectrum */
#define DET_DFT_INPUT_SIZE	2560

/* Size of dft input array for SDR spectrum */
#define SDR_DFT_INPUT_SIZE	1474

/* Scale factor to keep DFT bin values in range */
#define DET_DFT_SCALE	1800

/* Scale factor to keep DFT bin values in range */
#define SDR_DFT_SCALE	2

/* DFT Signal Amplitude averaging window */
#define AMPL_AVE_WIN		2
#define AMPL_AVE_MUL		1

#endif
