/*
 *  xwxapt: An application to decode APT signals from weather
 *  satellites and produce an image of the weather.
 *
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef IMAGE_H
#define IMAGE_H		1

#include "common.h"

/* Definitions for NOAA image processing */
#define NOAA_PIXEL_SAMPLES	      14 /* DSP samples used for an image pixel*/
#define NOAA_IMAGE_WIDTH         749 /* Width in pixels of images produced */
#define NOAA_SYNC_CHA_SPACE      545 /* Space between ch A sync and image  */
#define NOAA_CHA_CHB_SPACE      1512 /* Space between ch A & B, in samples */
#define CHB_PADDING				 218 /* Padding after Ch B to read all line*/
#define NOAA_SYNC_PULSES	 	   7 /* Number of pulses in the sync train */
#define NOAA_SYNC_SAMPLES	      23 /* Carrier samples per 1/2 sync cycle */
#define NOAA_SYNC_LEAD			  46 /* Sync train lead length, in samples */
#define NOAA_SYNC_TAIL			  80 /* Sync train tail length, in samples */
#define NOAA_SYNC_LOWER      2500000 /* Sync train detector lower threshold*/
#define NOAA_SYNC_UPPER      5000000 /* Sync train detector upper threshold*/
#define NOAA_SYNC_REF            750 /* Required position of sync train    */
#define NOAA_SCALE_FACTOR         25 /* Factor to keep pixel values < 255  */

/* Definitions for Meteor image processing. Sat is now defunct */
#define METEOR_PIXEL_SAMPLES	    24 /* DSP samples used for an image pixel*/
#define METEOR_IMAGE_WIDTH         800 /* Width in pixels of images produced */
#define METEOR_SYNC_IMAGE_SPACE    648 /* Space between sync and image start */
#define METEOR_SYNC_PULSES		     5 /* Number of pulses in the sync train */
#define METEOR_SYNC_MARK	        13 /* Number of carrier samples in mark  */
#define METEOR_SYNC_SPACE	        27 /* Number of carrier samples in space */
#define METEOR_SYNC_FIFO_SIZE      200 /* Size of sync detector samples fifo */
#define METEOR_SYNC_LOWER      2000000 /* Sync train detector lower threshold*/
#define METEOR_SYNC_UPPER      3500000 /* Sync train detector upper threshold*/
#define METEOR_SYNC_REF            648 /* Required position of sync train    */
#define METEOR_SCALE_FACTOR		     7 /* Factor to keep pixel values < 255  */

/* Extend in samples beyond sync reference to search for sync */
#define SYNC_SEARCH_EXTEND		200

/* 2.4kHz sub-carrier maximum amplitude limit */
#define MAX_SUBCARRIER_AMPL		32768

/* Maximum value limit for a display pixel */
#define MAX_PIXEL_VAL			255

/* Satellite type definitions */
enum
{
  NOAA_15, /* NOAA type APT format   */
  NOAA_18, /* NOAA type APT format   */
  NOAA_19, /* NOAA type APT format   */
  METEOR   /* METEOR type APT format */
};

#define SAT_NAMES	"NOAA-15", "NOAA-18", "NOAA-19", "Meteor"
#define SYNC_REFS	NOAA_SYNC_REF, NOAA_SYNC_REF, NOAA_SYNC_REF, METEOR_SYNC_REF

/* Color maps to use */
#define NOAA_A_COLORMAP 	0
#define NOAA_B_COLORMAP 	1
#define METEOR_COLORMAP 	2

#define BLACK_CUT_OFF		1 /* Black cut-off percentile for normalization */
#define WHITE_CUT_OFF		2 /* White cut-off percentile for normalization */

#endif

