#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "rtlsdr.h"
#include "shared.h"


void
on_main_window_destroy                 (GtkObject       *object,
                                        gpointer         user_data)
{
  Cleanup();
  gtk_main_quit();
}


gboolean
on_main_window_delete_event            (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  if( isFlagSet(ACTION_FLAGS_ALL) )
  {
	quit_dialog = create_quit_dialog();
	gtk_widget_show( quit_dialog );
  }
  else
  {
	Cleanup();
	gtk_main_quit();
  }

  return TRUE;
}


gboolean
on_viewport_button_press_event         (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  if( event->button == 3 )
	Popup_Menu();
  return TRUE;
}


void
on_receive_togglebutton_toggled        (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  Receive_Togglebutton_Toggled( togglebutton );
}


void
on_normalize_togglebutton_toggled      (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  if( gtk_toggle_button_get_active(togglebutton) )
	SetFlag( IMAGE_NORMALIZE );
  else
	ClearFlag( IMAGE_NORMALIZE );
}


void
on_colorize_togglebutton_toggled       (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  if( gtk_toggle_button_get_active(togglebutton) )
	SetFlag( IMAGE_COLORIZE );
  else
	ClearFlag( IMAGE_COLORIZE );
}


void
on_invert_togglebutton_toggled         (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  if( gtk_toggle_button_get_active(togglebutton) )
	SetFlag( IMAGE_ROTATE );
  else
	ClearFlag( IMAGE_ROTATE );
}


void
on_level_setup_togglebutton_toggled    (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  if( isFlagSet(START_STOP_TIMER) )
	return;

  /* Run signal level setup function */
  if( gtk_toggle_button_get_active(togglebutton) )
  {
	SetFlag( ACTION_SETUP_AUDIO );
	Show_Message( _("Starting signal level setup "), "black" );
	g_idle_add( Setup_Signal_Level, NULL );
  } /* if( isFlagClear(ACTION_SETUP_AUDIO) ) */
  else
	ClearFlag( ACTION_SETUP_AUDIO );
}


void
on_operation_timer_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  timeout_dialog = create_operation_timer();
  gtk_widget_show( timeout_dialog );
}


void
on_start_stop_timer_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  start_stop_timer = create_start_stop_timer();
  gtk_widget_show( start_stop_timer );
}


void
on_cancel_timer_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  g_idle_add( Cancel_Timer, NULL );
}


void
on_decode_from_dsp_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  SetFlag( ACTION_PROCESS_DSP );

  /* Open file selection dialog */
  File_Selection();

  /* Offer a default image file name */
  File_Name( gbl_image_file );
  gtk_file_selection_set_filename(
	  GTK_FILE_SELECTION(fileselection),
	  gbl_image_file );
}


void
on_record_to_file_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  SetFlag( ACTION_RECORD_APT );

  /* Open file selection dialog */
  File_Selection();

  /* Offer a default name for the samples file */
  File_Name( gbl_samples_file );
  gtk_file_selection_set_filename(
	  GTK_FILE_SELECTION(fileselection), gbl_samples_file );
}


void
on_decode_from_file_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  char record_path[64];

  SetFlag( ACTION_PROCESS_FILE );

  /* Open file selection dialog */
  File_Selection();

  /* Offer the default 'record/' directory for opening a samples file */
  size_t s = sizeof( record_path );
  Strlcpy( record_path, rc_data.xwxapt_dir, s );
  Strlcat( record_path, "record/", s );
  gtk_file_selection_set_filename(
	  GTK_FILE_SELECTION(fileselection), record_path );
}


void
on_stop_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  ClearFlag( ACTION_FLAGS_ALL );
}


void
on_quit_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if( isFlagSet(ACTION_FLAGS_ALL) )
  {
	quit_dialog = create_quit_dialog();
	gtk_widget_show( quit_dialog );
  }
  else
  {
	Cleanup();
	gtk_main_quit();
  }
}


void
on_fileselection_response              (GtkDialog       *dialog,
                                        gint             response_id,
                                        gpointer         user_data)
{
  Fileselection_Response( response_id );
}


void
on_timeout_okbutton_clicked            (GtkButton       *button,
                                        gpointer         user_data)
{
  Timeout_Setup( button );
}


gboolean
on_error_dialog_delete_event           (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  return TRUE;
}


void
on_error_dialog_destroy                (GtkObject       *object,
                                        gpointer         user_data)
{
  error_dialog = NULL;
}


void
on_error_ok_button_clicked             (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy( error_dialog );
}


void
on_error_quit_button_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
  Cleanup();
  gtk_main_quit();
}


void
on_hrs_entry_changed                   (GtkEditable     *editable,
                                        gpointer         user_data)
{
  Hours_Entry( editable );
}


void
on_min_entry_changed                   (GtkEditable     *editable,
                                        gpointer         user_data)
{
  Minutes_Entry( editable );
}


void
on_start_stop_cancel_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy( start_stop_timer );
}


void
on_start_stop_ok_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  Start_Stop_OK_Clicked( button );
}


void
on_quit_cancel_button_clicked          (GtkButton       *button,
                                        gpointer         user_data)
{
  gtk_widget_destroy( quit_dialog );
}


void
on_quit_button_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  Cleanup();
  gtk_main_quit();
}


void
on_noaa15_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  rc_data.rtlsdr_center_freq = 137620000;
  gbl_sat_type = NOAA_15;
  Initialize_Top_Window();

  /* Enter center freq to relevant entry widget */
  Enter_Center_Freq( rc_data.rtlsdr_center_freq );
}


void
on_noaa18_activate                     (GtkMenuItem     *menuitem,
										gpointer         user_data)
{
  rc_data.rtlsdr_center_freq = 137912500;
  gbl_sat_type = NOAA_18;
  Initialize_Top_Window();

  /* Enter center freq to relevant entry widget */
  Enter_Center_Freq( rc_data.rtlsdr_center_freq );
}


void
on_noaa19_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  rc_data.rtlsdr_center_freq = 137100000;
  gbl_sat_type = NOAA_19;
  Initialize_Top_Window();

  /* Enter center freq to relevant entry widget */
  Enter_Center_Freq( rc_data.rtlsdr_center_freq );
}


void
on_meteor_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  rc_data.rtlsdr_center_freq = 137100000; /* ?? Sat is now extinct */
  gbl_sat_type = METEOR;
  Initialize_Top_Window();

  /* Enter center freq to relevant entry widget */
  Enter_Center_Freq( rc_data.rtlsdr_center_freq );
}


void
on_dft_drawingarea_size_allocate       (GtkWidget       *widget,
                                        GdkRectangle    *allocation,
                                        gpointer         user_data)
{
  Fft_Drawingarea_Size_Alloc( allocation );
}



gboolean
on_dft_drawingarea_expose_event        (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
  if( gbl_wfall_pixbuf == NULL )
	return( TRUE );

  gdk_draw_pixbuf(
	  widget->window, NULL,
	  gbl_wfall_pixbuf,
	  event->area.x, event->area.y,
	  event->area.x, event->area.y,
	  event->area.width, event->area.height,
	  GDK_RGB_DITHER_NONE, 0, 0 );

  return TRUE;
}


void
on_demod_drawingarea_size_allocate     (GtkWidget       *widget,
                                        GdkRectangle    *allocation,
                                        gpointer         user_data)
{
  gbl_scope_width  = allocation->width;
  gbl_scope_height = allocation->height;
}


gboolean
on_demod_drawingarea_expose_event      (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
  /* Draw scope background */
  cairo_t *cr = gdk_cairo_create( gbl_scope->window );
  cairo_set_source_rgb( cr, 0.0, .3, 0.0 );
  cairo_rectangle(
	  cr, 0.0, 0.0,
	  (double)gbl_scope_width,
	  (double)gbl_scope_height );
  cairo_fill( cr );
  cairo_destroy( cr );

  return TRUE;
}


void
on_gain_hscale_value_changed           (GtkRange        *range,
                                        gpointer         user_data)
{
  if( isFlagClear(RTLSDR_INIT) ||
	  isFlagClear(TUNER_GAIN_MANL) )
	return;
  gdouble gain = gtk_range_get_value( range );
  Set_Tuner_Gain( gain );
}


void
on_auto_checkbutton_toggled            (GtkToggleButton *togglebutton,
										gpointer         user_data)
{
  if( isFlagClear(RTLSDR_INIT) ) return;
  if( gtk_toggle_button_get_active(togglebutton) )
  {
	Set_Tuner_Gain_Mode( TUNER_GAIN_AUTO );
	ClearFlag(TUNER_GAIN_MANL);
  }
  else
  {
	Set_Tuner_Gain_Mode( TUNER_GAIN_MANUAL );
	SetFlag(TUNER_GAIN_MANL);
  }
}


void
on_offset_checkbutton_toggled          (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  if( gtk_toggle_button_get_active(togglebutton) )
	SetFlag( ENABLE_DOPPLER_CORR );
  else
	ClearFlag( ENABLE_DOPPLER_CORR );
}


  void
on_bw_entry_activate                   (GtkEntry        *entry,
	                                    gpointer         user_data)
{
  BW_Entry_Activate( entry );
}


void
on_freq_entry_activate                 (GtkEntry        *entry,
										gpointer         user_data)
{
  /* Get center freq value in Hz, entry value is in kHz */
  double khz = atof( gtk_entry_get_text(entry) );
  rc_data.rtlsdr_center_freq = (uint32_t)( khz * 1000.0 );
  if( isFlagSet(RTLSDR_INIT) )
	Rtlsdr_Set_Center_Freq( rc_data.rtlsdr_center_freq );
}


void
on_dagc_checkbutton_toggled            (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  if( isFlagClear(RTLSDR_INIT) ) return;
  if( gtk_toggle_button_get_active(togglebutton) )
	Rtlsdr_Set_Agc_Mode( RTL_DAGC_ON );
  else
	Rtlsdr_Set_Agc_Mode( RTL_DAGC_OFF );
}


void
on_subcarrier_radiobutton_toggled      (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  ClearFlag( CARRIER_SPECTRUM );
  if( gtk_toggle_button_get_active(togglebutton) )
	Idft_Init( DET_DFT_INPUT_SIZE, gbl_wfall_width );
}


void
on_carrier_radiobutton_toggled         (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  SetFlag( CARRIER_SPECTRUM );
  if( gtk_toggle_button_get_active(togglebutton) )
	Idft_Init( SDR_DFT_INPUT_SIZE, gbl_wfall_width );
}

