#ifndef COMMON_H
#define COMMON_H	1

#include <math.h>
#include <signal.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <gtk/gtk.h>


/* Definitions of some flags */
#define HOME_LOC_ENTERED	0X0001
#define REMT_LOC_ENTERED	0X0002
#define XPLANET_ENABLED		0X0004
#define HOME_LONG_WEST		0x0008
#define HOME_LATD_SOUTH		0x0010
#define REMT_LONG_WEST		0x0020
#define REMT_LATD_SOUTH		0x0040
#define DEFAULT_HOME		0x0080

/* Return values */
#define ERROR		1
#define SUCCESS		0

/* Size of char arrays (strings) for error messages etc */
#define MESG_SIZE	128

/*-------------------------------------------------------------------*/

typedef struct
{
  /* Home position and name string */
  char
	home_posn[30],
	home_name[25];

  /* Conversion factor from Km to distance unit */
  double unit_conv;

  /* xplanet command and files */
  char
	xplanet_cmnd[196],
	config_file[64],
	marker_file[64],
	arc_file[64];

} rc_data_t;

/*-------------------------------------------------------------------*/

/* Function Prototypes produced by cproto */
/* calculate.c */
void Position_to_Gridloc(double lon, double lat, char *grid_loc);
void Gridloc_to_Position(char *grid_loc, double *lon, double *lat);
void Degrees_to_DMS(double deg, int *ideg, int *imin, int *isec);
void DMS_to_Degrees(int ideg, int imin, int isec, double *deg);
void Bearing_Distance(void);
void Read_Home_Position(void);
void Read_Remote_Position(void);
void Read_Home_Locator(void);
void Read_Remote_Locator(void);
void Default_Home_Position(void);
int Display_Location(void);
gboolean Locator_Valid(GtkEntry *entry);
gboolean Position_Valid(GtkEntry *entry, gpointer user_data);
/* callbacks.c */
void Error_Dialog(char *message);
void on_main_window_destroy(GtkObject *object, gpointer user_data);
void on_home_pos_activate(GtkEntry *entry, gpointer user_data);
void on_home_lon_dir_clicked(GtkButton *button, gpointer user_data);
void on_home_lat_dir_clicked(GtkButton *button, gpointer user_data);
void on_home_loc_activate(GtkEntry *entry, gpointer user_data);
void on_remt_pos_activate(GtkEntry *entry, gpointer user_data);
void on_remt_lon_dir_clicked(GtkButton *button, gpointer user_data);
void on_remt_lat_dir_clicked(GtkButton *button, gpointer user_data);
void on_remt_loc_activate(GtkEntry *entry, gpointer user_data);
void on_default_home_clicked(GtkButton *button, gpointer user_data);
void on_enable_xplanet_toggled(GtkToggleButton *togglebutton, gpointer user_data);
void on_quit_clicked(GtkButton *button, gpointer user_data);
void on_pos_changed(GtkEditable *editable, gpointer user_data);
void on_loc_changed(GtkEditable *editable, gpointer user_data);
void on_clear_clicked(GtkButton *button, gpointer user_data);
void on_bad_entry_dialog_destroy(GtkObject *object, gpointer user_data);
void on_okbutton_clicked(GtkButton *button, gpointer user_data);
gboolean on_main_window_delete(GtkWidget *widget, GdkEvent *event, gpointer user_data);
gboolean on_bad_entry_dialog_delete_event(GtkWidget *widget, GdkEvent *event, gpointer user_data);
/* interface.c */
GtkWidget *create_main_window(void);
GtkWidget *create_bad_entry_dialog(void);
/* main.c */
int main(int argc, char *argv[]);
gboolean Load_Config(gpointer data);
/* shared.c */
/* support.c */
GtkWidget *lookup_widget(GtkWidget *widget, const gchar *widget_name);
void add_pixmap_directory(const gchar *directory);
GtkWidget *create_pixmap(GtkWidget *widget, const gchar *filename);
GdkPixbuf *create_pixbuf(const gchar *filename);
void glade_set_atk_action_description(AtkAction *action, const gchar *action_name, const gchar *description);
/* utils.c */
int Load_Line(char *buff, FILE *pfile, char *messg);
int Cleanup(void);
int isFlagSet(int flag);
int isFlagClear(int flag);
void SetFlag(int flag);
void ClearFlag(int flag);
void ToggleFlag(int flag);
void Usage(void);
void Strlcpy(char *dest, const char *src, size_t n);
double Atof(const char *nptr);

#endif
