#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include "callbacks.h"
#include "shared.h"

/* xgridloc bad entry warning */
static GtkWidget *xgridloc_bad_entry_dialog = NULL;


/* My addition */
void
Error_Dialog( char *message )
{
  if( xgridloc_bad_entry_dialog != NULL ) return;
  xgridloc_bad_entry_dialog = create_bad_entry_dialog();
  GtkWidget *label = lookup_widget( xgridloc_bad_entry_dialog, "label18" );
  gtk_label_set_text( GTK_LABEL(label), message );
  gtk_widget_show( xgridloc_bad_entry_dialog );
}

void
on_main_window_destroy(
    GtkObject       *object,
    gpointer         user_data)
{
  /* Delete xplanet files */
  Cleanup();
  gtk_main_quit();
}


void
on_home_pos_activate(
    GtkEntry        *entry,
    gpointer         user_data)
{
  if( !Position_Valid(entry, user_data) )
	return;
  ClearFlag( DEFAULT_HOME );
  Read_Home_Position();
}


void
on_home_lon_dir_clicked(
    GtkButton       *button,
    gpointer         user_data)
{
  if( isFlagClear(HOME_LONG_WEST) )
  {
    SetFlag( HOME_LONG_WEST );
    gtk_button_set_label( button, _("West") );
  }
  else
  {
    ClearFlag( HOME_LONG_WEST );
    gtk_button_set_label( button, _("East") );
  }

  ClearFlag( DEFAULT_HOME );
  Read_Home_Position();
}


void
on_home_lat_dir_clicked(
    GtkButton       *button,
    gpointer         user_data)
{
  if( isFlagClear(HOME_LATD_SOUTH) )
  {
    SetFlag( HOME_LATD_SOUTH );
    gtk_button_set_label( button, _("South") );
  }
  else
  {
    ClearFlag( HOME_LATD_SOUTH );
    gtk_button_set_label( button, _("North") );
  }

  ClearFlag( DEFAULT_HOME );
  Read_Home_Position();
}


void
on_home_loc_activate(
    GtkEntry        *entry,
    gpointer         user_data)
{
  int len;
  char buff[7];

  /* Get entry field */
  Strlcpy( buff, gtk_entry_get_text(entry), sizeof(buff) );
  len = (int)strlen(buff);

  /* Fill last characters with default */
  if( len == 4 )
  {
	buff[4] = 'M';
	buff[5] = 'M';
	buff[6] = '\0';
	gtk_entry_set_text( entry, buff );
  }

  if( !Locator_Valid(entry) )
	return;
  ClearFlag( DEFAULT_HOME );
  Read_Home_Locator();
}


void
on_remt_pos_activate(
    GtkEntry        *entry,
    gpointer         user_data)
{
  if( !Position_Valid(entry, user_data) )
	return;
  Read_Remote_Position();
}


void
on_remt_lon_dir_clicked(
    GtkButton       *button,
    gpointer         user_data)
{
  if( isFlagClear(REMT_LONG_WEST) )
  {
    SetFlag( REMT_LONG_WEST );
    gtk_button_set_label( button, _("West") );
  }
  else
  {
    ClearFlag( REMT_LONG_WEST );
    gtk_button_set_label( button, _("East") );
  }
  Read_Remote_Position();
}


void
on_remt_lat_dir_clicked(
    GtkButton       *button,
    gpointer         user_data)
{
  if( isFlagClear(REMT_LATD_SOUTH) )
  {
    SetFlag( REMT_LATD_SOUTH );
    gtk_button_set_label( button, _("South") );
  }
  else
  {
    ClearFlag( REMT_LATD_SOUTH );
    gtk_button_set_label( button, _("North") );
  }
  Read_Remote_Position();
}


void
on_remt_loc_activate(
    GtkEntry        *entry,
    gpointer         user_data)
{
  int len;
  char buff[7];

  /* Get entry field */
  Strlcpy( buff, gtk_entry_get_text(entry), sizeof(buff) );
  len = (int)strlen(buff);

  /* Fill last characters with default */
  if( len == 4 )
  {
	buff[4] = 'M';
	buff[5] = 'M';
	buff[6] = '\0';
	gtk_entry_set_text( entry, buff );
  }

  if( !Locator_Valid(entry) )
	return;
  Read_Remote_Locator();
}


void
on_default_home_clicked(
	GtkButton       *button,
	gpointer         user_data)
{
  SetFlag( DEFAULT_HOME );
  Default_Home_Position();
}


void
on_enable_xplanet_toggled(
    GtkToggleButton *togglebutton,
    gpointer         user_data)
{
  /* Toggle xplanet-enabled flag */
  if( isFlagClear(XPLANET_ENABLED) )
    SetFlag( XPLANET_ENABLED );
  else
  {
    Cleanup();
    ClearFlag( XPLANET_ENABLED );
  }

  /* Display Home/Remote positions in xplanet */
  if( isFlagSet( HOME_LOC_ENTERED ) &&
      isFlagSet( REMT_LOC_ENTERED ) &&
      isFlagSet( XPLANET_ENABLED  ) )
    Bearing_Distance();
}


void
on_quit_clicked(
    GtkButton       *button,
    gpointer         user_data)
{
  /* Delete xplanet files */
  Cleanup();
  gtk_main_quit();
}


void
on_pos_changed(
    GtkEditable     *editable,
    gpointer         user_data)
{
  Position_Valid(GTK_ENTRY(editable), user_data);
}


void
on_loc_changed(
    GtkEditable     *editable,
    gpointer         user_data)
{
  Locator_Valid(GTK_ENTRY(editable));
}


void
on_clear_clicked(
    GtkButton       *button,
    gpointer         user_data)
{
  /* Clear all fields exept 'home' */
  gtk_entry_set_text( GTK_ENTRY(lookup_widget(xgridloc_main_window,
	  "remt_lon_deg")),  "" );
  gtk_entry_set_text( GTK_ENTRY(lookup_widget(xgridloc_main_window,
	  "remt_lon_min")),  "" );
  gtk_entry_set_text( GTK_ENTRY(lookup_widget(xgridloc_main_window,
	  "remt_lon_sec")),  "" );
  gtk_entry_set_text( GTK_ENTRY(lookup_widget(xgridloc_main_window,
	  "remt_lat_deg")),  "" );
  gtk_entry_set_text( GTK_ENTRY(lookup_widget(xgridloc_main_window,
	  "remt_lat_min")),  "" );
  gtk_entry_set_text( GTK_ENTRY(lookup_widget(xgridloc_main_window,
	  "remt_lat_sec")),  "" );
  gtk_entry_set_text( GTK_ENTRY(lookup_widget(xgridloc_main_window,
	  "remt_loc"    )),  "" );
  gtk_entry_set_text( GTK_ENTRY(lookup_widget(xgridloc_main_window,
	  "bng_spath"   )),  "" );
  gtk_entry_set_text( GTK_ENTRY(lookup_widget(xgridloc_main_window,
	  "dist_spath" )),   "" );
  gtk_entry_set_text( GTK_ENTRY(lookup_widget(xgridloc_main_window,
	  "bng_lpath"  )),   "" );
  gtk_entry_set_text( GTK_ENTRY(lookup_widget(xgridloc_main_window,
	  "dist_lpath" )),   "" );
  gtk_button_set_label( GTK_BUTTON(lookup_widget(xgridloc_main_window,
	  "remt_lon_dir")), _("East") );
  gtk_button_set_label( GTK_BUTTON(lookup_widget(xgridloc_main_window,
	  "remt_lat_dir")), _("North") );

  /* Clear remote direction flags */
  ClearFlag( REMT_LONG_WEST | REMT_LATD_SOUTH );
}

void
on_bad_entry_dialog_destroy(
    GtkObject       *object,
    gpointer         user_data)
{
  xgridloc_bad_entry_dialog = NULL;
}


void
on_okbutton_clicked(
    GtkButton       *button,
    gpointer         user_data)
{
  gtk_widget_destroy( xgridloc_bad_entry_dialog );
  xgridloc_bad_entry_dialog = NULL;
}


gboolean
on_main_window_delete                   (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  /* Delete xplanet files */
  Cleanup();
  gtk_main_quit();

  return FALSE;
}


gboolean
on_bad_entry_dialog_delete_event       (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
  return TRUE;
}

