/*
 *  xfhell: An application to transmit and receive
 *  Feld Hell signals using a computer's sound card
 *
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef SHARE_H
#define SHARE_H	1

#include "common.h"

/* Global widgets */
extern GtkWidget
  *main_window,
  *gbl_drawingarea,
  *gbl_scope,
  *gbl_popup_menu,
  *gbl_tx_scrolledwindow,
  *gbl_scope_label;

/* Text buffers for text viewers */
extern GtkTextBuffer *gbl_tx_text_buffer;

/* QSO data record */
extern qso_record_t qso_record;

/* Runtime config data */
extern rc_data_t rc_data;

/* Index to macros */
extern int gbl_macro_idx;

/* Average bin values */
extern int *gbl_bin_ave;

/* Keyboard entry buffer */
extern guint keybd_buff[KEY_BUFF_SIZE];

/* Receive text contrast request */
extern int contrast;

/* Average bin values */
extern int *gbl_bin_ave;

extern int deskew;

/* Signal/DSP samples buffer */
extern short *xmit_buffer;

/* Macros attached to F1-F9  */
extern char *macro[NUM_OF_LABELS];

/* dft in/out (real/imaginary) buffers */
extern int
  *dft_in_r,
  *dft_out_r,
  *dft_out_i;

extern int
  txch_ptr,		/* Pointer to character for transmission */
  space_cnt,	/* Count of spaces typed in */
  tx_buff_idx;	/* Index to signal samples buffer for Tx */

/* Receive window and waterfall pixbuffs */
extern pixbuf_data_t
  wfall_pixbuf,
  receive_pixbuf;

#endif

