/*
 * Initial main.c file generated by Glade. Edit as required.
 * Glade will not overwrite this file.
 *
 *  xfhell: An application to transmit and receive
 *  Feld Hell signals using a computer's sound card
 *
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 3 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#include "main.h"
#include "shared.h"

/* Signal handler */
static void sig_handler( int signal );

/*------------------------------------------------------------------------*/

  int
main (int argc, char *argv[])
{
  /* Command line option returned by getopt() */
  int option;

  /* New and old actions for sigaction() */
  struct sigaction sa_new, sa_old;


  /* Initialize new actions */
  sa_new.sa_handler = sig_handler;
  sigemptyset( &sa_new.sa_mask );
  sa_new.sa_flags = 0;

  /* Register function to handle signals */
  sigaction( SIGINT,  &sa_new, &sa_old );
  sigaction( SIGSEGV, &sa_new, 0 );
  sigaction( SIGFPE,  &sa_new, 0 );
  sigaction( SIGTERM, &sa_new, 0 );
  sigaction( SIGABRT, &sa_new, 0 );

  gtk_set_locale ();
  gtk_init (&argc, &argv);

  /* Process command line options */
  while( (option = getopt(argc, argv, "hv") ) != -1 )
	switch( option )
	{
	  case 'h': /* Print usage and exit */
		Usage();
		exit( 0 );

	  case 'v': /* Print version */
		puts( PACKAGE_STRING );
		exit( 0 );

	  default: /* Print usage and exit */
		Usage();
		exit( -1 );

	} /* End of switch( option ) */

  /* Null pixbuf pointers */
  receive_pixbuf.pixbuf = NULL;
  wfall_pixbuf.pixbuf   = NULL;

  /*
   * The following code was added by Glade to create one of each component
   * (except popup menus), just so that you see something after building
   * the project. Delete any components that you don't want shown initially.
   */
  main_window = create_main_window ();
  gtk_window_set_title( GTK_WINDOW(main_window), PACKAGE_STRING );
  gbl_popup_menu = create_main_menu();

  /* Get drawing area widget */
  gbl_drawingarea = lookup_widget( main_window, "drawingarea" );

  /* Get Tx text buffer and scroller */
  gbl_tx_text_buffer = gtk_text_view_get_buffer
	( GTK_TEXT_VIEW(lookup_widget(main_window, "tx_textview")) );
  gbl_tx_scrolledwindow = lookup_widget( main_window, "tx_scrolledwindow" );

  /* Get scope widget */
  gbl_scope = lookup_widget( main_window, "scope" );
  gbl_scope_label = lookup_widget( main_window, "scope_label" );

  /* Get and enter contrast value */
  contrast = ELEMENT_MAX - (ELEMENT_MAX/10) *
	 (int)( gtk_range_get_adjustment(GTK_RANGE(
			 lookup_widget(main_window, "contrast")))->value );

  /* Set labels to Xmit and Rcve buttons */
  {
	GtkWidget
	  *button,
	  *xmit_status,
	  *rcve_status;

	button = lookup_widget( main_window, "xmit" );
	xmit_status = gtk_label_new (_("TRANSMIT"));
	gtk_widget_show (xmit_status);
	gtk_container_add (GTK_CONTAINER (button), xmit_status);
	g_object_set_data_full (G_OBJECT (main_window), "xmit_status",
		gtk_widget_ref (xmit_status),(GDestroyNotify) gtk_widget_unref);

	button = lookup_widget( main_window, "rcve" );
	rcve_status = gtk_label_new (_("RECEIVE"));
	gtk_widget_show (rcve_status);
	gtk_container_add (GTK_CONTAINER (button), rcve_status);
	g_object_set_data_full (G_OBJECT (main_window), "rcve_status",
		gtk_widget_ref (rcve_status),(GDestroyNotify) gtk_widget_unref);
  }

  /* Set default flags */
  SetFlag( TX2RX_LOOPBACK );
  SetFlag( RECORD_QSO );
  SetFlag( SAVE_PIXBUF );
  rc_data.num_rows  = 2;
  rc_data.rev_video = FALSE;
  rc_data.log_adif_fp    = NULL;
  rc_data.station_log_fp = NULL;

  /* Show main window */
  gtk_widget_show (main_window);

  /* Load runtime config file, abort on error */
  g_idle_add( Load_Config, main_window );

  gtk_main ();

  return 0;
}

/*-------------------------------------------------------------------*/

/*  Load_Config()
 *
 *  Loads the xfhellrc configuration file
 */

  gboolean
Load_Config( gpointer data )
{
  int
	lb_idx, /* Label buffer index */
	mc_idx, /* Macro buffer index */
	ln_idx, /* Line buffer index  */
	ln_len, /* Line buffer length */
	tg_cnt, /* Count '<' and '>'  */
	height, /* Set Receive window height */
	idx;

  char
	rc_fpath[64], /* File path to xfhellrc */
	line[81];     /* Buffer for Load_Line  */

  /* Config file pointer */
  FILE *xfhellrc;


  /* Setup file path to xfhellrc */
  snprintf( rc_fpath, sizeof(rc_fpath),
	  "%s/xfhell/xfhellrc", getenv("HOME") );

  /* Open xfhellrc file */
  xfhellrc = fopen( rc_fpath, "r" );
  if( xfhellrc == NULL )
  {
	perror( rc_fpath );
	Error_Dialog(
		_("Failed to open xfhellrc file\n"\
		  "Quit xfhell and correct"), QUIT );
	return( FALSE );
  }

  /*** Read runtime configuration data ***/
  /* ALSA channel names and values */
  char *chan_name[] =
  {
	"FRONT_LEFT",
	"FRONT_RIGHT",
	"REAR_LEFT",
	"REAR_RIGHT",
	"SIDE_LEFT",
	"SIDE_RIGHT",
	"MONO"
  };

  int chan_number[] =
  {
	SND_MIXER_SCHN_FRONT_LEFT,
	SND_MIXER_SCHN_FRONT_RIGHT,
	SND_MIXER_SCHN_REAR_LEFT,
	SND_MIXER_SCHN_REAR_RIGHT,
	SND_MIXER_SCHN_SIDE_LEFT,
	SND_MIXER_SCHN_SIDE_RIGHT,
	SND_MIXER_SCHN_MONO
  };

  int num_chn = 7;

  /*** Read Sound Card configuration data ***/
  /* Read card name, abort if EOF */
  if( Load_Line(line, xfhellrc, _("Sound Card Name")) != SUCCESS )
	return( FALSE );
  Strlcpy( rc_data.snd_card, line, sizeof(rc_data.snd_card) );

  /* Read card name, abort if EOF */
  if( Load_Line(line, xfhellrc, _("PCM Device Name")) != SUCCESS )
	return( FALSE );
  Strlcpy( rc_data.pcm_dev, line, sizeof(rc_data.pcm_dev) );

  /* Read DSP rate Samples/sec, abort if EOF */
  if( Load_Line(line, xfhellrc, _("DSP Rate") ) != SUCCESS )
	return( FALSE );
  rc_data.dsp_rate = atoi( line );

  /* Read ALSA "channel", abort if EOF */
  if( Load_Line(line, xfhellrc, _("ALSA Channel") ) != SUCCESS )
	return( FALSE );
  for( idx = 0; idx < num_chn; idx++ )
	if( strcmp(chan_name[idx], line) == 0 )
	  break;
  if( idx == num_chn )
  {
	fclose( xfhellrc );
	Error_Dialog(
		_("Invalid ALSA channel name\n"\
		  "Quit and correct xfhellrc"), QUIT);
	return( FALSE );
  }
  rc_data.channel = chan_number[idx];

  /* Set right or left channel buffer index */
  if( strstr(line, "LEFT") || strstr(line, "MONO") )
	rc_data.use_chn = 0;
  else rc_data.use_chn = 1;

  /* Set number of channels */
  if( strstr(line, "MONO") )
	rc_data.num_chn = 1;
  else rc_data.num_chn = 2;

  /* Read capture source, abort if EOF */
  if( Load_Line(line, xfhellrc, _("Capture Source")) != SUCCESS )
	return( FALSE );
  Strlcpy( rc_data.cap_src, line, sizeof(rc_data.cap_src) );

  /* Read Capture volume control, abort if EOF */
  if( Load_Line(line, xfhellrc, _("Capture Volume Control")) != SUCCESS )
	return( FALSE );
  Strlcpy( rc_data.cap_vol, line, sizeof(rc_data.cap_vol) );

  /* Read Capture volume, abort if EOF */
  if( Load_Line(line, xfhellrc, _("Capture Volume")) != SUCCESS )
	return( FALSE );
  rc_data.cap_lev = atoi( line );

  /* Read Playback Master volume control, abort if EOF */
  if( Load_Line(line, xfhellrc, _("Playback Master Volume Control")) != SUCCESS )
	return( FALSE );
  Strlcpy( rc_data.mst_vol, line, sizeof(rc_data.mst_vol) );

  /* Read Playback PCM volume control, abort if EOF */
  if( Load_Line(line, xfhellrc, _("Playback PCM Volume Control")) != SUCCESS )
	return( FALSE );
  Strlcpy( rc_data.pcm_vol, line, sizeof(rc_data.pcm_vol) );

  /* Read Playback volume, abort if EOF */
  if( Load_Line(line, xfhellrc, _("Playback Volume")) != SUCCESS )
	return( FALSE );
  rc_data.pbk_lev = atoi( line );

  /*** End of Sound Card configuration data ***/

  /* Read CW encoder speed, abort if EOF */
  if( Load_Line(line, xfhellrc, _("CW Encoder Speed") ) != SUCCESS )
	return( FALSE );
  rc_data.wpm = atoi( line );

  /* Read CW message to send at tag '*', abort if EOF */
  if( Load_Line(line, xfhellrc, _("CW Message") ) != SUCCESS )
	return( FALSE );
  Strlcpy( rc_data.cw_mesg, line, sizeof(rc_data.cw_mesg) );

  /* Read word wrap column, abort if EOF */
  if( Load_Line(line, xfhellrc, _("Word Wrap Column") ) != SUCCESS )
	return( FALSE );
  rc_data.wwrap = atoi( line );

  /*** Setup default main menu items ***/

  /* Read CAT serial port device, abort if EOF */
  if( Load_Line(line, xfhellrc, _("CAT Serial Port") ) != SUCCESS )
	return( FALSE );
  Strlcpy( rc_data.cat_serial, line, sizeof(rc_data.cat_serial) );

  /* Read Transceiver type for  CAT, abort if EOF */
  if( Load_Line(line, xfhellrc, _("Transceiver type for CAT") ) != SUCCESS )
	return( FALSE );
  if( strcmp(line, "FT847") == 0 )
	rc_data.tcvr_type = FT847;
  else if( strcmp(line, "FT857") == 0 )
	rc_data.tcvr_type = FT857;
  else if( strcmp(line, "K2") == 0 )
	rc_data.tcvr_type = K2;
  else if( strcmp(line, "K3") == 0 )
	rc_data.tcvr_type = K3;
  else if( strcmp(line, "NONE") == 0 )
	rc_data.tcvr_type = NONE;
  else
  {
	rc_data.tcvr_type = NONE;
	fclose( xfhellrc );
	Error_Dialog(
		_("Error reading Transceiver type\n"\
		  "Quit and correct xfhellrc"), QUIT );
	return( FALSE );
  }

  /* Enable CAT, disable RTS/DTR */
  if( rc_data.tcvr_type == NONE )
	ClearFlag( ENABLE_CAT );
  else
  {
	SetFlag( ENABLE_CAT );
	ClearFlag( ENABLE_RTS_DTR );
  }

  /* Read RTS/DTR-Control serial port device, abort if EOF */
  if( Load_Line(line, xfhellrc,
		_("RTS/DTR-Control Serial Port") ) != SUCCESS )
	return( FALSE );
  Strlcpy( rc_data.rts_serial, line, sizeof(rc_data.rts_serial) );

  /* Read RTS/DTR-Control choice, abort if EOF */
  if( Load_Line(line, xfhellrc,
		_("RTS/DTR-Control Enable") ) != SUCCESS )
	return( FALSE );
  if( strcmp(line, "DTR") == 0 )
  {
	SetFlag( ENABLE_DTR );
	SetFlag( ENABLE_RTS_DTR );
	ClearFlag( ENABLE_CAT );
  }
  else if( strcmp(line, "RTS") == 0 )
  {
	SetFlag( ENABLE_RTS_DTR );
	ClearFlag( ENABLE_CAT );
  }
  else if( strcmp(line, "NONE") == 0 )
	ClearFlag( ENABLE_RTS_DTR );
  else
  {
	fclose( xfhellrc );
	Error_Dialog(
		_("Error reading xfhellrc\n"\
		  "Unrecognized RTS/DTR-Control option\n"\
		  "Quit xfhell and correct"), QUIT );
	return( FALSE );
  }

  /* Read Record QSO enable flag, abort if EOF */
  if( Load_Line(line, xfhellrc, _("Record QSOs Enable") ) != SUCCESS )
	return( FALSE );

  if( strcmp(line, "yes") == 0 )
  {
	gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(
		  lookup_widget(gbl_popup_menu, "record_qsos")), TRUE );
	SetFlag( RECORD_QSO );
  }
  else if( strcmp(line, "no") == 0 )
	gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(
		  lookup_widget(gbl_popup_menu, "record_qsos")), FALSE );
  else
  {
	fclose( xfhellrc );
	Error_Dialog(
		_("Error reading xfhellrc\n"\
		  "Unrecognized Record QSO option\n"\
		  "Quit xfhell and correct"), QUIT );
	return( FALSE );
  }

  /* Disable callbacks to menu handlers to prevent messups */
  SetFlag( NO_CALLBACKS );

  /* Read Hellschreiber mode */
  if( Load_Line(line, xfhellrc, _("Hellschreiber Mode")) != SUCCESS )
	return( FALSE );
  if( strcmp(line, "FeldHell") == 0 )
  {
	/* Set appropriate radio button active */
	gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(
		  lookup_widget(gbl_popup_menu, "feldhell")), TRUE);
	SetFlag( MODE_FELDHELL );
  }
  else if( strcmp(line, "FMHell") == 0 )
  {
	/* Set appropriate radio button active */
	gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(
		  lookup_widget(gbl_popup_menu, "fmhell")), TRUE);
	ClearFlag( MODE_FELDHELL );
  }
  else
  {
	fclose( xfhellrc );
	Error_Dialog(
		_("Error reading xfhellrc\n"\
		  "Unrecognized Hell Mode option\n"\
		  "Quit xfhell and correct"), QUIT );
	return( FALSE );
  }

  /* Read Hellschreiber baud rate */
  if( Load_Line(line, xfhellrc, _("Hellschreiber Baud Rate")) != SUCCESS )
	return( FALSE );
  rc_data.baud_rate = Atof( line );

  /* Read dot size */
  if( Load_Line(line, xfhellrc, _("Read Dot Size")) != SUCCESS )
	return( FALSE );
  rc_data.dot_size = atoi( line );
  if( (rc_data.dot_size > 4) || (rc_data.dot_size < 2) )
  {
	fclose( xfhellrc );
	Error_Dialog(
		_("Error reading xfhellrc\n"\
		  "Dot size incorrect\n"\
		  "Quit xfhell and correct"), QUIT );
	return( FALSE );
  }

  /* Read Capitalize enable flag, abort if EOF */
  if( Load_Line(line, xfhellrc, _("Capitalize Enable") ) != SUCCESS )
	return( FALSE );
  if( strcmp(line, "yes") == 0 )
  {
	gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(
		  lookup_widget(gbl_popup_menu, "capitalize_letters")), TRUE );
	SetFlag( CAPITALIZE );
  }
  else if( strcmp(line, "no") == 0 )
	gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(
		  lookup_widget(gbl_popup_menu, "capitalize_letters")), FALSE );
  else
  {
	fclose( xfhellrc );
	Error_Dialog(
		_("Error reading xfhellrc\n"\
		  "Unrecognized Capitalize option\n"\
		  "Quit xfhell and correct"), QUIT );
	return( FALSE );
  }

  /* Read input tone (Rx BFO) frequency */
  if( Load_Line(line, xfhellrc, _("Input Tone")) != SUCCESS )
	return( FALSE );
  rc_data.tone_freq   = atoi( line );
  rc_data.center_line = wfall_pixbuf.width / 2;

  /* Read Receive window half size setting */
  if( Load_Line(line, xfhellrc, _("Receive Window Size")) != SUCCESS )
	return( FALSE );
  if( strcmp(line, "no") == 0 ) height = 0;
  else
	if( strcmp(line, "yes") == 0 ) height = 1;
  else
  {
	fclose( xfhellrc );
	Error_Dialog(
		_("Error reading xfhellrc\n"\
		  "Unrecognized Receive Window Size option\n"\
		  "Quit xfhell and correct"), QUIT );
	return( FALSE );
  }

  /* Read operator callsign, abort if EOF */
  if( Load_Line(line, xfhellrc, _("Operator Callsign") ) != SUCCESS )
	return( FALSE );
  Strlcpy( rc_data.call, line, sizeof(rc_data.call) );

  /* Read operator name, abort if EOF */
  if( Load_Line(line, xfhellrc, _("Operator Name") ) != SUCCESS )
	return( FALSE );
  Strlcpy( rc_data.name, line, sizeof(rc_data.name) );

  /* Read Zone, abort if EOF */
  if( Load_Line(line, xfhellrc, _("ITU Zone") ) != SUCCESS )
	return( FALSE );
  Strlcpy( rc_data.zone, line, sizeof(rc_data.zone) );

  /* Read QTH, abort if EOF */
  if( Load_Line(line, xfhellrc, _("QTH Name") ) != SUCCESS )
	return( FALSE );
  Strlcpy( rc_data.qth, line, sizeof(rc_data.qth) );

  /* Read QTH locator, abort if EOF */
  if( Load_Line(line, xfhellrc, _("QTH Locator") ) != SUCCESS )
	return( FALSE );
  Strlcpy( rc_data.loc, line, sizeof(rc_data.loc) );

  /* Read Transmitter name, abort if EOF */
  if( Load_Line(line, xfhellrc, _("Transmitter Name") ) != SUCCESS )
	return( FALSE );
  Strlcpy( rc_data.tx, line, sizeof(rc_data.tx) );

  /* Read Transmitter power, abort if EOF */
  if( Load_Line(line, xfhellrc, _("Transmitter Power") ) != SUCCESS )
	return( FALSE );
  Strlcpy( rc_data.tx_power, line, sizeof(rc_data.tx_power) );

  /* Read Transmitter antenna, abort if EOF */
  if( Load_Line(line, xfhellrc, _("Transmitter Antenna") ) != SUCCESS )
	return( FALSE );
  Strlcpy( rc_data.tx_ant, line, sizeof(rc_data.tx_ant) );

  /* Read Receiver name, abort if EOF */
  if( Load_Line(line, xfhellrc, _("Receiver Name") ) != SUCCESS )
	return( FALSE );
  Strlcpy( rc_data.rx, line, sizeof(rc_data.rx) );

  /* Read Receiver N.Fig, abort if EOF */
  if( Load_Line(line, xfhellrc, _("Receiver Noise Figure") ) != SUCCESS )
	return( FALSE );
  Strlcpy( rc_data.rx_nfig, line, sizeof(rc_data.rx_nfig) );

  /* Read Receiver antenna, abort if EOF */
  if( Load_Line(line, xfhellrc, _("Receiver Antenna") ) != SUCCESS )
	return( FALSE );
  Strlcpy( rc_data.rx_ant, line, sizeof(rc_data.rx_ant) );

  /* Read propagation medium */
  if( Load_Line(line, xfhellrc, _("Propagation Medium") ) != SUCCESS )
	return( FALSE );
  Strlcpy( qso_record.via, line, sizeof(qso_record.via) );

  /* Read default remarks on QSO */
  if( Load_Line(line, xfhellrc, _("Default Remarks") ) != SUCCESS )
	return( FALSE );
  Strlcpy( qso_record.remarks, line, sizeof(qso_record.remarks) );

  /*** Read macro labels from rc file ***/
  /* Null buffer pointers just in case */
  for( idx = 0; idx < NUM_OF_LABELS; idx++ )
	macro[idx] = NULL;

  /* Preload a line */
  if( Load_Line(line, xfhellrc, _("Macro Labels") ) != SUCCESS )
	return( FALSE );

  for( lb_idx = 0; lb_idx < NUM_OF_LABELS; lb_idx++ )
  {
	/* For setting macro button labels */
	GtkLabel *lbl;
	char lname[8];
	char label[LABEL_LENGTH+6];

	/* Abort if first line is not a label */
	if( line[0] != '[' )
	{
	  fprintf( stderr, "xfhell: First Macro line not a label\n%s\n", line );
	  fclose( xfhellrc );
	  Error_Dialog(
		  _("Error reading xfhellrc\n"\
			"First Macro line not a label\n"\
			"Quit xfhell and correct"), QUIT);
	  return( FALSE );
	}

	/* Look for closing ']' */
	ln_idx = 1;
	while( (ln_idx <= LABEL_LENGTH) && (line[ln_idx] != ']') )
	  ln_idx++;

	/* Abort if label string > LABEL_LENGTH char + [] */
	if( ln_idx > LABEL_LENGTH )
	{
	  fprintf( stderr, "xfhell: Macro label too long\n%s\n", line );
	  fclose( xfhellrc );
	  Error_Dialog(
		  _("Error reading xfhellrc\n"\
			"Macro label too long\n"\
			"Quit xfhell and correct"), QUIT);
	  return( FALSE );
	}

	/* Enter label string if all OK */
	snprintf( label, sizeof(label), "[F%d] ", lb_idx+1 );
	line[strlen(line)-1] = '\0';
	Strlcat( label, &line[1], sizeof(label) );

	/* Set macro button labels */
	snprintf( lname, sizeof(lname), "label%d", lb_idx+1 );
	lbl = GTK_LABEL( lookup_widget(main_window, lname) );
	gtk_label_set_text( lbl, label );

	/*** Read macros ***/
	mc_idx = tg_cnt = 0;
	do
	{
	  if( Load_Line(line, xfhellrc, _("Macros")) != SUCCESS )
		return( FALSE );

	  /* Read labels if line starts with '[' */
	  if( line[0] == '[' ) break;

	  /* Allocate memory to macro buffer */
	  ln_len = (int)strlen( line );

	  /* Ignore | end-of-macro delimeter */
	  if( line[ln_len-1] == '|' ) ln_len--;
	  if( !mem_realloc((void **)&macro[lb_idx],
			(size_t)(ln_len + mc_idx + 2)) )
	  {
		fclose( xfhellrc );
		return( FALSE );
	  }

	  /* Concatenate lines to macro */
	  for( ln_idx = 0; ln_idx < ln_len; ln_idx++ )
	  {
		macro[lb_idx][mc_idx++] = line[ln_idx];

		/* Count tag delimiters */
		if( (line[ln_idx] == '<') ||
			(line[ln_idx] == '>') )
		  tg_cnt++;
	  }

	  /* Terminate Macro with LF and null */
	  macro[lb_idx][mc_idx++] = LF;
	  macro[lb_idx][mc_idx] = '\0';
	} /* do */
	while( line[ln_len] != '|'  );

	/* Abort if tag delimiters are odd number */
	if( tg_cnt & 1 )
	{
	  fprintf( stderr, "xfhell: Malformed tag in Macro\n%s\n", line );
	  fclose( xfhellrc );
	  Error_Dialog(
		  _("Error reading xfhellrc\n"\
			"Malformed tag in Macro\n"\
			"Quit xfhell and correct"), QUIT );
	  return( FALSE );
	}
  } /* for( lb_idx = 0; lb_idx < NUM_OF_LABELS; lb_idx++ ) */

  /*** Do the global config variables ***/
  /* Set appropriate baud rate menu item */
  {
	char btn[7];
	GtkWidget *item;

	snprintf( btn, sizeof(btn),
		"br%d", (int)(rc_data.baud_rate * 10.0 + 0.001) );
	btn[6] = '\0';
	item = lookup_widget(gbl_popup_menu, btn);
	if( !item )
	{
	  fclose( xfhellrc );
	  Error_Dialog(
		  _("Error reading xfhellrc\n"\
			"Invalid Baud rate\n"\
			"Quit xfhell and correct"), QUIT );
	  return( FALSE );
	}
	gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(item), TRUE );
  }

  /* Set apropriate dot height menu item */
  switch( rc_data.dot_size )
  {
	case 2:
	  gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(
			lookup_widget(gbl_popup_menu, "md2x2")), TRUE);
	  break;

	case 3:
	  gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(
			lookup_widget(gbl_popup_menu, "md3x3")), TRUE);
	  break;

	case 4:
	  gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(
			lookup_widget(gbl_popup_menu, "md4x4")), TRUE);
	  break;

	default:
	  fclose( xfhellrc );
	  Error_Dialog(
		  _("Error reading xfhellrc\n"\
			"Invalid dot height\n"\
			"Quit xfhell and correct"), QUIT );
	  return( FALSE );
  }

  /* Set up CAT if enabled */
  switch( rc_data.tcvr_type )
  {
	case K2:
	  gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(
			lookup_widget(gbl_popup_menu, "k2")), TRUE );
	  break;

	case K3:
	  gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(
			lookup_widget(gbl_popup_menu, "k3")), TRUE );
	  break;

	case FT847:
	  gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(
			lookup_widget(gbl_popup_menu, "ft847")), TRUE );
	  break;

	case FT857:
	  gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(
			lookup_widget(gbl_popup_menu, "ft857")), TRUE );
	  break;
  }

  /* Set RTS/DTR control */
  if( isFlagSet(ENABLE_RTS_DTR) )
  {
	rc_data.tcvr_type = NONE;
	ClearFlag( ENABLE_CAT );
	gtk_check_menu_item_set_active( GTK_CHECK_MENU_ITEM(
		  lookup_widget(gbl_popup_menu, "rts_ctl")), TRUE );
  }

  /* Wait for GTK to complete its tasks */
  while( g_main_context_iteration(NULL, FALSE) );

  /* Set Receive window height check button */
  GtkToggleButton *toggle = GTK_TOGGLE_BUTTON(
	  lookup_widget(main_window, "height_checkbutton"));
  if( height )
  {
	gtk_toggle_button_set_active( toggle, TRUE );
	gtk_widget_set_size_request( gbl_drawingarea,
		gbl_drawingarea->allocation.width, 172 );
  }
  else
  {
	gtk_toggle_button_set_active( toggle, FALSE );
	gtk_widget_set_size_request( gbl_drawingarea,
		gbl_drawingarea->allocation.width, 340 );
  }

  /* Close rc file */
  fclose( xfhellrc );

  /* Set volume spinbuttons */
  gtk_spin_button_set_value( GTK_SPIN_BUTTON(lookup_widget(
		  main_window, "rxvol_spinbutton")), rc_data.cap_lev );
  gtk_spin_button_set_value( GTK_SPIN_BUTTON(lookup_widget(
		  main_window, "txvol_spinbutton")), rc_data.pbk_lev );

  /* Enable menu handlers */
  ClearFlag( NO_CALLBACKS );

  /* Initialize Cairo */
  SetFlag( INITIALIZE_CAIRO );

  /* Clear Font file name and set params */
  rc_data.font_file[0] = '\0';
  New_Parameters();
  Make_Sin_Wavetable();

  return( FALSE );
} /* End of Load_Config() */

/*------------------------------------------------------------------*/

/*  sig_handler()
 *
 *  Signal Action Handler function
 */

static void sig_handler( int signal )
{
  /* Wrap up and quit */
  Cleanup();
  fprintf( stderr, "\n" );
  switch( signal )
  {
	case SIGINT :
	  fprintf( stderr, "%s\n",  _("xfhell: Exiting via User Interrupt") );
	  exit( signal );

	case SIGSEGV :
	  fprintf( stderr, "%s\n",  _("xfhell: Segmentation Fault") );
	  exit( signal );

	case SIGFPE :
	  fprintf( stderr, "%s\n",  _("xfhell: Floating Point Exception") );
	  exit( signal );

	case SIGABRT :
	  fprintf( stderr, "%s\n",  _("xfhell: Abort Signal received") );
	  exit( signal );

	case SIGTERM :
	  fprintf( stderr, "%s\n",  _("xfhell: Termination Request received") );
	  exit( signal );
  }

} /* End of sig_handler() */

/*------------------------------------------------------------------------*/

