/*
 *  wxapt: An application to decode APT signals from weather
 *  satellites and produce an image of the weather.
 *
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#ifndef SHARED_H
#define SHARED_H		1

#include "common.h"
#include "image.h"


/* Runtime config data */
extern rc_data_t rc_data;

extern int
  gbl_sat_type, /* Weather satellite type number   */
  gbl_sync_ref, /* Required position of sync train */
  gbl_sync_err, /* Deviation from sync reference   */
  gbl_duration,	/* Processing duration */
  gbl_line_idx; /* Index to signal samples buffer   */

/* List of required sync position references */
extern int gbl_sync_refs[];

/* Signal/DSP samples buffer */
extern short gbl_line_buffer[];

/* Satellite type names */
extern char *gbl_sat_names[];

extern char
  gbl_samples_file[MAX_FILE_NAME], /* Samples file name */
  gbl_image_file[MAX_FILE_NAME];   /* Image files name  */

/* Pointer to samples file */
extern FILE *gbl_samples_fp;

/* Buffer for reading in Sound Card DSP data */
extern short *gbl_snd_buffer;
extern int snd_buf_idx; /* Index for this buffer  */

extern int dsp_rate_err;  /* dsp sampling rate error*/

#endif

