/*  shared.c
 *
 *  Shared global variables
 */

/*
 *  wxapt: An application to decode APT signals from
 *  weather satellites and produce image(s) of the weather.
 *
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License as
 *  published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details:
 *
 *  http://www.gnu.org/copyleft/gpl.txt
 */

#include "shared.h"

/* Runtime config data */
rc_data_t rc_data;

int
  gbl_sat_type, /* Weather satellite type number   */
  gbl_sync_ref, /* Required position of sync train */
  gbl_sync_err, /* Deviation from sync reference   */
  gbl_duration,	/* Processing duration */
  gbl_line_idx; /* Index to signal samples buffer   */

/* List of required sync position references */
int gbl_sync_refs[] = { SYNC_REFS };

/* Signal/DSP samples buffer */
short gbl_line_buffer[BLOCK_BUFFER_SIZE];

/* Satellite type names */
char *gbl_sat_names[] = { SAT_NAMES };

char
  gbl_samples_file[MAX_FILE_NAME], /* Samples file name */
  gbl_image_file  [MAX_FILE_NAME]; /* Image files name  */

/* Pointer to samples file */
FILE *gbl_samples_fp = NULL;

/* Buffer for reading in DSP data */
short *gbl_snd_buffer = NULL;

/* Index for this buffer  */
int snd_buf_idx;

/* dsp sampling rate error*/
int dsp_rate_err;

/*------------------------------------------------------------------------*/

