/*
 * twHamQTH - an online callsign look up progran
 *
 * Copyright (C) 2011->2014 Ted Williams - WA0EIR
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  
 */

#include "twhamqth.h"

/*
 * buildWidgets - builds all the main interface widgets
 * passed parent shell and app context
 */

struct CBdata *buildWidgets (Widget shell, XtAppContext app)
{
   static struct CBdata cbData;
   Widget fileMenu;
   Widget form1, menuBar, helpMenu; 
   Widget notebook;
   Widget mainPage, rc1, mainTX, scroller;
   Widget mainPB, lookupTF, lookupPB, clearPB, savePB;
   Widget qrtPB, exportPB;

   int i, j;
   XmString xs[15];
   char buffer[32];

   form1 = XtVaCreateWidget ("form1", xmFormWidgetClass, shell,
      NULL);

   /* create the menuBar */
   i = 0;
   xs[i] = XmStringCreateLocalized ("File"); i++;
   xs[i] = XmStringCreateLocalized ("Help"); i++;

   menuBar = XmVaCreateSimpleMenuBar (form1, "menuBar",
      XmVaCASCADEBUTTON, xs[0], 'F',
      XmVaCASCADEBUTTON, xs[1], 'H',
      NULL);

   for (j=0; j<i; j++)
   {
      XmStringFree (xs[j]);
   }

   XtVaSetValues (menuBar,
      XmNtopAttachment, XmATTACH_FORM,
      XmNtopOffset, 0,
      XmNleftAttachment, XmATTACH_FORM,
      XmNleftOffset, 0,
      XmNrightAttachment, XmATTACH_FORM,
      XmNrightOffset, 0,
      XmNbottomAttachment, XmATTACH_NONE,
      XmNmenuHelpWidget, XtNameToWidget (menuBar, "button_1"),
      NULL);

   /* create the pulldown menu for the File button */
   i = 0;
   xs[i] = XmStringCreateLocalized ("Lookup"); i++;
   xs[i] = XmStringCreateLocalized ("Ctrl-L"); i++;
   xs[i] = XmStringCreateLocalized ("Save");   i++;
   xs[i] = XmStringCreateLocalized ("Ctrl-S"); i++;
   xs[i] = XmStringCreateLocalized ("Clear");  i++;
   xs[i] = XmStringCreateLocalized ("Ctrl-C"); i++;
   xs[i] = XmStringCreateLocalized ("Remove"); i++;
   xs[i] = XmStringCreateLocalized ("Ctrl-R"); i++;
   xs[i] = XmStringCreateLocalized ("Export"); i++;
   xs[i] = XmStringCreateLocalized ("Ctrl-E"); i++;
   xs[i] = XmStringCreateLocalized ("QRT");    i++;
   xs[i] = XmStringCreateLocalized ("Ctrl-Q"); i++;

   fileMenu = XmVaCreateSimplePulldownMenu (menuBar, "fileMenu", 0, fileCB,

      XmVaPUSHBUTTON, xs[0], 'L', "Ctrl<Key>L", xs[1],
      XmVaPUSHBUTTON, xs[2], 'S', "Ctrl<Key>S", xs[3],
      XmVaPUSHBUTTON, xs[4], 'C', "Ctrl<Key>C", xs[5],
      XmVaPUSHBUTTON, xs[6], 'R', "Ctrl<Key>R", xs[7],
      XmVaPUSHBUTTON, xs[8], 'E', "Ctrl<Key>E", xs[9],
      XmVaSEPARATOR,
      XmVaPUSHBUTTON, xs[10], 'Q', "Ctrl<Key>Q", xs[11],
      NULL);

   for (j=0; j<i; j++)
   {
      XmStringFree (xs[j]);
   }

   /* create the pulldown menu for the Help button */
   i = 0;
   xs[i] = XmStringCreateLocalized ("About"); i++;
   xs[i] = XmStringCreateLocalized ("Ctrl-A"); i++;
   xs[i] = XmStringCreateLocalized ("Help"); i++;
   xs[i] = XmStringCreateLocalized ("Ctrl-H"); i++;

   helpMenu = XmVaCreateSimplePulldownMenu (menuBar, "helpMenu", 1, helpCB,
      XmVaPUSHBUTTON, xs[0], 'A', "Ctrl<Key>A", xs[1],
      XmVaPUSHBUTTON, xs[2], 'H', "Ctrl<Key>H", xs[3],
      NULL);

   for (j=0; j<i; j++)
   {
      XmStringFree (xs[j]);
   }


   /* QRT button */
   qrtPB = XtVaCreateManagedWidget ("QRT", xmPushButtonWidgetClass, form1,
      XmNwidth, 80,
      XmNtopAttachment, XmATTACH_NONE,
      XmNbottomAttachment, XmATTACH_FORM,
      XmNleftAttachment, XmATTACH_NONE,
      XmNleftAttachment, XmATTACH_NONE,
      //XmNleftAttachment, XmATTACH_POSITION,
      //XmNleftPosition, 80,
      XmNrightAttachment, XmATTACH_FORM,
      NULL);

   /* export button */
   exportPB = XtVaCreateManagedWidget ("Export", xmPushButtonWidgetClass, form1,
      XmNwidth, 80,
      XmNtopAttachment, XmATTACH_NONE,
      XmNbottomAttachment, XmATTACH_FORM,
      XmNleftAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_NONE,
      //XmNrightAttachment, XmATTACH_POSITION,
      //XmNrightPosition, 20,
      NULL);

   /* Create the Notebook */
   notebook = XtVaCreateWidget ("notebook", xmNotebookWidgetClass, form1,
      XmNtopAttachment, XmATTACH_WIDGET,
      XmNtopWidget, menuBar,
      XmNbottomAttachment, XmATTACH_WIDGET,
      XmNbottomWidget, qrtPB,
      XmNrightAttachment, XmATTACH_FORM,
      XmNrightOffset, -10,
      XmNleftAttachment, XmATTACH_FORM,
      XmNbindingType, XmNONE,
      XmNbindingWidth, 0,
      XmNbackPageSize, 10,
      XmNbackPageNumber, 5,
      /* hack for lessTif */
      XmNorientation, useMotif ? XmVERTICAL : XmHORIZONTAL,
      XmNbackPagePlacement, useMotif ? XmTOP_RIGHT : XmTOP_RIGHT,
      NULL);

   /* notebook main page form widget */
   mainPage = XtVaCreateManagedWidget ("mainPage", xmFormWidgetClass, notebook,
      NULL);

   /* row/column for push buttons on main page */
   rc1 = XtVaCreateWidget ("rc1", xmRowColumnWidgetClass, mainPage,
      XmNorientation, XmHORIZONTAL,
      XmNentryAlignment, XmALIGNMENT_CENTER,
      XmNpacking, XmPACK_COLUMN,
      XmNcolumns, 4,
      XmNtopAttachment, XmATTACH_FORM,
      /* helps lesstif geometry */
      XmNbottomAttachment, XmATTACH_NONE,
      XmNrightAttachment, XmATTACH_NONE,
      XmNleftAttachment, XmATTACH_FORM,
      NULL);

   /* Search Text, Lookup, Save and Clear PB for row/column on main page */
   lookupTF = XtVaCreateManagedWidget ("lookupTF", xmTextFieldWidgetClass, rc1,
      XmNcolumns, 8,
      XmNmaxLength, 15,
      XmNwordWrap, True,
      NULL);

   lookupPB = XtVaCreateManagedWidget ("Lookup", xmPushButtonWidgetClass, rc1,
      XmNmnemonic, 'L',
      NULL);

   savePB = XtVaCreateManagedWidget ("Save", xmPushButtonWidgetClass, rc1,
      XmNmnemonic, 'S',
      NULL);

   clearPB = XtVaCreateManagedWidget ("Clear", xmPushButtonWidgetClass, rc1,
      XmNmnemonic, 'C',
      NULL);

   /* text widget for lookup data */
   mainTX = XtVaCreateWidget ("mainTX", xmTextWidgetClass, mainPage,
      XmNrows, TEXT_ROWS,
      XmNmarginWidth, 10,
      XmNmarginHeight, 10,
      XmNeditMode, XmMULTI_LINE_EDIT,
      XmNwordWrap, True,
      XmNtopAttachment, XmATTACH_WIDGET,
      XmNtopWidget, rc1,
      XmNbottomAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_FORM,
      XmNleftAttachment, XmATTACH_FORM,
      NULL);

   /* Main notebook tab pushbutton */
   mainPB = XtVaCreateManagedWidget ("Main", xmPushButtonWidgetClass, notebook,
      /* hack for lessTif */
      XmNnotebookChildType, useMotif ? XmMAJOR_TAB : XmMINOR_TAB,
      NULL);

   /* fill the callback data struct */
   cbData.app  = app;
   cbData.wid1 = notebook;
   cbData.wid2 = lookupTF;
   cbData.wid3 = mainTX;

   /* fileMenu get cbData via the userData property */
   XtVaSetValues (fileMenu,
      XmNuserData, (XtPointer) &cbData,
      NULL);

   /* Add callbacks */
   XtAddCallback (lookupPB, XmNactivateCallback, lookupCB, (XtPointer) &cbData);

   XtAddCallback (lookupTF, XmNactivateCallback, lookupCB, (XtPointer) &cbData);

   XtAddCallback (clearPB, XmNactivateCallback, clearCB, (XtPointer) &cbData);

   XtAddCallback (mainPB, XmNactivateCallback, mainCB, (XtPointer) &cbData);

   XtAddCallback (savePB, XmNactivateCallback, saveCB, (XtPointer) &cbData);

   XtAddCallback (lookupTF, XmNmodifyVerifyCallback, mvCB, (XtPointer) &cbData);

   XtAddCallback (exportPB, XmNactivateCallback, exportCB, (XtPointer) &cbData);

   XtAddCallback(notebook, XmNpageChangedCallback, pageChangeCB,
                 (XtPointer) fileMenu);

   XtAddCallback (qrtPB, XmNactivateCallback, qrtCB, (XtPointer) NULL);

   XtAddCallback (lookupTF, XmNfocusCallback, initCB, (XtPointer) &cbData);

   /* Manage everything */
   XtManageChild (menuBar);
   XtManageChild (mainTX);
   XtManageChild (rc1);
   XtManageChild (mainPage);
   XtManageChild (notebook);
   XtManageChild (form1);

   /* ummanage Remove push button from the File menu until needed */
   XtUnmanageChild (XtNameToWidget (fileMenu, "button_3"));
   /* get rid of the page scroller */
#if 1
   scroller = XtNameToWidget (notebook, "PageScroller");
   XtUnmanageChild (scroller);
#endif

   /* focus to lookupTF */
   XmProcessTraversal (lookupTF, XmTRAVERSE_CURRENT);
   return (&cbData);
}


/*
 * getLogin - dialog box to get user name and password
 */
void getLogin (Widget w)
{
   static Widget pwDiag = NULL;
   static Widget topLabel, nameLabel, pwordLabel;
   static Widget okPB, nameTF, pwordTF;
   XmString xs;
   static struct CBdata loginWids;

   if (pwDiag != NULL)
   {
      /* make sure username, password, and their TFs are empty */
      appRes.username[0] = '\0';
      appRes.password[0] = '\0';

      XtVaSetValues (pwordTF,
         XmNvalue, "",
         NULL);

      XtVaSetValues (nameTF,
         XmNvalue, "",
         NULL);

      /* pop it up */
      XtManageChild (pwDiag);
      return;
   }

   /* lazy instantiation */
   pwDiag = XmCreateFormDialog (w, "pwDiag", NULL, 0);

   /* set some dialog properties */
   XtVaSetValues (pwDiag,
      XmNdialogStyle, XmDIALOG_PRIMARY_APPLICATION_MODAL,
      XmNmarginHeight, 10,
      XmNmarginWidth, 10,
      NULL);

   /* remove some window manager things and set title */
   XtVaSetValues (XtParent (pwDiag),
      XmNtitle, "Login Dialog",
      XmNmwmFunctions, MWM_FUNC_ALL | MWM_FUNC_CLOSE,
      NULL);

   /* create top label and String with instructions */
   xs = XmStringCreateLocalized
        ("Enter your hamQTH.com\nUsername and Password");
   topLabel = XtVaCreateManagedWidget ("topLabel", xmLabelWidgetClass,
      pwDiag,
      XmNlabelString, xs,
      XmNalignment, XmALIGNMENT_CENTER,
      XmNtopAttachment, XmATTACH_FORM,
      XmNbottomAttachment, XmATTACH_NONE,
      XmNrightAttachment, XmATTACH_FORM,
      XmNleftAttachment, XmATTACH_FORM,
      NULL);
   XmStringFree (xs);

   /* OK button on the bottom */
   okPB = XtVaCreateManagedWidget ("OK", xmPushButtonWidgetClass, pwDiag,
      XmNtopAttachment, XmATTACH_NONE,
      XmNbottomAttachment, XmATTACH_FORM,
      XmNrightAttachment, XmATTACH_POSITION,
      XmNrightPosition, 60,
      XmNleftAttachment, XmATTACH_POSITION,
      XmNleftPosition, 40,
      NULL);

   /* text field for username */
   nameTF = XtVaCreateManagedWidget ("nameTF", xmTextFieldWidgetClass, pwDiag,
      XmNmaxLength, 20,
      XmNtopAttachment, XmATTACH_WIDGET,
      XmNtopWidget, topLabel,
      XmNbottomAttachment, XmATTACH_NONE,
      XmNrightAttachment, XmATTACH_FORM,
      XmNleftAttachment, XmATTACH_NONE,
      NULL);

   /* text field for password */
   pwordTF = XtVaCreateManagedWidget ("pwordTF", xmTextFieldWidgetClass, pwDiag,
      XmNeditable, True,
      XmNmaxLength, 20,
      XmNtopAttachment, XmATTACH_WIDGET,
      XmNtopWidget, nameTF,
      XmNbottomAttachment, XmATTACH_WIDGET,
      XmNbottomWidget, okPB,
      XmNrightAttachment, XmATTACH_FORM,
      XmNleftAttachment, XmATTACH_OPPOSITE_WIDGET,
      XmNleftWidget, nameTF,
      XmNleftOffset, 0,
      NULL);

   /* labels for the text fields */
   xs = XmStringCreateLocalized ("Username");
   nameLabel = XtVaCreateManagedWidget ("nameLabel", xmLabelWidgetClass, pwDiag,
      XmNlabelString, xs,
      XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET,
      XmNtopWidget, nameTF,
      XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
      XmNbottomWidget, nameTF,
      XmNrightAttachment, XmATTACH_WIDGET,
      XmNrightWidget, nameTF,
      XmNleftAttachment, XmATTACH_FORM,
      NULL);
   XmStringFree (xs);

   xs = XmStringCreateLocalized ("Password");
   pwordLabel = XtVaCreateManagedWidget ("pwordLabel", xmLabelWidgetClass,
      pwDiag,
      XmNlabelString, xs,
      XmNtopAttachment, XmATTACH_OPPOSITE_WIDGET,
      XmNtopWidget, pwordTF,
      XmNbottomAttachment, XmATTACH_OPPOSITE_WIDGET,
      XmNbottomWidget, pwordTF,
      XmNrightAttachment, XmATTACH_WIDGET,
      XmNrightWidget, pwordTF,
      XmNleftAttachment, XmATTACH_FORM,
      NULL);
   XmStringFree (xs);

   XtManageChild (pwDiag);

   /* setup loginWids for okPB client_data */
   loginWids.wid1 = nameTF;
   loginWids.wid2 = pwordTF;

   XtAddCallback(okPB, XmNactivateCallback, okCB, (XtPointer) &loginWids);
   XtAddCallback(pwordTF, XmNactivateCallback, okCB, (XtPointer) &loginWids);
   XtAddCallback(pwordTF, XmNmodifyVerifyCallback, pwordCB, (XtPointer) NULL);

   /* pop it up */
   XtManageChild (pwDiag);
}
